/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.immutables.generator.Naming;

interface Depluralizer {
    public static final Depluralizer NONE = new Depluralizer(){

        @Override
        public String depluralize(String name) {
            return name;
        }
    };

    public String depluralize(String var1);

    public static class DictionaryAidedDepluralizer
    implements Depluralizer {
        private final ImmutableMap<String, String> dictionary;
        private static final Naming NAMING_IES_PLURAL = Naming.from((String)"*ies");
        private static final Naming NAMING_S_PLURAL = Naming.from((String)"*s");
        private static final Splitter SPLITTER_UNDERSCORE = Splitter.on((char)'_').omitEmptyStrings().trimResults();
        private static final Joiner JOINER_UNDERSCORE = Joiner.on((char)'_');

        DictionaryAidedDepluralizer(String[] exceptions) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)exceptions.length);
            Splitter splitter = Splitter.on((char)':');
            for (String s : exceptions) {
                List parts = splitter.splitToList((CharSequence)s.toLowerCase());
                if (parts.size() == 1) {
                    map.put(parts.get(0), parts.get(0));
                    continue;
                }
                if (parts.size() != 2) continue;
                map.put(parts.get(1), parts.get(0));
            }
            this.dictionary = ImmutableMap.copyOf((Map)map);
        }

        @Override
        public String depluralize(String name) {
            LinkedList parts = Lists.newLinkedList(DictionaryAidedDepluralizer.splitCamelCase(name));
            String plural = (String)parts.removeLast();
            String singular = (String)this.dictionary.get((Object)plural);
            if (singular != null) {
                parts.addLast(singular);
                return DictionaryAidedDepluralizer.joinCamelCase(parts);
            }
            String detected = NAMING_IES_PLURAL.detect(name);
            if (!detected.isEmpty()) {
                return detected + "y";
            }
            detected = NAMING_S_PLURAL.detect(name);
            if (!detected.isEmpty()) {
                return detected;
            }
            return name;
        }

        private static String joinCamelCase(Iterable<String> parts) {
            return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, JOINER_UNDERSCORE.join(parts));
        }

        private static Iterable<String> splitCamelCase(String name) {
            return SPLITTER_UNDERSCORE.split((CharSequence)CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name));
        }
    }
}

