/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.immutables.generator.Naming;
import org.immutables.value.processor.meta.CachingElements;
import org.immutables.value.processor.meta.ImmutableStyleInfo;
import org.immutables.value.processor.meta.MoreElements;
import org.immutables.value.processor.meta.MoreTypes;
import org.immutables.value.processor.meta.Proto;
import org.immutables.value.processor.meta.Styles;
import org.immutables.value.processor.meta.ValueAttribute;
import org.immutables.value.processor.meta.ValueType;

final class JavaBeanAttributesCollector {
    private final ValueType type;
    private final Proto.Protoclass protoclass;
    private final Fields fields;
    private final Getters getters;
    private final Setters setters;
    private final Styles styles;

    JavaBeanAttributesCollector(Proto.Protoclass protoclass, ValueType type) {
        this.type = (ValueType)Preconditions.checkNotNull((Object)type, (Object)"type");
        this.protoclass = (Proto.Protoclass)Preconditions.checkNotNull((Object)protoclass, (Object)"protoclass");
        this.styles = new Styles(ImmutableStyleInfo.copyOf(protoclass.styles().style()).withGet("is*", "get*").withSet("set*"));
        this.fields = new Fields();
        List<ExecutableElement> members = ElementFilter.methodsIn(protoclass.processing().getElementUtils().getAllMembers(this.getCachedTypeElement()));
        this.getters = new Getters(members);
        this.setters = new Setters(members);
    }

    private static boolean isJavaLangObject(Element element) {
        return MoreElements.isType(element) && MoreElements.asType(element).getQualifiedName().contentEquals(Object.class.getName());
    }

    private TypeElement getCachedTypeElement() {
        return CachingElements.getDelegate(MoreElements.asType(this.type.element));
    }

    void collect() {
        ArrayList<ValueAttribute> attributes = new ArrayList<ValueAttribute>();
        for (String name : Sets.intersection(this.fields.names(), (Set)Sets.intersection(this.getters.names(), this.setters.names()))) {
            attributes.add(this.toAttribute(name, this.fields.field(name)));
        }
        this.type.attributes.addAll(attributes);
    }

    private ValueAttribute toAttribute(String name, Element element) {
        TypeMirror returnType = element.getKind().isField() ? element.asType() : MoreElements.asExecutable(element).getReturnType();
        ValueAttribute attribute = new ValueAttribute();
        attribute.reporter = this.protoclass.report();
        attribute.returnType = returnType;
        attribute.names = this.styles.forAccessorWithRaw(element.getSimpleName().toString(), name);
        attribute.element = element;
        attribute.containingType = this.type;
        attribute.isGenerateAbstract = true;
        attribute.initAndValidate(null);
        return attribute;
    }

    private class Getters {
        private final Map<String, ExecutableElement> getters;
        private final TypeMirror boxedBooleanType;

        private Getters(Iterable<? extends ExecutableElement> methods) {
            ProcessingEnvironment processing = JavaBeanAttributesCollector.this.protoclass.environment().processing();
            this.boxedBooleanType = processing.getElementUtils().getTypeElement(Boolean.class.getCanonicalName()).asType();
            LinkedHashMap<String, ExecutableElement> map = new LinkedHashMap<String, ExecutableElement>();
            for (ExecutableElement executableElement : methods) {
                if (!this.isGetter(executableElement)) continue;
                String name = this.javaBeanAttributeName(executableElement.getSimpleName().toString());
                map.put(name, executableElement);
            }
            this.getters = ImmutableMap.copyOf(map);
        }

        private String javaBeanAttributeName(String raw) {
            for (Naming naming : ((JavaBeanAttributesCollector)JavaBeanAttributesCollector.this).styles.scheme().get) {
                String detected = naming.requireJavaBeanConvention().detect(raw);
                if (detected.isEmpty()) continue;
                return detected;
            }
            throw new IllegalArgumentException(String.format("%s it not a getter in %s", raw, JavaBeanAttributesCollector.this.type.name()));
        }

        private ExecutableElement getter(String name) {
            Preconditions.checkArgument((boolean)this.names().contains(name), (String)"Getter by name %s not found in %s", (Object[])new Object[]{name, JavaBeanAttributesCollector.this.type.name()});
            return this.getters.get(name);
        }

        public Set<String> names() {
            return this.getters.keySet();
        }

        private boolean isGetter(ExecutableElement executable) {
            if (JavaBeanAttributesCollector.isJavaLangObject(executable.getEnclosingElement())) {
                return false;
            }
            String name = executable.getSimpleName().toString();
            boolean isGetterName = false;
            for (Naming naming : ((JavaBeanAttributesCollector)JavaBeanAttributesCollector.this).styles.scheme().get) {
                if (naming.detect(name).isEmpty()) continue;
                isGetterName = true;
                break;
            }
            if (!isGetterName) {
                return false;
            }
            if (name.startsWith("is") && name.length() > "is".length() && !this.isBoolean(executable.getReturnType())) {
                return false;
            }
            return executable.getParameters().isEmpty() && executable.getReturnType().getKind() != TypeKind.VOID && executable.getModifiers().contains((Object)Modifier.PUBLIC) && !executable.getModifiers().contains((Object)Modifier.STATIC) && !executable.getModifiers().contains((Object)Modifier.ABSTRACT);
        }

        private boolean isBoolean(TypeMirror type) {
            return type.getKind() == TypeKind.BOOLEAN || this.boxedBooleanType.equals(type);
        }
    }

    private class Setters {
        private final Map<String, ExecutableElement> setters;

        private Setters(Iterable<? extends ExecutableElement> methods) {
            LinkedHashMap<String, ExecutableElement> map = new LinkedHashMap<String, ExecutableElement>();
            for (ExecutableElement executableElement : methods) {
                if (!this.isSetter(executableElement)) continue;
                String name = ((JavaBeanAttributesCollector)JavaBeanAttributesCollector.this).styles.scheme().set.requireJavaBeanConvention().detect(executableElement.getSimpleName().toString());
                map.put(name, executableElement);
            }
            this.setters = ImmutableMap.copyOf(map);
        }

        Set<String> names() {
            return this.setters.keySet();
        }

        private boolean isSetter(ExecutableElement executable) {
            if (JavaBeanAttributesCollector.isJavaLangObject(executable.getEnclosingElement())) {
                return false;
            }
            Naming set = ((JavaBeanAttributesCollector)JavaBeanAttributesCollector.this).styles.scheme().set;
            boolean notASetter = set.detect(executable.getSimpleName().toString()).isEmpty();
            if (notASetter) {
                return false;
            }
            return !executable.getModifiers().contains((Object)Modifier.STATIC) && executable.getModifiers().contains((Object)Modifier.PUBLIC) && executable.getParameters().size() == 1 && executable.getReturnType().getKind() == TypeKind.VOID;
        }
    }

    private class Fields {
        private final Map<String, VariableElement> fields;

        private Fields() {
            LinkedHashMap<String, VariableElement> map = new LinkedHashMap<String, VariableElement>();
            for (VariableElement field : this.collectFields(JavaBeanAttributesCollector.this.getCachedTypeElement(), new LinkedHashSet())) {
                if (field.getModifiers().contains((Object)Modifier.STATIC)) continue;
                String name = field.getSimpleName().toString();
                map.put(name, field);
                for (String alt : this.alternativeNamesFor(field)) {
                    map.put(alt, field);
                }
            }
            this.fields = ImmutableMap.copyOf(map);
        }

        private Set<String> alternativeNamesFor(VariableElement element) {
            String name = element.getSimpleName().toString();
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            if (name.length() > 1 && Character.isUpperCase(name.charAt(0)) && Character.isLowerCase(name.charAt(1))) {
                names.add(Character.toLowerCase(name.charAt(0)) + name.substring(1));
            }
            if (name.length() > 1 && name.charAt(0) == '_') {
                String altName = name.substring(1);
                names.add(altName);
            }
            if (name.length() == 1 && Character.isUpperCase(name.charAt(0))) {
                names.add(name.toLowerCase());
            }
            return names;
        }

        VariableElement field(String name) {
            Preconditions.checkArgument((boolean)this.names().contains(name), (String)"Field by name %s not found in %s", (Object[])new Object[]{name, JavaBeanAttributesCollector.this.type.name()});
            return this.fields.get(name);
        }

        private <C extends Collection<VariableElement>> C collectFields(@Nullable Element element, C collection) {
            if (element == null || !element.getKind().isClass() || element.getKind() == ElementKind.ENUM) {
                return collection;
            }
            collection.addAll(ElementFilter.fieldsIn(element.getEnclosedElements()));
            TypeMirror parent = MoreElements.asType(element).getSuperclass();
            if (parent.getKind() != TypeKind.NONE) {
                this.collectFields(MoreTypes.asDeclared(parent).asElement(), collection);
            }
            return collection;
        }

        public Set<String> names() {
            return this.fields.keySet();
        }
    }
}

