/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.encode;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.immutables.generator.Templates;
import org.immutables.value.processor.encode.Code;
import org.immutables.value.processor.encode.EncodedElement;
import org.immutables.value.processor.encode.EncodingInfo;
import org.immutables.value.processor.encode.StandardNaming;
import org.immutables.value.processor.encode.Type;
import org.immutables.value.processor.meta.Styles;
import org.immutables.value.processor.meta.ValueType;

public final class Instantiation {
    private final Map<Code.Binding, String> bindings;
    private final Map<Code.Binding, String> builderBindings;
    private final Map<Code.Binding, String> deriveFieldBindings = new HashMap<Code.Binding, String>();
    private final Map<Code.Binding, String> thisFieldBindings = new HashMap<Code.Binding, String>();
    final Type type;
    final EncodingInfo encoding;
    final EncodedElement expose;
    final Type.VariableResolver typer;
    private final Styles.UsingName.AttributeNames names;
    private final ValueType containingType;
    private final boolean shimFields;
    final Function<EncodedElement, String> directField = new Function<EncodedElement, String>(){

        public String apply(EncodedElement e) {
            return Instantiation.this.isShimField(e) ? Instantiation.this.directFieldName(e) : (String)Instantiation.this.namer.apply((Object)e);
        }
    };
    final Function<EncodedElement, String> shimName = new Function<EncodedElement, String>(){

        public String apply(EncodedElement input) {
            return Instantiation.this.shimName(input);
        }
    };
    final Function<EncodedElement, String> namer = new Function<EncodedElement, String>(){

        public String apply(EncodedElement input) {
            return input.inBuilder() ? (String)Instantiation.this.builderBindings.get(input.asBinding()) : (String)Instantiation.this.bindings.get(input.asBinding());
        }
    };
    final Predicate<EncodedElement> isInlined = new Predicate<EncodedElement>(){

        public boolean apply(EncodedElement input) {
            return Instantiation.this.isInlined(input);
        }
    };
    public final Function<String, String> filterDoc = new Function<String, String>(){

        public String apply(String input) {
            return input.replace("<*>", ((Instantiation)Instantiation.this).names.var);
        }
    };
    final Templates.Invokable fragmentOf = new Templates.Invokable(){

        @Nullable
        public Templates.Invokable invoke(Templates.Invokation invokation, Object ... parameters) {
            EncodedElement el = (EncodedElement)parameters[0];
            ImmutableMap overrideBindings = null;
            if (el.params().size() == 1 && parameters.length > 1) {
                overrideBindings = ImmutableMap.of((Object)Code.Binding.newTop(el.firstParam().name()), (Object)parameters[1].toString());
            }
            Map contextBindings = el.inBuilder() ? Instantiation.this.builderBindings : Instantiation.this.bindings;
            Code.Interpolator interpolator = new Code.Interpolator(Instantiation.this.rawName(), contextBindings, (Map<Code.Binding, String>)overrideBindings);
            if (Instantiation.this.isInlined(el)) {
                Instantiation.printWithIndentation(invokation, interpolator.apply((List<Code.Term>)el.oneLiner()));
            } else {
                invokation.out((String)contextBindings.get(el.asBinding())).out("(");
                boolean notFirst = false;
                for (EncodedElement.Param p : el.params()) {
                    if (notFirst) {
                        invokation.out(", ");
                    }
                    notFirst = true;
                    Code.Binding binding = Code.Binding.newTop(p.name());
                    invokation.out((CharSequence)interpolator.dereference(binding));
                }
                invokation.out(")");
            }
            return null;
        }
    };
    final Templates.Invokable codeOf = new Templates.Invokable(){

        @Nullable
        public Templates.Invokable invoke(Templates.Invokation invokation, Object ... parameters) {
            EncodedElement el = (EncodedElement)parameters[0];
            Map contextBindings = el.inBuilder() ? Instantiation.this.builderBindings : Instantiation.this.bindings;
            List<Code.Term> code = el.code();
            if (parameters.length >= 2) {
                String param = parameters[1].toString();
                code = Code.replaceReturn(code, param);
            }
            Code.Interpolator interpolator = new Code.Interpolator(Instantiation.this.rawName(), contextBindings, null);
            Instantiation.printWithIndentation(invokation, interpolator.apply(code));
            return null;
        }
    };
    final Templates.Invokable codeThisFields = new Templates.Invokable(){

        @Nullable
        public Templates.Invokable invoke(Templates.Invokation invokation, Object ... parameters) {
            Instantiation.this.interpolateAndPrint(invokation, (EncodedElement)parameters[0], Instantiation.this.thisFieldBindings);
            return null;
        }
    };
    final Templates.Invokable codeDeriveFields = new Templates.Invokable(){

        @Nullable
        public Templates.Invokable invoke(Templates.Invokation invokation, Object ... parameters) {
            Instantiation.this.interpolateAndPrint(invokation, (EncodedElement)parameters[0], Instantiation.this.deriveFieldBindings);
            return null;
        }
    };
    final Function<EncodedElement, String> ownTypeParams = new Function<EncodedElement, String>(){

        public String apply(EncodedElement input) {
            Type.Parameters parameters = Type.Producer.emptyParameters();
            if (input.isFrom()) {
                for (Type.Variable v : Instantiation.this.typer.variables()) {
                    parameters = this.introduceAsEncodingVar(parameters, v);
                }
            } else {
                for (EncodedElement.TypeParam p : input.typeParams()) {
                    Type.Variable encodingVar = Instantiation.this.typer.byName(p.name());
                    if (encodingVar != null) {
                        parameters = this.introduceAsEncodingVar(parameters, encodingVar);
                        continue;
                    }
                    parameters = parameters.introduce(p.name(), (Iterable<? extends Type.Defined>)this.transformBounds(p.bounds()));
                }
            }
            if (parameters.names().isEmpty()) {
                return "";
            }
            return parameters + " ";
        }

        private Type.Parameters introduceAsEncodingVar(Type.Parameters parameters, Type.Variable encodingVar) {
            Type t = Instantiation.this.typer.apply(encodingVar);
            final Type.Parameters[] pHolder = new Type.Parameters[]{parameters};
            t.accept(new Type.Transformer(){

                @Override
                public Type variable(Type.Variable v) {
                    pHolder[0] = pHolder[0].introduce(v.name, (Iterable<? extends Type.Defined>)this.transformBounds(v.upperBounds));
                    return v;
                }
            });
            parameters = pHolder[0];
            return parameters;
        }

        private ImmutableList<Type.Defined> transformBounds(List<Type.Defined> bounds) {
            return FluentIterable.from(bounds).transform((Function)Instantiation.this.typer).filter(Type.Defined.class).toList();
        }
    };

    Instantiation(EncodingInfo encoding, EncodedElement expose, Type exposedType, Styles.UsingName.AttributeNames names, Type.VariableResolver resolver, ValueType containingType, boolean shimFields) {
        this.encoding = encoding;
        this.expose = expose;
        this.type = exposedType;
        this.names = names;
        this.typer = resolver;
        this.containingType = containingType;
        this.shimFields = shimFields;
        this.bindings = new HashMap<Code.Binding, String>(encoding.element().size());
        this.builderBindings = new HashMap<Code.Binding, String>(encoding.element().size());
        this.populateBindings(resolver);
    }

    private void populateBindings(Type.VariableResolver resolver) {
        if (this.hasVirtualImpl()) {
            this.deriveFieldBindings.put(this.encoding.impl().asBinding(), this.getDecoratedImplFieldName());
        }
        for (EncodedElement e : this.encoding.element()) {
            if (!e.isStatic()) continue;
            if (e.inBuilder()) {
                this.builderBindings.put(e.asBinding(), this.generateProperName(e));
                continue;
            }
            this.builderBindings.put(e.asBinding(), this.generateProperName(e));
            this.bindings.put(e.asBinding(), this.generateProperName(e));
        }
        for (EncodedElement e : this.encoding.element()) {
            if (e.isStatic()) continue;
            if (e.inBuilder()) {
                this.builderBindings.put(e.asBinding(), this.generateProperName(e));
                continue;
            }
            if (this.isShimField(e)) {
                this.bindings.put(e.asBinding(), this.generateShimAccess(e));
                if (e.isValueField() || e.isImplField()) {
                    this.thisFieldBindings.put(e.asBinding(), this.directThisFieldName(e));
                }
                if (!e.isValueField()) continue;
                this.deriveFieldBindings.put(e.asBinding(), this.directFieldName(e));
                continue;
            }
            this.bindings.put(e.asBinding(), this.generateProperName(e));
        }
        for (Type.Variable v : resolver.variables()) {
            Code.Binding binding = Code.Binding.newTop(v.name);
            String value = resolver.apply(v).toString();
            this.bindings.put(binding, value);
            this.builderBindings.put(binding, value);
        }
    }

    private String generateShimAccess(EncodedElement e) {
        return this.shimName(e) + "()";
    }

    private String shimName(EncodedElement e) {
        return this.directFieldName(e) + "$shim";
    }

    public boolean shimFields() {
        return this.shimFields;
    }

    private String directFieldName(EncodedElement e) {
        Preconditions.checkArgument((e.isValueField() || e.isImplField() ? 1 : 0) != 0);
        return e.isImplField() ? this.names.var : this.names.apply(e.naming(), false);
    }

    private String directThisFieldName(EncodedElement e) {
        return "this." + this.directFieldName(e);
    }

    protected boolean isShimField(EncodedElement e) {
        return this.shimFields && (e.isValueField() || e.isImplField());
    }

    public boolean hasTrivialFrom() {
        ImmutableList<Code.Term> oneLiner = this.encoding.from().oneLiner();
        return oneLiner.size() == 1 && ((Code.Term)oneLiner.get(0)).equals(Code.Binding.newTop(this.encoding.from().firstParam().name()));
    }

    public String getDecoratedImplFieldName() {
        return this.directFieldName(this.encoding.impl()) + "$impl";
    }

    public boolean hasValueOrVirtualFields() {
        if (this.encoding.impl().isVirtual()) {
            return true;
        }
        for (EncodedElement e : this.encoding.element()) {
            if (!e.isValueField()) continue;
            return true;
        }
        return false;
    }

    public List<String> exposeDoc() {
        return this.expose.doc();
    }

    public boolean hasVirtualImpl() {
        return this.encoding.impl().isVirtual();
    }

    public boolean supportsInternalImplConstructor() {
        return this.encoding.build().type().equals(this.encoding.impl().type());
    }

    public boolean supportsDefaultValue() {
        return !this.encoding.impl().code().isEmpty();
    }

    private String generateProperName(EncodedElement element) {
        if (element.isImplField()) {
            return this.names.var;
        }
        if (element.isExpose()) {
            return this.names.get;
        }
        if (element.standardNaming() != StandardNaming.NONE) {
            switch (element.standardNaming()) {
                case GET: {
                    return this.names.get;
                }
                case INIT: {
                    return this.names.init;
                }
                case ADD: {
                    return this.names.add();
                }
                case ADD_ALL: {
                    return this.names.addAll();
                }
                case PUT: {
                    return this.names.put();
                }
                case PUT_ALL: {
                    return this.names.putAll();
                }
                case WITH: {
                    return this.names.with;
                }
            }
        }
        if (this.isDefaultUnspecifiedValue(element)) {
            if (element.isCopy()) {
                return this.names.with;
            }
            if (element.isInit()) {
                return this.names.init;
            }
        }
        if (element.isStaticField() && element.isFinal()) {
            String base = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, this.rawName());
            return element.naming().apply(base);
        }
        return this.names.apply(element.naming(), element.depluralize());
    }

    private String rawName() {
        return this.names.raw;
    }

    private boolean isInlined(EncodedElement el) {
        return el.isInlinable() && !el.oneLiner().isEmpty() && !this.encoding.crossReferencedMethods().contains((Object)el.name()) && !this.entangledBuildMethod(el);
    }

    private boolean entangledBuildMethod(EncodedElement el) {
        return el.isBuild() && this.containingType.isGenerateBuilderConstructor();
    }

    public ValueType getContainingType() {
        return this.containingType;
    }

    private boolean isDefaultUnspecifiedValue(EncodedElement element) {
        return element.naming().isIdentity() && !element.depluralize();
    }

    private void interpolateAndPrint(Templates.Invokation invokation, EncodedElement el, Map<Code.Binding, String> overrides) {
        Code.Interpolator interpolator = new Code.Interpolator(this.rawName(), this.bindings, overrides);
        Instantiation.printWithIndentation(invokation, interpolator.apply(el.code()));
    }

    private static void printWithIndentation(Templates.Invokation invokation, List<Code.Term> terms) {
        int indentLevel = 0;
        int indentWrap = 0;
        boolean nextNewline = false;
        for (Code.Term t : terms) {
            if (t.isWhitespace() && t.is('\n')) {
                nextNewline = true;
                continue;
            }
            if (t.isDelimiter() && t.is('}')) {
                --indentLevel;
            }
            if (nextNewline) {
                nextNewline = false;
                invokation.ln();
                for (int i = 0; i < indentLevel + indentWrap; ++i) {
                    invokation.out("  ");
                }
            }
            if (t.isDelimiter() && (t.is(';') || t.is('}') || t.is('{'))) {
                indentWrap = 0;
            } else if (!t.isIgnorable()) {
                indentWrap = 2;
            }
            if (t.isDelimiter() && t.is('{')) {
                ++indentLevel;
            }
            invokation.out((CharSequence)t);
        }
    }

    public String toString() {
        return this.type + "(by " + this.encoding.name() + ")";
    }
}

