/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.ObjectArrays;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.immutables.generator.ClasspathFence;
import org.immutables.generator.EnvironmentState;
import org.immutables.generator.SourceExtraction;
import org.immutables.value.Value;
import org.immutables.value.processor.encode.EncMetadataMirror;
import org.immutables.value.processor.encode.EncodingInfo;
import org.immutables.value.processor.encode.EncodingMirror;
import org.immutables.value.processor.encode.Inflater;
import org.immutables.value.processor.encode.Instantiator;
import org.immutables.value.processor.encode.Type;
import org.immutables.value.processor.meta.AnnotationInjections;
import org.immutables.value.processor.meta.Annotations;
import org.immutables.value.processor.meta.AstMirror;
import org.immutables.value.processor.meta.CachingElements;
import org.immutables.value.processor.meta.CheckedExceptionProbe;
import org.immutables.value.processor.meta.Constitution;
import org.immutables.value.processor.meta.CriteriaMirror;
import org.immutables.value.processor.meta.CriteriaRepositoryMirror;
import org.immutables.value.processor.meta.CustomImmutableAnnotations;
import org.immutables.value.processor.meta.DataMirror;
import org.immutables.value.processor.meta.DepluralizeMirror;
import org.immutables.value.processor.meta.EnclosingMirror;
import org.immutables.value.processor.meta.FConstructorMirror;
import org.immutables.value.processor.meta.FIncludeMirror;
import org.immutables.value.processor.meta.FactoryMirror;
import org.immutables.value.processor.meta.FunctionalMirror;
import org.immutables.value.processor.meta.ImmutableConstitution;
import org.immutables.value.processor.meta.ImmutableMirror;
import org.immutables.value.processor.meta.ImmutableProto;
import org.immutables.value.processor.meta.ImmutableStyleInfo;
import org.immutables.value.processor.meta.IncludeMirror;
import org.immutables.value.processor.meta.InjectAnnotationMirror;
import org.immutables.value.processor.meta.InjectManyAnnotationsMirror;
import org.immutables.value.processor.meta.ModifiableMirror;
import org.immutables.value.processor.meta.OkQualifierMirror;
import org.immutables.value.processor.meta.OkTypeAdaptersMirror;
import org.immutables.value.processor.meta.Reporter;
import org.immutables.value.processor.meta.RepositoryMirror;
import org.immutables.value.processor.meta.Round;
import org.immutables.value.processor.meta.SourceNames;
import org.immutables.value.processor.meta.StructuralMirror;
import org.immutables.value.processor.meta.StyleInfo;
import org.immutables.value.processor.meta.StyleMirror;
import org.immutables.value.processor.meta.Styles;
import org.immutables.value.processor.meta.TransformMirror;
import org.immutables.value.processor.meta.TreesIncludeMirror;
import org.immutables.value.processor.meta.TypeAdaptersMirror;
import org.immutables.value.processor.meta.UnshadeGuava;
import org.immutables.value.processor.meta.ValueImmutableInfo;
import org.immutables.value.processor.meta.ValueType;
import org.immutables.value.processor.meta.VersionMirror;
import org.immutables.value.processor.meta.Visibility;
import org.immutables.value.processor.meta.VisitMirror;

@Value.Enclosing
public class Proto {
    private static final boolean DEBUG_ON = false;
    static final String ORDINAL_VALUE_INTERFACE_TYPE = "org.immutables.ordinal.OrdinalValue";
    static final String JACKSON_TYPE_INFO = "com.fasterxml.jackson.annotation.JsonTypeInfo";
    static final String JACKSON_DESERIALIZE = "com.fasterxml.jackson.databind.annotation.JsonDeserialize";
    static final String JACKSON_SERIALIZE = "com.fasterxml.jackson.databind.annotation.JsonSerialize";
    static final String JACKSON_ANNOTATIONS_INSIDE = "com.fasterxml.jackson.annotation.JacksonAnnotationsInside";
    static final String PARCELABLE_INTERFACE_TYPE = "android.os.Parcelable";
    static final String PARCELABLE_CREATOR_FIELD = "CREATOR";

    private Proto() {
    }

    public static Type.Factory typeFactory() {
        return Proto.typeFactoryAndInflater().factory;
    }

    private static TypeFactoryAndInflater typeFactoryAndInflater() {
        return (TypeFactoryAndInflater)EnvironmentState.getPerProcessing(TypeFactoryAndInflater.class, () -> new TypeFactoryAndInflater());
    }

    static boolean isJacksonSerializedAnnotated(Element element) {
        return Proto.isAnnotatedWith(element, JACKSON_SERIALIZE) || Proto.isAnnotatedWith(element, JACKSON_DESERIALIZE);
    }

    static boolean isJacksonDeserializedAnnotated(Element element) {
        return Proto.isAnnotatedWith(element, JACKSON_DESERIALIZE);
    }

    static boolean isJacksonJsonTypeInfoAnnotated(Element element) {
        return Proto.isAnnotatedWith(element, JACKSON_TYPE_INFO);
    }

    static boolean isAnnotatedWith(Element element, String annotation) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement e = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (e.getQualifiedName().contentEquals(annotation)) {
                return true;
            }
            if (!Annotations.hasJacksonPackagePrefix(annotation) || annotation.equals(JACKSON_ANNOTATIONS_INSIDE) || !Proto.isAnnotatedWith(e, JACKSON_ANNOTATIONS_INSIDE) || !Proto.isAnnotatedWith(e, annotation)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static String[] concat(@Nullable String[] first, @Nullable String[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return (String[])ObjectArrays.concat((Object[])first, (Object[])second, String.class);
    }

    static enum ToInjectionInfo implements Function<InjectAnnotationMirror, AnnotationInjections.InjectionInfo>
    {
        FUNCTION;


        public AnnotationInjections.InjectionInfo apply(InjectAnnotationMirror input) {
            return AnnotationInjections.infoFrom(input);
        }
    }

    static enum ToStyleInfo implements Function<StyleMirror, StyleInfo>
    {
        FUNCTION;


        public StyleInfo apply(StyleMirror input) {
            return StyleInfo.infoFrom(input);
        }
    }

    static enum ToImmutableInfo implements Function<ImmutableMirror, ValueImmutableInfo>
    {
        FUNCTION;


        public ValueImmutableInfo apply(ImmutableMirror input) {
            return ValueImmutableInfo.infoFrom(input);
        }
    }

    static enum IsPublic implements Predicate<Element>
    {
        PREDICATE;


        public boolean apply(Element input) {
            return input.getModifiers().contains((Object)Modifier.PUBLIC);
        }
    }

    static enum DeclatedTypeToElement implements Function<DeclaredType, TypeElement>
    {
        FUNCTION;


        public TypeElement apply(DeclaredType input) {
            return (TypeElement)input.asElement();
        }
    }

    static enum ElementToName implements Function<TypeElement, String>
    {
        FUNCTION;


        public String apply(TypeElement input) {
            return input.getQualifiedName().toString();
        }
    }

    @Value.Immutable
    public static abstract class Protoclass
    extends Diagnosable {
        private List<String> debugLines = ImmutableList.of();

        @Value.Derived
        public String name() {
            return SourceNames.sourceQualifiedNameFor(this.sourceElement());
        }

        @Value.Auxiliary
        public abstract Element sourceElement();

        public abstract DeclaringPackage packageOf();

        public abstract Optional<DeclaringType> declaringType();

        @Value.Lazy
        public Optional<CriteriaMirror> criteria() {
            if (!this.declaringType().isPresent()) {
                return Optional.absent();
            }
            return this.kind().isIncluded() || this.kind().isDefinedValue() || this.kind().isJavaBean() ? ((DeclaringType)this.declaringType().get()).criteria() : Optional.absent();
        }

        @Value.Lazy
        public Optional<RepositoryMirror> repository() {
            if (!this.declaringType().isPresent()) {
                return Optional.absent();
            }
            return this.kind().isIncluded() || this.kind().isDefinedValue() ? ((DeclaringType)this.declaringType().get()).repository() : Optional.absent();
        }

        @Value.Lazy
        public Optional<CriteriaRepositoryMirror> criteriaRepository() {
            if (!this.declaringType().isPresent()) {
                return Optional.absent();
            }
            return this.kind().isIncluded() || this.kind().isDefinedValue() || this.kind().isJavaBean() ? ((DeclaringType)this.declaringType().get()).criteriaRepository() : Optional.absent();
        }

        @Value.Lazy
        public Optional<TypeAdaptersMirror> gsonTypeAdapters() {
            Optional<AbstractDeclaring> typeAdaptersProvider = this.typeAdaptersProvider();
            if (typeAdaptersProvider.isPresent()) {
                return ((AbstractDeclaring)typeAdaptersProvider.get()).typeAdapters();
            }
            if ((this.kind().isDefinedValue() || this.kind().isIncluded()) && !this.kind().isNested() && this.repository().isPresent()) {
                return Optional.of((Object)this.environment().defaultTypeAdapters());
            }
            return Optional.absent();
        }

        @Value.Lazy
        public Optional<AbstractDeclaring> typeAdaptersProvider() {
            Optional typeDefining = this.declaringType().isPresent() ? Optional.of((Object)((DeclaringType)this.declaringType().get()).associatedTopLevel()) : Optional.absent();
            Optional<TypeAdaptersMirror> typeDefined = typeDefining.isPresent() ? ((DeclaringType)typeDefining.get()).typeAdapters() : Optional.absent();
            Optional<TypeAdaptersMirror> packageDefined = this.packageOf().typeAdapters();
            if (packageDefined.isPresent()) {
                if (typeDefined.isPresent()) {
                    this.report().withElement(((DeclaringType)typeDefining.get()).element()).annotationNamed(TypeAdaptersMirror.simpleName()).warning(Reporter.About.INCOMPAT, "@%s is also used on the package, this type level annotation is ignored", TypeAdaptersMirror.simpleName());
                }
                return Optional.of((Object)this.packageOf());
            }
            return typeDefined.isPresent() ? Optional.of((Object)typeDefining.get()) : Optional.absent();
        }

        @Value.Lazy
        public Optional<OkTypeAdaptersMirror> okJsonTypeAdapters() {
            Optional<AbstractDeclaring> typeAdaptersProvider = this.okTypeAdaptersProvider();
            if (typeAdaptersProvider.isPresent()) {
                return ((AbstractDeclaring)typeAdaptersProvider.get()).okTypeAdapters();
            }
            return Optional.absent();
        }

        @Value.Lazy
        public Optional<AbstractDeclaring> okTypeAdaptersProvider() {
            Optional typeDefining = this.declaringType().isPresent() ? Optional.of((Object)((DeclaringType)this.declaringType().get()).associatedTopLevel()) : Optional.absent();
            Optional<OkTypeAdaptersMirror> typeDefined = typeDefining.isPresent() ? ((DeclaringType)typeDefining.get()).okTypeAdapters() : Optional.absent();
            Optional<OkTypeAdaptersMirror> packageDefined = this.packageOf().okTypeAdapters();
            if (packageDefined.isPresent()) {
                if (typeDefined.isPresent()) {
                    this.report().withElement(((DeclaringType)typeDefining.get()).element()).annotationNamed(OkTypeAdaptersMirror.simpleName()).warning("@%s is also used on the package, this type level annotation is ignored", OkTypeAdaptersMirror.simpleName());
                }
                return Optional.of((Object)this.packageOf());
            }
            return typeDefined.isPresent() ? Optional.of((Object)typeDefining.get()) : Optional.absent();
        }

        @Value.Lazy
        public Optional<DataMirror> datatypeMarker() {
            Optional<AbstractDeclaring> provider = this.datatypeProvider();
            if (provider.isPresent()) {
                return ((AbstractDeclaring)provider.get()).datatypeEnabled();
            }
            return Optional.absent();
        }

        @Value.Lazy
        public Optional<AbstractDeclaring> datatypeProvider() {
            Optional typeDefining = this.declaringType().isPresent() ? Optional.of((Object)((DeclaringType)this.declaringType().get()).associatedTopLevel()) : Optional.absent();
            Optional<DataMirror> typeDefined = typeDefining.isPresent() ? ((DeclaringType)typeDefining.get()).datatypeEnabled() : Optional.absent();
            Optional<DataMirror> packageDefined = this.packageOf().datatypeEnabled();
            if (packageDefined.isPresent()) {
                if (typeDefined.isPresent()) {
                    this.report().withElement(((DeclaringType)typeDefining.get()).element()).annotationNamed(DataMirror.simpleName()).warning("@%s is also used on the package, this type level annotation is ignored", DataMirror.simpleName());
                }
                return Optional.of((Object)this.packageOf());
            }
            return typeDefined.isPresent() ? Optional.of((Object)typeDefining.get()) : Optional.absent();
        }

        public abstract Kind kind();

        @Value.Derived
        public Visibility visibility() {
            return Visibility.of(this.sourceElement());
        }

        public Visibility declaringVisibility() {
            if (this.declaringType().isPresent()) {
                return Visibility.of(((DeclaringType)this.declaringType().get()).element());
            }
            return Visibility.PUBLIC;
        }

        @Override
        @Value.Derived
        @Value.Auxiliary
        public Element element() {
            if (this.kind().isFactory()) {
                return this.sourceElement();
            }
            if (this.declaringType().isPresent()) {
                return ((DeclaringType)this.declaringType().get()).element();
            }
            return this.packageOf().element();
        }

        @Value.Lazy
        public Optional<Long> serialVersion() {
            if (this.declaringType().isPresent()) {
                DeclaringType t = (DeclaringType)this.declaringType().get();
                if (t.serialVersion().isPresent()) {
                    return t.serialVersion();
                }
                if (t.enclosingTopLevel().isPresent() && ((DeclaringType)t.enclosingTopLevel().get()).serialVersion().isPresent()) {
                    return ((DeclaringType)t.enclosingTopLevel().get()).serialVersion();
                }
            }
            return this.packageOf().serialVersion();
        }

        @Value.Lazy
        public boolean isSerialStructural() {
            if (this.declaringType().isPresent()) {
                DeclaringType t = (DeclaringType)this.declaringType().get();
                if (t.isSerialStructural()) {
                    return true;
                }
                if (t.enclosingTopLevel().isPresent() && ((DeclaringType)t.enclosingTopLevel().get()).isSerialStructural()) {
                    return true;
                }
            }
            return this.packageOf().isSerialStructural();
        }

        @Value.Lazy
        public boolean isJacksonSerialized() {
            if (!this.styles().style().jacksonIntegration()) {
                return false;
            }
            if (this.declaringType().isPresent()) {
                DeclaringType t = (DeclaringType)this.declaringType().get();
                if (t.isJacksonSerialized()) {
                    return true;
                }
                if (t.enclosingTopLevel().isPresent() && ((DeclaringType)t.enclosingTopLevel().get()).isJacksonSerialized()) {
                    return true;
                }
            }
            return this.packageOf().isJacksonSerialized();
        }

        @Value.Lazy
        public boolean isJacksonDeserialized() {
            if (!this.styles().style().jacksonIntegration()) {
                return false;
            }
            if (this.declaringType().isPresent()) {
                DeclaringType t = (DeclaringType)this.declaringType().get();
                if (t.isJacksonDeserialized()) {
                    return true;
                }
                if (t.enclosingTopLevel().isPresent() && ((DeclaringType)t.enclosingTopLevel().get()).isJacksonDeserialized()) {
                    return true;
                }
            }
            return this.packageOf().isJacksonDeserialized();
        }

        @Value.Lazy
        public ValueImmutableInfo features() {
            Optional<ValueImmutableInfo> features;
            if (this.declaringType().isPresent() && !((DeclaringType)this.declaringType().get()).useImmutableDefaults() && (features = ((DeclaringType)this.declaringType().get()).features()).isPresent()) {
                return (ValueImmutableInfo)features.get();
            }
            return this.styles().defaults();
        }

        @Value.Lazy
        public Styles styles() {
            StyleInfo styleInfo = (StyleInfo)this.determineStyle().or((Object)this.environment().defaultStyles());
            Optional<String[]> depluralize = this.depluralize();
            if (depluralize.isPresent()) {
                styleInfo = ImmutableStyleInfo.copyOf(styleInfo).withDepluralize(true).withDepluralizeDictionary(Proto.concat(styleInfo.depluralizeDictionary(), (String[])depluralize.get()));
            }
            return styleInfo.getStyles();
        }

        @Value.Lazy
        public Optional<String[]> depluralize() {
            String[] dictionary = null;
            Optional<String[]> depluralize = this.packageOf().depluralize();
            if (depluralize.isPresent()) {
                dictionary = Proto.concat(dictionary, (String[])depluralize.get());
            }
            if (this.declaringType().isPresent()) {
                DeclaringType type = (DeclaringType)this.declaringType().get();
                if (type.enclosingTopLevel().isPresent() && (depluralize = ((DeclaringType)type.enclosingTopLevel().get()).depluralize()).isPresent()) {
                    dictionary = Proto.concat(dictionary, (String[])depluralize.get());
                }
                if ((depluralize = type.depluralize()).isPresent()) {
                    dictionary = Proto.concat(dictionary, (String[])depluralize.get());
                }
            }
            return Optional.fromNullable((Object)dictionary);
        }

        private Optional<StyleInfo> determineStyle() {
            if (this.declaringType().isPresent()) {
                DeclaringType type = (DeclaringType)this.declaringType().get();
                Optional<DeclaringType> enclosing = type.enclosingOf();
                if (enclosing.isPresent()) {
                    Optional<StyleInfo> style;
                    Optional<StyleInfo> enclosingStyle = ((DeclaringType)enclosing.get()).style();
                    if (enclosing.get() != type && (style = type.style()).isPresent() && enclosingStyle.isPresent() && !style.equals(enclosingStyle)) {
                        this.warnAboutIncompatibleStyles();
                    }
                    if (enclosingStyle.isPresent()) {
                        return enclosingStyle;
                    }
                } else {
                    Optional<StyleInfo> style = type.style();
                    if (style.isPresent()) {
                        return style;
                    }
                    Optional<DeclaringType> topLevel = type.enclosingTopLevel();
                    if (topLevel.isPresent() && ((DeclaringType)topLevel.get()).style().isPresent()) {
                        return ((DeclaringType)topLevel.get()).style();
                    }
                }
            }
            return this.packageOf().style();
        }

        private void warnAboutIncompatibleStyles() {
            this.report().annotationNamed(StyleMirror.simpleName()).warning(Reporter.About.INCOMPAT, "Use styles only on enclosing types. All nested styles will inherit it. Nested immutables cannot deviate in style from enclosing type, so generated stucture will be consistent", new Object[0]);
        }

        @Value.Derived
        @Value.Auxiliary
        public Optional<DeclaringType> enclosingOf() {
            if (this.declaringType().isPresent()) {
                if (this.kind().isFactory()) {
                    return this.declaringType();
                }
                if (this.kind().isNested()) {
                    if (this.kind().isIncluded()) {
                        return this.declaringType();
                    }
                    return ((DeclaringType)this.declaringType().get()).enclosingOf();
                }
            }
            return Optional.absent();
        }

        Styles.UsingName.TypeNames createTypeNames() {
            Element sourceElement = this.sourceElement();
            if (sourceElement.getKind() == ElementKind.CONSTRUCTOR) {
                sourceElement = sourceElement.getEnclosingElement();
            }
            return this.styles().forType(sourceElement.getSimpleName().toString());
        }

        @Value.Lazy
        public boolean isJacksonJsonTypeInfo() {
            DeclaringType type;
            if (!this.styles().style().jacksonIntegration()) {
                return false;
            }
            if (this.declaringType().isPresent() && (type = (DeclaringType)this.declaringType().get()).isJacksonJsonTypeInfo()) {
                return true;
            }
            return this.packageOf().isJacksonJsonTypeInfo();
        }

        public boolean isAst() {
            return this.declaringType().isPresent() && ((DeclaringType)this.declaringType().get()).isAst();
        }

        public boolean isTransformer() {
            return this.declaringType().isPresent() && ((DeclaringType)this.declaringType().get()).isTransformer();
        }

        public boolean isVisitor() {
            return this.declaringType().isPresent() && ((DeclaringType)this.declaringType().get()).isVisitor();
        }

        public Optional<TransformMirror> getTransform() {
            return this.declaringType().isPresent() ? ((DeclaringType)this.declaringType().get()).getTransform() : Optional.absent();
        }

        public Optional<VisitMirror> getVisit() {
            return this.declaringType().isPresent() ? ((DeclaringType)this.declaringType().get()).getVisit() : Optional.absent();
        }

        public Optional<TreesIncludeMirror> getTreesInclude() {
            return this.declaringType().isPresent() ? ((DeclaringType)this.declaringType().get()).getTreesInclude() : Optional.absent();
        }

        @Value.Lazy
        public Constitution constitution() {
            return ImmutableConstitution.builder().protoclass(this).build();
        }

        @Value.Lazy
        public Instantiator encodingInstantiator() {
            ArrayList<EncodingInfo> results = new ArrayList<EncodingInfo>();
            this.packageOf().collectEncodings(results);
            if (this.declaringType().isPresent()) {
                ((DeclaringType)this.declaringType().get()).collectEncodings(results);
            }
            return this.environment().instantiatorFor((Set<EncodingInfo>)FluentIterable.from(results).toSet());
        }

        public boolean isJacksonProperties() {
            if (!this.styles().style().jacksonIntegration()) {
                return false;
            }
            if (this.declaringType().isPresent() && ((DeclaringType)this.declaringType().get()).jacksonSerializeMode() != JacksonMode.NONE) {
                return true;
            }
            return this.isJacksonSerialized();
        }

        Protoclass debug(String line) {
            return this;
        }

        List<String> getDebugLines() {
            return this.debugLines;
        }

        public static enum Kind {
            INCLUDED_IN_PACKAGE,
            INCLUDED_ON_TYPE,
            INCLUDED_FACTORY_IN_PACKAGE,
            INCLUDED_FACTORY_ON_TYPE,
            INCLUDED_CONSTRUCTOR_IN_PACKAGE,
            INCLUDED_CONSTRUCTOR_ON_TYPE,
            INCLUDED_IN_TYPE,
            DEFINED_FACTORY,
            DEFINED_CONSTRUCTOR,
            DEFINED_TYPE,
            DEFINED_JAVABEAN,
            DEFINED_TYPE_AND_COMPANION,
            DEFINED_COMPANION,
            DEFINED_AND_ENCLOSING_TYPE,
            DEFINED_ENCLOSING_TYPE,
            DEFINED_NESTED_TYPE;


            public boolean isNested() {
                switch (this) {
                    case INCLUDED_IN_TYPE: 
                    case DEFINED_NESTED_TYPE: {
                        return true;
                    }
                }
                return false;
            }

            public boolean isIncluded() {
                switch (this) {
                    case INCLUDED_IN_TYPE: 
                    case INCLUDED_IN_PACKAGE: 
                    case INCLUDED_ON_TYPE: {
                        return true;
                    }
                }
                return false;
            }

            public boolean isEnclosing() {
                switch (this) {
                    case DEFINED_AND_ENCLOSING_TYPE: 
                    case DEFINED_ENCLOSING_TYPE: {
                        return true;
                    }
                }
                return false;
            }

            public boolean isJavaBean() {
                return this == DEFINED_JAVABEAN;
            }

            public boolean isValue() {
                switch (this) {
                    case INCLUDED_IN_TYPE: 
                    case DEFINED_NESTED_TYPE: 
                    case INCLUDED_IN_PACKAGE: 
                    case INCLUDED_ON_TYPE: 
                    case DEFINED_AND_ENCLOSING_TYPE: 
                    case DEFINED_TYPE: 
                    case DEFINED_TYPE_AND_COMPANION: {
                        return true;
                    }
                }
                return false;
            }

            public boolean isDefinedValue() {
                switch (this) {
                    case DEFINED_NESTED_TYPE: 
                    case DEFINED_AND_ENCLOSING_TYPE: 
                    case DEFINED_TYPE: 
                    case DEFINED_TYPE_AND_COMPANION: {
                        return true;
                    }
                }
                return false;
            }

            public boolean isModifiable() {
                return this == DEFINED_TYPE_AND_COMPANION || this == DEFINED_COMPANION;
            }

            public boolean isConstructor() {
                switch (this) {
                    case DEFINED_CONSTRUCTOR: 
                    case INCLUDED_CONSTRUCTOR_IN_PACKAGE: 
                    case INCLUDED_CONSTRUCTOR_ON_TYPE: {
                        return true;
                    }
                }
                return false;
            }

            public boolean isFactory() {
                switch (this) {
                    case DEFINED_CONSTRUCTOR: 
                    case INCLUDED_CONSTRUCTOR_IN_PACKAGE: 
                    case INCLUDED_CONSTRUCTOR_ON_TYPE: 
                    case DEFINED_FACTORY: 
                    case INCLUDED_FACTORY_IN_PACKAGE: 
                    case INCLUDED_FACTORY_ON_TYPE: {
                        return true;
                    }
                }
                return false;
            }

            public boolean isEnclosingOnly() {
                return this == DEFINED_ENCLOSING_TYPE;
            }
        }
    }

    @Value.Immutable
    public static abstract class DeclaringType
    extends AbstractDeclaring {
        @Override
        @Value.Auxiliary
        public abstract TypeElement element();

        @Override
        @Value.Derived
        public String name() {
            return this.element().getQualifiedName().toString();
        }

        public DeclaringType associatedTopLevel() {
            return (DeclaringType)this.enclosingTopLevel().or((Object)this);
        }

        @Value.Lazy
        public Optional<DeclaringType> enclosingTopLevel() {
            TypeElement top;
            Element e = top = this.element();
            while (e.getKind() != ElementKind.PACKAGE) {
                top = e;
                e = e.getEnclosingElement();
            }
            if (top == this.element()) {
                return Optional.absent();
            }
            return Optional.of((Object)this.interner().forType(ImmutableProto.DeclaringType.builder().environment(this.environment()).interner(this.interner()).element(top).build()));
        }

        @Value.Lazy
        public Optional<CriteriaMirror> criteria() {
            return CriteriaMirror.find(this.element());
        }

        @Value.Lazy
        public Optional<RepositoryMirror> repository() {
            return RepositoryMirror.find(this.element());
        }

        @Value.Lazy
        public Optional<CriteriaRepositoryMirror> criteriaRepository() {
            return CriteriaRepositoryMirror.find(this.element());
        }

        @Value.Lazy
        public Optional<DeclaringType> enclosingOf() {
            Optional<DeclaringType> topLevel = this.enclosingTopLevel();
            if (topLevel.isPresent() && ((DeclaringType)topLevel.get()).isEnclosing()) {
                return topLevel;
            }
            return Optional.absent();
        }

        @Override
        @Value.Derived
        @Value.Auxiliary
        public DeclaringPackage packageOf() {
            Element e = this.element();
            while (e.getKind() != ElementKind.PACKAGE) {
                e = e.getEnclosingElement();
            }
            return this.interner().forPackage(ImmutableProto.DeclaringPackage.builder().environment(this.environment()).interner(this.interner()).element((PackageElement)e).build());
        }

        @Value.Lazy
        public Optional<ValueImmutableInfo> features() {
            Optional immutableAnnotation = ImmutableMirror.find(this.element()).transform((Function)ToImmutableInfo.FUNCTION);
            if (immutableAnnotation.isPresent()) {
                return immutableAnnotation;
            }
            for (String a : this.environment().round().customImmutableAnnotations()) {
                if (!Proto.isAnnotatedWith(this.element(), a)) continue;
                return Optional.of((Object)this.environment().defaultStyles().defaults());
            }
            return Optional.absent();
        }

        @Override
        @Value.Lazy
        public JacksonMode jacksonSerializeMode() {
            boolean wasJacksonSerialize = false;
            for (AnnotationMirror annotationMirror : this.element().getAnnotationMirrors()) {
                TypeElement e = (TypeElement)annotationMirror.getAnnotationType().asElement();
                if (!wasJacksonSerialize && e.getQualifiedName().contentEquals(Proto.JACKSON_SERIALIZE)) {
                    wasJacksonSerialize = true;
                }
                if (!e.getQualifiedName().contentEquals(Proto.JACKSON_DESERIALIZE)) continue;
                for (ExecutableElement executableElement : annotationMirror.getElementValues().keySet()) {
                    if (!executableElement.getSimpleName().contentEquals("builder")) continue;
                    return JacksonMode.BUILDER;
                }
                return JacksonMode.DELEGATED;
            }
            return wasJacksonSerialize ? JacksonMode.DELEGATED : JacksonMode.NONE;
        }

        @Value.Lazy
        public boolean useImmutableDefaults() {
            Optional<ValueImmutableInfo> immutables = this.features();
            if (immutables.isPresent()) {
                return ((ValueImmutableInfo)immutables.get()).isDefault();
            }
            return true;
        }

        @Value.Lazy
        public boolean isEnclosing() {
            if (EnclosingMirror.isPresent(this.element())) {
                return true;
            }
            if (this.isTopLevel()) {
                for (MetaAnnotated metaAnnotated : this.metaAnnotated()) {
                    if (!metaAnnotated.isEnclosing()) continue;
                    return true;
                }
            }
            return false;
        }

        @Value.Lazy
        public boolean isModifiable() {
            return ModifiableMirror.isPresent(this.element());
        }

        @Value.Derived
        @Value.Auxiliary
        public boolean isTopLevel() {
            return this.element().getNestingKind() == NestingKind.TOP_LEVEL;
        }

        @Value.Derived
        @Value.Auxiliary
        public boolean isJavaBean() {
            return this.element().getKind().isClass() && this.element().getKind() != ElementKind.ENUM && !this.element().getModifiers().contains((Object)Modifier.PRIVATE) && !this.element().getModifiers().contains((Object)Modifier.ABSTRACT) && (CriteriaMirror.find(this.element()).isPresent() || CriteriaRepositoryMirror.find(this.element()).isPresent());
        }

        public boolean isImmutable() {
            return this.features().isPresent();
        }

        boolean verifiedFactory(ExecutableElement element) {
            if (!this.isTopLevel() || !DeclaringType.suitableForBuilderFactory(element)) {
                this.report().withElement(element).annotationNamed(FactoryMirror.simpleName()).error("@%s method '%s' should be static, non-private, non-void and enclosed in top level type", FactoryMirror.simpleName(), element.getSimpleName());
                return false;
            }
            return true;
        }

        boolean verifiedConstructor(ExecutableElement element) {
            if (!this.isTopLevel() || !DeclaringType.suitableForBuilderConstructor(element)) {
                this.report().withElement(element).annotationNamed(FConstructorMirror.simpleName()).error("@%s annotated element should be non-private constructor in a top level type", FConstructorMirror.simpleName(), element.getSimpleName());
                return false;
            }
            return true;
        }

        static boolean suitableForBuilderConstructor(ExecutableElement element) {
            return element.getKind() == ElementKind.CONSTRUCTOR && !element.getModifiers().contains((Object)Modifier.PRIVATE);
        }

        static boolean suitableForBuilderFactory(ExecutableElement element) {
            return element.getKind() == ElementKind.METHOD && element.getReturnType().getKind() != TypeKind.VOID && !element.getModifiers().contains((Object)Modifier.PRIVATE) && element.getModifiers().contains((Object)Modifier.STATIC);
        }

        @Value.Check
        protected void validate() {
            if (this.include().isPresent() && !this.isTopLevel()) {
                this.report().annotationNamed(IncludeMirror.simpleName()).error("@%s could not be used on nested types.", IncludeMirror.simpleName());
            }
            if (this.builderInclude().isPresent() && !this.isTopLevel()) {
                this.report().annotationNamed(FIncludeMirror.simpleName()).error("@%s could not be used on nested types.", FIncludeMirror.simpleName());
            }
            if (this.isEnclosing() && !this.isTopLevel()) {
                this.report().annotationNamed(EnclosingMirror.simpleName()).error("@%s should only be used on a top-level types.", EnclosingMirror.simpleName());
            }
            if (this.isImmutable() && this.element().getKind() == ElementKind.ENUM) {
                this.report().annotationNamed(ImmutableMirror.simpleName()).error("@%s is not supported on enums", ImmutableMirror.simpleName());
            }
            if (this.isModifiable() && (this.isEnclosed() || this.isEnclosing())) {
                this.report().annotationNamed(ModifiableMirror.simpleName()).error("@%s could not be used with or within @%s", ModifiableMirror.simpleName(), EnclosingMirror.simpleName());
            }
        }

        @Value.Lazy
        public CharSequence sourceCode() {
            if (!this.isTopLevel()) {
                return this.associatedTopLevel().sourceCode();
            }
            return SourceExtraction.extract((ProcessingEnvironment)this.processing(), (TypeElement)CachingElements.getDelegate(this.element()));
        }

        @Value.Lazy
        public CharSequence headerComments() {
            if (!this.isTopLevel()) {
                return this.associatedTopLevel().headerComments();
            }
            return SourceExtraction.headerFrom((CharSequence)this.sourceCode());
        }

        @Value.Lazy
        public SourceExtraction.Imports sourceImports() {
            if (!this.isTopLevel()) {
                return this.associatedTopLevel().sourceImports();
            }
            return SourceExtraction.importsFrom((CharSequence)this.sourceCode());
        }

        public boolean isTransformer() {
            return this.getTransform().isPresent();
        }

        public boolean isVisitor() {
            return this.getVisit().isPresent();
        }

        @Value.Lazy
        public Optional<TransformMirror> getTransform() {
            return this.environment().hasTreesModule() ? TransformMirror.find(this.element()) : Optional.absent();
        }

        @Value.Lazy
        public Optional<TreesIncludeMirror> getTreesInclude() {
            return this.environment().hasTreesModule() ? TreesIncludeMirror.find(this.element()) : Optional.absent();
        }

        @Value.Lazy
        public Optional<VisitMirror> getVisit() {
            return this.environment().hasTreesModule() ? VisitMirror.find(this.element()) : Optional.absent();
        }

        @Value.Lazy
        public boolean isAst() {
            return this.environment().hasTreesModule() && AstMirror.isPresent(this.element());
        }

        public boolean isEnclosed() {
            return this.enclosingOf().isPresent();
        }

        @Override
        protected void collectEncodings(Collection<EncodingInfo> encodings) {
            if (this.enclosingTopLevel().isPresent()) {
                ((DeclaringType)this.enclosingTopLevel().get()).collectEncodings(encodings);
            }
            super.collectEncodings(encodings);
        }
    }

    @Value.Immutable
    public static abstract class DeclaringPackage
    extends AbstractDeclaring {
        @Override
        @Value.Auxiliary
        public abstract PackageElement element();

        @Override
        public DeclaringPackage packageOf() {
            return this;
        }

        @Override
        @Value.Auxiliary
        @Value.Derived
        public String simpleName() {
            return this.element().isUnnamed() ? "" : this.element().getSimpleName().toString();
        }

        @Override
        @Value.Derived
        public String name() {
            return this.element().isUnnamed() ? "" : this.element().getQualifiedName().toString();
        }

        @Value.Lazy
        Optional<DeclaringPackage> namedParentPackage() {
            String parentPackageName = SourceNames.parentPackageName(this.element());
            while (!parentPackageName.isEmpty()) {
                PackageElement parentPackage = this.environment().processing().getElementUtils().getPackageElement(parentPackageName);
                if (parentPackage != null) {
                    return Optional.of((Object)this.interner().forPackage(ImmutableProto.DeclaringPackage.builder().environment(this.environment()).interner(this.interner()).element(parentPackage).build()));
                }
                parentPackageName = SourceNames.parentPackageName(parentPackageName);
            }
            return Optional.absent();
        }

        @Override
        @Value.Lazy
        public boolean isJacksonSerialized() {
            boolean isJacksonSerialized = super.isJacksonSerialized();
            if (isJacksonSerialized) {
                return isJacksonSerialized;
            }
            Optional<DeclaringPackage> parent = this.namedParentPackage();
            if (parent.isPresent()) {
                return ((DeclaringPackage)parent.get()).isJacksonSerialized();
            }
            return false;
        }

        @Override
        @Value.Lazy
        public boolean isJacksonDeserialized() {
            if (super.isJacksonDeserialized()) {
                return true;
            }
            Optional<DeclaringPackage> parent = this.namedParentPackage();
            if (parent.isPresent()) {
                return ((DeclaringPackage)parent.get()).isJacksonDeserialized();
            }
            return false;
        }

        @Override
        @Value.Lazy
        public boolean isJacksonJsonTypeInfo() {
            if (super.isJacksonJsonTypeInfo()) {
                return true;
            }
            Optional<DeclaringPackage> parent = this.namedParentPackage();
            if (parent.isPresent()) {
                return ((DeclaringPackage)parent.get()).isJacksonJsonTypeInfo();
            }
            return false;
        }

        @Override
        @Value.Lazy
        public boolean isSerialStructural() {
            boolean isSerialStructural = super.isSerialStructural();
            if (isSerialStructural) {
                return isSerialStructural;
            }
            Optional<DeclaringPackage> parent = this.namedParentPackage();
            if (parent.isPresent()) {
                return ((DeclaringPackage)parent.get()).isSerialStructural();
            }
            return false;
        }

        @Override
        @Value.Lazy
        public Optional<Long> serialVersion() {
            Optional<Long> serialVersion = super.serialVersion();
            if (serialVersion.isPresent()) {
                return serialVersion;
            }
            Optional<DeclaringPackage> parent = this.namedParentPackage();
            if (parent.isPresent()) {
                return ((DeclaringPackage)parent.get()).serialVersion();
            }
            return Optional.absent();
        }

        @Override
        @Value.Lazy
        public Optional<StyleInfo> style() {
            Optional<StyleInfo> style = super.style();
            if (style.isPresent()) {
                return style;
            }
            Optional<DeclaringPackage> parent = this.namedParentPackage();
            if (parent.isPresent()) {
                return ((DeclaringPackage)parent.get()).style();
            }
            return Optional.absent();
        }

        @Override
        @Value.Lazy
        public Optional<String[]> depluralize() {
            Optional<String[]> depluralize;
            String[] dictionary = null;
            Optional<DeclaringPackage> parent = this.namedParentPackage();
            if (parent.isPresent() && (depluralize = ((DeclaringPackage)parent.get()).depluralize()).isPresent()) {
                dictionary = Proto.concat(dictionary, (String[])depluralize.get());
            }
            if ((depluralize = super.depluralize()).isPresent()) {
                dictionary = Proto.concat(dictionary, (String[])depluralize.get());
            }
            return Optional.fromNullable(dictionary);
        }

        @Override
        protected void collectEncodings(Collection<EncodingInfo> encodings) {
            Optional<DeclaringPackage> parent = this.namedParentPackage();
            if (parent.isPresent()) {
                ((DeclaringPackage)parent.get()).collectEncodings(encodings);
            }
            super.collectEncodings(encodings);
        }

        @Override
        @Value.Lazy
        public Optional<DataMirror> datatypeEnabled() {
            Optional<DataMirror> datatypeMarker = super.datatypeEnabled();
            if (datatypeMarker.isPresent()) {
                return datatypeMarker;
            }
            Optional<DeclaringPackage> parent = this.namedParentPackage();
            if (parent.isPresent()) {
                return ((DeclaringPackage)parent.get()).datatypeEnabled();
            }
            return Optional.absent();
        }
    }

    public static enum JacksonMode {
        NONE,
        DELEGATED,
        BUILDER;

    }

    public static abstract class AbstractDeclaring
    extends Diagnosable {
        private final List<AnnotationInjections.AnnotationInjection> annotationInjections = new ArrayList<AnnotationInjections.AnnotationInjection>();

        public abstract String name();

        @Override
        @Value.Auxiliary
        public abstract Element element();

        public abstract DeclaringPackage packageOf();

        @Value.Lazy
        protected Optional<IncludeMirror> include() {
            return IncludeMirror.find(this.element());
        }

        @Value.Lazy
        protected Optional<FIncludeMirror> builderInclude() {
            return FIncludeMirror.find(this.element());
        }

        public String asPrefix() {
            return this.name().isEmpty() ? "" : this.name() + ".";
        }

        public Optional<DeclaringType> asType() {
            return this instanceof DeclaringType ? Optional.of((Object)((DeclaringType)this)) : Optional.absent();
        }

        @Value.Auxiliary
        abstract Interning interner();

        @Value.Lazy
        public Optional<TypeAdaptersMirror> typeAdapters() {
            return TypeAdaptersMirror.find(this.element());
        }

        @Value.Lazy
        public Optional<OkTypeAdaptersMirror> okTypeAdapters() {
            return OkTypeAdaptersMirror.find(this.element());
        }

        @Value.Lazy
        List<TypeElement> includedTypes() {
            Optional<IncludeMirror> includes = this.include();
            ImmutableList typeMirrors = includes.isPresent() ? ImmutableList.copyOf((Object[])((IncludeMirror)includes.get()).valueMirror()) : ImmutableList.of();
            FluentIterable typeElements = FluentIterable.from((Iterable)typeMirrors).filter(DeclaredType.class).transform((Function)DeclatedTypeToElement.FUNCTION);
            ImmutableSet uniqueTypeNames = typeElements.filter((Predicate)IsPublic.PREDICATE).transform((Function)ElementToName.FUNCTION).toSet();
            if (uniqueTypeNames.size() != typeMirrors.size()) {
                this.report().annotationNamed(IncludeMirror.simpleName()).warning(Reporter.About.INCOMPAT, "Some types were ignored, non-supported for inclusion: duplicates, non declared reference types, non-public", new Object[0]);
            }
            return typeElements.toList();
        }

        @Value.Lazy
        List<TypeElement> builderIncludedTypes() {
            Optional<FIncludeMirror> includes = this.builderInclude();
            ImmutableList typeMirrors = includes.isPresent() ? ImmutableList.copyOf((Object[])((FIncludeMirror)includes.get()).valueMirror()) : ImmutableList.of();
            FluentIterable typeElements = FluentIterable.from((Iterable)typeMirrors).filter(DeclaredType.class).transform((Function)DeclatedTypeToElement.FUNCTION);
            ImmutableSet uniqueTypeNames = typeElements.filter((Predicate)IsPublic.PREDICATE).transform((Function)ElementToName.FUNCTION).toSet();
            if (uniqueTypeNames.size() != typeMirrors.size()) {
                this.report().annotationNamed(IncludeMirror.simpleName()).warning(Reporter.About.INCOMPAT, "Some types were ignored, non-supported for inclusion: duplicates, non declared reference types, non-public", new Object[0]);
            }
            return typeElements.toList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<AnnotationInjections.AnnotationInjection> getAnnotationInjections() {
            if (!this.environment().hasAnnotateModule()) {
                return ImmutableList.of();
            }
            this.metaAnnotated();
            List<AnnotationInjections.AnnotationInjection> list = this.annotationInjections;
            synchronized (list) {
                return ImmutableList.copyOf(this.annotationInjections);
            }
        }

        @Value.Lazy
        List<MetaAnnotated> metaAnnotated() {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (AnnotationMirror annotationMirror : this.element().getAnnotationMirrors()) {
                MetaAnnotated meta = MetaAnnotated.from(annotationMirror, this.environment());
                this.registerAnnotationInjection(annotationMirror, meta);
                builder.add((Object)meta);
            }
            return builder.build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerAnnotationInjection(AnnotationMirror mirror, MetaAnnotated meta) {
            for (AnnotationInjections.InjectionInfo info : meta.injectAnnotation()) {
                AnnotationInjections.AnnotationInjection injection = info.injectionFor(mirror, this.environment());
                List<AnnotationInjections.AnnotationInjection> list = this.annotationInjections;
                synchronized (list) {
                    this.annotationInjections.add(injection);
                }
            }
        }

        @Value.Lazy
        public Optional<StyleInfo> style() {
            Optional style = StyleMirror.find(this.element()).transform((Function)ToStyleInfo.FUNCTION);
            if (style.isPresent()) {
                return style;
            }
            for (MetaAnnotated m : this.metaAnnotated()) {
                Optional<StyleInfo> metaStyle = m.style();
                if (!metaStyle.isPresent()) continue;
                return metaStyle;
            }
            return Optional.absent();
        }

        @Value.Lazy
        public Optional<DataMirror> datatypeEnabled() {
            Optional<DataMirror> datatypeOwn = DataMirror.find(this.element());
            if (datatypeOwn.isPresent()) {
                return datatypeOwn;
            }
            for (MetaAnnotated m : this.metaAnnotated()) {
                Optional<DataMirror> d = m.datatypeEnabled();
                if (!d.isPresent()) continue;
                return d;
            }
            return Optional.absent();
        }

        @Value.Lazy
        public Optional<Long> serialVersion() {
            Optional<VersionMirror> version = VersionMirror.find(this.element());
            if (version.isPresent()) {
                return Optional.of((Object)((VersionMirror)version.get()).value());
            }
            for (MetaAnnotated metaAnnotated : this.metaAnnotated()) {
                Optional<Long> serialVersion = metaAnnotated.serialVersion();
                if (!serialVersion.isPresent()) continue;
                return serialVersion;
            }
            return Optional.absent();
        }

        @Value.Lazy
        public boolean isSerialStructural() {
            return StructuralMirror.isPresent(this.element());
        }

        @Value.Lazy
        public boolean isJacksonSerialized() {
            if (this.jacksonSerializeMode() == JacksonMode.DELEGATED) {
                return true;
            }
            for (MetaAnnotated metaAnnotated : this.metaAnnotated()) {
                if (!metaAnnotated.isJacksonSerialized()) continue;
                return true;
            }
            return false;
        }

        @Value.Lazy
        public JacksonMode jacksonSerializeMode() {
            return Proto.isJacksonSerializedAnnotated(this.element()) ? JacksonMode.DELEGATED : JacksonMode.NONE;
        }

        @Value.Lazy
        public boolean isJacksonDeserialized() {
            if (this.isJacksonDeserializedAnnotated()) {
                return true;
            }
            for (MetaAnnotated metaAnnotated : this.metaAnnotated()) {
                if (!metaAnnotated.isJacksonDeserialized()) continue;
                return true;
            }
            return false;
        }

        protected void collectEncodings(Collection<EncodingInfo> encodings) {
            for (MetaAnnotated m : this.metaAnnotated()) {
                encodings.addAll(m.encodings());
            }
        }

        @Value.Lazy
        public Optional<String[]> depluralize() {
            String[] dictionary = null;
            for (MetaAnnotated metaAnnotated : this.metaAnnotated()) {
                Optional<String[]> depluralize = metaAnnotated.depluralize();
                if (!depluralize.isPresent()) continue;
                dictionary = Proto.concat(dictionary, (String[])depluralize.get());
            }
            Optional<DepluralizeMirror> depluralize = DepluralizeMirror.find(this.element());
            if (depluralize.isPresent()) {
                dictionary = Proto.concat(dictionary, ((DepluralizeMirror)depluralize.get()).dictionary());
            }
            return Optional.fromNullable(dictionary);
        }

        @Value.Lazy
        public boolean isJacksonDeserializedAnnotated() {
            return Proto.isJacksonDeserializedAnnotated(this.element());
        }

        @Value.Lazy
        public boolean isJacksonJsonTypeInfo() {
            if (Proto.isJacksonJsonTypeInfoAnnotated(this.element())) {
                return true;
            }
            for (MetaAnnotated metaAnnotated : this.metaAnnotated()) {
                if (!metaAnnotated.isJacksonJsonTypeInfo()) continue;
                return true;
            }
            return false;
        }
    }

    @Value.Immutable
    public static abstract class Environment {
        private final Map<Set<EncodingInfo>, Instantiator> instantiators = new HashMap<Set<EncodingInfo>, Instantiator>();

        @Value.Parameter
        abstract ProcessingEnvironment processing();

        @Value.Parameter
        abstract Round round();

        @Value.Derived
        StyleInfo defaultStyles() {
            TypeElement element = this.findElement(StyleMirror.qualifiedName());
            if (element == null) {
                this.processing().getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Could not found annotations on the compile classpath. It looks like annotation processor is running in a separate annotation-processing classpath and unable to get to annotation definitions. To fix this, please add annotation-only artifact 'org.immutables:value:(version):annotations' to 'compile' 'compileOnly' or 'provided' dependency scope.");
                element = this.findElement(StyleMirror.mirrorQualifiedName());
                Verify.verify((element != null ? 1 : 0) != 0, (String)"Classpath should contain at least mirror annotation, otherwise library is corrupted", (Object[])new Object[0]);
            }
            try {
                return ToStyleInfo.FUNCTION.apply(StyleMirror.from(element));
            }
            catch (Exception ex) {
                this.processing().getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "The version of the Immutables annotation on the classpath has incompatible differences from the Immutables annotation processor used. Various problems might occur, like this one: " + ex);
                element = this.findElement(StyleMirror.mirrorQualifiedName());
                Verify.verify((element != null ? 1 : 0) != 0, (String)"classpath should contain at least the mirror annotation, otherwise library is corrupted", (Object[])new Object[0]);
                return ToStyleInfo.FUNCTION.apply(StyleMirror.from(element));
            }
        }

        @Nullable
        @Value.Lazy
        String typeMoreObjects() {
            for (String shortName : Arrays.asList("base.MoreObjects", "base.Objects")) {
                String name = UnshadeGuava.typeString(shortName);
                if (!this.hasElement(name)) continue;
                return name;
            }
            return null;
        }

        public boolean hasGuavaLib() {
            return this.typeMoreObjects() != null;
        }

        @Value.Lazy
        public boolean hasOkJsonLib() {
            return this.hasElement("com.squareup.moshi.Moshi");
        }

        @Value.Lazy
        public boolean hasGsonLib() {
            return this.hasElement("com.google.gson.Gson");
        }

        @Value.Lazy
        public boolean hasDatatypesModule() {
            return this.hasElement(DataMirror.qualifiedName());
        }

        @Value.Lazy
        public boolean hasJacksonLib() {
            return this.hasElement(Proto.JACKSON_DESERIALIZE);
        }

        @Value.Lazy
        public boolean hasCriteriaModule() {
            return this.hasElement(CriteriaMirror.qualifiedName());
        }

        @Value.Lazy
        public boolean hasMongoModule() {
            return this.hasElement(RepositoryMirror.qualifiedName());
        }

        @Value.Lazy
        public boolean hasSerialModule() {
            return this.hasElement(VersionMirror.qualifiedName());
        }

        @Value.Lazy
        public boolean hasTreesModule() {
            return this.hasElement(TransformMirror.qualifiedName());
        }

        @Value.Lazy
        public boolean hasAstModule() {
            return this.hasElement(AstMirror.qualifiedName());
        }

        @Value.Lazy
        public boolean hasOrdinalModule() {
            return this.hasElement(Proto.ORDINAL_VALUE_INTERFACE_TYPE);
        }

        @Value.Lazy
        public boolean hasBuilderModule() {
            return this.hasElement(FactoryMirror.qualifiedName());
        }

        @Value.Lazy
        public boolean hasFuncModule() {
            return this.hasElement(FunctionalMirror.qualifiedName());
        }

        @Value.Lazy
        public boolean hasEncodeModule() {
            return this.hasElement(EncodingMirror.qualifiedName());
        }

        @Value.Lazy
        public boolean hasAnnotateModule() {
            return this.hasElement(InjectAnnotationMirror.qualifiedName());
        }

        @Value.Lazy
        public boolean hasJava9Collections() {
            for (SourceVersion v9 : SourceVersion.values()) {
                if (!v9.name().equals("RELEASE_9") || this.processing().getSourceVersion().compareTo(v9) < 0) continue;
                TypeElement element = this.findElement(List.class.getCanonicalName());
                assert (element != null) : "always present in modern JREs";
                for (ExecutableElement e : ElementFilter.methodsIn(element.getEnclosedElements())) {
                    if (!e.getModifiers().contains((Object)Modifier.STATIC) || !e.getSimpleName().contentEquals("of")) continue;
                    return true;
                }
            }
            return false;
        }

        @Value.Lazy
        TypeAdaptersMirror defaultTypeAdapters() {
            TypeElement typeElement = this.findElement(TypeAdaptersMirror.qualifiedName());
            Preconditions.checkState((typeElement != null ? 1 : 0) != 0, (String)"Processor internal error, @%s is not know to be on the classpath", (Object[])new Object[]{TypeAdaptersMirror.qualifiedName()});
            return TypeAdaptersMirror.from(typeElement);
        }

        ValueType composeValue(Protoclass protoclass) {
            return this.round().composeValue(protoclass);
        }

        ImmutableList<Protoclass> protoclassesFrom(Iterable<? extends Element> elements) {
            return this.round().protoclassesFrom(elements);
        }

        private boolean hasElement(String qualifiedName) {
            return this.findElement(qualifiedName) != null;
        }

        @Nullable
        private TypeElement findElement(String qualifiedName) {
            if (ClasspathFence.isInhibited((String)qualifiedName)) {
                return null;
            }
            try {
                TypeElement typeElement = this.processing().getElementUtils().getTypeElement(qualifiedName);
                return typeElement;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        Instantiator instantiatorFor(Set<EncodingInfo> encodings) {
            return this.instantiators.computeIfAbsent(encodings, key -> Proto.typeFactoryAndInflater().inflater.instantiatorFor((Set<EncodingInfo>)key));
        }

        public boolean isCheckedException(TypeMirror throwable) {
            return this.checkedExceptionProbe().isCheckedException(throwable);
        }

        @Value.Lazy
        CheckedExceptionProbe checkedExceptionProbe() {
            return new CheckedExceptionProbe(this.processing().getTypeUtils(), this.processing().getElementUtils());
        }
    }

    static abstract class Diagnosable {
        Diagnosable() {
        }

        @Value.Auxiliary
        abstract Element element();

        @Value.Auxiliary
        abstract Environment environment();

        ProcessingEnvironment processing() {
            return this.environment().processing();
        }

        @Value.Auxiliary
        @Value.Derived
        public String simpleName() {
            return this.element().getSimpleName().toString();
        }

        public Reporter report() {
            return Reporter.from(this.processing()).withElement(this.element());
        }
    }

    private static class MetaAnnotatedCache
    implements Runnable {
        final ConcurrentMap<String, MetaAnnotated> cache = new ConcurrentHashMap<String, MetaAnnotated>(16, 0.7f, 1);

        private MetaAnnotatedCache() {
        }

        @Override
        public void run() {
            this.cache.clear();
        }
    }

    @Value.Immutable(builder=false)
    public static abstract class MetaAnnotated {
        @Value.Parameter
        @Value.Auxiliary
        public abstract Element element();

        @Value.Parameter
        @Value.Auxiliary
        public abstract String qualifiedName();

        @Value.Parameter
        @Value.Auxiliary
        public abstract Environment environment();

        @Value.Derived
        @Value.Auxiliary
        public Set<EncodingInfo> encodings() {
            if (this.qualifiedName().endsWith("Enabled") || CustomImmutableAnnotations.annotations().contains((Object)this.qualifiedName()) || this.style().isPresent()) {
                Optional encoding = EncMetadataMirror.find(this.element()).transform((Function)Proto.typeFactoryAndInflater().inflater);
                if (encoding.isPresent()) {
                    return encoding.asSet();
                }
                ArrayList<EncodingInfo> result = new ArrayList<EncodingInfo>();
                for (AnnotationMirror annotationMirror : this.element().getAnnotationMirrors()) {
                    MetaAnnotated metaAnnotated = MetaAnnotated.from(annotationMirror, this.environment());
                    result.addAll(metaAnnotated.encodings());
                }
                if (!result.isEmpty()) {
                    return ImmutableSet.copyOf(result);
                }
            }
            return ImmutableSet.of();
        }

        @Value.Derived
        @Value.Auxiliary
        public Optional<DataMirror> datatypeEnabled() {
            return DataMirror.find(this.element());
        }

        @Value.Derived
        @Value.Auxiliary
        public Optional<StyleInfo> style() {
            return StyleMirror.find(this.element()).transform((Function)ToStyleInfo.FUNCTION);
        }

        @Value.Derived
        @Value.Auxiliary
        public Optional<String[]> depluralize() {
            Optional<DepluralizeMirror> d = DepluralizeMirror.find(this.element());
            if (d.isPresent()) {
                return Optional.of((Object)((DepluralizeMirror)d.get()).dictionary());
            }
            return Optional.absent();
        }

        @Value.Derived
        @Value.Auxiliary
        public Optional<Long> serialVersion() {
            if (!this.environment().hasSerialModule()) {
                return Optional.absent();
            }
            Optional<VersionMirror> version = VersionMirror.find(this.element());
            return version.isPresent() ? Optional.of((Object)((VersionMirror)version.get()).value()) : Optional.absent();
        }

        @Value.Derived
        @Value.Auxiliary
        public boolean isSerialStructural() {
            return this.environment().hasSerialModule() && StructuralMirror.isPresent(this.element());
        }

        @Value.Derived
        @Value.Auxiliary
        public boolean isJacksonSerialized() {
            return this.environment().hasJacksonLib() && Proto.isJacksonSerializedAnnotated(this.element());
        }

        @Value.Derived
        @Value.Auxiliary
        public boolean isJacksonDeserialized() {
            return this.environment().hasJacksonLib() && Proto.isJacksonDeserializedAnnotated(this.element());
        }

        @Value.Derived
        @Value.Auxiliary
        public boolean isJacksonJsonTypeInfo() {
            return this.environment().hasJacksonLib() && Proto.isJacksonJsonTypeInfoAnnotated(this.element());
        }

        @Value.Derived
        @Value.Auxiliary
        public boolean isJsonQualifier() {
            return this.environment().hasOkJsonLib() && OkQualifierMirror.isPresent(this.element());
        }

        @Value.Derived
        @Value.Auxiliary
        public boolean isEnclosing() {
            return EnclosingMirror.isPresent(this.element());
        }

        @Value.Derived
        @Value.Auxiliary
        public ImmutableList<AnnotationInjections.InjectionInfo> injectAnnotation() {
            if (this.environment().hasAnnotateModule()) {
                Optional<InjectManyAnnotationsMirror> injectMany;
                ImmutableList.Builder builder = ImmutableList.builder();
                Optional<InjectAnnotationMirror> injectAnnotation = InjectAnnotationMirror.find(this.element());
                if (injectAnnotation.isPresent()) {
                    builder.add((Object)ToInjectionInfo.FUNCTION.apply((InjectAnnotationMirror)injectAnnotation.get()));
                }
                if ((injectMany = InjectManyAnnotationsMirror.find(this.element())).isPresent()) {
                    for (InjectAnnotationMirror m : ((InjectManyAnnotationsMirror)injectMany.get()).value()) {
                        builder.add((Object)ToInjectionInfo.FUNCTION.apply(m));
                    }
                }
                return builder.build();
            }
            return ImmutableList.of();
        }

        public static MetaAnnotated from(AnnotationMirror mirror, Environment environment) {
            TypeElement element = (TypeElement)mirror.getAnnotationType().asElement();
            String name = element.getQualifiedName().toString();
            return MetaAnnotated.metaAnnotatedCache().computeIfAbsent(name, n -> ImmutableProto.MetaAnnotated.of(element, name, environment));
        }

        private static ConcurrentMap<String, MetaAnnotated> metaAnnotatedCache() {
            return ((MetaAnnotatedCache)EnvironmentState.getPerProcessing(MetaAnnotatedCache.class, (Supplier)(Supplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$metaAnnotatedCache$1(), ()Lorg/immutables/value/processor/meta/Proto$MetaAnnotatedCache;)())).cache;
        }

        private static /* synthetic */ MetaAnnotatedCache lambda$metaAnnotatedCache$1() {
            return new MetaAnnotatedCache();
        }
    }

    static final class Interning {
        private final Interner<DeclaringPackage> packageInterner = Interners.newStrongInterner();
        private final Interner<DeclaringType> typeInterner = Interners.newStrongInterner();
        private final Interner<Protoclass> protoclassInterner = Interners.newStrongInterner();

        Interning() {
        }

        DeclaringPackage forPackage(DeclaringPackage declaringPackage) {
            return (DeclaringPackage)this.packageInterner.intern((Object)declaringPackage);
        }

        DeclaringType forType(DeclaringType declaringType) {
            return (DeclaringType)this.typeInterner.intern((Object)declaringType);
        }

        Protoclass forProto(Protoclass protoclass) {
            return (Protoclass)this.protoclassInterner.intern((Object)protoclass);
        }
    }

    private static class TypeFactoryAndInflater
    implements Runnable {
        final Type.Factory factory = new Type.Producer();
        final Inflater inflater = new Inflater(this.factory);

        private TypeFactoryAndInflater() {
        }

        @Override
        public void run() {
        }
    }
}

