/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.encode;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.immutables.value.processor.encode.Eq;

final class Code {
    private static final CharMatcher DELIMITER = CharMatcher.anyOf((CharSequence)"!\"#$%&'()*+,-./:;<=>?@[]^{|}~");
    private static final CharMatcher WHITESPACE = CharMatcher.whitespace();
    private static final CharMatcher LETTER_OR_DIGIT = CharMatcher.javaLetterOrDigit().or(CharMatcher.anyOf((CharSequence)"$_"));
    private static final CharMatcher IDENTIFIER_START = CharMatcher.javaLetter().or(CharMatcher.anyOf((CharSequence)"$_"));

    private Code() {
    }

    static boolean usesThis(List<Term> code) {
        for (Term t : code) {
            if (!t.isBinding() || !(t instanceof Binding)) continue;
            Binding b = (Binding)t;
            if (b.isTop() && b.identifier().equals("this")) {
                return true;
            }
            if (!b.isField() && !b.isMethod()) continue;
            return true;
        }
        return false;
    }

    static String join(List<Term> terms) {
        return Joiner.on((String)"").join(terms);
    }

    static List<Term> termsFrom(String input) {
        Scanner s = new Scanner(input);
        s.scan();
        return s.terms;
    }

    static List<Term> trimLeadingIndent(List<Term> code) {
        ArrayList<Term> result = new ArrayList<Term>(code);
        ListIterator<Term> it = result.listIterator();
        while (it.hasNext()) {
            String whitespace;
            int indexOf;
            Term t = it.next();
            if (!t.isWhitespace() || (indexOf = (whitespace = t.toString()).indexOf(10)) < 0) continue;
            it.set(new Whitespace(whitespace.substring(0, indexOf + 1)));
        }
        return result;
    }

    static List<Term> replaceReturn(List<Term> code, String replacement) {
        ListIterator<Term> revIt;
        ArrayList<Term> result = new ArrayList<Term>(code);
        ListIterator<Term> it = result.listIterator();
        boolean wasReturn = false;
        while (it.hasNext()) {
            Term t = it.next();
            if (!t.isWordOrNumber() || !t.is("return")) continue;
            it.set(new Other(replacement));
            wasReturn = true;
        }
        if (!wasReturn && Code.nextNonBlankIs(revIt = Lists.reverse(result).listIterator(), "}")) {
            Code.nextNonBlankIs(revIt, ";");
            revIt.previous();
            revIt.add(new Delimiter(";"));
            revIt.add(new Other(replacement));
            revIt.add(new Whitespace("\n"));
        }
        return result;
    }

    static List<Term> oneLiner(List<Term> code) {
        Iterator<Term> it;
        if (!code.isEmpty() && Code.nextNonBlankIs(it = code.iterator(), "{") && Code.nextNonBlankIs(it, "return")) {
            ListIterator<Term> revIt;
            ArrayList<Term> line = new ArrayList<Term>();
            while (it.hasNext()) {
                Term t = it.next();
                if (line.isEmpty() && t.isIgnorable()) continue;
                line.add(t);
            }
            if (line.size() > 2 && Code.nextNonBlankIs(revIt = Lists.reverse(line).listIterator(), "}") && Code.nextNonBlankIs(revIt, ";")) {
                Term t;
                while (revIt.hasNext() && (t = revIt.next()).isIgnorable()) {
                    revIt.remove();
                }
                if (revIt.hasPrevious()) {
                    revIt.previous();
                }
                while (revIt.hasPrevious()) {
                    revIt.previous();
                    revIt.remove();
                }
                return ImmutableList.copyOf(line);
            }
        }
        return ImmutableList.of();
    }

    private static boolean nextNonBlankIs(Iterator<Term> terms, String string) {
        while (terms.hasNext()) {
            Term t = terms.next();
            if (t.isIgnorable()) continue;
            return t.is(string);
        }
        return false;
    }

    static final class Binding
    extends Term {
        Binding(String string) {
            super(string);
        }

        String identifier() {
            return this.toString().substring(2);
        }

        boolean isTop() {
            return this.charAt(1) == '^';
        }

        boolean isField() {
            return this.charAt(1) == '@';
        }

        boolean isMethod() {
            return this.charAt(1) == ':';
        }

        @Override
        boolean isBinding() {
            return true;
        }

        static Binding newField(String identifier) {
            return new Binding("@@" + identifier);
        }

        static Binding newMethod(String identifier) {
            return new Binding("@:" + identifier);
        }

        static Binding newTop(String identifier) {
            return new Binding("@^" + identifier);
        }

        static boolean chars(char c0, char c1) {
            return c0 == '@' && (c1 == '@' || c1 == '^' || c1 == ':');
        }
    }

    private static final class Other
    extends Term {
        Other(String value) {
            super(value);
        }

        Other replace(String search, String replacement) {
            StringBuilder builder = new StringBuilder(this);
            int index = builder.indexOf(search);
            if (index < 0) {
                return this;
            }
            builder.replace(index, index + search.length(), replacement);
            return new Other(builder.toString());
        }

        @Override
        boolean isComment() {
            return this.charAt(0) == '/';
        }

        @Override
        boolean isString() {
            return this.charAt(0) == '\"';
        }
    }

    static final class Whitespace
    extends Term {
        static final Whitespace EMPTY = new Whitespace("");

        Whitespace(String value) {
            super(value);
        }

        @Override
        boolean isWhitespace() {
            return true;
        }
    }

    private static final class Delimiter
    extends Term {
        Delimiter(String value) {
            super(value);
        }

        @Override
        boolean isDelimiter() {
            return true;
        }
    }

    static final class WordOrNumber
    extends Term {
        WordOrNumber(String string) {
            super(string);
        }

        @Override
        boolean isWordOrNumber() {
            return true;
        }
    }

    static abstract class Term
    extends Eq<Term>
    implements CharSequence {
        private final String string;

        Term(String string) {
            super(string);
            this.string = string;
        }

        char charOf() {
            if (this.string.length() == 1) {
                return this.string.charAt(0);
            }
            throw new IllegalStateException("'" + this + "' term is not a single character");
        }

        boolean isWordOrNumber() {
            return false;
        }

        boolean isDelimiter() {
            return false;
        }

        boolean isIgnorable() {
            return this.isWhitespace() || this.isComment();
        }

        boolean isWhitespace() {
            return false;
        }

        boolean isBinding() {
            return false;
        }

        boolean isComment() {
            return false;
        }

        boolean isString() {
            return false;
        }

        boolean is(char c) {
            return this.length() == 1 && this.charAt(0) == c;
        }

        boolean is(String string) {
            return this.string.equals(string);
        }

        @Override
        public String toString() {
            return this.string;
        }

        @Override
        protected boolean eq(Term other) {
            return this.string.equals(other.string);
        }

        @Override
        public int length() {
            return this.string.length();
        }

        @Override
        public char charAt(int index) {
            return this.string.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.string.subSequence(start, end);
        }
    }

    static class Scanner {
        final List<Term> terms = new ArrayList<Term>();
        private final String input;

        Scanner(String input) {
            this.input = input;
        }

        void scan() {
            char c;
            int p = 0;
            while ((c = this.get(p)) != '\u0000') {
                int end;
                if (c == '/' && this.get(p + 1) == '/') {
                    end = this.slashSlashComment(p + 2);
                    int n = p;
                    p = end;
                    this.terms.add(new Other(this.get(n, p)));
                    continue;
                }
                if (c == '/' && this.get(p + 1) == '*') {
                    end = this.slashStarComment(p + 2);
                    int n = p;
                    p = end;
                    this.terms.add(new Other(this.get(n, p)));
                    continue;
                }
                if (c == '\'' || c == '\"') {
                    end = this.quotedLiteral(p + 1, c);
                    int n = p;
                    p = end;
                    this.terms.add(new Other(this.get(n, p)));
                    continue;
                }
                if (c == '@' && Binding.chars(c, this.get(p + 1))) {
                    end = this.whileMatches(p + 2, LETTER_OR_DIGIT);
                    int n = p;
                    p = end;
                    this.terms.add(new Binding(this.get(n, p)));
                    continue;
                }
                if (DELIMITER.matches(c)) {
                    this.terms.add(new Delimiter(this.get(p++, p)));
                    continue;
                }
                if (LETTER_OR_DIGIT.matches(c)) {
                    end = this.whileMatches(p + 1, LETTER_OR_DIGIT);
                    int n = p;
                    p = end;
                    this.terms.add(new WordOrNumber(this.get(n, p)));
                    continue;
                }
                if (WHITESPACE.matches(c)) {
                    end = this.whileMatches(p + 1, WHITESPACE);
                    int n = p;
                    p = end;
                    this.terms.add(new Whitespace(this.get(n, p)));
                    continue;
                }
                this.terms.add(new Other(this.get(p++, p)));
            }
        }

        private int whileMatches(int p, CharMatcher matcher) {
            while (matcher.matches(this.get(p))) {
                ++p;
            }
            return p;
        }

        private int quotedLiteral(int p, char quote) {
            while (true) {
                char c;
                if ((c = this.get(p++)) == '\\') {
                    ++p;
                    continue;
                }
                if (c == quote) break;
            }
            return p++;
        }

        private int slashSlashComment(int p) {
            char c;
            while ((c = this.get(p++)) != '\u0000' && c != '\n') {
            }
            return p - 1;
        }

        private int slashStarComment(int p) {
            char c;
            do {
                if ((c = this.get(p++)) != '\u0000') continue;
                return p;
            } while (c != '*' || this.get(p) != '/');
            return p + 1;
        }

        private String get(int from, int to) {
            return this.input.substring(Math.max(0, from), Math.min(to, this.input.length()));
        }

        private char get(int i) {
            if (i < 0 || i >= this.input.length()) {
                return '\u0000';
            }
            return this.input.charAt(i);
        }
    }

    static class Binder {
        private final Map<String, String> imports;
        private final Set<Binding> bindings;

        Binder(Map<String, String> imports, Set<Binding> bindings) {
            this.imports = imports;
            this.bindings = bindings;
        }

        List<Term> apply(List<Term> terms) {
            ArrayList<Term> result = new ArrayList<Term>();
            try {
                this.resolve(terms, terms.listIterator(), result, false);
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot bind: " + Code.join(terms), ex);
            }
            return result;
        }

        private void resolve(List<Term> inputTerms, ListIterator<Term> it, List<Term> result, boolean untilGenericsClose) {
            State state = State.NONE;
            while (it.hasNext()) {
                String identifier;
                Term t = it.next();
                if (untilGenericsClose && t.is(">")) {
                    result.add(t);
                    return;
                }
                if ((state == State.DOT || state == State.THIS_DOT || untilGenericsClose) && t.is("<")) {
                    result.add(t);
                    this.resolve(inputTerms, it, result, true);
                    continue;
                }
                if ((state = state.next(t, inputTerms, it.nextIndex())).isValue()) {
                    identifier = t.toString();
                    Binding top = Binding.newTop(identifier);
                    Binding field = Binding.newField(identifier);
                    if (state == State.TOP_VALUE && this.bindings.contains(top)) {
                        result.add(top);
                        continue;
                    }
                    if (this.bindings.contains(field)) {
                        result.add(field);
                        continue;
                    }
                    if (state == State.TOP_VALUE && this.imports.containsKey(identifier)) {
                        String qualifiedName = this.imports.get(identifier);
                        result.addAll(Code.termsFrom(qualifiedName));
                        continue;
                    }
                    result.add(t);
                    continue;
                }
                if (state.isMethod()) {
                    identifier = t.toString();
                    if (this.imports.containsKey(identifier)) {
                        String qualifiedName = this.imports.get(identifier);
                        result.addAll(Code.termsFrom(qualifiedName));
                        continue;
                    }
                    Binding method = Binding.newMethod(identifier);
                    if (this.bindings.contains(method)) {
                        result.add(method);
                        continue;
                    }
                    result.add(t);
                    continue;
                }
                result.add(t);
            }
        }

        List<Term> parameterAsThis(List<Term> result, String param) {
            Term t;
            Binding thisSubstitute = Binding.newTop("this");
            WordOrNumber thisToken = new WordOrNumber("this");
            ListIterator<Term> it = result.listIterator();
            while (it.hasNext()) {
                Binding b;
                t = it.next();
                if (t.is("this")) {
                    it.set(thisSubstitute);
                    continue;
                }
                if (!t.isBinding() || !(b = (Binding)t).isTop() || !b.identifier().equals(param)) continue;
                it.set(thisToken);
            }
            result = this.apply(result);
            it = result.listIterator();
            while (it.hasNext()) {
                t = it.next();
                if (t == thisToken) {
                    it.set(Binding.newTop(param));
                    continue;
                }
                if (t != thisSubstitute) continue;
                it.set(thisToken);
            }
            return result;
        }

        static enum State {
            NONE,
            DOT,
            THIS,
            THIS_DOT,
            THIS_1COLON,
            THIS_2COLONS,
            TOP_VALUE,
            TOP_METHOD,
            THIS_VALUE,
            THIS_METHOD,
            THIS_METHOD_REFERENCE;


            boolean isValue() {
                return this == TOP_VALUE || this == THIS_VALUE;
            }

            boolean isMethod() {
                return this == TOP_METHOD || this == THIS_METHOD || this == THIS_METHOD_REFERENCE;
            }

            State next(Term t, List<Term> inputTerms, int nextIndex) {
                boolean isIdent;
                boolean isDot = t.isDelimiter() && t.is(".");
                boolean isColon = t.isDelimiter() && t.is(":");
                boolean isThis = t.isWordOrNumber() && t.is("this");
                boolean bl = isIdent = t.isWordOrNumber() && !isThis && IDENTIFIER_START.matches(t.toString().charAt(0));
                if (t.isIgnorable()) {
                    return this;
                }
                if (isDot) {
                    switch (this) {
                        case THIS: {
                            return THIS_DOT;
                        }
                    }
                    return DOT;
                }
                if (isColon) {
                    switch (this) {
                        case THIS: {
                            return THIS_1COLON;
                        }
                        case THIS_1COLON: {
                            return THIS_2COLONS;
                        }
                    }
                    return NONE;
                }
                if (isThis) {
                    return THIS;
                }
                if (isIdent) {
                    switch (this) {
                        case THIS_2COLONS: {
                            return THIS_METHOD_REFERENCE;
                        }
                        case THIS_DOT: {
                            if (Code.nextNonBlankIs(inputTerms.listIterator(nextIndex), "(")) {
                                return THIS_METHOD;
                            }
                            return THIS_VALUE;
                        }
                        case THIS: 
                        case DOT: {
                            return NONE;
                        }
                    }
                    if (Code.nextNonBlankIs(inputTerms.listIterator(nextIndex), "(")) {
                        return THIS_METHOD;
                    }
                    return TOP_VALUE;
                }
                return NONE;
            }
        }
    }

    static class Interpolator
    implements Function<List<Term>, List<Term>> {
        private final String name;
        private final Map<Binding, String> bindings;
        @Nullable
        private final Map<Binding, String> overrides;

        Interpolator(String name, Map<Binding, String> bindings, @Nullable Map<Binding, String> overrides) {
            this.name = name;
            this.bindings = bindings;
            this.overrides = overrides;
        }

        public List<Term> apply(List<Term> terms) {
            ArrayList<Term> result = new ArrayList<Term>(terms.size());
            for (Term t : terms) {
                if (t.isBinding()) {
                    result.add(this.dereference((Binding)t));
                    continue;
                }
                if (t.isString()) {
                    result.add(((Other)t).replace("<*>", this.name));
                    continue;
                }
                result.add(t);
            }
            return result;
        }

        Term dereference(Binding binding) {
            String value = null;
            if (this.overrides != null) {
                value = this.overrides.get(binding);
            }
            if (value == null) {
                value = this.bindings.get(binding);
            }
            if (value == null) {
                value = binding.identifier();
            }
            return new WordOrNumber(value);
        }
    }
}

