/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Ascii;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import javax.annotation.Nullable;
import javax.lang.model.element.TypeElement;
import org.immutables.generator.SourceExtraction;
import org.immutables.value.processor.meta.Proto;
import org.immutables.value.processor.meta.Round;

class ImportsTypeStringResolver
implements Function<String, String> {
    boolean unresolved;
    @Nullable
    private final Proto.DeclaringType usingType;
    @Nullable
    private final Proto.DeclaringType originType;
    @Nullable
    private ImmutableList<TypeElement> extendedClasses;
    @Nullable
    private ImmutableSet<TypeElement> implementedInterfaces;
    private ImmutableSet<String> unresolvedYetArguments = ImmutableSet.of();
    private Round round;

    ImportsTypeStringResolver(@Nullable Proto.DeclaringType usingType, @Nullable Proto.DeclaringType originType) {
        this.usingType = usingType == null ? null : usingType.associatedTopLevel();
        this.originType = originType == null ? null : originType.associatedTopLevel();
    }

    void hierarchyTraversalForUnresolvedTypes(Round round, ImmutableList<TypeElement> extendedClasses, ImmutableSet<TypeElement> implementedInterfaces, ImmutableSet<String> unresolvedYetArguments) {
        this.round = round;
        this.extendedClasses = extendedClasses;
        this.implementedInterfaces = implementedInterfaces;
        this.unresolvedYetArguments = unresolvedYetArguments;
    }

    public String apply(String input) {
        this.unresolved = false;
        boolean assumedUnqualified = Ascii.isUpperCase((char)input.charAt(0));
        if (assumedUnqualified) {
            input = this.qualifyImportedIfPossible(input, false);
        }
        return input;
    }

    String resolveTopForAttribute(String input) {
        this.unresolved = false;
        boolean assumedUnqualified = Ascii.isUpperCase((char)input.charAt(0));
        if (assumedUnqualified) {
            input = this.qualifyImportedIfPossible(input, !this.unresolvedYetArguments.contains((Object)input));
        }
        return input;
    }

    @Nullable
    private String getFromSourceImports(String resolvable, boolean notTypeArgument) {
        String resolved;
        UnmodifiableIterator importsSet;
        for (SourceExtraction.Imports imports : importsSet = this.takeImportSets()) {
            String resolved2 = (String)imports.classes.get((Object)resolvable);
            if (resolved2 == null) continue;
            return resolved2;
        }
        if (this.extendedClasses != null) {
            for (TypeElement type : this.extendedClasses) {
                Proto.DeclaringType top = this.round.declaringTypeFrom(type).associatedTopLevel();
                resolved = (String)top.sourceImports().classes.get((Object)resolvable);
                if (resolved == null) continue;
                return resolved;
            }
        }
        if (this.implementedInterfaces != null) {
            for (TypeElement type : this.implementedInterfaces) {
                Proto.DeclaringType top = this.round.declaringTypeFrom(type).associatedTopLevel();
                resolved = (String)top.sourceImports().classes.get((Object)resolvable);
                if (resolved == null) continue;
                return resolved;
            }
        }
        if (notTypeArgument && this.originType != null && !this.hasStarImports((SourceExtraction.Imports[])importsSet)) {
            return this.originType.packageOf().name() + "." + resolvable;
        }
        return null;
    }

    private SourceExtraction.Imports[] takeImportSets() {
        if (this.usingType == null && this.originType == null) {
            return new SourceExtraction.Imports[0];
        }
        if (this.usingType == null) {
            return new SourceExtraction.Imports[]{this.originType.sourceImports()};
        }
        if (this.originType == null || this.usingType == this.originType) {
            return new SourceExtraction.Imports[]{this.usingType.sourceImports()};
        }
        return new SourceExtraction.Imports[]{this.originType.sourceImports(), this.usingType.sourceImports()};
    }

    private boolean hasStarImports(SourceExtraction.Imports ... importsSet) {
        for (SourceExtraction.Imports imports : importsSet) {
            for (String statement : imports.all) {
                if (!statement.endsWith(".*")) continue;
                return true;
            }
        }
        return false;
    }

    private String qualifyImportedIfPossible(String typeName, boolean notTypeArgument) {
        int nestedTypeDotIndex = typeName.indexOf(46);
        String resolvable = nestedTypeDotIndex > 0 ? typeName.substring(0, nestedTypeDotIndex) : typeName;
        String resolvedImported = this.getFromSourceImports(resolvable, notTypeArgument);
        if (resolvedImported != null) {
            return nestedTypeDotIndex > 0 ? resolvedImported + typeName.substring(nestedTypeDotIndex) : resolvedImported;
        }
        this.unresolved = true;
        return typeName;
    }
}

