/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.encode;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.immutables.value.processor.encode.Code;
import org.immutables.value.processor.encode.Structurizer;

@ParametersAreNonnullByDefault
@Generated(from="Structurizer", generator="Immutables")
final class ImmutableStructurizer {
    private ImmutableStructurizer() {
    }

    @Generated(from="Structurizer.Statement", generator="Immutables")
    @Immutable
    static final class Statement
    extends Structurizer.Statement {
        private final ImmutableList<Code.Term> annotations;
        private final ImmutableList<Code.Term> signature;
        private final ImmutableList<Code.Term> parameters;
        private final ImmutableList<Code.Term> expression;
        private final ImmutableList<Code.Term> block;
        private final ImmutableList<Structurizer.Statement> definitions;
        private final transient boolean isClassOrInterface;
        private final Optional<String> name;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();
        private volatile transient long lazyInitBitmap;
        private static final long RETURN_TYPE_LAZY_INIT_BIT = 1L;
        private transient List<Code.Term> returnType;

        private Statement(Builder builder) {
            this.annotations = builder.annotations.build();
            this.signature = builder.signature.build();
            this.parameters = builder.parameters.build();
            this.expression = builder.expression.build();
            this.block = builder.block.build();
            this.definitions = builder.definitions.build();
            if (builder.nameIsSet()) {
                this.initShim.name((Optional<String>)builder.name);
            }
            this.isClassOrInterface = this.initShim.isClassOrInterface();
            this.name = this.initShim.name();
            this.initShim = null;
        }

        private Statement(ImmutableList<Code.Term> annotations, ImmutableList<Code.Term> signature, ImmutableList<Code.Term> parameters, ImmutableList<Code.Term> expression, ImmutableList<Code.Term> block, ImmutableList<Structurizer.Statement> definitions, Optional<String> name) {
            this.annotations = annotations;
            this.signature = signature;
            this.parameters = parameters;
            this.expression = expression;
            this.block = block;
            this.definitions = definitions;
            this.initShim.name(name);
            this.isClassOrInterface = this.initShim.isClassOrInterface();
            this.name = this.initShim.name();
            this.initShim = null;
        }

        ImmutableList<Code.Term> annotations() {
            return this.annotations;
        }

        ImmutableList<Code.Term> signature() {
            return this.signature;
        }

        ImmutableList<Code.Term> parameters() {
            return this.parameters;
        }

        ImmutableList<Code.Term> expression() {
            return this.expression;
        }

        ImmutableList<Code.Term> block() {
            return this.block;
        }

        ImmutableList<Structurizer.Statement> definitions() {
            return this.definitions;
        }

        @Override
        boolean isClassOrInterface() {
            InitShim shim = this.initShim;
            return shim != null ? shim.isClassOrInterface() : this.isClassOrInterface;
        }

        @Override
        Optional<String> name() {
            InitShim shim = this.initShim;
            return shim != null ? shim.name() : this.name;
        }

        public final Statement withAnnotations(Code.Term ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new Statement((ImmutableList<Code.Term>)newValue, this.signature, this.parameters, this.expression, this.block, this.definitions, this.name);
        }

        public final Statement withAnnotations(Iterable<? extends Code.Term> elements) {
            if (this.annotations == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new Statement((ImmutableList<Code.Term>)newValue, this.signature, this.parameters, this.expression, this.block, this.definitions, this.name);
        }

        public final Statement withSignature(Code.Term ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new Statement(this.annotations, (ImmutableList<Code.Term>)newValue, this.parameters, this.expression, this.block, this.definitions, this.name);
        }

        public final Statement withSignature(Iterable<? extends Code.Term> elements) {
            if (this.signature == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new Statement(this.annotations, (ImmutableList<Code.Term>)newValue, this.parameters, this.expression, this.block, this.definitions, this.name);
        }

        public final Statement withParameters(Code.Term ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new Statement(this.annotations, this.signature, (ImmutableList<Code.Term>)newValue, this.expression, this.block, this.definitions, this.name);
        }

        public final Statement withParameters(Iterable<? extends Code.Term> elements) {
            if (this.parameters == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new Statement(this.annotations, this.signature, (ImmutableList<Code.Term>)newValue, this.expression, this.block, this.definitions, this.name);
        }

        public final Statement withExpression(Code.Term ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new Statement(this.annotations, this.signature, this.parameters, (ImmutableList<Code.Term>)newValue, this.block, this.definitions, this.name);
        }

        public final Statement withExpression(Iterable<? extends Code.Term> elements) {
            if (this.expression == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new Statement(this.annotations, this.signature, this.parameters, (ImmutableList<Code.Term>)newValue, this.block, this.definitions, this.name);
        }

        public final Statement withBlock(Code.Term ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new Statement(this.annotations, this.signature, this.parameters, this.expression, (ImmutableList<Code.Term>)newValue, this.definitions, this.name);
        }

        public final Statement withBlock(Iterable<? extends Code.Term> elements) {
            if (this.block == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new Statement(this.annotations, this.signature, this.parameters, this.expression, (ImmutableList<Code.Term>)newValue, this.definitions, this.name);
        }

        public final Statement withDefinitions(Structurizer.Statement ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new Statement(this.annotations, this.signature, this.parameters, this.expression, this.block, (ImmutableList<Structurizer.Statement>)newValue, this.name);
        }

        public final Statement withDefinitions(Iterable<? extends Structurizer.Statement> elements) {
            if (this.definitions == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new Statement(this.annotations, this.signature, this.parameters, this.expression, this.block, (ImmutableList<Structurizer.Statement>)newValue, this.name);
        }

        public final Statement withName(Optional<String> value) {
            Optional<String> newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new Statement(this.annotations, this.signature, this.parameters, this.expression, this.block, this.definitions, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Statement && this.equalTo((Statement)another);
        }

        private boolean equalTo(Statement another) {
            return this.annotations.equals(another.annotations) && this.signature.equals(another.signature) && this.parameters.equals(another.parameters) && this.expression.equals(another.expression) && this.block.equals(another.block) && this.definitions.equals(another.definitions) && this.isClassOrInterface == another.isClassOrInterface && this.name.equals(another.name);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.annotations.hashCode();
            h += (h << 5) + this.signature.hashCode();
            h += (h << 5) + this.parameters.hashCode();
            h += (h << 5) + this.expression.hashCode();
            h += (h << 5) + this.block.hashCode();
            h += (h << 5) + this.definitions.hashCode();
            h += (h << 5) + Booleans.hashCode((boolean)this.isClassOrInterface);
            h += (h << 5) + this.name.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Statement").omitNullValues().add("annotations", this.annotations).add("signature", this.signature).add("parameters", this.parameters).add("expression", this.expression).add("block", this.block).add("definitions", this.definitions).add("isClassOrInterface", this.isClassOrInterface).add("name", this.name).toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        List<Code.Term> returnType() {
            if ((this.lazyInitBitmap & 1L) == 0L) {
                Statement statement = this;
                synchronized (statement) {
                    if ((this.lazyInitBitmap & 1L) == 0L) {
                        this.returnType = Objects.requireNonNull(super.returnType(), "returnType");
                        this.lazyInitBitmap |= 1L;
                    }
                }
            }
            return this.returnType;
        }

        public static Structurizer.Statement copyOf(Structurizer.Statement instance) {
            if (instance instanceof Statement) {
                return (Statement)instance;
            }
            return new Structurizer.Statement.Builder().addAllAnnotations(instance.annotations()).addAllSignature(instance.signature()).addAllParameters(instance.parameters()).addAllExpression(instance.expression()).addAllBlock(instance.block()).addAllDefinitions(instance.definitions()).name(instance.name()).build();
        }

        @Generated(from="Structurizer.Statement", generator="Immutables")
        @NotThreadSafe
        public static class Builder {
            private static final long OPT_BIT_NAME = 1L;
            private long optBits;
            private final ImmutableList.Builder<Code.Term> annotations = ImmutableList.builder();
            private final ImmutableList.Builder<Code.Term> signature = ImmutableList.builder();
            private final ImmutableList.Builder<Code.Term> parameters = ImmutableList.builder();
            private final ImmutableList.Builder<Code.Term> expression = ImmutableList.builder();
            private final ImmutableList.Builder<Code.Term> block = ImmutableList.builder();
            private final ImmutableList.Builder<Structurizer.Statement> definitions = ImmutableList.builder();
            @Nullable
            private Optional<String> name;

            public Builder() {
                if (!(this instanceof Structurizer.Statement.Builder)) {
                    throw new UnsupportedOperationException("Use: new Structurizer.Statement.Builder()");
                }
            }

            public final Structurizer.Statement.Builder addAnnotations(Code.Term element) {
                this.annotations.add((Object)element);
                return (Structurizer.Statement.Builder)this;
            }

            public final Structurizer.Statement.Builder addAnnotations(Code.Term ... elements) {
                this.annotations.add((Object[])elements);
                return (Structurizer.Statement.Builder)this;
            }

            public final Structurizer.Statement.Builder addAllAnnotations(Iterable<? extends Code.Term> elements) {
                this.annotations.addAll(elements);
                return (Structurizer.Statement.Builder)this;
            }

            public final Structurizer.Statement.Builder addSignature(Code.Term element) {
                this.signature.add((Object)element);
                return (Structurizer.Statement.Builder)this;
            }

            public final Structurizer.Statement.Builder addSignature(Code.Term ... elements) {
                this.signature.add((Object[])elements);
                return (Structurizer.Statement.Builder)this;
            }

            public final Structurizer.Statement.Builder addAllSignature(Iterable<? extends Code.Term> elements) {
                this.signature.addAll(elements);
                return (Structurizer.Statement.Builder)this;
            }

            public final Structurizer.Statement.Builder addParameters(Code.Term element) {
                this.parameters.add((Object)element);
                return (Structurizer.Statement.Builder)this;
            }

            public final Structurizer.Statement.Builder addParameters(Code.Term ... elements) {
                this.parameters.add((Object[])elements);
                return (Structurizer.Statement.Builder)this;
            }

            public final Structurizer.Statement.Builder addAllParameters(Iterable<? extends Code.Term> elements) {
                this.parameters.addAll(elements);
                return (Structurizer.Statement.Builder)this;
            }

            public final Structurizer.Statement.Builder addExpression(Code.Term element) {
                this.expression.add((Object)element);
                return (Structurizer.Statement.Builder)this;
            }

            public final Structurizer.Statement.Builder addExpression(Code.Term ... elements) {
                this.expression.add((Object[])elements);
                return (Structurizer.Statement.Builder)this;
            }

            public final Structurizer.Statement.Builder addAllExpression(Iterable<? extends Code.Term> elements) {
                this.expression.addAll(elements);
                return (Structurizer.Statement.Builder)this;
            }

            public final Structurizer.Statement.Builder addBlock(Code.Term element) {
                this.block.add((Object)element);
                return (Structurizer.Statement.Builder)this;
            }

            public final Structurizer.Statement.Builder addBlock(Code.Term ... elements) {
                this.block.add((Object[])elements);
                return (Structurizer.Statement.Builder)this;
            }

            public final Structurizer.Statement.Builder addAllBlock(Iterable<? extends Code.Term> elements) {
                this.block.addAll(elements);
                return (Structurizer.Statement.Builder)this;
            }

            public final Structurizer.Statement.Builder addDefinitions(Structurizer.Statement element) {
                this.definitions.add((Object)element);
                return (Structurizer.Statement.Builder)this;
            }

            public final Structurizer.Statement.Builder addDefinitions(Structurizer.Statement ... elements) {
                this.definitions.add((Object[])elements);
                return (Structurizer.Statement.Builder)this;
            }

            public final Structurizer.Statement.Builder addAllDefinitions(Iterable<? extends Structurizer.Statement> elements) {
                this.definitions.addAll(elements);
                return (Structurizer.Statement.Builder)this;
            }

            public final Structurizer.Statement.Builder name(Optional<String> name) {
                Builder.checkNotIsSet(this.nameIsSet(), "name");
                this.name = Objects.requireNonNull(name, "name");
                this.optBits |= 1L;
                return (Structurizer.Statement.Builder)this;
            }

            public Structurizer.Statement build() {
                return new Statement(this);
            }

            private boolean nameIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private static void checkNotIsSet(boolean isSet, String name) {
                if (isSet) {
                    throw new IllegalStateException("Builder of Statement is strict, attribute is already set: ".concat(name));
                }
            }
        }

        @Generated(from="Structurizer.Statement", generator="Immutables")
        private final class InitShim {
            private byte isClassOrInterfaceBuildStage = 0;
            private boolean isClassOrInterface;
            private byte nameBuildStage = 0;
            private Optional<String> name;

            private InitShim() {
            }

            boolean isClassOrInterface() {
                if (this.isClassOrInterfaceBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.isClassOrInterfaceBuildStage == 0) {
                    this.isClassOrInterfaceBuildStage = (byte)-1;
                    this.isClassOrInterface = Statement.super.isClassOrInterface();
                    this.isClassOrInterfaceBuildStage = 1;
                }
                return this.isClassOrInterface;
            }

            Optional<String> name() {
                if (this.nameBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.nameBuildStage == 0) {
                    this.nameBuildStage = (byte)-1;
                    this.name = Objects.requireNonNull(Statement.super.name(), "name");
                    this.nameBuildStage = 1;
                }
                return this.name;
            }

            void name(Optional<String> name) {
                this.name = name;
                this.nameBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.isClassOrInterfaceBuildStage == -1) {
                    attributes.add("isClassOrInterface");
                }
                if (this.nameBuildStage == -1) {
                    attributes.add("name");
                }
                return "Cannot build Statement, attribute initializers form cycle " + attributes;
            }
        }
    }
}

