/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.immutables.generator.AnnotationMirrors;
import org.immutables.generator.StringLiterals;
import org.immutables.value.processor.meta.CachingElements;
import org.immutables.value.processor.meta.InjectAnnotationMirror;
import org.immutables.value.processor.meta.Proto;

public final class AnnotationInjections {
    private static final String P_ANNOTATION = "@";
    private static final String P_R = "]]";
    private static final String P_L = "[[";
    private static final String P_ALL = "[[*]]";
    private static final String P_SIMPLE_NAME = "[[!name]]";
    private static final String P_ALL_NAMES = "[[*names]]";
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ");
    private static final Joiner.MapJoiner ATTR_JOINER = COMMA_JOINER.withKeyValueSeparator(" = ");

    private AnnotationInjections() {
    }

    private static String emptyIfDefault(String annotationType) {
        if (annotationType.equals("org.immutables.annotate.InjectAnnotation") || annotationType.equals(InjectAnnotation.class.getName())) {
            return "";
        }
        return annotationType;
    }

    public static InjectionInfo infoFrom(InjectAnnotationMirror mirror) {
        return new InjectionInfo(mirror.code(), AnnotationInjections.emptyIfDefault(mirror.typeName()), mirror.deduplicationKey(), mirror.ifPresent(), mirror.target());
    }

    @SafeVarargs
    public static Collection<String> collectInjections(Element element, InjectAnnotation.Where target, Collection<String> attributeNames, Iterable<AnnotationInjection> ... injections) {
        HashMap<String, String> injectionCode = new HashMap<String, String>();
        for (Iterable<AnnotationInjection> inj : injections) {
            for (AnnotationInjection a : inj) {
                a.addIfApplicable(element, target, attributeNames, injectionCode);
            }
        }
        return injectionCode.values();
    }

    private static enum ToLiteral implements Function<String, String>
    {
        FUNCTION;


        public String apply(String input) {
            return StringLiterals.toLiteral((String)input);
        }
    }

    public static final class InjectionInfo {
        final String code;
        final String annotationType;
        final boolean ifPresent;
        final String deduplicationKey;
        final EnumSet<InjectAnnotation.Where> targets;
        final boolean hasPlaceholders;

        private InjectionInfo(String code, String annotationType, String deduplicationKey, boolean ifPresent, InjectAnnotation.Where[] targets) {
            this.code = code.trim();
            this.annotationType = annotationType;
            this.ifPresent = ifPresent;
            this.targets = targets.length == 0 ? EnumSet.allOf(InjectAnnotation.Where.class) : EnumSet.copyOf(Arrays.asList(targets));
            this.hasPlaceholders = this.hasPlaceholders(code);
            this.deduplicationKey = InjectionInfo.deduplicationKeyFor(deduplicationKey, annotationType, code);
        }

        private boolean hasPlaceholders(String code) {
            return code.contains(AnnotationInjections.P_L) && code.contains(AnnotationInjections.P_R);
        }

        AnnotationInjection injectionFor(AnnotationMirror annotation, Proto.Environment environment) {
            return new AnnotationInjection(this, this.hasPlaceholders ? this.extractPlaceholderValues(annotation, environment) : ImmutableMap.of());
        }

        private ImmutableMap<String, String> extractPlaceholderValues(AnnotationMirror annotation, Proto.Environment environment) {
            ImmutableMap.Builder literals = ImmutableMap.builder();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : environment.processing().getElementUtils().getElementValuesWithDefaults(CachingElements.getDelegate(annotation)).entrySet()) {
                String key = e.getKey().getSimpleName().toString();
                String value = AnnotationMirrors.toCharSequence((AnnotationValue)e.getValue()).toString();
                literals.put((Object)key, (Object)value);
            }
            return literals.build();
        }

        private static String deduplicationKeyFor(String deduplicationKey, String annotationType, String code) {
            if (!deduplicationKey.isEmpty()) {
                return deduplicationKey;
            }
            if (!annotationType.isEmpty()) {
                return annotationType;
            }
            return code;
        }
    }

    public static final class AnnotationInjection {
        private final InjectionInfo info;
        private final ImmutableMap<String, String> literals;

        AnnotationInjection(InjectionInfo info, ImmutableMap<String, String> literals) {
            this.info = info;
            this.literals = literals;
        }

        void addIfApplicable(Element element, InjectAnnotation.Where target, Collection<String> attributeNames, Map<String, String> annotationCode) {
            String simpleName = element.getSimpleName().toString();
            if (annotationCode.containsKey(this.info.deduplicationKey)) {
                return;
            }
            if (!this.info.targets.contains((Object)target)) {
                return;
            }
            if (this.info.ifPresent && !this.info.annotationType.isEmpty()) {
                AnnotationMirror presentAnnotation = AnnotationMirrors.findAnnotation(element.getAnnotationMirrors(), (String)this.info.annotationType);
                if (presentAnnotation == null) {
                    return;
                }
                if (this.info.code.isEmpty()) {
                    annotationCode.put(this.info.deduplicationKey, AnnotationMirrors.toCharSequence((AnnotationMirror)presentAnnotation).toString());
                    return;
                }
            }
            String code = this.info.hasPlaceholders ? this.interpolateCode(simpleName, attributeNames) : this.info.code;
            annotationCode.put(this.info.deduplicationKey, this.prependAnnotationTypeIfNecessary(code));
        }

        private String interpolateCode(String simpleName, Collection<String> attributeNames) {
            String c = this.info.code;
            if (c.isEmpty()) {
                return "(" + ATTR_JOINER.join(this.literals) + ")";
            }
            if (c.contains(AnnotationInjections.P_ALL)) {
                c = c.replace(AnnotationInjections.P_ALL, ATTR_JOINER.join(this.literals));
            }
            if ((c = c.replace(AnnotationInjections.P_SIMPLE_NAME, simpleName)).contains(AnnotationInjections.P_ALL_NAMES)) {
                String literals = FluentIterable.from(attributeNames).transform((Function)ToLiteral.FUNCTION).join(COMMA_JOINER);
                c = c.replace(AnnotationInjections.P_ALL_NAMES, "{" + literals + "}");
            }
            for (Map.Entry e : this.literals.entrySet()) {
                c = c.replace(AnnotationInjections.P_L + (String)e.getKey() + AnnotationInjections.P_R, (CharSequence)e.getValue());
            }
            return c;
        }

        private String prependAnnotationTypeIfNecessary(String code) {
            if (!this.info.annotationType.isEmpty() && !code.startsWith(AnnotationInjections.P_ANNOTATION)) {
                return AnnotationInjections.P_ANNOTATION + this.info.annotationType + code;
            }
            return code;
        }
    }

    public static @interface InjectManyAnnotations {
        public InjectAnnotation[] value();
    }

    public static @interface InjectAnnotation {
        public String code() default "";

        public Class<? extends Annotation> type() default InjectAnnotation.class;

        public boolean ifPresent() default false;

        public Where[] target();

        public String deduplicationKey() default "";

        public static enum Where {
            FIELD,
            ACCESSOR,
            SYNTHETIC_FIELDS,
            CONSTRUCTOR_PARAMETER,
            INITIALIZER,
            ELEMENT_INITIALIZER,
            BUILDER_TYPE,
            IMMUTABLE_TYPE,
            MODIFIABLE_TYPE,
            CONSTRUCTOR;

        }
    }
}

