/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import org.immutables.value.processor.encode.Type;
import org.immutables.value.processor.encode.TypeExtractor;
import org.immutables.value.processor.meta.Generics;

public final class GsonTypeTokens {
    private final Generics generics;
    private final TypeExtractor typeExtractor;

    public GsonTypeTokens(Generics generics, TypeExtractor typeExtractor) {
        this.generics = generics;
        this.typeExtractor = typeExtractor;
    }

    public Type parseType(String typeUsage) {
        return this.typeExtractor.parser.parse(typeUsage);
    }

    public CharSequence sourceFor(String typeUsage) {
        return this.sourceFor(this.parseType(typeUsage));
    }

    public CharSequence sourceFor(final Type rootType) {
        final StringBuilder out = new StringBuilder();
        class Sourcer
        implements Type.Visitor<Void> {
            boolean wasUngenerifiedTypeUsed = false;

            Sourcer() {
            }

            StringBuilder openTokenMethod(String name) {
                return out.append("TypeToken.").append(name).append('(');
            }

            StringBuilder closeMethod() {
                return out.append(')');
            }

            StringBuilder closeMethodGetType() {
                return out.append(").getType()");
            }

            StringBuilder classLiteral() {
                return out.append(".class");
            }

            @Override
            public Void primitive(Type.Primitive primitive) {
                out.append(primitive);
                this.classLiteral();
                return null;
            }

            @Override
            public Void reference(Type.Reference reference) {
                out.append(reference);
                this.classLiteral();
                return null;
            }

            @Override
            public Void parameterized(Type.Parameterized parameterized) {
                this.wasUngenerifiedTypeUsed = true;
                this.openTokenMethod("getParameterized");
                out.append(parameterized.reference);
                this.classLiteral();
                for (Type.Nonprimitive argument : parameterized.arguments) {
                    out.append(", ");
                    argument.accept(this);
                }
                if (rootType == parameterized) {
                    this.closeMethod();
                } else {
                    this.closeMethodGetType();
                }
                return null;
            }

            @Override
            public Void variable(Type.Variable variable) {
                if (rootType == variable) {
                    this.openTokenMethod("get");
                }
                this.wasUngenerifiedTypeUsed = true;
                out.append("typeArguments[").append(((GsonTypeTokens)GsonTypeTokens.this).generics.get((String)variable.name).index).append("]");
                if (rootType == variable) {
                    this.closeMethod();
                }
                return null;
            }

            @Override
            public Void array(Type.Array array) {
                if (array.element instanceof Type.Parameterized) {
                    this.wasUngenerifiedTypeUsed = true;
                    this.openTokenMethod("getArray");
                    array.element.accept(this);
                    if (rootType == array) {
                        this.closeMethod();
                    } else {
                        this.closeMethodGetType();
                    }
                } else {
                    if (rootType == array) {
                        this.openTokenMethod("get");
                    }
                    out.append(array.element).append("[]");
                    this.classLiteral();
                    if (rootType == array) {
                        this.closeMethod();
                    }
                }
                return null;
            }

            @Override
            public Void superWildcard(Type.Wildcard.Super wildcard) {
                return wildcard.lowerBound.accept(this);
            }

            @Override
            public Void extendsWildcard(Type.Wildcard.Extends wildcard) {
                return wildcard.upperBound.accept(this);
            }
        }
        Sourcer sourcer = new Sourcer();
        rootType.accept(sourcer);
        if (sourcer.wasUngenerifiedTypeUsed) {
            StringBuilder castBuilder = new StringBuilder();
            castBuilder.append("(TypeToken<").append(rootType).append(">) ");
            out.insert(0, castBuilder);
        }
        return out;
    }
}

