/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.generator;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.immutables.value.internal.generator.Generator;
import org.immutables.value.internal.generator.StaticEnvironment;
import org.immutables.value.internal.generator.Templates;
import org.immutables.value.internal.google.common.base.Joiner;
import org.immutables.value.internal.google.common.base.Preconditions;
import org.immutables.value.internal.google.common.base.Throwables;
import org.immutables.value.internal.google.common.collect.ImmutableSet;
import org.immutables.value.internal.google.common.collect.Sets;

public abstract class AbstractGenerator
extends AbstractProcessor {
    protected abstract void process();

    protected final void invoke(Templates.Invokable invokable) {
        Preconditions.checkArgument(invokable.arity() == 0, "Entry template fragment should not have parameters");
        invokable.invoke(Templates.Invokation.initial(), new Object[0]);
    }

    @Override
    public final Set<String> getSupportedAnnotationTypes() {
        Generator.SupportedAnnotations annotations = this.getClass().getAnnotation(Generator.SupportedAnnotations.class);
        if (annotations != null) {
            HashSet<String> annotationNames = Sets.newHashSet();
            for (Class<? extends Annotation> c : annotations.value()) {
                annotationNames.add(c.getCanonicalName());
            }
            return ImmutableSet.copyOf(annotationNames);
        }
        return super.getSupportedAnnotationTypes();
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        try {
            StaticEnvironment.init(annotations, round, this.processingEnv);
            if (!round.processingOver() && !round.errorRaised()) {
                this.process();
            }
            StaticEnvironment.shutdown();
        }
        catch (Exception ex) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, Joiner.on('\n').join(AbstractGenerator.class.getName() + " threw", Throwables.getStackTraceAsString(ex), new Object[0]));
        }
        return false;
    }
}

