/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.generator;

import java.util.Arrays;
import org.immutables.value.internal.generator.Templates;
import org.immutables.value.internal.google.common.base.Function;
import org.immutables.value.internal.google.common.base.Optional;
import org.immutables.value.internal.google.common.base.Predicate;
import org.immutables.value.internal.google.common.collect.Iterables;
import org.immutables.value.internal.google.common.primitives.Chars;
import org.immutables.value.internal.google.common.primitives.Ints;
import org.immutables.value.internal.google.common.primitives.Longs;

public final class Intrinsics {
    private Intrinsics() {
    }

    public static <T> T $cast(Object object) {
        return (T)object;
    }

    public static <T> T $(T value) {
        return value;
    }

    public static <F, T> T $(Function<? super F, T> unary, F value) {
        return unary.apply(value);
    }

    public static <F> Boolean $(Predicate<? super F> predicate, F value) {
        return predicate.apply(value);
    }

    public static <L, R, T> T $(L left, Templates.Binary<? super L, ? super R, T> binary, R right) {
        return binary.apply(left, right);
    }

    public static <T> T $(Templates.Apply<T> apply, Object ... parameters) {
        return apply.apply(parameters);
    }

    public static Templates.Product $(Object ... parameters) {
        return new Templates.Product(parameters);
    }

    public static <F> void $(Templates.Invokation invokation, Function<? super F, ?> unary, F value) {
        invokation.out(Intrinsics.$(unary, value));
    }

    public static <A, B> void $(Templates.Invokation invokation, A left, Templates.Binary<? super A, ? super B, ?> binary, B right) {
        invokation.out(Intrinsics.$(left, binary, right));
    }

    public static void $(Templates.Invokation invokation, Templates.Apply<?> apply, Object ... parameters) {
        invokation.out(Intrinsics.$(apply, parameters));
    }

    public static void $(Templates.Invokation invokation, Templates.Invokable invokable, Object ... parameters) {
        invokable.invoke(invokation, parameters);
    }

    public static void $(Templates.Invokation invokation, Object object, Object ... parameters) {
        invokation.out(object).out(parameters);
    }

    public static boolean $if(boolean value) {
        return value;
    }

    public static boolean $if(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return !((String)value).isEmpty();
        }
        if (value instanceof Iterable) {
            return !Iterables.isEmpty((Iterable)value);
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        if (value instanceof Optional) {
            return ((Optional)value).isPresent();
        }
        return true;
    }

    public static <T> Iterable<T> $in(Iterable<T> iterable) {
        return iterable;
    }

    public static <T> Iterable<T> $in(Optional<T> optional) {
        return optional.asSet();
    }

    public static <T> Iterable<T> $in(T[] elements) {
        return Arrays.asList(elements);
    }

    public static Iterable<Character> $in(char[] elements) {
        return Chars.asList(elements);
    }

    public static Iterable<Integer> $in(int[] elements) {
        return Ints.asList(elements);
    }

    public static Iterable<Long> $in(long[] elements) {
        return Longs.asList(elements);
    }
}

