/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.generator;

import java.util.ArrayList;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.immutables.value.internal.google.common.base.Joiner;
import org.immutables.value.internal.google.common.base.Splitter;
import org.immutables.value.internal.google.common.collect.Lists;
import org.immutables.value.internal.google.common.collect.Sets;
import org.immutables.value.internal.google.common.reflect.Reflection;

@Deprecated
final class LegacyJavaPostprocessing {
    private static final Pattern FULLY_QUALIFIED_PATTERN = Pattern.compile("(\\W)(([a-z0-9_]+\\.)+)([A-Z][A-Za-z0-9_]*)");
    private static final Pattern PACKAGE_DECLARATION = Pattern.compile("package ([a-z0-9_\\.]+)");
    private static final Joiner LINE_JOINER = Joiner.on('\n');
    private static final Splitter LINE_SPLITTER = Splitter.on('\n');

    LegacyJavaPostprocessing() {
    }

    static CharSequence rewrite(CharSequence content) {
        ArrayList<String> modifiedLines = Lists.newArrayList();
        TreeSet<String> importStatements = Sets.newTreeSet();
        String packageName = null;
        int indexOfGenImportsPlaceholder = -1;
        int indexOfPackageLine = -1;
        for (String l : LINE_SPLITTER.split(content)) {
            if (packageName == null && l.startsWith("package ")) {
                packageName = LegacyJavaPostprocessing.extractPackageName(l);
                indexOfPackageLine = modifiedLines.size();
                modifiedLines.add(l);
                continue;
            }
            if (l.startsWith("// Generated imports")) {
                indexOfGenImportsPlaceholder = modifiedLines.size();
                continue;
            }
            if (l.startsWith("import ")) {
                if (indexOfGenImportsPlaceholder < 0) {
                    indexOfGenImportsPlaceholder = modifiedLines.size();
                }
                modifiedLines.add(l);
                continue;
            }
            Matcher matcher = FULLY_QUALIFIED_PATTERN.matcher(l);
            while (matcher.find()) {
                String importClass = matcher.group().substring(1);
                if (Reflection.getPackageName(importClass).equals("java.lang")) continue;
                importStatements.add("import " + importClass + ";");
            }
            modifiedLines.add(FULLY_QUALIFIED_PATTERN.matcher(l).replaceAll("$1$4").replace(",", ", ").replace(",  ", ", "));
        }
        if (indexOfGenImportsPlaceholder < 0) {
            indexOfGenImportsPlaceholder = indexOfPackageLine + 1;
        }
        modifiedLines.addAll(indexOfGenImportsPlaceholder, importStatements);
        return LINE_JOINER.join(modifiedLines);
    }

    private static String extractPackageName(String l) {
        return PACKAGE_DECLARATION.matcher(l).replaceAll("$1");
    }
}

