/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.generator;

import java.util.List;
import org.immutables.value.internal.google.common.base.Ascii;
import org.immutables.value.internal.google.common.base.CaseFormat;
import org.immutables.value.internal.google.common.base.CharMatcher;
import org.immutables.value.internal.google.common.base.Function;
import org.immutables.value.internal.google.common.base.Preconditions;
import org.immutables.value.internal.google.common.base.Splitter;

public abstract class Naming
implements Function<String, String> {
    private static final String NOT_DETECTED = "";
    private static final String NAME_PLACEHOLDER = "*";
    private static final Splitter TEMPLATE_SPLITTER = Splitter.on("*");
    private static final CharMatcher TEMPLATE_CHAR_MATCHER = CharMatcher.JAVA_LETTER_OR_DIGIT.or(CharMatcher.is('*')).precomputed();

    private Naming() {
    }

    @Override
    public abstract String apply(String var1);

    public abstract String detect(String var1);

    public static Naming from(String template) {
        List<String> parts;
        if (template.isEmpty()) {
            template = NAME_PLACEHOLDER;
        }
        Preconditions.checkArgument((parts = TEMPLATE_SPLITTER.splitToList(template)).size() <= 2 && TEMPLATE_CHAR_MATCHER.matchesAllOf(template), "Wrong naming template: %s. Shoud be {prefix?}*{suffix?} where prefix and suffix optional identifier parts", template);
        return parts.size() == 1 ? new VerbatimNaming(template) : new PrefixSuffixNaming(parts.get(0), parts.get(1));
    }

    public static Naming[] fromAll(String ... templates) {
        Naming[] namings = new Naming[templates.length];
        for (int i = 0; i < templates.length; ++i) {
            namings[i] = Naming.from(templates[i]);
        }
        return namings;
    }

    private static class PrefixSuffixNaming
    extends Naming {
        final String prefix;
        final String suffix;
        final int lengthsOfPrefixAndSuffix;

        PrefixSuffixNaming(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
            this.lengthsOfPrefixAndSuffix = suffix.length() + prefix.length();
        }

        @Override
        public String apply(String input) {
            CaseFormat resultFormat = this.prefix.isEmpty() ? CaseFormat.LOWER_CAMEL : CaseFormat.UPPER_CAMEL;
            return this.prefix + CaseFormat.LOWER_CAMEL.to(resultFormat, input) + this.suffix;
        }

        @Override
        public String detect(String identifier) {
            boolean suffixMatches;
            if (this.lengthsOfPrefixAndSuffix == 0) {
                return identifier;
            }
            if (identifier.length() <= this.lengthsOfPrefixAndSuffix) {
                return Naming.NOT_DETECTED;
            }
            boolean prefixMatches = this.prefix.isEmpty() || identifier.startsWith(this.prefix) && Ascii.isUpperCase(identifier.charAt(this.prefix.length()));
            boolean bl = suffixMatches = this.suffix.isEmpty() || identifier.endsWith(this.suffix);
            if (prefixMatches && suffixMatches) {
                String detected = identifier.substring(this.prefix.length(), identifier.length() - this.suffix.length());
                return this.prefix.isEmpty() ? detected : CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, detected);
            }
            return Naming.NOT_DETECTED;
        }

        public String toString() {
            return Naming.class.getSimpleName() + ".from(" + this.prefix + Naming.NAME_PLACEHOLDER + this.suffix + ")";
        }
    }

    private static class VerbatimNaming
    extends Naming {
        final String name;

        VerbatimNaming(String name) {
            this.name = name;
        }

        @Override
        public String apply(String input) {
            return this.name;
        }

        @Override
        public String detect(String identifier) {
            return identifier.equals(this.name) ? this.name : Naming.NOT_DETECTED;
        }

        public String toString() {
            return Naming.class.getSimpleName() + ".from(" + this.name + ")";
        }
    }
}

