/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.generator;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.immutables.value.internal.generator.LegacyJavaPostprocessing;
import org.immutables.value.internal.generator.StaticEnvironment;
import org.immutables.value.internal.generator.Templates;
import org.immutables.value.internal.google.common.base.CharMatcher;
import org.immutables.value.internal.google.common.base.Joiner;
import org.immutables.value.internal.google.common.base.Preconditions;
import org.immutables.value.internal.google.common.base.Predicates;
import org.immutables.value.internal.google.common.base.Splitter;
import org.immutables.value.internal.google.common.base.Strings;
import org.immutables.value.internal.google.common.base.Supplier;
import org.immutables.value.internal.google.common.base.Throwables;
import org.immutables.value.internal.google.common.cache.CacheBuilder;
import org.immutables.value.internal.google.common.cache.CacheLoader;
import org.immutables.value.internal.google.common.cache.LoadingCache;
import org.immutables.value.internal.google.common.collect.FluentIterable;
import org.immutables.value.internal.google.common.collect.Sets;
import org.immutables.value.internal.google.common.io.CharSink;
import org.immutables.value.internal.google.common.io.CharSource;
import org.immutables.value.internal.google.common.io.CharStreams;

public final class Output {
    public final Templates.Invokable error = new Templates.Invokable(){

        @Override
        @Nullable
        public Templates.Invokable invoke(Templates.Invokation invokation, Object ... parameters) {
            String message = CharMatcher.WHITESPACE.trimFrom(parameters[0].toString());
            StaticEnvironment.processing().getMessager().printMessage(Diagnostic.Kind.ERROR, message);
            return null;
        }

        @Override
        public int arity() {
            return 1;
        }
    };
    public final Templates.Invokable trim = new Templates.Fragment(1){

        @Override
        public void run(Templates.Invokation invokation) {
            invokation.out((Object)CharMatcher.WHITESPACE.trimFrom(this.toCharSequence(invokation.param(0).toString())));
        }

        private CharSequence toCharSequence(Object param) {
            Preconditions.checkNotNull(param);
            if (param instanceof Templates.Fragment) {
                return ((Templates.Fragment)param).toCharSequence();
            }
            return param.toString();
        }
    };
    public final Templates.Invokable java = new Templates.Fragment(3){

        @Override
        public void run(Templates.Invokation invokation) {
            String packageName = invokation.param(0).toString();
            String simpleName = invokation.param(1).toString();
            Templates.Invokable body = (Templates.Invokable)invokation.param(2);
            ResourceKey key = new ResourceKey(packageName, simpleName);
            SourceFile javaFile = Output.getFiles().sourceFiles.getUnchecked(key);
            body.invoke(new Templates.Invokation(javaFile.consumer, new Object[0]), new Object[0]);
            javaFile.complete();
        }
    };
    public final Templates.Invokable service = new Templates.Fragment(3){
        private static final String META_INF_SERVICES = "META-INF/services/";

        @Override
        public void run(Templates.Invokation invokation) {
            String interfaceName = invokation.param(0).toString();
            Templates.Invokable body = (Templates.Invokable)invokation.param(1);
            ResourceKey key = new ResourceKey("", META_INF_SERVICES + interfaceName);
            AppendResourceFile servicesFile = Output.getFiles().appendResourceFiles.getUnchecked(key);
            body.invoke(new Templates.Invokation(servicesFile.consumer, new Object[0]), new Object[0]);
        }
    };

    private static Filer getFiler() {
        return StaticEnvironment.processing().getFiler();
    }

    private static Files getFiles() {
        return StaticEnvironment.getInstance(Files.class, FilesSupplier.INSTANCE);
    }

    private static class Files
    implements StaticEnvironment.Completable {
        final LoadingCache<ResourceKey, SourceFile> sourceFiles = CacheBuilder.newBuilder().concurrencyLevel(1).build(new CacheLoader<ResourceKey, SourceFile>(){

            @Override
            public SourceFile load(ResourceKey key) throws Exception {
                return new SourceFile(key);
            }
        });
        final LoadingCache<ResourceKey, AppendResourceFile> appendResourceFiles = CacheBuilder.newBuilder().concurrencyLevel(1).build(new CacheLoader<ResourceKey, AppendResourceFile>(){

            @Override
            public AppendResourceFile load(ResourceKey key) throws Exception {
                return new AppendResourceFile(key);
            }
        });

        private Files() {
        }

        @Override
        public void complete() {
            if (!StaticEnvironment.round().errorRaised()) {
                for (AppendResourceFile file : this.appendResourceFiles.asMap().values()) {
                    file.complete();
                }
            }
        }
    }

    private static enum FilesSupplier implements Supplier<Files>
    {
        INSTANCE;


        @Override
        public Files get() {
            return new Files();
        }
    }

    private static class SourceFile {
        final ResourceKey key;
        final Templates.CharConsumer consumer = new Templates.CharConsumer();

        SourceFile(ResourceKey key) {
            this.key = key;
        }

        void complete() {
            if (!StaticEnvironment.round().errorRaised()) {
                try {
                    this.writeFile();
                }
                catch (IOException ex) {
                    throw Throwables.propagate(ex);
                }
            }
        }

        private void writeFile() throws IOException {
            block14: {
                CharSequence sourceCode = this.extractSourceCode();
                try (Writer writer = Output.getFiler().createSourceFile(this.key.toString(), new Element[0]).openWriter();){
                    writer.append(sourceCode);
                }
                catch (IOException ex) {
                    if (this.identicalFileIsAlreadyGenerated(sourceCode)) break block14;
                    throw ex;
                }
            }
        }

        private boolean identicalFileIsAlreadyGenerated(CharSequence sourceCode) {
            try {
                String existingContent = new CharSource(){

                    @Override
                    public Reader openStream() throws IOException {
                        return Output.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, SourceFile.this.key.packageName, SourceFile.this.key.relativeName).openReader(true);
                    }
                }.read();
                if (existingContent.contentEquals(sourceCode)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        private CharSequence extractSourceCode() {
            return LegacyJavaPostprocessing.rewrite(this.consumer.asCharSequence());
        }
    }

    private static class AppendResourceFile {
        private static final Pattern COMMENT_LINE = Pattern.compile("^\\#.*");
        final ResourceKey key;
        final Templates.CharConsumer consumer = new Templates.CharConsumer();

        AppendResourceFile(ResourceKey key) {
            this.key = key;
        }

        void complete() {
            if (!StaticEnvironment.round().errorRaised()) {
                try {
                    this.writeFile();
                }
                catch (FilerException ex) {
                    throw Throwables.propagate(ex);
                }
                catch (IOException ex) {
                    throw Throwables.propagate(ex);
                }
            }
        }

        private void writeFile() throws IOException {
            LinkedHashSet services = Sets.newLinkedHashSet();
            try {
                FileObject existing = Output.getFiler().getResource(StandardLocation.CLASS_OUTPUT, this.key.packageName, this.key.relativeName);
                FluentIterable.from(CharStreams.readLines(existing.openReader(true))).filter(Predicates.not(Predicates.contains(COMMENT_LINE))).copyInto(services);
            }
            catch (Exception exception) {
                // empty catch block
            }
            FluentIterable.from(Splitter.on("\n").split(this.consumer.asCharSequence())).copyInto(services);
            new CharSink(){

                @Override
                public Writer openStream() throws IOException {
                    return Output.getFiler().createResource(StandardLocation.CLASS_OUTPUT, AppendResourceFile.this.key.packageName, AppendResourceFile.this.key.relativeName, new Element[0]).openWriter();
                }
            }.writeLines(services, "\n");
        }
    }

    private static final class ResourceKey {
        private static Joiner PACKAGE_RESOURCE_JOINER = Joiner.on('.').skipNulls();
        final String packageName;
        final String relativeName;

        ResourceKey(String packageName, String simpleName) {
            this.packageName = Preconditions.checkNotNull(packageName);
            this.relativeName = Preconditions.checkNotNull(simpleName);
        }

        public String toString() {
            return PACKAGE_RESOURCE_JOINER.join(Strings.emptyToNull(this.packageName), this.relativeName, new Object[0]);
        }

        public int hashCode() {
            return Objects.hash(this.packageName, this.relativeName);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ResourceKey) {
                ResourceKey other = (ResourceKey)obj;
                return this.packageName.equals(other.packageName) || this.relativeName.equals(other.relativeName);
            }
            return false;
        }
    }
}

