/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.generator;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.eclipse.jdt.internal.compiler.apt.model.ElementImpl;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.immutables.value.internal.google.common.base.Function;
import org.immutables.value.internal.google.common.base.Functions;
import org.immutables.value.internal.google.common.base.Predicate;
import org.immutables.value.internal.google.common.base.Predicates;
import org.immutables.value.internal.google.common.collect.FluentIterable;
import org.immutables.value.internal.google.common.collect.ImmutableList;
import org.immutables.value.internal.google.common.collect.Iterables;
import org.immutables.value.internal.google.common.collect.Lists;
import org.immutables.value.internal.google.common.collect.Maps;
import org.immutables.value.internal.google.common.collect.Ordering;

public final class SourceOrdering {
    private static final OrderingProvider DEFAULT_PROVIDER = new OrderingProvider(){

        @Override
        public Ordering<Element> enclosedBy(Element element) {
            return Ordering.explicit(element.getEnclosedElements());
        }
    };
    private static final OrderingProvider PROVIDER = SourceOrdering.createProvider();

    private SourceOrdering() {
    }

    public static ImmutableList<Element> getEnclosedElements(Element element) {
        return SourceOrdering.enclosedBy(element).immutableSortedCopy(element.getEnclosedElements());
    }

    public static Ordering<Element> enclosedBy(Element element) {
        return PROVIDER.enclosedBy(element);
    }

    private static OrderingProvider createProvider() {
        try {
            return new EclipseCompilerOrderingProvider();
        }
        catch (Throwable ex) {
            return DEFAULT_PROVIDER;
        }
    }

    public static ImmutableList<Element> getAllAccessors(final Elements elements, final TypeElement type) {
        class CollectedOrdering
        extends Ordering<Element>
        implements Function<Element, String> {
            Map<String, 1CollectedOrdering.Intratype> accessorOrderings = Maps.newLinkedHashMap();
            List<TypeElement> linearizedTypes = Lists.newArrayList();

            CollectedOrdering() {
                this.traverse(type);
                this.traverseObjectForInterface();
            }

            private void traverseObjectForInterface() {
                if (type.getKind() == ElementKind.INTERFACE) {
                    this.traverse(elements.getTypeElement(Object.class.getName()));
                }
            }

            void traverse(@Nullable TypeElement element) {
                if (element == null) {
                    return;
                }
                this.collectEnclosing(element);
                this.traverse(this.asTypeElement(element.getSuperclass()));
                for (TypeMirror typeMirror : element.getInterfaces()) {
                    this.traverse(this.asTypeElement(typeMirror));
                }
            }

            TypeElement asTypeElement(TypeMirror type2) {
                if (type2 instanceof DeclaredType) {
                    return (TypeElement)((DeclaredType)type2).asElement();
                }
                return null;
            }

            void collectEnclosing(TypeElement type2) {
                1CollectedOrdering.Intratype intratype = new 1CollectedOrdering.Intratype();
                intratype.rank = this.linearizedTypes.size();
                intratype.ordering = Ordering.explicit(FluentIterable.from(SourceOrdering.getEnclosedElements(type2)).filter(IsAccessor.PREDICATE).transform(this).toList());
                for (Element accessor : Iterables.filter(type2.getEnclosedElements(), IsAccessor.PREDICATE)) {
                    String key = this.apply(accessor);
                    if (this.accessorOrderings.containsKey(key)) continue;
                    this.accessorOrderings.put(key, intratype);
                }
                this.linearizedTypes.add(type2);
            }

            @Override
            public String apply(Element input) {
                return input.getSimpleName().toString();
            }

            @Override
            public int compare(Element left, Element right) {
                1CollectedOrdering.Intratype rightIntratype;
                String leftKey = this.apply(left);
                String rightKey = this.apply(right);
                1CollectedOrdering.Intratype leftIntratype = this.accessorOrderings.get(leftKey);
                return leftIntratype == (rightIntratype = this.accessorOrderings.get(rightKey)) ? leftIntratype.ordering.compare(leftKey, rightKey) : Integer.compare(leftIntratype.rank, rightIntratype.rank);
            }

            class 1CollectedOrdering.Intratype {
                Ordering<String> ordering;
                int rank;

                1CollectedOrdering.Intratype() {
                }
            }
        }
        return FluentIterable.from(ImmutableList.of()).append((Iterable<? extends Element>)elements.getAllMembers(type)).filter(IsAccessor.PREDICATE).toSortedList(new CollectedOrdering());
    }

    private static enum IsAccessor implements Predicate<Element>
    {
        PREDICATE;


        @Override
        public boolean apply(Element input) {
            if (input.getKind() != ElementKind.METHOD) {
                return false;
            }
            ExecutableElement element = (ExecutableElement)input;
            boolean parameterless = element.getParameters().isEmpty();
            boolean nonstatic = !element.getModifiers().contains((Object)Modifier.STATIC);
            return parameterless && nonstatic;
        }
    }

    private static class EclipseCompilerOrderingProvider
    implements OrderingProvider,
    Function<Element, Object> {
        private EclipseCompilerOrderingProvider() {
        }

        @Override
        public Object apply(Element input) {
            return ((ElementImpl)input)._binding;
        }

        @Override
        public Ordering<Element> enclosedBy(Element element) {
            if (element instanceof ElementImpl && Iterables.all(element.getEnclosedElements(), Predicates.instanceOf(ElementImpl.class))) {
                ElementImpl implementation = (ElementImpl)element;
                if (implementation._binding instanceof SourceTypeBinding) {
                    SourceTypeBinding sourceBinding = (SourceTypeBinding)implementation._binding;
                    return Ordering.natural().onResultOf(Functions.compose(this.bindingsToSourceOrder(sourceBinding), this));
                }
            }
            return DEFAULT_PROVIDER.enclosedBy(element);
        }

        private Function<Object, Integer> bindingsToSourceOrder(SourceTypeBinding sourceBinding) {
            IdentityHashMap<Object, Integer> bindings = Maps.newIdentityHashMap();
            if (sourceBinding.scope.referenceContext.methods != null) {
                for (AbstractMethodDeclaration abstractMethodDeclaration : sourceBinding.scope.referenceContext.methods) {
                    bindings.put(abstractMethodDeclaration.binding, abstractMethodDeclaration.declarationSourceStart);
                }
            }
            if (sourceBinding.scope.referenceContext.fields != null) {
                for (AbstractMethodDeclaration abstractMethodDeclaration : sourceBinding.scope.referenceContext.fields) {
                    bindings.put(abstractMethodDeclaration.binding, abstractMethodDeclaration.declarationSourceStart);
                }
            }
            if (sourceBinding.scope.referenceContext.memberTypes != null) {
                for (AbstractMethodDeclaration abstractMethodDeclaration : sourceBinding.scope.referenceContext.memberTypes) {
                    bindings.put(abstractMethodDeclaration.binding, abstractMethodDeclaration.declarationSourceStart);
                }
            }
            return Functions.forMap(bindings);
        }

        static {
            ElementImpl.class.getCanonicalName();
        }
    }

    static interface OrderingProvider {
        public Ordering<Element> enclosedBy(Element var1);
    }
}

