/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor;

import java.util.Collection;
import java.util.Map;
import org.immutables.value.internal.generator.Generator;
import org.immutables.value.internal.google.common.base.Function;
import org.immutables.value.internal.google.common.collect.ImmutableList;
import org.immutables.value.internal.google.common.collect.ImmutableMap;
import org.immutables.value.internal.google.common.collect.Multimaps;
import org.immutables.value.internal.processor.ValuesTemplate;
import org.immutables.value.internal.processor.meta.DiscoveredValue;

@Generator.Template
abstract class Marshalers
extends ValuesTemplate {
    final Function<Iterable<DiscoveredValue>, Iterable<DiscoveredValue>> onlyMarshaled = new Function<Iterable<DiscoveredValue>, Iterable<DiscoveredValue>>(){

        @Override
        public Iterable<DiscoveredValue> apply(Iterable<DiscoveredValue> input) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (DiscoveredValue value : input) {
                if (!value.isGenerateMarshaled()) continue;
                builder.add(value);
            }
            return builder.build();
        }
    };
    final ByPackageGrouper byPackage = new ByPackageGrouper();
    @Generator.Typedef
    Map.Entry<String, Collection<DiscoveredValue>> ByPackage;

    Marshalers() {
    }

    int roundCode() {
        return System.identityHashCode(this.round());
    }

    class ByPackageGrouper
    implements Function<Iterable<DiscoveredValue>, Iterable<Map.Entry<String, Collection<DiscoveredValue>>>> {
        ByPackageGrouper() {
        }

        @Override
        public Iterable<Map.Entry<String, Collection<DiscoveredValue>>> apply(Iterable<DiscoveredValue> discoveredValue) {
            return ((ImmutableMap)Multimaps.index(discoveredValue, new Function<DiscoveredValue, String>(){

                @Override
                public String apply(DiscoveredValue input) {
                    return input.getPackageName();
                }
            }).asMap()).entrySet();
        }
    }
}

