/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.internal.generator.StringLiterals;
import org.immutables.value.internal.google.common.collect.ImmutableList;

final class AnnotationPrinting {
    AnnotationPrinting() {
    }

    static List<String> getAnnotationLines(ExecutableElement element) {
        ImmutableList.Builder annotationLines = ImmutableList.builder();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String string = annotationMirror.toString();
            if (string.startsWith("@org.immutables") || string.startsWith("@java.lang.Override")) continue;
            PrintVisitor printer = new PrintVisitor();
            printer.visitAnnotation(annotationMirror, null);
            annotationLines.add(printer.toString());
        }
        return annotationLines.build();
    }

    private static final class PrintVisitor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        private final StringBuilder builder = new StringBuilder();

        private PrintVisitor() {
        }

        public String toString() {
            return this.builder.toString();
        }

        void visitValue(AnnotationValue value) {
            value.accept(this, null);
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            this.builder.append(o);
            return null;
        }

        @Override
        public Void visitString(String s, Void p) {
            this.builder.append(StringLiterals.toLiteral(s));
            return null;
        }

        @Override
        public Void visitType(TypeMirror t, Void p) {
            this.builder.append(t.toString()).append(".class");
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> vals, Void p) {
            this.builder.append('{');
            boolean notFirst = false;
            for (AnnotationValue annotationValue : vals) {
                if (notFirst) {
                    this.builder.append(',');
                }
                notFirst = true;
                this.visitValue(annotationValue);
            }
            this.builder.append('}');
            return null;
        }

        @Override
        public Void visitEnumConstant(VariableElement c, Void p) {
            this.builder.append(c.getEnclosingElement()).append('.').append(c.getSimpleName());
            return null;
        }

        @Override
        public Void visitAnnotation(AnnotationMirror a, Void p) {
            String annotationString = a.toString();
            int startOfParameters = annotationString.indexOf(40);
            if (startOfParameters > 0) {
                annotationString = annotationString.substring(0, startOfParameters);
            }
            this.builder.append(annotationString);
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = a.getElementValues();
            if (!values.isEmpty()) {
                this.builder.append('(');
                boolean notFirst = false;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : values.entrySet()) {
                    if (notFirst) {
                        this.builder.append(',');
                    }
                    notFirst = true;
                    this.builder.append(e.getKey().getSimpleName()).append(" = ");
                    this.visitValue(e.getValue());
                }
                this.builder.append(')');
            }
            return null;
        }
    }
}

