/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.immutables.value.internal.google.common.base.Function;
import org.immutables.value.internal.google.common.base.Predicate;
import org.immutables.value.internal.google.common.collect.HashMultimap;
import org.immutables.value.internal.google.common.collect.ImmutableSet;
import org.immutables.value.internal.google.common.collect.ImmutableSetMultimap;
import org.immutables.value.internal.google.common.collect.SetMultimap;
import org.immutables.value.internal.processor.meta.DiscoveredValue;

public class CaseStructure {
    public final List<DiscoveredValue> implementationTypes;
    public final SetMultimap<String, DiscoveredValue> subtyping;
    public final Set<String> implementationTypeNames;
    public final SetMultimap<String, DiscoveredValue> subtypeUsages = HashMultimap.create();
    public final SetMultimap<String, DiscoveredValue> abstractUsages = HashMultimap.create();
    public final Predicate<String> isImplementationType = new Predicate<String>(){

        @Override
        public boolean apply(String input) {
            return CaseStructure.this.implementationTypeNames.contains(input);
        }
    };
    public final Function<String, Iterable<DiscoveredValue>> knownSubtypes = new Function<String, Iterable<DiscoveredValue>>(){

        @Override
        public Iterable<DiscoveredValue> apply(@Nullable String typeName) {
            Set<DiscoveredValue> subtypes = CaseStructure.this.subtyping.get(typeName);
            CaseStructure.this.subtypeUsages.putAll(typeName, subtypes);
            for (DiscoveredValue subtype : subtypes) {
                CaseStructure.this.subtypeUsages.put(subtype.valueTypeName(), subtype);
            }
            return subtypes;
        }
    };

    public CaseStructure(DiscoveredValue discoveredValue) {
        this.implementationTypes = discoveredValue.getNestedChildren();
        this.implementationTypeNames = CaseStructure.buildImplementationType(this.implementationTypes);
        this.subtyping = CaseStructure.buildSubtyping(this.implementationTypes);
    }

    private static Set<String> buildImplementationType(List<DiscoveredValue> implementationTypes) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (DiscoveredValue discoveredValue : implementationTypes) {
            builder.add(discoveredValue.implementationTypeName());
        }
        return builder.build();
    }

    private static SetMultimap<String, DiscoveredValue> buildSubtyping(List<DiscoveredValue> implementationTypes) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (DiscoveredValue type : implementationTypes) {
            builder.put(type.internalTypeElement().getQualifiedName().toString(), type);
            for (String className : type.getExtendedClassesNames()) {
                builder.put(className, type);
            }
            for (String interfaceName : type.getImplementedInterfacesNames()) {
                builder.put(interfaceName, type);
            }
        }
        return builder.build();
    }
}

