/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.Json;
import org.immutables.value.Mongo;
import org.immutables.value.Value;
import org.immutables.value.internal.google.common.base.Functions;
import org.immutables.value.internal.google.common.base.MoreObjects;
import org.immutables.value.internal.google.common.collect.ImmutableBiMap;
import org.immutables.value.internal.google.common.collect.ImmutableList;
import org.immutables.value.internal.google.common.collect.ImmutableMap;
import org.immutables.value.internal.google.common.collect.Iterables;
import org.immutables.value.internal.google.common.collect.Lists;
import org.immutables.value.internal.google.common.primitives.Primitives;
import org.immutables.value.internal.processor.meta.AnnotationPrinting;
import org.immutables.value.internal.processor.meta.DiscoveredValue;
import org.immutables.value.internal.processor.meta.SegmentedName;
import org.immutables.value.internal.processor.meta.TypeIntrospectionBase;

public abstract class DiscoveredAttribute
extends TypeIntrospectionBase {
    private static final String GOOGLE_COMMON_PREFIX = "com.go".concat("ogle.common.");
    private static final ImmutableMap<String, Class<?>> PRIMITIVE_TYPES;
    private static final ImmutableBiMap<String, String> BOXED_TO_PRIMITIVE_TYPES;
    private ExecutableElement element;
    private List<String> typeParameters = Collections.emptyList();
    private String implementationType;
    private Boolean isMapType;
    private Boolean isListType;
    private Boolean isSetType;
    private Boolean isOptionalType;
    @Nullable
    private List<String> expectedSubclasses;
    private boolean marshaledElement;
    private boolean marshaledSecondaryElement;
    private boolean specialMarshaledElement;
    private boolean specialMarshaledSecondaryElement;
    private boolean hasEnumFirstTypeParameter;
    private TypeElement containedTypeElement;
    private boolean generateOrdinalValueSet;
    private TypeMirror arrayComponent;

    public void setAttributeElement(ExecutableElement element) {
        this.element = element;
    }

    public boolean isBoolean() {
        return this.internalTypeName().equals(Boolean.TYPE.getName());
    }

    public boolean isStringType() {
        return this.internalTypeName().equals(String.class.getName());
    }

    public boolean charType() {
        return this.internalTypeName().equals(Character.TYPE.getName());
    }

    public boolean isSimpleLiteralType() {
        return this.isPrimitive() || this.isStringType() || this.isEnumType();
    }

    public boolean isMandatory() {
        return this.isGenerateAbstract() && !this.isContainerType();
    }

    @Override
    public boolean isComparable() {
        return this.isNumberType() || super.isComparable();
    }

    public String getMarshaledName() {
        String name;
        Json.Named options = this.element.getAnnotation(Json.Named.class);
        if (options != null && !(name = options.value()).isEmpty()) {
            return name;
        }
        return this.internalName();
    }

    public boolean isForceEmpty() {
        return this.element.getAnnotation(Json.ForceEmpty.class) != null;
    }

    @Override
    protected abstract TypeMirror internalTypeMirror();

    public boolean isGenerateFunction() {
        return false;
    }

    public boolean isGenerateLazy() {
        return false;
    }

    public boolean isGeneratePredicate() {
        return false;
    }

    public boolean isGenerateDefault() {
        return false;
    }

    public boolean isGenerateDerived() {
        return false;
    }

    public boolean isGenerateAbstract() {
        return false;
    }

    protected abstract String internalTypeName();

    protected abstract String internalName();

    public String getName() {
        return this.internalName();
    }

    public String getType() {
        return this.internalTypeName();
    }

    public List<String> getAnnotations() {
        return AnnotationPrinting.getAnnotationLines(this.element);
    }

    public boolean isJsonIgnore() {
        return this.element.getAnnotation(Json.Ignore.class) != null;
    }

    public String getImplementationType() {
        if (this.implementationType == null) {
            String type = this.getType();
            this.implementationType = this.isMapType() ? type.replace(Map.class.getName(), this.googleCommonHiddenFromShadePlugin("collect.ImmutableMap")) : (this.isListType() ? type.replace(List.class.getName(), this.googleCommonHiddenFromShadePlugin("collect.ImmutableList")) : (this.isSetType() ? type.replace(Set.class.getName(), this.isGenerateOrdinalValueSet() ? "org.immutables.common.collect.".concat("ImmutableOrdinalSet") : this.googleCommonHiddenFromShadePlugin("collect.ImmutableSet")) : type));
        }
        return this.implementationType;
    }

    public List<String> typeParameters() {
        this.ensureTypeIntrospected();
        return this.arrayComponent != null ? ImmutableList.of(this.arrayComponent.toString()) : this.typeParameters;
    }

    public boolean isMapType() {
        if (this.isMapType == null) {
            this.isMapType = this.internalTypeName().startsWith(Map.class.getName());
        }
        return this.isMapType;
    }

    public boolean isListType() {
        if (this.isListType == null) {
            this.isListType = this.internalTypeName().startsWith(List.class.getName());
        }
        return this.isListType;
    }

    public boolean isSetType() {
        if (this.isSetType == null) {
            this.isSetType = this.internalTypeName().startsWith(Set.class.getName());
        }
        return this.isSetType;
    }

    public boolean isOptionalType() {
        if (this.isOptionalType == null) {
            this.isOptionalType = this.internalTypeName().startsWith(this.googleCommonHiddenFromShadePlugin("base.Optional"));
        }
        return this.isOptionalType;
    }

    private String googleCommonHiddenFromShadePlugin(Object string) {
        return GOOGLE_COMMON_PREFIX + string;
    }

    public boolean isCollectionType() {
        return this.isSetType() || this.isListType();
    }

    public boolean isGenerateEnumSet() {
        this.ensureTypeIntrospected();
        return this.isSetType() && this.hasEnumFirstTypeParameter;
    }

    public boolean isGenerateEnumMap() {
        this.ensureTypeIntrospected();
        return this.isMapType() && this.hasEnumFirstTypeParameter;
    }

    public String getUnwrappedElementType() {
        return this.unwrapType(this.containmentTypeName());
    }

    public String getWrappedElementType() {
        return this.wrapType(this.containmentTypeName());
    }

    private String wrapType(String typeName) {
        return MoreObjects.firstNonNull(((ImmutableMap)((Object)BOXED_TO_PRIMITIVE_TYPES.inverse())).get(typeName), typeName);
    }

    private String unwrapType(String typeName) {
        return MoreObjects.firstNonNull(BOXED_TO_PRIMITIVE_TYPES.get(typeName), typeName);
    }

    private String containmentTypeName() {
        return this.isArrayType() || this.isContainerType() ? this.firstTypeParameter() : this.internalTypeName();
    }

    public String getRawType() {
        String type = this.getType();
        int endIndex = type.length();
        int firstIndexOfGenerics = type.indexOf(60);
        if (firstIndexOfGenerics > 0) {
            endIndex = firstIndexOfGenerics;
        }
        return type.substring(0, endIndex);
    }

    public String getConsumedElementType() {
        return this.isUnwrappedElementPrimitiveType() || String.class.getName().equals(this.containmentTypeName()) || this.hasEnumFirstTypeParameter ? this.getWrappedElementType() : "? extends " + this.getWrappedElementType();
    }

    private String extractRawType(String className) {
        int indexOfGenerics = className.indexOf(60);
        if (indexOfGenerics > 0) {
            return className.substring(0, indexOfGenerics);
        }
        return className;
    }

    public boolean isUnwrappedElementPrimitiveType() {
        return PRIMITIVE_TYPES.containsKey(this.getUnwrappedElementType());
    }

    public boolean isUnwrappedSecondaryElementPrimitiveType() {
        return PRIMITIVE_TYPES.containsKey(this.getUnwrappedSecondaryElementType());
    }

    public String firstTypeParameter() {
        return Iterables.getFirst(this.typeParameters(), "");
    }

    public String secondTypeParameter() {
        return Iterables.get(this.typeParameters(), 1);
    }

    public String getElementType() {
        return this.containmentTypeName();
    }

    public List<String> getExpectedSubclasses() {
        if (this.expectedSubclasses == null) {
            if (this.element.getAnnotation(Json.Subclasses.class) != null) {
                this.expectedSubclasses = DiscoveredAttribute.listExpectedSubclassesFromElement(this.element);
            } else {
                this.ensureTypeIntrospected();
                this.expectedSubclasses = this.containedTypeElement != null ? DiscoveredAttribute.listExpectedSubclassesFromElement(this.containedTypeElement) : ImmutableList.of();
            }
        }
        return this.expectedSubclasses;
    }

    private static List<String> listExpectedSubclassesFromElement(Element element) {
        return DiscoveredValue.extractedClassNamesFromAnnotationMirrors(Json.Subclasses.class.getCanonicalName(), "value", element.getAnnotationMirrors());
    }

    public boolean isGenerateOrdinalValueSet() {
        if (!this.isSetType()) {
            return false;
        }
        this.ensureTypeIntrospected();
        return this.generateOrdinalValueSet;
    }

    public boolean isDocumentElement() {
        this.ensureTypeIntrospected();
        return this.containedTypeElement != null && this.containedTypeElement.getAnnotation(Mongo.Repository.class) != null;
    }

    public boolean isArrayType() {
        return this.internalTypeMirror().getKind() == TypeKind.ARRAY;
    }

    @Override
    protected void introspectType() {
        TypeMirror typeMirror = this.internalTypeMirror();
        if (this.isContainerType()) {
            if (typeMirror instanceof DeclaredType) {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                ArrayList<String> typeParameters = Lists.newArrayList();
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                if (!typeArguments.isEmpty()) {
                    TypeMirror typeArgument;
                    if (typeArguments.size() == 1) {
                        typeArgument = typeArguments.get(0);
                        if (typeArgument instanceof DeclaredType) {
                            typeMirror = typeArgument;
                        }
                        if (this.isSetType()) {
                            this.generateOrdinalValueSet = new TypeIntrospectionBase(){

                                @Override
                                protected TypeMirror internalTypeMirror() {
                                    return typeArgument;
                                }
                            }.isOrdinalValue();
                        }
                    }
                    if (typeArguments.size() >= 1) {
                        TypeMirror typeSecondArgument;
                        typeArgument = typeArguments.get(0);
                        if (typeArgument instanceof DeclaredType) {
                            TypeElement typeElement = (TypeElement)((DeclaredType)typeArgument).asElement();
                            this.hasEnumFirstTypeParameter = typeElement.getSuperclass().toString().startsWith(Enum.class.getName());
                        }
                        if (typeArguments.size() >= 2 && (typeSecondArgument = typeArguments.get(1)) instanceof DeclaredType) {
                            TypeElement typeElement = (TypeElement)((DeclaredType)typeSecondArgument).asElement();
                            Json.Marshaled generateMarshaler = typeElement.getAnnotation(Json.Marshaled.class);
                            this.marshaledSecondaryElement = generateMarshaler != null;
                            this.specialMarshaledSecondaryElement = this.isSpecialMarshaledElement(this.marshaledSecondaryElement, typeElement.getQualifiedName());
                        }
                    }
                    typeParameters.addAll(Lists.transform(typeArguments, Functions.toStringFunction()));
                }
                this.typeParameters = typeParameters;
            }
        } else if (this.isArrayType()) {
            typeMirror = this.arrayComponent = ((ArrayType)typeMirror).getComponentType();
        }
        if (typeMirror instanceof DeclaredType) {
            TypeElement typeElement;
            this.containedTypeElement = typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            Json.Marshaled generateMarshaler = typeElement.getAnnotation(Json.Marshaled.class);
            this.marshaledElement = generateMarshaler != null;
            this.specialMarshaledElement = this.isSpecialMarshaledElement(this.marshaledElement, typeElement.getQualifiedName());
        }
        super.introspectType();
    }

    static boolean isRegularMashalableType(String name) {
        return String.class.getName().equals(name) || PRIMITIVE_TYPES.containsKey(name) || BOXED_TO_PRIMITIVE_TYPES.containsKey(name);
    }

    public String getRawCollectionType() {
        return this.isListType() ? List.class.getSimpleName() : (this.isSetType() ? Set.class.getSimpleName() : "");
    }

    public String getSecondaryElementType() {
        return this.secondTypeParameter();
    }

    public String getUnwrappedSecondaryElementType() {
        return this.unwrapType(this.secondTypeParameter());
    }

    public String getWrappedSecondaryElementType() {
        return this.wrapType(this.secondTypeParameter());
    }

    public String getUnwrapperOrRawSecondaryElementType() {
        return this.extractRawType(this.getWrappedSecondaryElementType());
    }

    public String getUnwrapperOrRawElementType() {
        return this.extractRawType(this.getWrappedElementType());
    }

    public boolean isNumberType() {
        String t = this.internalTypeName();
        return this.isPrimitive() && !Character.TYPE.getName().equals(t) && !Boolean.TYPE.getName().equals(t);
    }

    public boolean isFloatType() {
        String t = this.internalTypeName();
        return Float.TYPE.getName().equals(t) || Double.TYPE.getName().equals(t);
    }

    public boolean isFloat() {
        String t = this.internalTypeName();
        return Float.TYPE.getName().equals(t);
    }

    public boolean isDouble() {
        String t = this.internalTypeName();
        return Double.TYPE.getName().equals(t);
    }

    public boolean isNonRawElemementType() {
        return this.getElementType().indexOf(60) > 0;
    }

    public boolean isContainerType() {
        return this.isCollectionType() || this.isOptionalType() || this.isMapType();
    }

    public String getWrapperType() {
        return this.isPrimitive() ? Primitives.wrap(PRIMITIVE_TYPES.get(this.internalTypeName())).getName() : this.internalTypeName();
    }

    public boolean isPrimitive() {
        return PRIMITIVE_TYPES.containsKey(this.internalTypeName());
    }

    public int getConstructorArgumentOrder() {
        Value.Parameter annotation = this.element.getAnnotation(Value.Parameter.class);
        return annotation != null ? annotation.order() : -1;
    }

    public boolean isSpecialMarshaledElement() {
        this.ensureTypeIntrospected();
        return this.specialMarshaledElement;
    }

    public boolean isSpecialMarshaledSecondaryElement() {
        this.ensureTypeIntrospected();
        return this.specialMarshaledSecondaryElement;
    }

    public boolean isMarshaledElement() {
        if (this.isPrimitive()) {
            return false;
        }
        this.ensureTypeIntrospected();
        return this.marshaledElement;
    }

    public boolean isMarshaledSecondaryElement() {
        this.ensureTypeIntrospected();
        return this.marshaledSecondaryElement;
    }

    public boolean isPrimitiveElement() {
        return PRIMITIVE_TYPES.containsKey(this.getUnwrappedElementType());
    }

    private boolean isSpecialMarshaledElement(boolean isMarshaled, Object qualifiedName) {
        if (isMarshaled) {
            return true;
        }
        return !DiscoveredAttribute.isRegularMashalableType(qualifiedName.toString());
    }

    private static String marshalerNameFor(String typeName) {
        SegmentedName name = SegmentedName.from(typeName);
        return name.packageName + "." + name.simpleName + "Marshaler";
    }

    Collection<String> getMarshaledImportRoutines() {
        ArrayList<String> imports = Lists.newArrayListWithExpectedSize(2);
        if (this.isMarshaledElement()) {
            String typeName = this.isContainerType() ? this.getUnwrappedElementType() : this.getType();
            imports.add(DiscoveredAttribute.marshalerNameFor(typeName));
        }
        if (this.isMapType() && this.isMarshaledSecondaryElement()) {
            imports.add(DiscoveredAttribute.marshalerNameFor(this.getUnwrappedSecondaryElementType()));
        }
        return imports;
    }

    Collection<String> getSpecialMarshaledTypes() {
        ArrayList<String> marshaledTypeSet = Lists.newArrayListWithExpectedSize(2);
        if (this.isSpecialMarshaledElement()) {
            String typeName = this.isContainerType() ? this.getUnwrappedElementType() : this.getType();
            DiscoveredAttribute.addIfSpecialMarshalable(marshaledTypeSet, typeName);
        }
        if (this.isMapType() && this.isSpecialMarshaledSecondaryElement()) {
            DiscoveredAttribute.addIfSpecialMarshalable(marshaledTypeSet, this.getUnwrappedSecondaryElementType());
        }
        return marshaledTypeSet;
    }

    static void addIfSpecialMarshalable(Collection<String> marshaledTypes, String typeName) {
        if (!DiscoveredAttribute.isRegularMashalableType(typeName)) {
            marshaledTypes.add(typeName);
        }
    }

    public boolean isAuxiliary() {
        return this.element.getAnnotation(Value.Auxiliary.class) != null;
    }

    public boolean isMarshaledIgnore() {
        this.ensureTypeIntrospected();
        return this.isMarshaledElement();
    }

    static {
        ImmutableMap.Builder<String, Class<?>> builder = ImmutableMap.builder();
        for (Class<?> primitive : Primitives.allPrimitiveTypes()) {
            builder.put(primitive.getName(), primitive);
        }
        PRIMITIVE_TYPES = builder.build();
        builder = ImmutableBiMap.builder();
        for (Class<?> primitive : Primitives.allPrimitiveTypes()) {
            ((ImmutableBiMap.Builder)builder).put(Primitives.wrap(primitive).getName(), primitive.getName());
        }
        BOXED_TO_PRIMITIVE_TYPES = ((ImmutableBiMap.Builder)builder).build();
    }
}

