/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.internal.google.common.base.MoreObjects;
import org.immutables.value.internal.google.common.base.Preconditions;
import org.immutables.value.internal.google.common.base.Predicate;
import org.immutables.value.internal.google.common.collect.ImmutableList;
import org.immutables.value.internal.google.common.primitives.Booleans;
import org.immutables.value.internal.processor.meta.DiscoveredAttribute;

final class DiscoveredAttributes {
    private DiscoveredAttributes() {
    }

    public static Predicate<DiscoveredAttribute> isGenerateFunction() {
        return IsGenerateFunctionPredicate.INSTANCE;
    }

    public static Predicate<DiscoveredAttribute> isGeneratePredicate() {
        return IsGeneratePredicatePredicate.INSTANCE;
    }

    public static Predicate<DiscoveredAttribute> isGenerateDefault() {
        return IsGenerateDefaultPredicate.INSTANCE;
    }

    public static Predicate<DiscoveredAttribute> isGenerateDerived() {
        return IsGenerateDerivedPredicate.INSTANCE;
    }

    public static Predicate<DiscoveredAttribute> isGenerateAbstract() {
        return IsGenerateAbstractPredicate.INSTANCE;
    }

    public static Predicate<DiscoveredAttribute> isPrimitive() {
        return IsPrimitivePredicate.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final String REQUIRED_ATTRIBUTE = "Cannot build DiscoveredAttribute: required attribute '%s' is not set";
        @Nullable
        private TypeMirror internalTypeMirror;
        private boolean isGenerateFunction;
        private boolean isGenerateFunctionIsSet;
        private boolean isGeneratePredicate;
        private boolean isGeneratePredicateIsSet;
        private boolean isGenerateDefault;
        private boolean isGenerateDefaultIsSet;
        private boolean isGenerateDerived;
        private boolean isGenerateDerivedIsSet;
        private boolean isGenerateAbstract;
        private boolean isGenerateAbstractIsSet;
        private boolean isGenerateLazy;
        private boolean isGenerateLazyIsSet;
        @Nullable
        private String internalName;
        @Nullable
        private String internalTypeName;
        private ImmutableList.Builder<String> typeParametersBuilder = ImmutableList.builder();

        private Builder() {
        }

        public Builder copy(DiscoveredAttribute fromInstance) {
            Preconditions.checkNotNull(fromInstance);
            this.internalTypeMirror(fromInstance.internalTypeMirror());
            this.isGenerateFunction(fromInstance.isGenerateFunction());
            this.isGeneratePredicate(fromInstance.isGeneratePredicate());
            this.isGenerateDefault(fromInstance.isGenerateDefault());
            this.isGenerateDerived(fromInstance.isGenerateDerived());
            this.isGenerateAbstract(fromInstance.isGenerateAbstract());
            this.internalName(fromInstance.internalName());
            this.internalTypeName(fromInstance.internalTypeName());
            this.addTypeParameters(fromInstance.typeParameters());
            return this;
        }

        public Builder internalTypeMirror(TypeMirror internalTypeMirror) {
            this.internalTypeMirror = Preconditions.checkNotNull(internalTypeMirror);
            return this;
        }

        public Builder isGenerateFunction(boolean isGenerateFunction) {
            this.isGenerateFunction = isGenerateFunction;
            this.isGenerateFunctionIsSet = true;
            return this;
        }

        public Builder isGeneratePredicate(boolean isGeneratePredicate) {
            this.isGeneratePredicate = isGeneratePredicate;
            this.isGeneratePredicateIsSet = true;
            return this;
        }

        public Builder isGenerateDefault(boolean isGenerateDefault) {
            this.isGenerateDefault = isGenerateDefault;
            this.isGenerateDefaultIsSet = true;
            return this;
        }

        public Builder isGenerateDerived(boolean isGenerateDerived) {
            this.isGenerateDerived = isGenerateDerived;
            this.isGenerateDerivedIsSet = true;
            return this;
        }

        public Builder isGenerateLazy(boolean isGenerateLazy) {
            this.isGenerateLazy = isGenerateLazy;
            this.isGenerateLazyIsSet = true;
            return this;
        }

        public Builder isGenerateAbstract(boolean isGenerateAbstract) {
            this.isGenerateAbstract = isGenerateAbstract;
            this.isGenerateAbstractIsSet = true;
            return this;
        }

        public Builder internalName(String internalName) {
            this.internalName = Preconditions.checkNotNull(internalName);
            return this;
        }

        public Builder internalTypeName(String internalTypeName) {
            this.internalTypeName = Preconditions.checkNotNull(internalTypeName);
            return this;
        }

        public Builder addTypeParameters(String typeParametersElement) {
            this.typeParametersBuilder.add((Object)typeParametersElement);
            return this;
        }

        public Builder addTypeParameters(String ... typeParametersElements) {
            for (String it : typeParametersElements) {
                this.typeParametersBuilder.add((Object)it);
            }
            return this;
        }

        public Builder addTypeParameters(Iterable<? extends String> typeParametersElements) {
            this.typeParametersBuilder.addAll(typeParametersElements);
            return this;
        }

        public Builder clearTypeParameters() {
            this.typeParametersBuilder = ImmutableList.builder();
            return this;
        }

        public DiscoveredAttribute build() {
            Preconditions.checkState(this.internalTypeMirror != null, REQUIRED_ATTRIBUTE, "internalTypeMirror");
            Preconditions.checkState(this.internalName != null, REQUIRED_ATTRIBUTE, "internalName");
            Preconditions.checkState(this.internalTypeName != null, REQUIRED_ATTRIBUTE, "internalTypeName");
            return new ImmutableDiscoveredAttribute(this);
        }
    }

    @Immutable
    private static final class ImmutableDiscoveredAttribute
    extends DiscoveredAttribute {
        private final TypeMirror internalTypeMirror;
        private final boolean isGenerateFunction;
        private final boolean isGeneratePredicate;
        private final boolean isGenerateDefault;
        private final boolean isGenerateLazy;
        private final boolean isGenerateDerived;
        private final boolean isGenerateAbstract;
        private final String internalName;
        private final String internalTypeName;

        ImmutableDiscoveredAttribute(Builder builder) {
            this.internalTypeMirror = Preconditions.checkNotNull(builder.internalTypeMirror);
            this.internalName = Preconditions.checkNotNull(builder.internalName);
            this.internalTypeName = Preconditions.checkNotNull(builder.internalTypeName);
            this.isGenerateFunction = builder.isGenerateFunctionIsSet ? builder.isGenerateFunction : super.isGenerateFunction();
            this.isGeneratePredicate = builder.isGeneratePredicateIsSet ? builder.isGeneratePredicate : super.isGeneratePredicate();
            this.isGenerateDefault = builder.isGenerateDefaultIsSet ? builder.isGenerateDefault : super.isGenerateDefault();
            this.isGenerateDerived = builder.isGenerateDerivedIsSet ? builder.isGenerateDerived : super.isGenerateDerived();
            this.isGenerateAbstract = builder.isGenerateAbstractIsSet ? builder.isGenerateAbstract : super.isGenerateAbstract();
            this.isGenerateLazy = builder.isGenerateLazyIsSet ? builder.isGenerateLazy : super.isGenerateLazy();
        }

        @Override
        public TypeMirror internalTypeMirror() {
            return this.internalTypeMirror;
        }

        @Override
        public boolean isGenerateFunction() {
            return this.isGenerateFunction;
        }

        @Override
        public boolean isGenerateLazy() {
            return this.isGenerateLazy;
        }

        @Override
        public boolean isGeneratePredicate() {
            return this.isGeneratePredicate;
        }

        @Override
        public boolean isGenerateDefault() {
            return this.isGenerateDefault;
        }

        @Override
        public boolean isGenerateDerived() {
            return this.isGenerateDerived;
        }

        @Override
        public boolean isGenerateAbstract() {
            return this.isGenerateAbstract;
        }

        @Override
        public String internalName() {
            return this.internalName;
        }

        @Override
        public String internalTypeName() {
            return this.internalTypeName;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof ImmutableDiscoveredAttribute && this.equalTo((ImmutableDiscoveredAttribute)another);
        }

        private boolean equalTo(ImmutableDiscoveredAttribute another) {
            return this.internalTypeMirror.equals(another.internalTypeMirror) && this.isGenerateFunction == another.isGenerateFunction && this.isGeneratePredicate == another.isGeneratePredicate && this.isGenerateDefault == another.isGenerateDefault && this.isGenerateDerived == another.isGenerateDerived && this.isGenerateAbstract == another.isGenerateAbstract && this.internalName.equals(another.internalName) && this.internalTypeName.equals(another.internalTypeName);
        }

        public int hashCode() {
            int h = 31;
            h = h * 17 + this.internalTypeMirror.hashCode();
            h = h * 17 + Booleans.hashCode(this.isGenerateFunction);
            h = h * 17 + Booleans.hashCode(this.isGeneratePredicate);
            h = h * 17 + Booleans.hashCode(this.isGenerateDefault);
            h = h * 17 + Booleans.hashCode(this.isGenerateDerived);
            h = h * 17 + Booleans.hashCode(this.isGenerateAbstract);
            h = h * 17 + this.internalName.hashCode();
            h = h * 17 + this.internalTypeName.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper("DiscoveredAttribute").add("internalTypeMirror", this.internalTypeMirror).add("isGenerateFunction", this.isGenerateFunction).add("isGeneratePredicate", this.isGeneratePredicate).add("isGenerateDefault", this.isGenerateDefault).add("isGenerateDerived", this.isGenerateDerived).add("isGenerateAbstract", this.isGenerateAbstract).add("internalName", this.internalName).add("internalTypeName", this.internalTypeName).toString();
        }
    }

    private static enum IsPrimitivePredicate implements Predicate<DiscoveredAttribute>
    {
        INSTANCE;


        @Override
        public boolean apply(DiscoveredAttribute input) {
            return input.isPrimitive();
        }

        public String toString() {
            return "DiscoveredAttributes.isPrimitive()";
        }
    }

    private static enum IsGenerateAbstractPredicate implements Predicate<DiscoveredAttribute>
    {
        INSTANCE;


        @Override
        public boolean apply(DiscoveredAttribute input) {
            return input.isGenerateAbstract();
        }

        public String toString() {
            return "DiscoveredAttributes.isGenerateAbstract()";
        }
    }

    private static enum IsGenerateDerivedPredicate implements Predicate<DiscoveredAttribute>
    {
        INSTANCE;


        @Override
        public boolean apply(DiscoveredAttribute input) {
            return input.isGenerateDerived();
        }

        public String toString() {
            return "DiscoveredAttributes.isGenerateDerived()";
        }
    }

    private static enum IsGenerateDefaultPredicate implements Predicate<DiscoveredAttribute>
    {
        INSTANCE;


        @Override
        public boolean apply(DiscoveredAttribute input) {
            return input.isGenerateDefault();
        }

        public String toString() {
            return "DiscoveredAttributes.isGenerateDefault()";
        }
    }

    private static enum IsGeneratePredicatePredicate implements Predicate<DiscoveredAttribute>
    {
        INSTANCE;


        @Override
        public boolean apply(DiscoveredAttribute input) {
            return input.isGeneratePredicate();
        }

        public String toString() {
            return "DiscoveredAttributes.isGeneratePredicate()";
        }
    }

    private static enum IsGenerateFunctionPredicate implements Predicate<DiscoveredAttribute>
    {
        INSTANCE;


        @Override
        public boolean apply(DiscoveredAttribute input) {
            return input.isGenerateFunction();
        }

        public String toString() {
            return "DiscoveredAttributes.isGenerateFunction()";
        }
    }
}

