/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import org.immutables.value.Jackson;
import org.immutables.value.Json;
import org.immutables.value.Mongo;
import org.immutables.value.Parboil;
import org.immutables.value.Value;
import org.immutables.value.internal.google.common.base.Function;
import org.immutables.value.internal.google.common.base.Joiner;
import org.immutables.value.internal.google.common.base.Predicate;
import org.immutables.value.internal.google.common.base.Predicates;
import org.immutables.value.internal.google.common.base.Strings;
import org.immutables.value.internal.google.common.collect.FluentIterable;
import org.immutables.value.internal.google.common.collect.ImmutableList;
import org.immutables.value.internal.google.common.collect.ImmutableSet;
import org.immutables.value.internal.google.common.collect.Lists;
import org.immutables.value.internal.google.common.collect.Ordering;
import org.immutables.value.internal.google.common.collect.Sets;
import org.immutables.value.internal.processor.meta.CaseStructure;
import org.immutables.value.internal.processor.meta.DiscoveredAttribute;
import org.immutables.value.internal.processor.meta.DiscoveredAttributes;
import org.immutables.value.internal.processor.meta.SegmentedName;
import org.immutables.value.internal.processor.meta.TypeIntrospectionBase;

public abstract class DiscoveredValue
extends TypeIntrospectionBase {
    private SegmentedName segmentedName;
    private boolean emptyNesting;
    private CaseStructure caseStructure;
    private static final int SOME_RANDOM_LIMIT = 120;
    private DiscoveredValue nestingParent;
    private List<DiscoveredValue> nestedChildren;
    @Nullable
    private String validationMethodName;
    private Value.Immutable immutableProperties;
    private Boolean hasAbstractBuilder;
    private Set<String> importedMarshalledRoutines;
    private Set<String> generateMarshaledTypes;
    private List<DiscoveredAttribute> implementedAttributes;

    public SegmentedName getSegmentedName() {
        return this.segmentedName;
    }

    public void setSegmentedName(SegmentedName segmentedName) {
        this.segmentedName = segmentedName;
    }

    public String getSimpleName() {
        return this.segmentedName.simpleName;
    }

    public boolean isEmptyNesting() {
        return this.emptyNesting;
    }

    public boolean isGenerateJacksonMapped() {
        return this.internalTypeElement().getAnnotation(Jackson.Mapped.class) != null;
    }

    public void setEmptyNesting(boolean emptyNesting) {
        this.emptyNesting = emptyNesting;
    }

    public String valueTypeName() {
        return this.internalTypeElement().getQualifiedName().toString();
    }

    public boolean isTopLevel() {
        return this.segmentedName.enclosingClassName.isEmpty();
    }

    public boolean isAnnotationType() {
        return this.internalTypeElement().getKind() == ElementKind.ANNOTATION_TYPE;
    }

    public String implementationTypeName() {
        return Joiner.on('.').skipNulls().join(Strings.emptyToNull(this.getPackageName()), this.getImmutableReferenceName(), new Object[0]);
    }

    public String getImmutableReferenceName() {
        return "Immutable" + (this.isHasNestingParent() ? this.getName() : this.getSimpleName());
    }

    public boolean isGenerateParboiled() {
        return this.isEmptyNesting() && this.internalTypeElement().getAnnotation(Parboil.Ast.class) != null;
    }

    public boolean isGenerateTransformer() {
        return this.isEmptyNesting() && this.internalTypeElement().getAnnotation(Value.Transformer.class) != null;
    }

    public CaseStructure getCases() {
        if (this.caseStructure == null) {
            this.caseStructure = new CaseStructure(this);
        }
        return this.caseStructure;
    }

    public void setNestingParent(DiscoveredValue nestingParent) {
        this.nestingParent = nestingParent;
    }

    public void setNestedChildren(List<DiscoveredValue> nestedChildren) {
        this.nestedChildren = nestedChildren;
        for (DiscoveredValue child : nestedChildren) {
            child.setNestingParent(this);
        }
    }

    public List<DiscoveredValue> getNestedChildren() {
        return this.nestedChildren;
    }

    public boolean isHasNestingParent() {
        return this.nestingParent != null;
    }

    public boolean isHasNestedChildren() {
        return this.nestedChildren != null;
    }

    @Nullable
    public String getValidationMethodName() {
        return this.validationMethodName;
    }

    public boolean isIface() {
        return this.internalTypeElement().getKind() == ElementKind.INTERFACE || this.internalTypeElement().getKind() == ElementKind.ANNOTATION_TYPE;
    }

    public String getInheritsKeyword() {
        return this.isIface() ? "implements" : "extends";
    }

    public <T extends Annotation> T getAnnotationFromThisOrEnclosingElement(Class<T> annotationType) {
        T annotation = this.internalTypeElement().getAnnotation(annotationType);
        if (annotation == null && this.nestingParent != null) {
            annotation = this.nestingParent.internalTypeElement().getAnnotation(annotationType);
        }
        return annotation;
    }

    public boolean isGenerateGetters() {
        return this.internalTypeElement().getAnnotation(Value.Getters.class) != null;
    }

    public void setValidationMethodName(@Nullable String validationMethodName) {
        this.validationMethodName = validationMethodName;
    }

    public String getPackageName() {
        return this.segmentedName.packageName;
    }

    public String getName() {
        return this.segmentedName.referenceClassName;
    }

    public String getDefName() {
        return this.isHasNestingParent() ? this.segmentedName.simpleName : "Immutable" + this.segmentedName.simpleName;
    }

    public String getAccessPrefix() {
        Value.Immutable immutable = this.getGenerateImmutableProperties();
        if (immutable != null && immutable.nonpublic()) {
            return "";
        }
        if (this.internalTypeElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
            return "public ";
        }
        return "";
    }

    public boolean isGenerateOrdinalValue() {
        return this.isOrdinalValue();
    }

    public boolean isUseConstructorOnly() {
        return this.isUseConstructor() && !this.isUseBuilder();
    }

    private Value.Immutable getGenerateImmutableProperties() {
        if (this.immutableProperties == null) {
            this.immutableProperties = this.internalTypeElement().getAnnotation(Value.Immutable.class);
        }
        return this.immutableProperties;
    }

    public boolean isUseCopyMethods() {
        return this.getGenerateImmutableProperties().withers() && this.getImplementedAttributes().size() > 0 && this.getImplementedAttributes().size() < 120;
    }

    public boolean isUseSingleton() {
        return this.getGenerateImmutableProperties().singleton();
    }

    public boolean isUseInterned() {
        return this.getGenerateImmutableProperties().intern();
    }

    public boolean isUsePrehashed() {
        return this.isUseInterned() || this.isGenerateOrdinalValue() || this.getGenerateImmutableProperties().prehash();
    }

    public boolean isGenerateMarshaled() {
        return this.getAnnotationFromThisOrEnclosingElement(Json.Marshaled.class) != null || this.isGenerateRepository();
    }

    public boolean isGenerateRepository() {
        return this.internalTypeElement().getAnnotation(Mongo.Repository.class) != null;
    }

    public boolean isHasAbstractBuilder() {
        if (this.hasAbstractBuilder == null) {
            boolean abstractBuilderDeclared = false;
            List<? extends Element> enclosedElements = this.internalTypeElement().getEnclosedElements();
            for (Element element : enclosedElements) {
                if (element.getKind() != ElementKind.CLASS || !element.getSimpleName().contentEquals("Builder")) continue;
                abstractBuilderDeclared = true;
                break;
            }
            this.hasAbstractBuilder = abstractBuilderDeclared;
        }
        return this.hasAbstractBuilder;
    }

    public String getDocumentName() {
        Mongo.Repository annotation = this.internalTypeElement().getAnnotation(Mongo.Repository.class);
        if (annotation != null && !annotation.value().isEmpty()) {
            return annotation.value();
        }
        return this.inferDocumentCollectionName(this.getName());
    }

    private String inferDocumentCollectionName(String name) {
        char[] a = name.toCharArray();
        a[0] = Character.toLowerCase(a[0]);
        return String.valueOf(a);
    }

    public Set<String> getGenerateMarshaledImportRoutines() {
        if (this.importedMarshalledRoutines == null) {
            LinkedHashSet<String> imports = Sets.newLinkedHashSet();
            for (DiscoveredAttribute a : this.filteredAttributes()) {
                imports.addAll(a.getMarshaledImportRoutines());
            }
            this.collectImportRoutines(imports);
            this.importedMarshalledRoutines = ImmutableSet.copyOf(imports);
        }
        return this.importedMarshalledRoutines;
    }

    private void collectImportRoutines(Set<String> imports) {
        Element element = this.internalTypeElement();
        while (true) {
            imports.addAll(this.extractClassNamesFromMirrors(Json.Import.class, "value", element.getAnnotationMirrors()));
            Element enclosingElement = element.getEnclosingElement();
            if (enclosingElement == null || element instanceof PackageElement) break;
            element = enclosingElement;
        }
    }

    @Nullable
    public DiscoveredAttribute getIdAttribute() {
        for (DiscoveredAttribute attribute : this.getImplementedAttributes()) {
            if (!attribute.getMarshaledName().equals("_id")) continue;
            return attribute;
        }
        return null;
    }

    public Set<String> getGenerateMarshaledTypes() {
        if (this.generateMarshaledTypes == null) {
            LinkedHashSet<String> marshaledTypes = Sets.newLinkedHashSet();
            for (DiscoveredAttribute a : this.filteredAttributes()) {
                marshaledTypes.addAll(a.getSpecialMarshaledTypes());
            }
            this.generateMarshaledTypes = marshaledTypes;
        }
        return this.generateMarshaledTypes;
    }

    private List<String> extractClassNamesFromMirrors(Class<?> annotationType, String annotationValueName, List<? extends AnnotationMirror> annotationMirrors) {
        return DiscoveredValue.extractedClassNamesFromAnnotationMirrors(annotationType.getCanonicalName(), annotationValueName, annotationMirrors);
    }

    public static List<String> extractedClassNamesFromAnnotationMirrors(String annotationTypeName, String annotationValueName, List<? extends AnnotationMirror> annotationMirrors) {
        final ArrayList collectClassNames = Lists.newArrayList();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotationTypeName)) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
                if (!e.getKey().getSimpleName().contentEquals(annotationValueName)) continue;
                e.getValue().accept(new SimpleAnnotationValueVisitor6<Void, Void>(){

                    @Override
                    public Void visitArray(List<? extends AnnotationValue> vals, Void p) {
                        for (AnnotationValue annotationValue : vals) {
                            annotationValue.accept(this, p);
                        }
                        return null;
                    }

                    @Override
                    public Void visitType(TypeMirror t, Void p) {
                        collectClassNames.add(t.toString());
                        return null;
                    }
                }, null);
            }
        }
        return ImmutableList.copyOf(collectClassNames);
    }

    public List<DiscoveredAttribute> getSettableAttributes() {
        return this.filteredAttributes().filter(Predicates.or(DiscoveredAttributes.isGenerateAbstract(), DiscoveredAttributes.isGenerateDefault())).toList();
    }

    public boolean isUseConstructor() {
        return !this.getConstructorArguments().isEmpty() || !this.isUseBuilder() && !this.isUseSingleton() && this.getImplementedAttributes().isEmpty();
    }

    public List<DiscoveredAttribute> getConstructorArguments() {
        return this.filteredAttributes().filter(Predicates.compose(Predicates.not(Predicates.equalTo(-1)), ToConstructorArgumentOrder.FUNCTION)).toSortedList(Ordering.natural().onResultOf(ToConstructorArgumentOrder.FUNCTION));
    }

    public List<DiscoveredAttribute> getConstructorOmited() {
        return this.filteredAttributes().filter(Predicates.compose(Predicates.equalTo(-1), ToConstructorArgumentOrder.FUNCTION)).toList();
    }

    public List<DiscoveredAttribute> getExcludableAttributes() {
        ArrayList<DiscoveredAttribute> excludables = Lists.newArrayList();
        for (DiscoveredAttribute attribute : this.filteredAttributes()) {
            if (!attribute.isGenerateAbstract() || !attribute.isContainerType() || attribute.isArrayType()) continue;
            excludables.add(attribute);
        }
        return excludables;
    }

    public List<DiscoveredAttribute> mandatoryAttributes() {
        ArrayList<DiscoveredAttribute> mandatory = Lists.newArrayList();
        for (DiscoveredAttribute attribute : this.getSettableAttributes()) {
            if (!attribute.isMandatory()) continue;
            mandatory.add(attribute);
        }
        return mandatory;
    }

    public List<DiscoveredAttribute> getLazyAttributes() {
        ArrayList<DiscoveredAttribute> lazyAttributes = Lists.newArrayList();
        for (DiscoveredAttribute attribute : this.filteredAttributes()) {
            if (!attribute.isGenerateLazy()) continue;
            lazyAttributes.add(attribute);
        }
        return lazyAttributes;
    }

    public List<DiscoveredAttribute> getAllAccessibleAttributes() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.getImplementedAttributes())).addAll(this.getLazyAttributes())).build();
    }

    private FluentIterable<DiscoveredAttribute> filteredAttributes() {
        return FluentIterable.from(this.attributes());
    }

    public List<DiscoveredAttribute> getMarshaledAttributes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DiscoveredAttribute attribute : this.getImplementedAttributes()) {
            if (attribute.isJsonIgnore()) continue;
            builder.add(attribute);
        }
        return builder.build();
    }

    public List<DiscoveredAttribute> getUnmarshaledAttributes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DiscoveredAttribute attribute : this.getSettableAttributes()) {
            if (attribute.isJsonIgnore()) continue;
            builder.add(attribute);
        }
        return builder.build();
    }

    public List<DiscoveredAttribute> getPrimitiveDefaultAttributes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DiscoveredAttribute attribute : this.getSettableAttributes()) {
            if (!attribute.isPrimitive() || !attribute.isGenerateDefault()) continue;
            builder.add(attribute);
        }
        return builder.build();
    }

    public List<DiscoveredAttribute> getImplementedAttributes() {
        if (this.implementedAttributes == null) {
            this.implementedAttributes = this.filteredAttributes().filter(Predicates.or(Arrays.asList(DiscoveredAttributes.isGenerateAbstract(), DiscoveredAttributes.isGenerateDefault(), DiscoveredAttributes.isGenerateDerived()))).toList();
        }
        return this.implementedAttributes;
    }

    public List<DiscoveredAttribute> getEquivalenceAttributes() {
        return FluentIterable.from(this.getImplementedAttributes()).filter(NonAuxiliary.PREDICATE).toList();
    }

    public List<DiscoveredAttribute> getHelperAttributes() {
        return this.filteredAttributes().filter(Predicates.or(DiscoveredAttributes.isGenerateFunction(), DiscoveredAttributes.isGeneratePredicate())).toList();
    }

    public boolean hasSingleParameterConstructor() {
        return this.isUseConstructor() && this.getConstructorArguments().size() == 1;
    }

    @Override
    protected TypeMirror internalTypeMirror() {
        return this.internalTypeElement().asType();
    }

    public abstract TypeElement internalTypeElement();

    public abstract List<DiscoveredAttribute> attributes();

    public boolean isGenerateModifiable() {
        return true;
    }

    public boolean isHashCodeDefined() {
        return false;
    }

    public boolean isEqualToDefined() {
        return false;
    }

    public boolean isToStringDefined() {
        return false;
    }

    public boolean isUseBuilder() {
        return true;
    }

    private static enum ToConstructorArgumentOrder implements Function<DiscoveredAttribute, Integer>
    {
        FUNCTION;


        @Override
        public Integer apply(DiscoveredAttribute input) {
            return input.getConstructorArgumentOrder();
        }
    }

    private static enum NonAuxiliary implements Predicate<DiscoveredAttribute>
    {
        PREDICATE;


        @Override
        public boolean apply(DiscoveredAttribute input) {
            return !input.isAuxiliary();
        }
    }
}

