/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.element.TypeElement;
import org.immutables.value.internal.google.common.base.MoreObjects;
import org.immutables.value.internal.google.common.base.Preconditions;
import org.immutables.value.internal.google.common.collect.ImmutableList;
import org.immutables.value.internal.google.common.primitives.Booleans;
import org.immutables.value.internal.processor.meta.DiscoveredAttribute;
import org.immutables.value.internal.processor.meta.DiscoveredValue;

final class DiscoveredValues {
    private DiscoveredValues() {
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final String REQUIRED_ATTRIBUTE = "Cannot build DiscoveredType: required attribute '%s' is not set";
        @Nullable
        private String validationMethodName;
        @Nullable
        private TypeElement internalTypeElement;
        private ImmutableList.Builder<DiscoveredAttribute> attributesBuilder = ImmutableList.builder();
        private boolean isUseBuilder;
        private boolean isUseBuilderIsSet;
        private boolean isGenerateCompact;
        private boolean isGenerateCompactIsSet;
        private boolean isHashCodeDefined;
        private boolean isHashCodeDefinedIsSet;
        private boolean isEqualToDefined;
        private boolean isEqualToDefinedIsSet;
        private boolean isToStringDefined;
        private boolean isToStringDefinedIsSet;

        private Builder() {
        }

        public Builder copy(DiscoveredValue fromInstance) {
            Preconditions.checkNotNull(fromInstance);
            this.internalTypeElement(fromInstance.internalTypeElement());
            this.addAttributes(fromInstance.attributes());
            this.isUseBuilder(fromInstance.isUseBuilder());
            this.isGenerateCompact(fromInstance.isGenerateModifiable());
            this.isHashCodeDefined(fromInstance.isHashCodeDefined());
            this.isEqualToDefined(fromInstance.isEqualToDefined());
            this.isToStringDefined(fromInstance.isToStringDefined());
            return this;
        }

        public Builder validationMethodName(String validationMethodName) {
            this.validationMethodName = validationMethodName;
            return this;
        }

        public Builder internalTypeElement(TypeElement internalTypeElement) {
            this.internalTypeElement = Preconditions.checkNotNull(internalTypeElement);
            return this;
        }

        public Builder addAttributes(DiscoveredAttribute attributesElement) {
            this.attributesBuilder.add((Object)attributesElement);
            return this;
        }

        public Builder addAttributes(DiscoveredAttribute ... attributesElements) {
            for (DiscoveredAttribute it : attributesElements) {
                this.attributesBuilder.add((Object)it);
            }
            return this;
        }

        public Builder addAttributes(Iterable<? extends DiscoveredAttribute> attributesElements) {
            this.attributesBuilder.addAll(attributesElements);
            return this;
        }

        public Builder clearAttributes() {
            this.attributesBuilder = ImmutableList.builder();
            return this;
        }

        public Builder isUseBuilder(boolean isUseBuilder) {
            this.isUseBuilder = isUseBuilder;
            this.isUseBuilderIsSet = true;
            return this;
        }

        public Builder isGenerateCompact(boolean isGenerateCompact) {
            this.isGenerateCompact = isGenerateCompact;
            this.isGenerateCompactIsSet = true;
            return this;
        }

        public Builder isHashCodeDefined(boolean isHashCodeDefined) {
            this.isHashCodeDefined = isHashCodeDefined;
            this.isHashCodeDefinedIsSet = true;
            return this;
        }

        public Builder isEqualToDefined(boolean isEqualToDefined) {
            this.isEqualToDefined = isEqualToDefined;
            this.isEqualToDefinedIsSet = true;
            return this;
        }

        public Builder isToStringDefined(boolean isToStringDefined) {
            this.isToStringDefined = isToStringDefined;
            this.isToStringDefinedIsSet = true;
            return this;
        }

        public DiscoveredValue build() {
            Preconditions.checkState(this.internalTypeElement != null, REQUIRED_ATTRIBUTE, "internalTypeElement");
            DiscoveredValueSubclass type = new DiscoveredValueSubclass(this);
            type.setValidationMethodName(this.validationMethodName);
            return type;
        }
    }

    @Immutable
    private static final class DiscoveredValueSubclass
    extends DiscoveredValue {
        private final TypeElement internalTypeElement;
        private final List<DiscoveredAttribute> attributes;
        private final boolean isUseBuilder;
        private final boolean isGenerateCompact;
        private final boolean isHashCodeDefined;
        private final boolean isEqualToDefined;
        private final boolean isToStringDefined;

        DiscoveredValueSubclass(Builder builder) {
            this.internalTypeElement = Preconditions.checkNotNull(builder.internalTypeElement);
            this.attributes = builder.attributesBuilder.build();
            this.isUseBuilder = builder.isUseBuilderIsSet ? builder.isUseBuilder : super.isUseBuilder();
            this.isGenerateCompact = builder.isGenerateCompactIsSet ? builder.isGenerateCompact : super.isGenerateModifiable();
            this.isHashCodeDefined = builder.isHashCodeDefinedIsSet ? builder.isHashCodeDefined : super.isHashCodeDefined();
            this.isEqualToDefined = builder.isEqualToDefinedIsSet ? builder.isEqualToDefined : super.isEqualToDefined();
            this.isToStringDefined = builder.isToStringDefinedIsSet ? builder.isToStringDefined : super.isToStringDefined();
        }

        @Override
        public TypeElement internalTypeElement() {
            return this.internalTypeElement;
        }

        @Override
        public List<DiscoveredAttribute> attributes() {
            return this.attributes;
        }

        @Override
        public boolean isUseBuilder() {
            return this.isUseBuilder;
        }

        @Override
        public boolean isGenerateModifiable() {
            return this.isGenerateCompact;
        }

        @Override
        public boolean isHashCodeDefined() {
            return this.isHashCodeDefined;
        }

        @Override
        public boolean isEqualToDefined() {
            return this.isEqualToDefined;
        }

        @Override
        public boolean isToStringDefined() {
            return this.isToStringDefined;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof DiscoveredValueSubclass && this.equalTo((DiscoveredValueSubclass)another);
        }

        private boolean equalTo(DiscoveredValueSubclass another) {
            return this.internalTypeElement.equals(another.internalTypeElement) && this.attributes.equals(another.attributes) && this.isUseBuilder == another.isUseBuilder && this.isGenerateCompact == another.isGenerateCompact && this.isHashCodeDefined == another.isHashCodeDefined && this.isEqualToDefined == another.isEqualToDefined && this.isToStringDefined == another.isToStringDefined;
        }

        public int hashCode() {
            int h = 31;
            h = h * 17 + this.internalTypeElement.hashCode();
            h = h * 17 + this.attributes.hashCode();
            h = h * 17 + Booleans.hashCode(this.isUseBuilder);
            h = h * 17 + Booleans.hashCode(this.isGenerateCompact);
            h = h * 17 + Booleans.hashCode(this.isHashCodeDefined);
            h = h * 17 + Booleans.hashCode(this.isEqualToDefined);
            h = h * 17 + Booleans.hashCode(this.isToStringDefined);
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper("DiscoveredType").add("internalTypeElement", this.internalTypeElement).add("attributes", this.attributes).add("isUseBuilder", this.isUseBuilder).add("isGenerateCompact", this.isGenerateCompact).add("isHashCodeDefined", this.isHashCodeDefined).add("isEqualToDefined", this.isEqualToDefined).add("isToStringDefined", this.isToStringDefined).toString();
        }
    }
}

