/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.immutables.value.Value;
import org.immutables.value.internal.generator.SourceOrdering;
import org.immutables.value.internal.google.common.collect.ImmutableList;
import org.immutables.value.internal.google.common.collect.Lists;
import org.immutables.value.internal.google.common.collect.Sets;
import org.immutables.value.internal.processor.meta.DiscoveredAttribute;
import org.immutables.value.internal.processor.meta.DiscoveredAttributes;
import org.immutables.value.internal.processor.meta.DiscoveredValue;
import org.immutables.value.internal.processor.meta.DiscoveredValues;
import org.immutables.value.internal.processor.meta.SegmentedName;

public class Discovery {
    private static final String ORDINAL_VALUE_TYPE = "org.immutables.common.collect.OrdinalValue";
    private static final String EQUALS_METHOD = "equals";
    private static final String TO_STRING_METHOD = "toString";
    private static final String HASH_CODE_METHOD = "hashCode";
    private final Set<TypeElement> annotations;
    private final RoundEnvironment round;
    private final ProcessingEnvironment processing;

    public Discovery(ProcessingEnvironment processing, RoundEnvironment round, Set<TypeElement> annotations) {
        this.processing = processing;
        this.round = round;
        this.annotations = annotations;
    }

    public List<DiscoveredValue> discover() {
        LinkedHashSet<Element> allElemenents = Sets.newLinkedHashSet();
        for (TypeElement annotationType : this.annotations) {
            allElemenents.addAll(this.round.getElementsAnnotatedWith(annotationType));
        }
        return this.checkForANumberOfAttributes(this.discoverValueTypes(allElemenents));
    }

    private List<DiscoveredValue> discoverValueTypes(Set<Element> allElemenents) {
        ArrayList<DiscoveredValue> generateTypes = Lists.newArrayListWithExpectedSize(allElemenents.size());
        for (Element typeElement : allElemenents) {
            TypeElement type;
            if (!(typeElement instanceof TypeElement) || (type = (TypeElement)typeElement).getEnclosingElement().getAnnotation(Value.Nested.class) != null) continue;
            this.collectDiscoveredTypeDescriptors(generateTypes, type);
        }
        return generateTypes;
    }

    private List<DiscoveredValue> checkForANumberOfAttributes(List<DiscoveredValue> generateTypes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DiscoveredValue discoveredValue : generateTypes) {
            if (!discoveredValue.isEmptyNesting() && discoveredValue.getImplementedAttributes().size() > 124) {
                this.processing.getMessager().printMessage(Diagnostic.Kind.ERROR, "Value objects with more than 124 attributes (including inherited) are not supported. Please decompose your object into a smaller ones", discoveredValue.internalTypeElement());
                continue;
            }
            builder.add(discoveredValue);
        }
        return builder.build();
    }

    private void collectDiscoveredTypeDescriptors(List<DiscoveredValue> generateTypes, TypeElement type) {
        List<DiscoveredValue> nestedChildren;
        Value.Immutable genImmutable = type.getAnnotation(Value.Immutable.class);
        Value.Nested genNested = type.getAnnotation(Value.Nested.class);
        if (genImmutable != null) {
            DiscoveredValue generateType = this.inspectDiscoveredType(type, genImmutable);
            if (genNested != null) {
                generateType.setNestedChildren(this.extractNestedChildren(type));
            }
            generateTypes.add(generateType);
        } else if (genNested != null && !(nestedChildren = this.extractNestedChildren(type)).isEmpty()) {
            DiscoveredValue emptyNestingType = DiscoveredValues.builder().internalTypeElement(type).isUseBuilder(false).isGenerateCompact(false).build();
            emptyNestingType.setEmptyNesting(true);
            emptyNestingType.setSegmentedName(SegmentedName.from(type.getQualifiedName()));
            emptyNestingType.setNestedChildren(nestedChildren);
            generateTypes.add(emptyNestingType);
        }
    }

    private List<DiscoveredValue> extractNestedChildren(TypeElement parent) {
        ImmutableList.Builder children = ImmutableList.builder();
        for (Element element : parent.getEnclosedElements()) {
            switch (element.getKind()) {
                case INTERFACE: 
                case CLASS: {
                    Value.Immutable annotation = element.getAnnotation(Value.Immutable.class);
                    if (annotation == null) break;
                    children.add(this.inspectDiscoveredType((TypeElement)element, annotation));
                    break;
                }
            }
        }
        return children.build();
    }

    private boolean isDiscoveredType(TypeElement type, Value.Immutable annotation) {
        boolean isStaticOrTopLevel = type.getKind() == ElementKind.INTERFACE || type.getKind() == ElementKind.ANNOTATION_TYPE || type.getKind() == ElementKind.CLASS && (type.getEnclosingElement().getKind() == ElementKind.PACKAGE || type.getModifiers().contains((Object)Modifier.STATIC));
        return annotation != null && isStaticOrTopLevel && this.isNonFinal(type);
    }

    private boolean isNonFinal(TypeElement type) {
        return !type.getModifiers().contains((Object)Modifier.FINAL);
    }

    DiscoveredValue inspectDiscoveredType(TypeElement type, Value.Immutable annotation) {
        if (!this.isDiscoveredType(type, annotation)) {
            this.error(type, "Type '%s' annotated with @%s must be non-final class, interface or annotation type", type.getSimpleName(), Value.Immutable.class.getSimpleName());
        }
        SegmentedName segmentedName = SegmentedName.from(this.processing, type);
        boolean useBuilder = annotation.builder();
        DiscoveredValues.Builder typeBuilder = DiscoveredValues.builder().internalTypeElement(type).isUseBuilder(useBuilder).isGenerateCompact(false);
        this.collectGeneratedCandidateMethods(type, typeBuilder);
        DiscoveredValue generateType = typeBuilder.build();
        generateType.setSegmentedName(segmentedName);
        return generateType;
    }

    private void collectGeneratedCandidateMethods(TypeElement type, DiscoveredValues.Builder typeBuilder) {
        for (Element element : this.getAccessorsInSourceOrder(type)) {
            if (!this.isElegibleAccessorMethod(element)) continue;
            this.processGenerationCandidateMethod(typeBuilder, (ExecutableElement)element);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(type.getEnclosedElements())) {
            switch (executableElement.getSimpleName().toString()) {
                case "equals": 
                case "hashCode": 
                case "toString": {
                    this.processGenerationCandidateMethod(typeBuilder, executableElement);
                }
            }
        }
    }

    private List<? extends Element> getAccessorsInSourceOrder(TypeElement type) {
        return type.getKind() == ElementKind.ANNOTATION_TYPE ? SourceOrdering.getEnclosedElements(type) : SourceOrdering.getAllAccessors(this.processing.getElementUtils(), type);
    }

    private boolean isElegibleAccessorMethod(Element element) {
        if (element.getKind() != ElementKind.METHOD) {
            return false;
        }
        if (element.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        switch (element.getSimpleName().toString()) {
            case "hashCode": 
            case "toString": {
                return false;
            }
        }
        String definitionType = element.getEnclosingElement().toString();
        if (definitionType.equals(Object.class.getName())) {
            return false;
        }
        return !definitionType.startsWith(ORDINAL_VALUE_TYPE);
    }

    private void processGenerationCandidateMethod(DiscoveredValues.Builder type, ExecutableElement attributeMethodCandidate) {
        Name name = attributeMethodCandidate.getSimpleName();
        List<? extends VariableElement> parameters = attributeMethodCandidate.getParameters();
        if (name.contentEquals(EQUALS_METHOD) && parameters.size() == 1 && parameters.get(0).asType().toString().equals(Object.class.getName()) && !attributeMethodCandidate.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            type.isEqualToDefined(true);
            return;
        }
        if (name.contentEquals(HASH_CODE_METHOD) && parameters.isEmpty() && !attributeMethodCandidate.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            type.isHashCodeDefined(true);
            return;
        }
        if (name.contentEquals(TO_STRING_METHOD) && parameters.isEmpty() && !attributeMethodCandidate.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            type.isToStringDefined(true);
            return;
        }
        Value.Check validateAnnotation = attributeMethodCandidate.getAnnotation(Value.Check.class);
        if (validateAnnotation != null) {
            if (!(attributeMethodCandidate.getReturnType().getKind() != TypeKind.VOID || !attributeMethodCandidate.getParameters().isEmpty() || attributeMethodCandidate.getModifiers().contains((Object)Modifier.PRIVATE) || attributeMethodCandidate.getModifiers().contains((Object)Modifier.ABSTRACT) || attributeMethodCandidate.getModifiers().contains((Object)Modifier.STATIC) || attributeMethodCandidate.getModifiers().contains((Object)Modifier.NATIVE))) {
                type.validationMethodName(attributeMethodCandidate.getSimpleName().toString());
            } else {
                this.error(attributeMethodCandidate, "Method '%s' annotated with @%s must be non-private parameter-less method and have void return type.", attributeMethodCandidate.getSimpleName(), Value.Check.class.getSimpleName());
            }
        }
        if (Discovery.isDiscoveredAttribute(attributeMethodCandidate)) {
            TypeMirror returnType = attributeMethodCandidate.getReturnType();
            DiscoveredAttributes.Builder attributeBuilder = DiscoveredAttributes.builder();
            if (Discovery.isAbstract(attributeMethodCandidate)) {
                attributeBuilder.isGenerateAbstract(true);
                if (attributeMethodCandidate.getDefaultValue() != null) {
                    attributeBuilder.isGenerateDefault(true);
                }
            } else if (Discovery.hasAnnotation(attributeMethodCandidate, Value.Default.class)) {
                attributeBuilder.isGenerateDefault(true);
            } else if (Discovery.hasAnnotation(attributeMethodCandidate, Value.Derived.class)) {
                attributeBuilder.isGenerateDerived(true);
            }
            if (Discovery.hasAnnotation(attributeMethodCandidate, Value.Lazy.class)) {
                if (Discovery.isAbstract(attributeMethodCandidate) || Discovery.isFinal(attributeMethodCandidate)) {
                    this.error(attributeMethodCandidate, "Method '%s' annotated with @%s must be non abstract and non-final", attributeMethodCandidate.getSimpleName(), Value.Lazy.class.getSimpleName());
                } else {
                    attributeBuilder.isGenerateLazy(true);
                }
            }
            attributeBuilder.internalName(name.toString());
            attributeBuilder.internalTypeName(returnType.toString());
            attributeBuilder.internalTypeMirror(returnType);
            DiscoveredAttribute generateAttribute = attributeBuilder.build();
            generateAttribute.setAttributeElement(attributeMethodCandidate);
            type.addAttributes(generateAttribute);
        }
    }

    private static boolean isAbstract(Element element) {
        return element.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    private static boolean isFinal(Element element) {
        return element.getModifiers().contains((Object)Modifier.FINAL);
    }

    private static boolean isDiscoveredAttribute(ExecutableElement attributeMethodCandidate) {
        return attributeMethodCandidate.getParameters().isEmpty() && attributeMethodCandidate.getReturnType().getKind() != TypeKind.VOID && (Discovery.isAbstract(attributeMethodCandidate) || Discovery.hasGenerateAnnotation(attributeMethodCandidate));
    }

    private static boolean hasGenerateAnnotation(ExecutableElement attributeMethodCandidate) {
        return Discovery.hasAnnotation(attributeMethodCandidate, Value.Default.class) || Discovery.hasAnnotation(attributeMethodCandidate, Value.Derived.class) || Discovery.hasAnnotation(attributeMethodCandidate, Value.Lazy.class);
    }

    private static boolean hasAnnotation(Element element, Class<? extends Annotation> annotationType) {
        return element.getAnnotation(annotationType) != null;
    }

    private void error(Element type, String message, Object ... parameters) {
        this.processing.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(message, parameters), type);
    }
}

