/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.util.LinkedList;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.immutables.value.internal.google.common.base.Joiner;
import org.immutables.value.internal.google.common.base.Preconditions;
import org.immutables.value.internal.google.common.base.Strings;
import org.immutables.value.internal.google.common.collect.Lists;

final class SegmentedName {
    private static final Joiner JOINER = Joiner.on('.').skipNulls();
    final String packageName;
    final String enclosingClassName;
    final String simpleName;
    final String referenceClassName;
    final String fullyQualifedName;

    private SegmentedName(String packageName, String enclosingClassName, String simpleName) {
        this.packageName = Preconditions.checkNotNull(packageName);
        this.enclosingClassName = Preconditions.checkNotNull(enclosingClassName);
        this.simpleName = Preconditions.checkNotNull(simpleName);
        this.referenceClassName = enclosingClassName.isEmpty() ? simpleName : JOINER.join(Strings.emptyToNull(enclosingClassName), Strings.emptyToNull(simpleName), new Object[0]);
        this.fullyQualifedName = JOINER.join(Strings.emptyToNull(packageName), Strings.emptyToNull(enclosingClassName), Strings.emptyToNull(simpleName));
    }

    public String[] toArray() {
        return new String[]{this.packageName, this.enclosingClassName, this.simpleName};
    }

    public String toString() {
        return String.format("[%s].[%s].[%s]", this.packageName, this.enclosingClassName, this.simpleName);
    }

    public static SegmentedName of(String packageName, String enclosingClassName, String simpleName) {
        return new SegmentedName(packageName, enclosingClassName, simpleName);
    }

    public static SegmentedName from(ProcessingEnvironment environment, TypeElement type) {
        PackageElement packageElement = environment.getElementUtils().getPackageOf(type);
        String packageName = packageElement.getQualifiedName().toString();
        String simpleName = type.getSimpleName().toString();
        LinkedList<String> enclosingTypes = Lists.newLinkedList();
        Element e = type;
        while ((e = e.getEnclosingElement()).getKind() != ElementKind.PACKAGE) {
            enclosingTypes.addFirst(e.getSimpleName().toString());
        }
        return SegmentedName.of(packageName, JOINER.join(enclosingTypes), simpleName);
    }

    public static SegmentedName from(CharSequence name) {
        Preconditions.checkArgument(name.length() > 1);
        int lastDotAfterPackageIndex = -1;
        int startOfSimpleName = -1;
        for (int i = name.length() - 1; i >= 0; --i) {
            char prevChar;
            char c = prevChar = i == 0 ? (char)'\u0000' : name.charAt(i - 1);
            if (prevChar != '.' && prevChar != '\u0000') continue;
            char c2 = name.charAt(i);
            if (Character.isUpperCase(c2)) {
                lastDotAfterPackageIndex = i - 1;
                if (startOfSimpleName < 0) {
                    startOfSimpleName = i;
                }
            }
            if (Character.isLowerCase(c2)) break;
        }
        if (startOfSimpleName < 0 && lastDotAfterPackageIndex < 0) {
            lastDotAfterPackageIndex = name.length();
        }
        String packageName = name.subSequence(0, Math.max(0, lastDotAfterPackageIndex)).toString();
        String simpleName = startOfSimpleName < 0 ? "" : name.subSequence(startOfSimpleName, name.length()).toString();
        String enclosingName = name.subSequence(Math.max(0, Math.min(lastDotAfterPackageIndex + 1, startOfSimpleName - 1)), Math.max(0, startOfSimpleName - 1)).toString();
        return SegmentedName.of(packageName, enclosingName, simpleName);
    }
}

