/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.internal.google.common.base.Function;
import org.immutables.value.internal.google.common.base.Predicate;
import org.immutables.value.internal.google.common.base.Predicates;
import org.immutables.value.internal.google.common.collect.FluentIterable;
import org.immutables.value.internal.google.common.collect.ImmutableList;
import org.immutables.value.internal.google.common.collect.ImmutableSet;
import org.immutables.value.internal.google.common.collect.Iterables;
import org.immutables.value.internal.google.common.collect.Lists;
import org.immutables.value.internal.google.common.collect.Sets;

public abstract class TypeIntrospectionBase {
    protected static final Predicate<CharSequence> UNDEFINABLE_PATTERN = Predicates.containsPattern("\\.Undefinable$");
    protected static final String ORDINAL_VALUE_INTERFACE_TYPE = "org.immutables.common.collect.OrdinalValue";
    private volatile boolean introspected;
    protected ImmutableList<String> extendedClassesNames;
    protected ImmutableSet<String> implementedInterfacesNames;

    protected abstract TypeMirror internalTypeMirror();

    protected void ensureTypeIntrospected() {
        if (!this.introspected) {
            this.introspectType();
            this.introspected = true;
        }
    }

    public ImmutableList<String> getExtendedClassesNames() {
        this.ensureTypeIntrospected();
        return this.extendedClassesNames;
    }

    public ImmutableSet<String> getImplementedInterfacesNames() {
        this.ensureTypeIntrospected();
        return this.implementedInterfacesNames;
    }

    public boolean isComparable() {
        this.ensureTypeIntrospected();
        return this.implementedInterfacesNames.contains(Comparable.class.getName());
    }

    public boolean isOrdinalValue() {
        this.ensureTypeIntrospected();
        return this.implementedInterfacesNames.contains(ORDINAL_VALUE_INTERFACE_TYPE);
    }

    public boolean isEnumType() {
        this.ensureTypeIntrospected();
        return this.extendedClassesNames.contains(Enum.class.getName());
    }

    public boolean isUndefinable() {
        this.ensureTypeIntrospected();
        return FluentIterable.from(this.implementedInterfacesNames).anyMatch(UNDEFINABLE_PATTERN);
    }

    public String getDirectSupertype() {
        this.ensureTypeIntrospected();
        return Iterables.getFirst(this.extendedClassesNames, null);
    }

    protected void introspectType() {
        ArrayList<TypeMirror> extendedClasses = Lists.newArrayList();
        LinkedHashSet<TypeMirror> implementedInterfaces = Sets.newLinkedHashSet();
        TypeMirror typeMirror = this.internalTypeMirror();
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            this.collectHierarchyMirrors(typeMirror, extendedClasses, implementedInterfaces);
        }
        this.extendedClassesNames = FluentIterable.from(extendedClasses).filter(DeclaredType.class).transform(ToNameOfTypeElement.FUNCTION).toList();
        this.implementedInterfacesNames = FluentIterable.from(implementedInterfaces).filter(DeclaredType.class).transform(ToNameOfTypeElement.FUNCTION).toSet();
    }

    private void collectHierarchyMirrors(TypeMirror topClass, List<TypeMirror> extendedClasses, Set<TypeMirror> implementedInterfaces) {
        if (topClass.getKind() != TypeKind.DECLARED || topClass.toString().equals(Object.class.getName())) {
            return;
        }
        this.collectInterfacesMirrors(topClass, implementedInterfaces);
        TypeElement e = this.toTypeElement(topClass);
        TypeMirror superClass = e.getSuperclass();
        extendedClasses.add(superClass);
        this.collectHierarchyMirrors(superClass, extendedClasses, implementedInterfaces);
        for (TypeMirror typeMirror : e.getInterfaces()) {
            this.collectInterfacesMirrors(typeMirror, implementedInterfaces);
        }
    }

    private void collectInterfacesMirrors(TypeMirror topClass, Set<TypeMirror> implementedInterfaces) {
        TypeElement e = this.toTypeElement(topClass);
        if (e.getKind().isInterface()) {
            implementedInterfaces.add(topClass);
            for (TypeMirror typeMirror : e.getInterfaces()) {
                this.collectInterfacesMirrors(typeMirror, implementedInterfaces);
            }
        }
    }

    private TypeElement toTypeElement(TypeMirror input) {
        return ToDeclaredTypeElement.FUNCTION.apply(input);
    }

    private static enum ToNameOfTypeElement implements Function<TypeMirror, String>
    {
        FUNCTION;


        @Override
        public String apply(TypeMirror input) {
            return ToDeclaredTypeElement.FUNCTION.apply(input).getQualifiedName().toString();
        }
    }

    private static enum ToDeclaredTypeElement implements Function<TypeMirror, TypeElement>
    {
        FUNCTION;


        @Override
        public TypeElement apply(TypeMirror input) {
            return (TypeElement)((DeclaredType)input).asElement();
        }
    }
}

