/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.generator;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import javax.lang.model.util.Types;
import org.immutables.value.internal.generator.StringLiterals;
import org.immutables.value.internal.google.common.collect.ImmutableCollection;
import org.immutables.value.internal.google.common.collect.ImmutableList;

public final class AnnotationMirrors {
    private AnnotationMirrors() {
    }

    public static CharSequence toCharSequence(AnnotationMirror value) {
        PrintVisitor printer = new PrintVisitor();
        printer.visitAnnotation(value, null);
        return printer.builder;
    }

    public static CharSequence toCharSequence(AnnotationValue value) {
        PrintVisitor printer = new PrintVisitor();
        printer.visitValue(value);
        return printer.builder;
    }

    public static ImmutableList<TypeMirror> getTypesFromMirrors(String annotationQualifiedName, String annotationAttributeName, List<? extends AnnotationMirror> annotationMirrors) {
        ImmutableList.Builder<TypeMirror> builder = ImmutableList.builder();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(annotationQualifiedName)) continue;
            AnnotationMirrors.collectTypesFromAnnotationAttribute(annotationAttributeName, builder, annotationMirror);
        }
        return builder.build();
    }

    public static ImmutableList<TypeMirror> getTypesFromMirrors(Types types, TypeMirror annotationType, String annotationAttributeName, List<? extends AnnotationMirror> annotationMirrors) {
        ImmutableList.Builder<TypeMirror> builder = ImmutableList.builder();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!types.isSameType(annotationMirror.getAnnotationType(), annotationType)) continue;
            AnnotationMirrors.collectTypesFromAnnotationAttribute(annotationAttributeName, builder, annotationMirror);
        }
        return builder.build();
    }

    private static void collectTypesFromAnnotationAttribute(String annotationValueName, final ImmutableCollection.Builder<TypeMirror> builder, AnnotationMirror annotationMirror) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
            if (!e.getKey().getSimpleName().contentEquals(annotationValueName)) continue;
            e.getValue().accept(new SimpleAnnotationValueVisitor7<Void, Void>(){

                @Override
                public Void visitArray(List<? extends AnnotationValue> vals, Void p) {
                    for (AnnotationValue annotationValue : vals) {
                        annotationValue.accept(this, p);
                    }
                    return null;
                }

                @Override
                public Void visitType(TypeMirror t, Void p) {
                    builder.add(t);
                    return null;
                }
            }, null);
        }
    }

    @Nullable
    public static AnnotationMirror findAnnotation(List<? extends AnnotationMirror> annotationMirrors, Class<? extends Annotation> annotationType) {
        String annotationTypeName = annotationType.getCanonicalName();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().contentEquals(annotationTypeName)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean isAnnotationPresent(List<? extends AnnotationMirror> annotationMirrors, Class<? extends Annotation> annotationType) {
        return AnnotationMirrors.findAnnotation(annotationMirrors, annotationType) != null;
    }

    private static final class PrintVisitor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        final StringBuilder builder = new StringBuilder();

        private PrintVisitor() {
        }

        void visitValue(AnnotationValue value) {
            value.accept(this, null);
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            this.builder.append(o);
            return null;
        }

        @Override
        public Void visitString(String s, Void p) {
            this.builder.append(StringLiterals.toLiteral(s));
            return null;
        }

        @Override
        public Void visitType(TypeMirror t, Void p) {
            this.builder.append(t).append(".class");
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> vals, Void p) {
            this.builder.append('{');
            boolean notFirst = false;
            for (AnnotationValue annotationValue : vals) {
                if (notFirst) {
                    this.builder.append(',');
                }
                notFirst = true;
                this.visitValue(annotationValue);
            }
            this.builder.append('}');
            return null;
        }

        @Override
        public Void visitEnumConstant(VariableElement c, Void p) {
            this.builder.append(c.getEnclosingElement()).append('.').append(c.getSimpleName());
            return null;
        }

        @Override
        public Void visitAnnotation(AnnotationMirror a, Void p) {
            String annotationString = a.toString();
            int startOfParameters = annotationString.indexOf(40);
            if (startOfParameters > 0) {
                annotationString = annotationString.substring(0, startOfParameters);
            }
            this.builder.append(annotationString);
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = a.getElementValues();
            if (!values.isEmpty()) {
                this.builder.append('(');
                boolean notFirst = false;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : values.entrySet()) {
                    if (notFirst) {
                        this.builder.append(',');
                    }
                    notFirst = true;
                    this.builder.append(e.getKey().getSimpleName()).append(" = ");
                    this.visitValue(e.getValue());
                }
                this.builder.append(')');
            }
            return null;
        }
    }
}

