/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.immutables.value.internal.google.common.base.CharMatcher;
import org.immutables.value.internal.google.common.base.Joiner;
import org.immutables.value.internal.google.common.base.Splitter;
import org.immutables.value.internal.google.common.collect.Lists;
import org.immutables.value.internal.google.common.collect.Sets;
import org.immutables.value.internal.google.common.reflect.Reflection;

@Deprecated
final class LegacyJavaPostprocessing {
    private static final String JAVA_LANG = "java.lang";
    private static final String JAVA_LANG_PREFIX = "java.lang.";
    private static final char DONT_IMPORT_ESCAPE = '`';
    private static final Pattern FULLY_QUALIFIED_PATTERN = Pattern.compile("(\\W)(([a-z0-9_]+\\.)*)([A-Z][A-Za-z0-9_]+)");
    private static final Pattern PACKAGE_DECLARATION = Pattern.compile("package ([a-z0-9_\\.]+)");
    private static final CharMatcher DONT_IMPORT_MATCHER = CharMatcher.is('`');
    private static final Joiner LINE_JOINER = Joiner.on('\n');
    private static final Splitter LINE_SPLITTER = Splitter.on('\n');

    LegacyJavaPostprocessing() {
    }

    static CharSequence rewrite(CharSequence content) {
        HashMap<String, String> takenImports = new HashMap<String, String>();
        ArrayList<String> modifiedLines = Lists.newArrayList();
        TreeSet<String> importStatements = Sets.newTreeSet();
        String packageName = null;
        int indexOfGenImportsPlaceholder = -1;
        int indexOfPackageLine = -1;
        for (String l : LINE_SPLITTER.split(content)) {
            if (packageName == null && l.startsWith("package ")) {
                packageName = LegacyJavaPostprocessing.extractPackageName(l);
                indexOfPackageLine = modifiedLines.size();
                modifiedLines.add(l);
                continue;
            }
            if (l.startsWith("// Generated imports")) {
                indexOfGenImportsPlaceholder = modifiedLines.size();
                continue;
            }
            if (l.startsWith("import ")) {
                if (indexOfGenImportsPlaceholder < 0) {
                    indexOfGenImportsPlaceholder = modifiedLines.size();
                }
                modifiedLines.add(l);
                continue;
            }
            if (DONT_IMPORT_MATCHER.matchesAnyOf(l)) {
                modifiedLines.add(DONT_IMPORT_MATCHER.removeFrom(l));
                continue;
            }
            Matcher matcher = FULLY_QUALIFIED_PATTERN.matcher(l);
            StringBuilder modifiedLine = new StringBuilder();
            int offset = 0;
            while (matcher.find()) {
                int start = matcher.start();
                modifiedLine.append(l.substring(offset, start));
                String group = matcher.group();
                modifiedLine.append(group.charAt(0));
                String importClass = group.substring(1);
                String simpleName = matcher.group(4);
                if (importClass.length() == simpleName.length()) {
                    takenImports.put(simpleName, importClass);
                    modifiedLine.append(simpleName);
                } else {
                    boolean shouldImportNoConflict;
                    String className = (String)takenImports.get(simpleName);
                    boolean bl = shouldImportNoConflict = className == null || className.equals(importClass);
                    if (!shouldImportNoConflict) {
                        shouldImportNoConflict = JAVA_LANG_PREFIX.concat(className).equals(importClass);
                    }
                    if (shouldImportNoConflict) {
                        boolean noImportNeeded;
                        boolean bl2 = noImportNeeded = Reflection.getPackageName(importClass).equals(JAVA_LANG) || LegacyJavaPostprocessing.samePackage(packageName, simpleName, importClass);
                        if (!noImportNeeded) {
                            importStatements.add("import " + importClass + ";");
                        }
                        takenImports.put(simpleName, importClass);
                        modifiedLine.append(simpleName);
                    } else {
                        modifiedLine.append(importClass);
                    }
                }
                offset = matcher.end();
            }
            modifiedLine.append(l.substring(offset, l.length()));
            modifiedLines.add(modifiedLine.toString());
        }
        if (indexOfGenImportsPlaceholder < 0) {
            indexOfGenImportsPlaceholder = indexOfPackageLine + 1;
        }
        modifiedLines.addAll(indexOfGenImportsPlaceholder, importStatements);
        return LINE_JOINER.join(modifiedLines);
    }

    private static boolean samePackage(String packageName, String simpleName, String importClass) {
        String fullyQualifiedName = packageName == null ? simpleName : packageName + '.' + simpleName;
        return fullyQualifiedName.equals(importClass);
    }

    private static String extractPackageName(String l) {
        return PACKAGE_DECLARATION.matcher(l).replaceAll("$1");
    }
}

