/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.generator;

import java.util.ArrayList;
import java.util.TreeSet;
import org.immutables.value.internal.google.common.base.Function;
import org.immutables.value.internal.google.common.base.Joiner;
import org.immutables.value.internal.google.common.base.Optional;
import org.immutables.value.internal.google.common.collect.Iterables;
import org.immutables.value.internal.google.common.collect.Lists;
import org.immutables.value.internal.google.common.collect.Sets;

final class PostprocessingMachine {
    private static final Joiner JOINER = Joiner.on("");

    private PostprocessingMachine() {
    }

    static CharSequence rewrite(CharSequence content) {
        String currentPackage = "";
        ImportsBuilder importsBuilder = new ImportsBuilder();
        ArrayList<String> parts = Lists.newArrayList();
        parts.add("");
        parts.add("");
        State state = State.UNDEFINED;
        int packageFrom = -1;
        int importFrom = -1;
        int nextPartFrom = 0;
        FiniteStateMachine machine = new FiniteStateMachine();
        FullyQualifiedNameMachine fullyQualifiedNameMachine = new FullyQualifiedNameMachine();
        CommentMachine commentMachine = new CommentMachine();
        block6: for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            switch (state) {
                case UNDEFINED: {
                    state = machine.nextChar(c).or(state);
                    if (PostprocessingMachine.isAlphabetic(c)) continue block6;
                    nextPartFrom = i + 1;
                    continue block6;
                }
                case PACKAGE: {
                    if (c == ' ') {
                        packageFrom = i + 1;
                    }
                    if (c != ';') continue block6;
                    currentPackage = content.subSequence(packageFrom, i).toString();
                    importsBuilder.setCurrentPackage(currentPackage);
                    state = State.UNDEFINED;
                    packageFrom = -1;
                    continue block6;
                }
                case IMPORTS: {
                    if (c == ' ') {
                        importFrom = i + 1;
                    }
                    if (c != ';') continue block6;
                    importsBuilder.addImport(content.subSequence(importFrom, i).toString());
                    state = State.UNDEFINED;
                    importFrom = -1;
                    continue block6;
                }
                case CLASS: {
                    commentMachine.nextChar(c);
                    if (commentMachine.isInComment()) continue block6;
                    fullyQualifiedNameMachine.nextChar(c, i);
                    if (!fullyQualifiedNameMachine.isFinished()) continue block6;
                    importsBuilder.addImport(content.subSequence(fullyQualifiedNameMachine.importFrom, fullyQualifiedNameMachine.importTo).toString());
                    parts.add(content.subSequence(nextPartFrom, fullyQualifiedNameMachine.importFrom).toString());
                    nextPartFrom = fullyQualifiedNameMachine.packageTo;
                }
            }
        }
        parts.add(content.subSequence(nextPartFrom, content.length()).toString());
        if (!currentPackage.isEmpty()) {
            parts.set(0, "package " + currentPackage + ";\n");
        }
        parts.set(1, importsBuilder.build());
        return JOINER.join(parts);
    }

    private static boolean isSpaceChar(char c) {
        return Character.isSpaceChar(c) || c == '\n' || c == '\t' || c == '\r';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isAlphabetic(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isLowerCaseAlphabetic(char c) {
        return c >= 'a' && c <= 'z';
    }

    private static boolean isUpperCaseAlphabetic(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static void main(String[] args) {
    }

    static enum CommentState {
        NOT_IN_COMMENT,
        COMMENT_CANDIDATE,
        LINE_COMMENT,
        BLOCK_COMMENT,
        BLOCK_COMMENT_OUT_CANDIDATE;

    }

    static final class CommentMachine {
        CommentState state = CommentState.NOT_IN_COMMENT;

        CommentMachine() {
        }

        void nextChar(char c) {
            switch (this.state) {
                case NOT_IN_COMMENT: {
                    if (c != '/') break;
                    this.state = CommentState.COMMENT_CANDIDATE;
                    break;
                }
                case COMMENT_CANDIDATE: {
                    if (c == '/') {
                        this.state = CommentState.LINE_COMMENT;
                        break;
                    }
                    if (c != '*') break;
                    this.state = CommentState.BLOCK_COMMENT;
                    break;
                }
                case LINE_COMMENT: {
                    if (c != '\n') break;
                    this.state = CommentState.NOT_IN_COMMENT;
                    break;
                }
                case BLOCK_COMMENT: {
                    if (c != '*') break;
                    this.state = CommentState.BLOCK_COMMENT_OUT_CANDIDATE;
                    break;
                }
                case BLOCK_COMMENT_OUT_CANDIDATE: {
                    this.state = c == '/' ? CommentState.NOT_IN_COMMENT : CommentState.BLOCK_COMMENT;
                }
            }
        }

        boolean isInComment() {
            return CommentState.LINE_COMMENT.equals((Object)this.state) || CommentState.BLOCK_COMMENT.equals((Object)this.state) || CommentState.BLOCK_COMMENT_OUT_CANDIDATE.equals((Object)this.state);
        }
    }

    static enum FullyQualifiedNameState {
        UNDEFINED,
        PACKAGE_PART_CANDIDATE,
        SPACE_BEFORE_DOT,
        DOT,
        CLASS,
        AFTER_CLASS,
        METHOD_OR_FIELD,
        FINISH;

    }

    static final class FullyQualifiedNameMachine {
        FullyQualifiedNameState state = FullyQualifiedNameState.UNDEFINED;
        int importFrom = -1;
        int importTo = -1;
        int packageTo = -1;

        FullyQualifiedNameMachine() {
        }

        void nextChar(char c, int i) {
            switch (this.state) {
                case UNDEFINED: {
                    if (!PostprocessingMachine.isAlphabetic(c)) break;
                    this.state = FullyQualifiedNameState.PACKAGE_PART_CANDIDATE;
                    this.importFrom = i;
                    break;
                }
                case PACKAGE_PART_CANDIDATE: {
                    if (c == '.') {
                        this.state = FullyQualifiedNameState.DOT;
                        break;
                    }
                    if (PostprocessingMachine.isSpaceChar(c)) {
                        this.state = FullyQualifiedNameState.SPACE_BEFORE_DOT;
                        break;
                    }
                    if (PostprocessingMachine.isAlphabetic(c) || PostprocessingMachine.isDigit(c)) break;
                    this.state = FullyQualifiedNameState.UNDEFINED;
                    break;
                }
                case SPACE_BEFORE_DOT: {
                    if (c == '.') {
                        this.state = FullyQualifiedNameState.DOT;
                        break;
                    }
                    if (PostprocessingMachine.isAlphabetic(c)) {
                        this.state = FullyQualifiedNameState.PACKAGE_PART_CANDIDATE;
                        this.importFrom = i;
                        break;
                    }
                    if (PostprocessingMachine.isSpaceChar(c)) break;
                    this.state = FullyQualifiedNameState.UNDEFINED;
                    break;
                }
                case DOT: {
                    if (PostprocessingMachine.isLowerCaseAlphabetic(c)) {
                        this.state = FullyQualifiedNameState.PACKAGE_PART_CANDIDATE;
                        break;
                    }
                    if (PostprocessingMachine.isUpperCaseAlphabetic(c)) {
                        this.state = FullyQualifiedNameState.CLASS;
                        break;
                    }
                    if (PostprocessingMachine.isSpaceChar(c)) break;
                    this.state = FullyQualifiedNameState.UNDEFINED;
                    break;
                }
                case CLASS: {
                    if (this.packageTo == -1) {
                        this.packageTo = i - 1;
                    }
                    if (PostprocessingMachine.isAlphabetic(c) || PostprocessingMachine.isDigit(c)) break;
                    this.state = FullyQualifiedNameState.AFTER_CLASS;
                    break;
                }
                case AFTER_CLASS: {
                    if (this.importTo == -1) {
                        this.importTo = i - 1;
                    }
                    if (PostprocessingMachine.isAlphabetic(c)) {
                        this.state = FullyQualifiedNameState.METHOD_OR_FIELD;
                        break;
                    }
                    if (c == '(' || c == '<' || c == ')' || c == '>' || c == '{' || c == '}') {
                        this.state = FullyQualifiedNameState.FINISH;
                        break;
                    }
                    if (PostprocessingMachine.isSpaceChar(c)) break;
                    this.state = FullyQualifiedNameState.UNDEFINED;
                    break;
                }
                case METHOD_OR_FIELD: {
                    if (PostprocessingMachine.isAlphabetic(c) || PostprocessingMachine.isDigit(c)) break;
                    this.state = FullyQualifiedNameState.FINISH;
                    break;
                }
                case FINISH: {
                    this.reset();
                }
            }
        }

        boolean isFinished() {
            return FullyQualifiedNameState.FINISH.equals((Object)this.state);
        }

        void reset() {
            this.state = FullyQualifiedNameState.UNDEFINED;
            this.importFrom = -1;
            this.importTo = -1;
            this.packageTo = 1;
        }
    }

    private static enum ToImportStatement implements Function<String, String>
    {
        FUNCTION;


        @Override
        public String apply(String input) {
            return "import " + input + ";\n";
        }
    }

    static final class ImportsBuilder {
        private static final String JAVA_LANG = "java.lang";
        private TreeSet<String> imports = Sets.newTreeSet();
        private Optional<String> currentPackage = Optional.absent();

        ImportsBuilder() {
        }

        void addImport(String importedPackage) {
            String normalized = this.normalize(importedPackage);
            if (normalized.startsWith(JAVA_LANG)) {
                return;
            }
            if (this.currentPackage.isPresent() && normalized.startsWith(this.currentPackage.get())) {
                return;
            }
            this.imports.add(normalized);
        }

        void setCurrentPackage(String currentPackage) {
            this.currentPackage = Optional.of(currentPackage);
        }

        private String normalize(String s) {
            return s.replace(" ", "").replace("\n", "").replace("\t", "").replace("\r", "");
        }

        String build() {
            return JOINER.join(Iterables.transform(this.imports, ToImportStatement.FUNCTION));
        }
    }

    static final class FiniteStateMachine {
        private static final char[][] vocabulary = new char[][]{{'p', 'a', 'c', 'k', 'a', 'g', 'e'}, {'i', 'm', 'p', 'o', 'r', 't'}, {'c', 'l', 'a', 's', 's'}};
        private static final State[] finalState = new State[]{State.PACKAGE, State.IMPORTS, State.CLASS};
        int wordIndex = -1;
        int charIndex = -1;

        FiniteStateMachine() {
        }

        Optional<State> nextChar(char c) {
            Optional<State> state = Optional.absent();
            if (this.wordIndex == -2) {
                if (!PostprocessingMachine.isAlphabetic(c) && !PostprocessingMachine.isDigit(c)) {
                    this.wordIndex = -1;
                }
            } else if (this.wordIndex == -1) {
                for (int i = 0; i < vocabulary.length; ++i) {
                    if (c != vocabulary[i][0]) continue;
                    this.wordIndex = i;
                    this.charIndex = 0;
                    break;
                }
                if (this.wordIndex == -1 && (PostprocessingMachine.isAlphabetic(c) || PostprocessingMachine.isDigit(c))) {
                    this.wordIndex = -2;
                }
            } else if (vocabulary[this.wordIndex][this.charIndex + 1] == c) {
                ++this.charIndex;
                if (vocabulary[this.wordIndex].length == this.charIndex + 1) {
                    state = Optional.of(finalState[this.wordIndex]);
                    this.wordIndex = -1;
                    this.charIndex = -1;
                }
            } else {
                this.wordIndex = -1;
                this.charIndex = -1;
            }
            return state;
        }
    }

    static enum State {
        UNDEFINED,
        PACKAGE,
        IMPORTS,
        CLASS;

    }
}

