/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.generator;

import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import org.immutables.value.internal.google.common.base.Preconditions;
import org.immutables.value.internal.google.common.base.Supplier;
import org.immutables.value.internal.google.common.collect.ClassToInstanceMap;
import org.immutables.value.internal.google.common.collect.ImmutableSet;
import org.immutables.value.internal.google.common.collect.MutableClassToInstanceMap;

final class StaticEnvironment {
    private static final ThreadLocal<EnvironmentState> state = new ThreadLocal<EnvironmentState>(){

        @Override
        protected EnvironmentState initialValue() {
            return new EnvironmentState();
        }
    };

    private StaticEnvironment() {
    }

    private static EnvironmentState state() {
        EnvironmentState s = state.get();
        Preconditions.checkState(s.initialized, "Static environment should be initialized");
        return s;
    }

    static <T extends Completable> T getInstance(Class<T> type, Supplier<T> supplier) {
        ClassToInstanceMap components = StaticEnvironment.state().components;
        Completable instance = (Completable)components.getInstance(type);
        if (instance == null) {
            instance = (Completable)supplier.get();
            components.putInstance(type, instance);
        }
        return (T)instance;
    }

    static ProcessingEnvironment processing() {
        return StaticEnvironment.state().processing;
    }

    static RoundEnvironment round() {
        return StaticEnvironment.state().round;
    }

    static Set<TypeElement> annotations() {
        return StaticEnvironment.state().annotations;
    }

    static void shutdown() throws Exception {
        StaticEnvironment.state().shutdown();
    }

    static void init(Set<? extends TypeElement> annotations, RoundEnvironment round, ProcessingEnvironment processing) {
        state.get().init(annotations, round, processing);
    }

    static interface Completable {
        public void complete();
    }

    private static class EnvironmentState {
        private ClassToInstanceMap<Completable> components;
        private ProcessingEnvironment processing;
        private RoundEnvironment round;
        private Set<TypeElement> annotations;
        private boolean initialized;

        private EnvironmentState() {
        }

        void shutdown() {
            for (Completable component : this.components.values()) {
                component.complete();
            }
            this.components = null;
            this.processing = null;
            this.round = null;
            this.annotations = null;
            this.initialized = false;
            state.remove();
        }

        void init(Set<? extends TypeElement> annotations, RoundEnvironment round, ProcessingEnvironment processing) {
            this.components = MutableClassToInstanceMap.create();
            this.processing = processing;
            this.round = round;
            this.annotations = ImmutableSet.copyOf(annotations);
            this.initialized = true;
        }
    }
}

