/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.generator;

import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.internal.google.common.base.Function;
import org.immutables.value.internal.google.common.collect.FluentIterable;
import org.immutables.value.internal.google.common.collect.ImmutableList;
import org.immutables.value.internal.google.common.collect.ImmutableSet;
import org.immutables.value.internal.google.common.collect.Lists;
import org.immutables.value.internal.google.common.collect.Sets;

@NotThreadSafe
public final class TypeHierarchyCollector {
    private final List<TypeMirror> extendedClasses = Lists.newArrayList();
    private final Set<TypeMirror> implementedInterfaces = Sets.newLinkedHashSet();

    public void collectFrom(TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            this.collectHierarchyMirrors(typeMirror, this.extendedClasses, this.implementedInterfaces);
        }
    }

    public ImmutableList<TypeMirror> extendedClasses() {
        return ImmutableList.copyOf(this.extendedClasses);
    }

    public ImmutableSet<TypeMirror> implementedInterfaces() {
        return ImmutableSet.copyOf(this.implementedInterfaces);
    }

    public ImmutableList<String> extendedClassNames() {
        return FluentIterable.from(this.extendedClasses).filter(DeclaredType.class).transform(ToNameOfTypeElement.FUNCTION).toList();
    }

    public ImmutableSet<String> implementedInterfaceNames() {
        return FluentIterable.from(this.implementedInterfaces).filter(DeclaredType.class).transform(ToNameOfTypeElement.FUNCTION).toSet();
    }

    private void collectHierarchyMirrors(TypeMirror topClass, List<TypeMirror> extendedClasses, Set<TypeMirror> implementedInterfaces) {
        if (topClass.getKind() != TypeKind.DECLARED || topClass.toString().equals(Object.class.getName())) {
            return;
        }
        this.collectInterfacesMirrors(topClass, implementedInterfaces);
        TypeElement e = this.toTypeElement(topClass);
        TypeMirror superClass = e.getSuperclass();
        extendedClasses.add(superClass);
        this.collectHierarchyMirrors(superClass, extendedClasses, implementedInterfaces);
        for (TypeMirror typeMirror : e.getInterfaces()) {
            this.collectInterfacesMirrors(typeMirror, implementedInterfaces);
        }
    }

    private void collectInterfacesMirrors(TypeMirror topClass, Set<TypeMirror> implementedInterfaces) {
        TypeElement e = this.toTypeElement(topClass);
        if (e.getKind().isInterface()) {
            implementedInterfaces.add(topClass);
            for (TypeMirror typeMirror : e.getInterfaces()) {
                this.collectInterfacesMirrors(typeMirror, implementedInterfaces);
            }
        }
    }

    private TypeElement toTypeElement(TypeMirror input) {
        return ToDeclaredTypeElement.FUNCTION.apply(input);
    }

    private static enum ToNameOfTypeElement implements Function<TypeMirror, String>
    {
        FUNCTION;


        @Override
        public String apply(TypeMirror input) {
            return ToDeclaredTypeElement.FUNCTION.apply(input).getQualifiedName().toString();
        }
    }

    private static enum ToDeclaredTypeElement implements Function<TypeMirror, TypeElement>
    {
        FUNCTION;


        @Override
        public TypeElement apply(TypeMirror input) {
            return (TypeElement)((DeclaredType)input).asElement();
        }
    }
}

