/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.internal.google.common.base.Optional;

public abstract class AnnotationReflect<A extends AnnotationReflect<A>> {
    public final AnnotationTypeReflect<A> type;
    public final AnnotationMirror mirror;

    protected AnnotationReflect(AnnotationTypeReflect<A> type, AnnotationMirror mirror) {
        this.type = type;
        this.mirror = mirror;
    }

    public static abstract class AnnotationTypeReflect<A extends AnnotationReflect<A>> {
        public final String canonicalName;

        protected AnnotationTypeReflect(String canonicalName) {
            this.canonicalName = canonicalName;
        }

        protected abstract A create(AnnotationMirror var1);

        public Optional<A> find(Iterable<? extends AnnotationMirror> mirrors) {
            for (AnnotationMirror annotationMirror : mirrors) {
                TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
                if (!element.getQualifiedName().contentEquals(this.canonicalName)) continue;
                return Optional.of(this.create(annotationMirror));
            }
            return Optional.absent();
        }
    }

    public class BooleanAttribute
    extends ReflectAttribute {
        public final boolean value;

        protected BooleanAttribute(String name) {
            super(name);
            this.value = this.initValue();
        }

        private boolean initValue() {
            this.findAnnotationValue().accept(new SimpleAnnotationValueVisitor7<Boolean, Void>(Boolean.valueOf(false)){

                @Override
                public Boolean visitBoolean(boolean b, Void p) {
                    return b;
                }
            }, null);
            return false;
        }
    }

    public class StringAttribute
    extends ReflectAttribute {
        public final String value;

        protected StringAttribute(String name) {
            super(name);
            this.value = this.initValue();
        }

        private String initValue() {
            return String.valueOf(this.findAnnotationValue().getValue());
        }

        public String toString() {
            return this.value;
        }
    }

    public class ReflectAttribute {
        final String name;

        public ReflectAttribute(String name) {
            this.name = name;
        }

        AnnotationValue findAnnotationValue() {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : AnnotationReflect.this.mirror.getElementValues().entrySet()) {
                if (!e.getKey().getSimpleName().contentEquals(this.name)) continue;
                return e.getValue();
            }
            throw new AssertionError((Object)"Annotation reflect attribute is not compatible with actual annotation");
        }
    }
}

