/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.immutables.value.internal.google.common.base.MoreObjects;
import org.immutables.value.internal.google.common.collect.ImmutableMap;
import org.immutables.value.internal.processor.meta.UnshadeGuava;

enum AttributeTypeKind {
    REGULAR("", new String[0]),
    ARRAY("", new String[0]),
    LIST("List", List.class.getName()),
    SET("Set", Set.class.getName()),
    ENUM_SET("Set", new String[0]),
    SORTED_SET("SortedSet", SortedSet.class.getName(), NavigableSet.class.getName()),
    MAP("Map", Map.class.getName()),
    ENUM_MAP("Map", new String[0]),
    SORTED_MAP("SortedMap", SortedMap.class.getName(), NavigableMap.class.getName()),
    MULTIMAP("Multimap", UnshadeGuava.typeString("collect.Multimap")),
    LIST_MULTIMAP("ListMultimap", UnshadeGuava.typeString("collect.ListMultimap")),
    SET_MULTIMAP("SetMultimap", UnshadeGuava.typeString("collect.SetMultimap")),
    MULTISET("Multiset", UnshadeGuava.typeString("collect.Multiset")),
    OPTIONAL_JDK("Optional", "java.util.Optional"),
    OPTIONAL_GUAVA("Optional", UnshadeGuava.typeString("base.Optional"));

    private final String[] rawTypes;
    private final String rawSimpleName;
    private static final ImmutableMap<String, AttributeTypeKind> rawTypeMapping;

    private AttributeTypeKind(String rawSimpleName, String ... rawTypes) {
        this.rawSimpleName = rawSimpleName;
        this.rawTypes = rawTypes;
    }

    public String rawSimpleName() {
        return this.rawSimpleName;
    }

    static AttributeTypeKind forRawType(String rawType) {
        return MoreObjects.firstNonNull(rawTypeMapping.get(rawType), REGULAR);
    }

    AttributeTypeKind withHasEnumFirstTypeParameter(boolean isEnum) {
        if (isEnum) {
            switch (this) {
                case SET: {
                    return ENUM_SET;
                }
                case MAP: {
                    return ENUM_MAP;
                }
            }
        }
        return this;
    }

    public boolean isSortedKind() {
        switch (this) {
            case SORTED_MAP: 
            case SORTED_SET: {
                return true;
            }
        }
        return false;
    }

    public boolean isSetKind() {
        switch (this) {
            case SET: 
            case SORTED_SET: 
            case ENUM_SET: {
                return true;
            }
        }
        return false;
    }

    public boolean isContainerKind() {
        switch (this) {
            case REGULAR: 
            case ARRAY: {
                return false;
            }
        }
        return true;
    }

    public boolean isCollectionKind() {
        switch (this) {
            case SET: 
            case SORTED_SET: 
            case ENUM_SET: 
            case LIST: 
            case MULTISET: {
                return true;
            }
        }
        return false;
    }

    public boolean isMappingKind() {
        switch (this) {
            case MAP: 
            case SORTED_MAP: 
            case ENUM_MAP: 
            case MULTIMAP: 
            case LIST_MULTIMAP: 
            case SET_MULTIMAP: {
                return true;
            }
        }
        return false;
    }

    public boolean isOptionalJdk() {
        return this == OPTIONAL_JDK;
    }

    public boolean isOptionalGuava() {
        return this == OPTIONAL_GUAVA;
    }

    public boolean isOptionalKind() {
        switch (this) {
            case OPTIONAL_GUAVA: 
            case OPTIONAL_JDK: {
                return true;
            }
        }
        return false;
    }

    public boolean isMultimapKind() {
        switch (this) {
            case MULTIMAP: 
            case LIST_MULTIMAP: 
            case SET_MULTIMAP: {
                return true;
            }
        }
        return false;
    }

    public boolean isSet() {
        return this == SET;
    }

    public boolean isEnumSet() {
        return this == ENUM_SET;
    }

    public boolean isSortedSet() {
        return this == SORTED_SET;
    }

    public boolean isList() {
        return this == LIST;
    }

    public boolean isMap() {
        return this == MAP;
    }

    public boolean isSortedMap() {
        return this == SORTED_MAP;
    }

    public boolean isArray() {
        return this == ARRAY;
    }

    public boolean isRegular() {
        return this == REGULAR;
    }

    public boolean isMultiset() {
        return this == MULTISET;
    }

    public boolean isMultimap() {
        return this == MULTIMAP;
    }

    public boolean isSetMultimap() {
        return this == SET_MULTIMAP;
    }

    public boolean isListMultimap() {
        return this == SET_MULTIMAP;
    }

    public boolean isEnumMap() {
        return this == ENUM_MAP;
    }

    static {
        ImmutableMap.Builder<String, AttributeTypeKind> builder = ImmutableMap.builder();
        for (AttributeTypeKind k : AttributeTypeKind.values()) {
            for (String r : k.rawTypes) {
                builder.put(r, k);
            }
        }
        rawTypeMapping = builder.build();
    }
}

