/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import org.immutables.value.internal.generator.Naming;
import org.immutables.value.internal.google.common.base.Joiner;
import org.immutables.value.internal.google.common.base.Strings;
import org.immutables.value.internal.google.common.base.Verify;
import org.immutables.value.internal.google.common.collect.Lists;
import org.immutables.value.internal.processor.meta.ImmutableConstitution;
import org.immutables.value.internal.processor.meta.Proto;
import org.immutables.value.internal.processor.meta.Styles;
import org.immutables.value.internal.processor.meta.Visibility;

public abstract class Constitution {
    private static final String NA_ERROR = "!error!";
    private static final String NEW_KEYWORD = "new";
    private static final Joiner JOINER = Joiner.on('.').skipNulls();

    public abstract Proto.Protoclass protoclass();

    public Visibility implementationVisibility() {
        return this.protoclass().visibility().forImplementation(this.protoclass().features().visibility());
    }

    public boolean isImplementationHidden() {
        return this.implementationVisibility().isMoreRestrictiveThan(this.protoclass().visibility());
    }

    public Styles.UsingName.TypeNames names() {
        return this.protoclass().createTypeNames();
    }

    public NameForms typeValue() {
        if (this.protoclass().kind().isValue()) {
            return this.isImplementationHidden() ? this.typeAbstract() : this.typeImmutable();
        }
        if (this.isFactory()) {
            ExecutableElement method = (ExecutableElement)this.protoclass().sourceElement();
            String type = method.getReturnType().toString();
            return ImmutableConstitution.NameForms.builder().simple(NA_ERROR).relative(type).packageOf(NA_ERROR).relativeAlreadyQualified(true).visibility(this.protoclass().visibility()).build();
        }
        return this.typeEnclosing();
    }

    public boolean hasImmutableInBuilder() {
        return this.implementationVisibility().isPrivate() && this.isTopLevelValue();
    }

    public boolean hasTopLevelBuilder() {
        return this.isFactory() || this.isTopLevelValue() && this.isOutsideBuilder();
    }

    private boolean isFactory() {
        return this.protoclass().kind().isFactory();
    }

    public boolean hasTopLevelImmutable() {
        return this.isTopLevelValue() && !this.hasImmutableInBuilder();
    }

    public boolean isOutsideBuilder() {
        return this.protoclass().features().builder() && this.implementationVisibility().isPrivate();
    }

    private boolean isTopLevelValue() {
        return this.protoclass().kind().isValue() && !this.protoclass().kind().isNested();
    }

    public boolean hasEnclosingNonvalue() {
        return this.protoclass().kind().isEnclosing() && !this.protoclass().kind().isValue();
    }

    public NameForms typeAbstract() {
        ArrayList<String> classSegments = Lists.newArrayListWithExpectedSize(2);
        Element e = this.collectClassSegments(classSegments);
        Verify.verify(e instanceof PackageElement);
        String packageOf = ((PackageElement)e).getQualifiedName().toString();
        String relative = JOINER.join(classSegments);
        boolean relativeAlreadyQualified = false;
        if (!this.protoclass().packageOf().name().equals(packageOf)) {
            relative = JOINER.join(packageOf, relative, new Object[0]);
            relativeAlreadyQualified = true;
        }
        return ImmutableConstitution.NameForms.builder().simple(this.names().typeAbstract).relative(relative).packageOf(packageOf).relativeAlreadyQualified(relativeAlreadyQualified).visibility(this.protoclass().visibility()).build();
    }

    private Element collectClassSegments(List<String> classSegments) {
        Element e = this.protoclass().sourceElement();
        while (e.getKind() != ElementKind.PACKAGE) {
            classSegments.add(e.getSimpleName().toString());
            e = e.getEnclosingElement();
        }
        Collections.reverse(classSegments);
        return e;
    }

    private String inPackage(String topLevel, String ... nested) {
        return JOINER.join(null, topLevel, nested);
    }

    public NameForms typeImmutable() {
        String relative;
        boolean nested = this.protoclass().kind().isNested();
        boolean inside = this.hasImmutableInBuilder();
        String simple = this.names().typeImmutable;
        if (nested) {
            String enclosingSimpleName = this.typeImmutableEnclosingSimpleName();
            simple = this.names().typeImmutableNested;
            relative = this.inPackage(enclosingSimpleName, simple);
        } else {
            relative = inside ? this.inPackage(this.typeBuilderSimpleName(), simple) : this.inPackage(simple, new String[0]);
        }
        return ImmutableConstitution.NameForms.builder().simple(simple).relative(relative).packageOf(this.protoclass().packageOf().name()).visibility(this.implementationVisibility()).build();
    }

    String typeImmutableEnclosingSimpleName() {
        String enclosingSimpleName = this.protoclass().enclosingOf().get().element().getSimpleName().toString();
        String enclosingRawName = this.names().rawFromAbstract(enclosingSimpleName);
        return this.names().namings.typeImmutableEnclosing.apply(enclosingRawName);
    }

    private String typeBuilderSimpleName() {
        Naming builderNaming = this.names().namings.typeBuilder;
        if (this.isImplementationHidden() || this.isFactory()) {
            builderNaming = builderNaming.requireNonConstant(Naming.Preference.SUFFIX);
        }
        return Naming.Usage.CAPITALIZED.apply(builderNaming.apply(this.names().raw));
    }

    public NameForms factoryBuilder() {
        NameForms nameForms = this.isImplementationHidden() ? this.typeBuilder() : this.typeImmutable();
        return nameForms.applied(this.names().builder);
    }

    public NameForms factoryOf() {
        if (this.isFactory()) {
            return ImmutableConstitution.NameForms.builder().simple(this.protoclass().declaringType().get().element().getSimpleName().toString()).relative(this.protoclass().declaringType().get().name()).relativeAlreadyQualified(true).packageOf(this.protoclass().packageOf().name()).visibility(this.protoclass().visibility().min(this.protoclass().declaringVisibility())).build().applied(this.protoclass().sourceElement().getSimpleName().toString());
        }
        return this.applyFactoryNaming(this.names().namings.of);
    }

    public NameForms factoryInstance() {
        return this.applyFactoryNaming(this.names().namings.instance);
    }

    public NameForms factoryCopyOf() {
        return this.applyFactoryNaming(this.names().namings.copyOf);
    }

    private NameForms applyFactoryNaming(Naming naming) {
        if (this.isImplementationHidden()) {
            naming = naming.requireNonConstant(Naming.Preference.PREFIX);
        }
        NameForms nameForms = this.isImplementationHidden() && this.protoclass().kind().isNested() ? this.typeEnclosing() : this.typeImmutable();
        String applyName = Naming.Usage.LOWERIZED.apply(naming.apply(this.names().raw));
        return nameForms.applied(applyName);
    }

    public NameForms typeEnclosing() {
        return ImmutableConstitution.NameForms.builder().simple(this.names().typeImmutableEnclosing).relative(this.names().typeImmutableEnclosing).packageOf(this.protoclass().packageOf().name()).visibility(this.protoclass().declaringVisibility()).build();
    }

    public NameForms typeBuilder() {
        Styles.UsingName.TypeNames names = this.names();
        boolean outside = this.isOutsideBuilder() || this.isFactory();
        boolean nested = this.protoclass().kind().isNested();
        String simple = this.typeBuilderSimpleName();
        String relative = outside && nested ? this.inPackage(this.inPackage(this.typeImmutableEnclosingSimpleName(), simple), new String[0]) : (outside ? this.inPackage(simple, new String[0]) : (nested ? this.inPackage(this.inPackage(this.typeImmutableEnclosingSimpleName(), names.typeImmutableNested, simple), new String[0]) : this.inPackage(this.inPackage(names.typeImmutable, simple), new String[0])));
        return ImmutableConstitution.NameForms.builder().simple(simple).relative(relative).packageOf(this.protoclass().packageOf().name()).visibility(this.protoclass().visibility().max(this.implementationVisibility())).build();
    }

    public static abstract class NameForms {
        public abstract String simple();

        public abstract String relative();

        public abstract String packageOf();

        public abstract Visibility visibility();

        public boolean relativeAlreadyQualified() {
            return false;
        }

        public String access() {
            switch (this.visibility()) {
                case PRIVATE: {
                    return "private ";
                }
                case PUBLIC: {
                    return "public ";
                }
            }
            return "";
        }

        public NameForms applied(String input) {
            return ImmutableConstitution.NameForms.builder().packageOf(this.packageOf()).simple(this.applyTo(this.simple(), input, false)).relative(this.applyTo(this.relative(), input, true)).visibility(this.visibility()).relativeAlreadyQualified(this.relativeAlreadyQualified()).build();
        }

        private String applyTo(String targetType, String input, boolean relative) {
            return Constitution.NEW_KEYWORD.equals(input) ? "new " + targetType : (relative ? targetType + '.' + input : input);
        }

        public String toString() {
            if (this.relativeAlreadyQualified()) {
                return this.relative();
            }
            return this.qualifyWithPackage(this.relative());
        }

        private String qualifyWithPackage(String reference) {
            return JOINER.join(Strings.emptyToNull(this.packageOf()), reference, new Object[0]);
        }
    }
}

