/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.internal.google.common.collect.Lists;
import org.immutables.value.internal.processor.meta.Proto;
import org.immutables.value.internal.processor.meta.Reporter;
import org.immutables.value.internal.processor.meta.Styles;
import org.immutables.value.internal.processor.meta.ValueAttribute;
import org.immutables.value.internal.processor.meta.ValueType;

final class FactoryMethodAttributesCollector {
    private final Proto.Protoclass protoclass;
    private final ValueType type;
    private final List<ValueAttribute> attributes = Lists.newArrayList();
    private final Styles styles;
    private final Reporter reporter;

    FactoryMethodAttributesCollector(Proto.Protoclass protoclass, ValueType type) {
        this.protoclass = protoclass;
        this.styles = protoclass.styles();
        this.type = type;
        this.reporter = protoclass.report();
    }

    void collect() {
        ExecutableElement element = (ExecutableElement)this.protoclass.sourceElement();
        List<? extends VariableElement> parameters = element.getParameters();
        for (VariableElement variableElement : parameters) {
            Name name = variableElement.getSimpleName();
            TypeMirror returnType = variableElement.asType();
            ValueAttribute attribute = new ValueAttribute();
            attribute.isGenerateAbstract = true;
            attribute.reporter = this.reporter;
            attribute.returnType = returnType;
            attribute.returnTypeName = returnType.toString();
            attribute.names = this.styles.forAccessor(name.toString());
            attribute.element = variableElement;
            attribute.containingType = this.type;
            this.attributes.add(attribute);
        }
        for (ValueAttribute valueAttribute : this.attributes) {
            valueAttribute.initAndValidate();
        }
        this.type.attributes.addAll(this.attributes);
    }
}

