/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.immutables.value.Value;
import org.immutables.value.internal.google.common.base.MoreObjects;
import org.immutables.value.internal.google.common.base.Optional;
import org.immutables.value.internal.google.common.base.Preconditions;
import org.immutables.value.internal.google.common.collect.Interner;
import org.immutables.value.internal.google.common.collect.Interners;
import org.immutables.value.internal.processor.meta.Proto;
import org.immutables.value.internal.processor.meta.Styles;
import org.immutables.value.internal.processor.meta.ValueType;
import org.immutables.value.internal.processor.meta.ValueTypeComposer;
import org.immutables.value.internal.processor.meta.Visibility;

@ParametersAreNonnullByDefault
public final class ImmutableProto {
    private ImmutableProto() {
    }

    @Immutable
    public static final class DeclaringPackage
    extends Proto.DeclaringPackage {
        private final PackageElement element;
        private final String name;
        private final boolean hasInclude;
        private final boolean isEnclosing;
        private final boolean isTopLevel;
        @Nullable
        private final Value.Immutable features;
        @Nullable
        private final Value.Style style;
        private final ProcessingEnvironment processing;
        private final int hashCode;
        @GuardedBy(value="this")
        private volatile long lazyInitBitmap;
        private static final long INCLUDED_TYPES_LAZY_INIT_BIT = 1L;
        @GuardedBy(value="this")
        private List<TypeElement> includedTypes;
        private static final long USE_IMMUTABLE_DEFAULTS_LAZY_INIT_BIT = 2L;
        @GuardedBy(value="this")
        private boolean useImmutableDefaults;
        private static final Interner<InternProxy> INTERNER = Interners.newStrongInterner();

        private DeclaringPackage(Builder builder) {
            this.element = builder.element;
            this.processing = builder.processing;
            this.name = Preconditions.checkNotNull(super.name());
            this.hasInclude = super.hasInclude();
            this.isEnclosing = super.isEnclosing();
            this.isTopLevel = super.isTopLevel();
            this.features = super.features();
            this.style = super.style();
            this.hashCode = this.computeHashCode();
        }

        private DeclaringPackage(DeclaringPackage original, PackageElement element, String name, boolean hasInclude, boolean isEnclosing, boolean isTopLevel, @Nullable Value.Immutable features, @Nullable Value.Style style, ProcessingEnvironment processing) {
            this.element = element;
            this.name = name;
            this.hasInclude = hasInclude;
            this.isEnclosing = isEnclosing;
            this.isTopLevel = isTopLevel;
            this.features = features;
            this.style = style;
            this.processing = processing;
            this.hashCode = this.computeHashCode();
        }

        public final DeclaringPackage withElement(PackageElement value) {
            if (this.element == value) {
                return this;
            }
            PackageElement newValue = Preconditions.checkNotNull(value);
            return DeclaringPackage.checkPreconditions(new DeclaringPackage(this, newValue, this.name, this.hasInclude, this.isEnclosing, this.isTopLevel, this.features, this.style, this.processing));
        }

        public final DeclaringPackage withProcessing(ProcessingEnvironment value) {
            if (this.processing == value) {
                return this;
            }
            ProcessingEnvironment newValue = Preconditions.checkNotNull(value);
            return DeclaringPackage.checkPreconditions(new DeclaringPackage(this, this.element, this.name, this.hasInclude, this.isEnclosing, this.isTopLevel, this.features, this.style, newValue));
        }

        @Override
        public PackageElement element() {
            return this.element;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public boolean hasInclude() {
            return this.hasInclude;
        }

        @Override
        public boolean isEnclosing() {
            return this.isEnclosing;
        }

        @Override
        public boolean isTopLevel() {
            return this.isTopLevel;
        }

        @Override
        @Nullable
        public Value.Immutable features() {
            return this.features;
        }

        @Override
        @Nullable
        public Value.Style style() {
            return this.style;
        }

        @Override
        public ProcessingEnvironment processing() {
            return this.processing;
        }

        public boolean equals(@Nullable Object another) {
            return this == another;
        }

        private boolean equalTo(DeclaringPackage another) {
            return this.name.equals(another.name);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.name.hashCode();
            return h;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return MoreObjects.toStringHelper("DeclaringPackage").omitNullValues().add("name", this.name).toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<TypeElement> includedTypes() {
            if ((this.lazyInitBitmap & 1L) == 0L) {
                DeclaringPackage declaringPackage = this;
                synchronized (declaringPackage) {
                    if ((this.lazyInitBitmap & 1L) == 0L) {
                        this.includedTypes = Preconditions.checkNotNull(super.includedTypes());
                        this.lazyInitBitmap |= 1L;
                    }
                }
            }
            return this.includedTypes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean useImmutableDefaults() {
            if ((this.lazyInitBitmap & 2L) == 0L) {
                DeclaringPackage declaringPackage = this;
                synchronized (declaringPackage) {
                    if ((this.lazyInitBitmap & 2L) == 0L) {
                        this.useImmutableDefaults = super.useImmutableDefaults();
                        this.lazyInitBitmap |= 2L;
                    }
                }
            }
            return this.useImmutableDefaults;
        }

        private static DeclaringPackage intern(DeclaringPackage instance) {
            return DeclaringPackage.INTERNER.intern((InternProxy)new InternProxy((DeclaringPackage)instance)).instance;
        }

        private static DeclaringPackage checkPreconditions(DeclaringPackage instance) {
            instance.validate();
            instance = DeclaringPackage.intern(instance);
            return instance;
        }

        public static DeclaringPackage copyOf(Proto.DeclaringPackage instance) {
            if (instance instanceof DeclaringPackage) {
                return (DeclaringPackage)instance;
            }
            Preconditions.checkNotNull(instance);
            return DeclaringPackage.builder().element(instance.element()).processing(instance.processing()).build();
        }

        @Deprecated
        public static DeclaringPackage copyOf(DeclaringPackage instance) {
            return Preconditions.checkNotNull(instance);
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INITIALIZED_BITSET_ALL_ = 3L;
            private static final long INITIALIZED_BIT_ELEMENT = 1L;
            private static final long INITIALIZED_BIT_PROCESSING = 2L;
            private long initializedBitset;
            @Nullable
            private PackageElement element;
            @Nullable
            private ProcessingEnvironment processing;

            private Builder() {
            }

            public final Builder element(PackageElement element) {
                this.element = Preconditions.checkNotNull(element);
                this.initializedBitset |= 1L;
                return this;
            }

            public final Builder processing(ProcessingEnvironment processing) {
                this.processing = Preconditions.checkNotNull(processing);
                this.initializedBitset |= 2L;
                return this;
            }

            public DeclaringPackage build() {
                this.checkRequiredAttributes();
                return DeclaringPackage.checkPreconditions(new DeclaringPackage(this));
            }

            private boolean elementIsSet() {
                return (this.initializedBitset & 1L) != 0L;
            }

            private boolean processingIsSet() {
                return (this.initializedBitset & 2L) != 0L;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset != 3L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
            }

            private String formatRequiredAttributesMessage() {
                return MoreObjects.toStringHelper("Cannot build DeclaringPackage, some of required attributes are not set ").omitNullValues().addValue(!this.elementIsSet() ? "element" : null).addValue(!this.processingIsSet() ? "processing" : null).toString();
            }

            public String toString() {
                return MoreObjects.toStringHelper("ImmutableProto.DeclaringPackage.Builder").omitNullValues().add("element", this.element).add("processing", this.processing).toString();
            }
        }

        private static class InternProxy {
            final DeclaringPackage instance;

            InternProxy(DeclaringPackage instance) {
                this.instance = instance;
            }

            public boolean equals(@Nullable Object another) {
                assert (another instanceof InternProxy);
                return this.instance.equalTo(((InternProxy)another).instance);
            }

            public int hashCode() {
                return this.instance.computeHashCode();
            }
        }
    }

    @Immutable
    public static final class DeclaringType
    extends Proto.DeclaringType {
        private final TypeElement element;
        private final String name;
        private final boolean isTopLevel;
        private final Optional<Proto.DeclaringType> enclosingOf;
        private final Proto.DeclaringPackage packageOf;
        private final boolean hasInclude;
        private final boolean isEnclosing;
        @Nullable
        private final Value.Immutable features;
        @Nullable
        private final Value.Style style;
        private final ProcessingEnvironment processing;
        private final int hashCode;
        @GuardedBy(value="this")
        private volatile long lazyInitBitmap;
        private static final long INCLUDED_TYPES_LAZY_INIT_BIT = 1L;
        @GuardedBy(value="this")
        private List<TypeElement> includedTypes;
        private static final long USE_IMMUTABLE_DEFAULTS_LAZY_INIT_BIT = 2L;
        @GuardedBy(value="this")
        private boolean useImmutableDefaults;
        private static final Interner<InternProxy> INTERNER = Interners.newStrongInterner();

        private DeclaringType(Builder builder) {
            this.element = builder.element;
            this.processing = builder.processing;
            this.name = Preconditions.checkNotNull(super.name());
            this.isTopLevel = super.isTopLevel();
            this.enclosingOf = Preconditions.checkNotNull(super.enclosingOf());
            this.packageOf = Preconditions.checkNotNull(super.packageOf());
            this.hasInclude = super.hasInclude();
            this.isEnclosing = super.isEnclosing();
            this.features = super.features();
            this.style = super.style();
            this.hashCode = this.computeHashCode();
        }

        private DeclaringType(DeclaringType original, TypeElement element, String name, boolean isTopLevel, Optional<Proto.DeclaringType> enclosingOf, Proto.DeclaringPackage packageOf, boolean hasInclude, boolean isEnclosing, @Nullable Value.Immutable features, @Nullable Value.Style style, ProcessingEnvironment processing) {
            this.element = element;
            this.name = name;
            this.isTopLevel = isTopLevel;
            this.enclosingOf = enclosingOf;
            this.packageOf = packageOf;
            this.hasInclude = hasInclude;
            this.isEnclosing = isEnclosing;
            this.features = features;
            this.style = style;
            this.processing = processing;
            this.hashCode = this.computeHashCode();
        }

        public final DeclaringType withElement(TypeElement value) {
            if (this.element == value) {
                return this;
            }
            TypeElement newValue = Preconditions.checkNotNull(value);
            return DeclaringType.checkPreconditions(new DeclaringType(this, newValue, this.name, this.isTopLevel, this.enclosingOf, this.packageOf, this.hasInclude, this.isEnclosing, this.features, this.style, this.processing));
        }

        public final DeclaringType withProcessing(ProcessingEnvironment value) {
            if (this.processing == value) {
                return this;
            }
            ProcessingEnvironment newValue = Preconditions.checkNotNull(value);
            return DeclaringType.checkPreconditions(new DeclaringType(this, this.element, this.name, this.isTopLevel, this.enclosingOf, this.packageOf, this.hasInclude, this.isEnclosing, this.features, this.style, newValue));
        }

        @Override
        public TypeElement element() {
            return this.element;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public boolean isTopLevel() {
            return this.isTopLevel;
        }

        @Override
        public Optional<Proto.DeclaringType> enclosingOf() {
            return this.enclosingOf;
        }

        @Override
        public Proto.DeclaringPackage packageOf() {
            return this.packageOf;
        }

        @Override
        public boolean hasInclude() {
            return this.hasInclude;
        }

        @Override
        public boolean isEnclosing() {
            return this.isEnclosing;
        }

        @Override
        @Nullable
        public Value.Immutable features() {
            return this.features;
        }

        @Override
        @Nullable
        public Value.Style style() {
            return this.style;
        }

        @Override
        public ProcessingEnvironment processing() {
            return this.processing;
        }

        public boolean equals(@Nullable Object another) {
            return this == another;
        }

        private boolean equalTo(DeclaringType another) {
            return this.name.equals(another.name);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.name.hashCode();
            return h;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return MoreObjects.toStringHelper("DeclaringType").omitNullValues().add("name", this.name).toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<TypeElement> includedTypes() {
            if ((this.lazyInitBitmap & 1L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 1L) == 0L) {
                        this.includedTypes = Preconditions.checkNotNull(super.includedTypes());
                        this.lazyInitBitmap |= 1L;
                    }
                }
            }
            return this.includedTypes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean useImmutableDefaults() {
            if ((this.lazyInitBitmap & 2L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 2L) == 0L) {
                        this.useImmutableDefaults = super.useImmutableDefaults();
                        this.lazyInitBitmap |= 2L;
                    }
                }
            }
            return this.useImmutableDefaults;
        }

        private static DeclaringType intern(DeclaringType instance) {
            return DeclaringType.INTERNER.intern((InternProxy)new InternProxy((DeclaringType)instance)).instance;
        }

        private static DeclaringType checkPreconditions(DeclaringType instance) {
            instance.validate();
            instance = DeclaringType.intern(instance);
            return instance;
        }

        public static DeclaringType copyOf(Proto.DeclaringType instance) {
            if (instance instanceof DeclaringType) {
                return (DeclaringType)instance;
            }
            Preconditions.checkNotNull(instance);
            return DeclaringType.builder().element(instance.element()).processing(instance.processing()).build();
        }

        @Deprecated
        public static DeclaringType copyOf(DeclaringType instance) {
            return Preconditions.checkNotNull(instance);
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INITIALIZED_BITSET_ALL_ = 3L;
            private static final long INITIALIZED_BIT_ELEMENT = 1L;
            private static final long INITIALIZED_BIT_PROCESSING = 2L;
            private long initializedBitset;
            @Nullable
            private TypeElement element;
            @Nullable
            private ProcessingEnvironment processing;

            private Builder() {
            }

            public final Builder element(TypeElement element) {
                this.element = Preconditions.checkNotNull(element);
                this.initializedBitset |= 1L;
                return this;
            }

            public final Builder processing(ProcessingEnvironment processing) {
                this.processing = Preconditions.checkNotNull(processing);
                this.initializedBitset |= 2L;
                return this;
            }

            public DeclaringType build() {
                this.checkRequiredAttributes();
                return DeclaringType.checkPreconditions(new DeclaringType(this));
            }

            private boolean elementIsSet() {
                return (this.initializedBitset & 1L) != 0L;
            }

            private boolean processingIsSet() {
                return (this.initializedBitset & 2L) != 0L;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset != 3L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
            }

            private String formatRequiredAttributesMessage() {
                return MoreObjects.toStringHelper("Cannot build DeclaringType, some of required attributes are not set ").omitNullValues().addValue(!this.elementIsSet() ? "element" : null).addValue(!this.processingIsSet() ? "processing" : null).toString();
            }

            public String toString() {
                return MoreObjects.toStringHelper("ImmutableProto.DeclaringType.Builder").omitNullValues().add("element", this.element).add("processing", this.processing).toString();
            }
        }

        private static class InternProxy {
            final DeclaringType instance;

            InternProxy(DeclaringType instance) {
                this.instance = instance;
            }

            public boolean equals(@Nullable Object another) {
                assert (another instanceof InternProxy);
                return this.instance.equalTo(((InternProxy)another).instance);
            }

            public int hashCode() {
                return this.instance.computeHashCode();
            }
        }
    }

    @Immutable
    public static final class MetaAnnotated
    extends Proto.MetaAnnotated {
        private final String name;
        private final Element element;
        @Nullable
        private final Value.Style style;
        private final int hashCode;
        private static final Interner<InternProxy> INTERNER = Interners.newStrongInterner();

        private MetaAnnotated(String name, Element element) {
            this.name = Preconditions.checkNotNull(name);
            this.element = Preconditions.checkNotNull(element);
            this.style = super.style();
            this.hashCode = this.computeHashCode();
        }

        private MetaAnnotated(MetaAnnotated original, String name, Element element, @Nullable Value.Style style) {
            this.name = name;
            this.element = element;
            this.style = style;
            this.hashCode = this.computeHashCode();
        }

        public final MetaAnnotated withName(String value) {
            if (this.name == value) {
                return this;
            }
            String newValue = Preconditions.checkNotNull(value);
            return MetaAnnotated.checkPreconditions(new MetaAnnotated(this, newValue, this.element, this.style));
        }

        public final MetaAnnotated withElement(Element value) {
            if (this.element == value) {
                return this;
            }
            Element newValue = Preconditions.checkNotNull(value);
            return MetaAnnotated.checkPreconditions(new MetaAnnotated(this, this.name, newValue, this.style));
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Element element() {
            return this.element;
        }

        @Override
        @Nullable
        public Value.Style style() {
            return this.style;
        }

        public boolean equals(@Nullable Object another) {
            return this == another;
        }

        private boolean equalTo(MetaAnnotated another) {
            return this.name.equals(another.name);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.name.hashCode();
            return h;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return MoreObjects.toStringHelper("MetaAnnotated").omitNullValues().add("name", this.name).toString();
        }

        private static MetaAnnotated intern(MetaAnnotated instance) {
            return MetaAnnotated.INTERNER.intern((InternProxy)new InternProxy((MetaAnnotated)instance)).instance;
        }

        public static MetaAnnotated of(String name, Element element) {
            return MetaAnnotated.checkPreconditions(new MetaAnnotated(name, element));
        }

        private static MetaAnnotated checkPreconditions(MetaAnnotated instance) {
            instance = MetaAnnotated.intern(instance);
            return instance;
        }

        public static MetaAnnotated copyOf(Proto.MetaAnnotated instance) {
            if (instance instanceof MetaAnnotated) {
                return (MetaAnnotated)instance;
            }
            return MetaAnnotated.of(instance.name(), instance.element());
        }

        @Deprecated
        public static MetaAnnotated copyOf(MetaAnnotated instance) {
            return Preconditions.checkNotNull(instance);
        }

        private static class InternProxy {
            final MetaAnnotated instance;

            InternProxy(MetaAnnotated instance) {
                this.instance = instance;
            }

            public boolean equals(@Nullable Object another) {
                assert (another instanceof InternProxy);
                return this.instance.equalTo(((InternProxy)another).instance);
            }

            public int hashCode() {
                return this.instance.computeHashCode();
            }
        }
    }

    @Immutable
    public static final class Protoclass
    extends Proto.Protoclass {
        private final Element sourceElement;
        private final Proto.DeclaringPackage packageOf;
        private final Optional<Proto.DeclaringType> declaringType;
        private final Proto.Protoclass.Kind kind;
        private final ValueTypeComposer composer;
        private final Visibility visibility;
        private final Element element;
        private final Optional<Proto.DeclaringType> enclosingOf;
        private final ProcessingEnvironment processing;
        @GuardedBy(value="this")
        private volatile long lazyInitBitmap;
        private static final long FEATURES_LAZY_INIT_BIT = 1L;
        @GuardedBy(value="this")
        private Value.Immutable features;
        private static final long STYLES_LAZY_INIT_BIT = 2L;
        @GuardedBy(value="this")
        private Styles styles;
        private static final long TYPE_LAZY_INIT_BIT = 4L;
        @GuardedBy(value="this")
        private ValueType type;
        private static final long SOURCE_QUALIFED_NAME_LAZY_INIT_BIT = 8L;
        @GuardedBy(value="this")
        private String sourceQualifedName;

        private Protoclass(Builder builder) {
            this.sourceElement = builder.sourceElement;
            this.packageOf = builder.packageOf;
            this.declaringType = builder.declaringType;
            this.kind = builder.kind;
            this.composer = builder.composer;
            this.processing = builder.processing;
            this.visibility = Preconditions.checkNotNull(super.visibility());
            this.element = Preconditions.checkNotNull(super.element());
            this.enclosingOf = Preconditions.checkNotNull(super.enclosingOf());
        }

        private Protoclass(Protoclass original, Element sourceElement, Proto.DeclaringPackage packageOf, Optional<Proto.DeclaringType> declaringType, Proto.Protoclass.Kind kind, ValueTypeComposer composer, Visibility visibility, Element element, Optional<Proto.DeclaringType> enclosingOf, ProcessingEnvironment processing) {
            this.sourceElement = sourceElement;
            this.packageOf = packageOf;
            this.declaringType = declaringType;
            this.kind = kind;
            this.composer = composer;
            this.visibility = visibility;
            this.element = element;
            this.enclosingOf = enclosingOf;
            this.processing = processing;
        }

        public final Protoclass withSourceElement(Element value) {
            if (this.sourceElement == value) {
                return this;
            }
            Element newValue = Preconditions.checkNotNull(value);
            return Protoclass.checkPreconditions(new Protoclass(this, newValue, this.packageOf, this.declaringType, this.kind, this.composer, this.visibility, this.element, this.enclosingOf, this.processing));
        }

        public final Protoclass withPackageOf(Proto.DeclaringPackage value) {
            if (this.packageOf == value) {
                return this;
            }
            Proto.DeclaringPackage newValue = Preconditions.checkNotNull(value);
            return Protoclass.checkPreconditions(new Protoclass(this, this.sourceElement, newValue, this.declaringType, this.kind, this.composer, this.visibility, this.element, this.enclosingOf, this.processing));
        }

        public final Protoclass withDeclaringType(Proto.DeclaringType value) {
            Optional<Proto.DeclaringType> newValue = Optional.of(value);
            return Protoclass.checkPreconditions(new Protoclass(this, this.sourceElement, this.packageOf, newValue, this.kind, this.composer, this.visibility, this.element, this.enclosingOf, this.processing));
        }

        public final Protoclass withDeclaringType(Optional<Proto.DeclaringType> optional) {
            if (this.declaringType == optional) {
                return this;
            }
            Optional<Proto.DeclaringType> newValue = Preconditions.checkNotNull(optional);
            return Protoclass.checkPreconditions(new Protoclass(this, this.sourceElement, this.packageOf, newValue, this.kind, this.composer, this.visibility, this.element, this.enclosingOf, this.processing));
        }

        public final Protoclass withKind(Proto.Protoclass.Kind value) {
            if (this.kind == value) {
                return this;
            }
            Proto.Protoclass.Kind newValue = Preconditions.checkNotNull(value);
            return Protoclass.checkPreconditions(new Protoclass(this, this.sourceElement, this.packageOf, this.declaringType, newValue, this.composer, this.visibility, this.element, this.enclosingOf, this.processing));
        }

        public final Protoclass withComposer(ValueTypeComposer value) {
            if (this.composer == value) {
                return this;
            }
            ValueTypeComposer newValue = Preconditions.checkNotNull(value);
            return Protoclass.checkPreconditions(new Protoclass(this, this.sourceElement, this.packageOf, this.declaringType, this.kind, newValue, this.visibility, this.element, this.enclosingOf, this.processing));
        }

        public final Protoclass withProcessing(ProcessingEnvironment value) {
            if (this.processing == value) {
                return this;
            }
            ProcessingEnvironment newValue = Preconditions.checkNotNull(value);
            return Protoclass.checkPreconditions(new Protoclass(this, this.sourceElement, this.packageOf, this.declaringType, this.kind, this.composer, this.visibility, this.element, this.enclosingOf, newValue));
        }

        @Override
        public Element sourceElement() {
            return this.sourceElement;
        }

        @Override
        public Proto.DeclaringPackage packageOf() {
            return this.packageOf;
        }

        @Override
        public Optional<Proto.DeclaringType> declaringType() {
            return this.declaringType;
        }

        @Override
        public Proto.Protoclass.Kind kind() {
            return this.kind;
        }

        @Override
        public ValueTypeComposer composer() {
            return this.composer;
        }

        @Override
        public Visibility visibility() {
            return this.visibility;
        }

        @Override
        public Element element() {
            return this.element;
        }

        @Override
        public Optional<Proto.DeclaringType> enclosingOf() {
            return this.enclosingOf;
        }

        @Override
        public ProcessingEnvironment processing() {
            return this.processing;
        }

        public boolean equals(@Nullable Object another) {
            return this == another || another instanceof Protoclass && this.equalTo((Protoclass)another);
        }

        private boolean equalTo(Protoclass another) {
            return this.sourceElement.equals(another.sourceElement) && this.packageOf.equals(another.packageOf) && this.declaringType.equals(another.declaringType) && this.kind.equals((Object)another.kind) && this.composer.equals(another.composer) && this.visibility.equals((Object)another.visibility) && this.element.equals(another.element) && this.enclosingOf.equals(another.enclosingOf);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.sourceElement.hashCode();
            h = h * 17 + this.packageOf.hashCode();
            h = h * 17 + this.declaringType.hashCode();
            h = h * 17 + this.kind.hashCode();
            h = h * 17 + this.composer.hashCode();
            h = h * 17 + this.visibility.hashCode();
            h = h * 17 + this.element.hashCode();
            h = h * 17 + this.enclosingOf.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper("Protoclass").omitNullValues().add("sourceElement", this.sourceElement).add("packageOf", this.packageOf).add("declaringType", this.declaringType.orNull()).add("kind", (Object)this.kind).add("composer", this.composer).add("visibility", (Object)this.visibility).add("element", this.element).add("enclosingOf", this.enclosingOf.orNull()).toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Value.Immutable features() {
            if ((this.lazyInitBitmap & 1L) == 0L) {
                Protoclass protoclass = this;
                synchronized (protoclass) {
                    if ((this.lazyInitBitmap & 1L) == 0L) {
                        this.features = super.features();
                        this.lazyInitBitmap |= 1L;
                    }
                }
            }
            return this.features;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Styles styles() {
            if ((this.lazyInitBitmap & 2L) == 0L) {
                Protoclass protoclass = this;
                synchronized (protoclass) {
                    if ((this.lazyInitBitmap & 2L) == 0L) {
                        this.styles = Preconditions.checkNotNull(super.styles());
                        this.lazyInitBitmap |= 2L;
                    }
                }
            }
            return this.styles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ValueType type() {
            if ((this.lazyInitBitmap & 4L) == 0L) {
                Protoclass protoclass = this;
                synchronized (protoclass) {
                    if ((this.lazyInitBitmap & 4L) == 0L) {
                        this.type = Preconditions.checkNotNull(super.type());
                        this.lazyInitBitmap |= 4L;
                    }
                }
            }
            return this.type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String sourceQualifedName() {
            if ((this.lazyInitBitmap & 8L) == 0L) {
                Protoclass protoclass = this;
                synchronized (protoclass) {
                    if ((this.lazyInitBitmap & 8L) == 0L) {
                        this.sourceQualifedName = Preconditions.checkNotNull(super.sourceQualifedName());
                        this.lazyInitBitmap |= 8L;
                    }
                }
            }
            return this.sourceQualifedName;
        }

        private static Protoclass checkPreconditions(Protoclass instance) {
            return instance;
        }

        public static Protoclass copyOf(Proto.Protoclass instance) {
            if (instance instanceof Protoclass) {
                return (Protoclass)instance;
            }
            Preconditions.checkNotNull(instance);
            return Protoclass.builder().sourceElement(instance.sourceElement()).packageOf(instance.packageOf()).declaringType(instance.declaringType()).kind(instance.kind()).composer(instance.composer()).processing(instance.processing()).build();
        }

        @Deprecated
        public static Protoclass copyOf(Protoclass instance) {
            return Preconditions.checkNotNull(instance);
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INITIALIZED_BITSET_ALL_ = 31L;
            private static final long INITIALIZED_BIT_SOURCE_ELEMENT = 1L;
            private static final long INITIALIZED_BIT_PACKAGE_OF = 2L;
            private static final long INITIALIZED_BIT_KIND = 4L;
            private static final long INITIALIZED_BIT_COMPOSER = 8L;
            private static final long INITIALIZED_BIT_PROCESSING = 16L;
            private long initializedBitset;
            @Nullable
            private Element sourceElement;
            @Nullable
            private Proto.DeclaringPackage packageOf;
            private Optional<Proto.DeclaringType> declaringType = Optional.absent();
            @Nullable
            private Proto.Protoclass.Kind kind;
            @Nullable
            private ValueTypeComposer composer;
            @Nullable
            private ProcessingEnvironment processing;

            private Builder() {
            }

            public final Builder sourceElement(Element sourceElement) {
                this.sourceElement = Preconditions.checkNotNull(sourceElement);
                this.initializedBitset |= 1L;
                return this;
            }

            public final Builder packageOf(Proto.DeclaringPackage packageOf) {
                this.packageOf = Preconditions.checkNotNull(packageOf);
                this.initializedBitset |= 2L;
                return this;
            }

            public final Builder declaringType(Proto.DeclaringType declaringType) {
                this.declaringType = Optional.of(declaringType);
                return this;
            }

            public final Builder declaringType(Optional<Proto.DeclaringType> declaringType) {
                this.declaringType = Preconditions.checkNotNull(declaringType);
                return this;
            }

            public final Builder kind(Proto.Protoclass.Kind kind) {
                this.kind = Preconditions.checkNotNull(kind);
                this.initializedBitset |= 4L;
                return this;
            }

            public final Builder composer(ValueTypeComposer composer) {
                this.composer = Preconditions.checkNotNull(composer);
                this.initializedBitset |= 8L;
                return this;
            }

            public final Builder processing(ProcessingEnvironment processing) {
                this.processing = Preconditions.checkNotNull(processing);
                this.initializedBitset |= 0x10L;
                return this;
            }

            public Protoclass build() {
                this.checkRequiredAttributes();
                return Protoclass.checkPreconditions(new Protoclass(this));
            }

            private boolean sourceElementIsSet() {
                return (this.initializedBitset & 1L) != 0L;
            }

            private boolean packageOfIsSet() {
                return (this.initializedBitset & 2L) != 0L;
            }

            private boolean kindIsSet() {
                return (this.initializedBitset & 4L) != 0L;
            }

            private boolean composerIsSet() {
                return (this.initializedBitset & 8L) != 0L;
            }

            private boolean processingIsSet() {
                return (this.initializedBitset & 0x10L) != 0L;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset != 31L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
            }

            private String formatRequiredAttributesMessage() {
                return MoreObjects.toStringHelper("Cannot build Protoclass, some of required attributes are not set ").omitNullValues().addValue(!this.sourceElementIsSet() ? "sourceElement" : null).addValue(!this.packageOfIsSet() ? "packageOf" : null).addValue(!this.kindIsSet() ? "kind" : null).addValue(!this.composerIsSet() ? "composer" : null).addValue(!this.processingIsSet() ? "processing" : null).toString();
            }

            public String toString() {
                return MoreObjects.toStringHelper("ImmutableProto.Protoclass.Builder").omitNullValues().add("sourceElement", this.sourceElement).add("packageOf", this.packageOf).add("declaringType", this.declaringType.orNull()).add("kind", (Object)this.kind).add("composer", this.composer).add("processing", this.processing).toString();
            }
        }
    }
}

