/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import org.immutables.value.internal.google.common.base.MoreObjects;
import org.immutables.value.internal.google.common.base.Preconditions;
import org.immutables.value.internal.google.common.collect.ImmutableSet;
import org.immutables.value.internal.processor.meta.Round;
import org.immutables.value.internal.processor.meta.ValueTypeComposer;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRound
extends Round {
    private final ProcessingEnvironment processing;
    private final RoundEnvironment round;
    private final ImmutableSet<TypeElement> annotations;
    private final ValueTypeComposer composer;

    private ImmutableRound(Builder builder) {
        this.processing = builder.processing;
        this.round = builder.round;
        this.annotations = builder.annotationsBuilder.build();
        this.composer = Preconditions.checkNotNull(super.composer());
    }

    private ImmutableRound(ImmutableRound original, ProcessingEnvironment processing, RoundEnvironment round, ImmutableSet<TypeElement> annotations, ValueTypeComposer composer) {
        this.processing = processing;
        this.round = round;
        this.annotations = annotations;
        this.composer = composer;
    }

    public final ImmutableRound withProcessing(ProcessingEnvironment value) {
        if (this.processing == value) {
            return this;
        }
        ProcessingEnvironment newValue = Preconditions.checkNotNull(value);
        return ImmutableRound.checkPreconditions(new ImmutableRound(this, newValue, this.round, this.annotations, this.composer));
    }

    public final ImmutableRound withRound(RoundEnvironment value) {
        if (this.round == value) {
            return this;
        }
        RoundEnvironment newValue = Preconditions.checkNotNull(value);
        return ImmutableRound.checkPreconditions(new ImmutableRound(this, this.processing, newValue, this.annotations, this.composer));
    }

    public final ImmutableRound withAnnotations(TypeElement ... elements) {
        ImmutableSet<TypeElement> newValue = ImmutableSet.copyOf(Arrays.asList(elements));
        return ImmutableRound.checkPreconditions(new ImmutableRound(this, this.processing, this.round, newValue, this.composer));
    }

    public final ImmutableRound withAnnotations(Iterable<? extends TypeElement> elements) {
        if (this.annotations == elements) {
            return this;
        }
        ImmutableSet<TypeElement> newValue = ImmutableSet.copyOf(elements);
        return ImmutableRound.checkPreconditions(new ImmutableRound(this, this.processing, this.round, newValue, this.composer));
    }

    @Override
    public ProcessingEnvironment processing() {
        return this.processing;
    }

    @Override
    public RoundEnvironment round() {
        return this.round;
    }

    public ImmutableSet<TypeElement> annotations() {
        return this.annotations;
    }

    @Override
    public ValueTypeComposer composer() {
        return this.composer;
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ImmutableRound && this.equalTo((ImmutableRound)another);
    }

    private boolean equalTo(ImmutableRound another) {
        return this.processing.equals(another.processing) && this.round.equals(another.round) && this.annotations.equals(another.annotations) && this.composer.equals(another.composer);
    }

    private int computeHashCode() {
        int h = 31;
        h = h * 17 + this.processing.hashCode();
        h = h * 17 + this.round.hashCode();
        h = h * 17 + this.annotations.hashCode();
        h = h * 17 + this.composer.hashCode();
        return h;
    }

    public int hashCode() {
        return this.computeHashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper("Round").omitNullValues().add("processing", this.processing).add("round", this.round).add("annotations", this.annotations).add("composer", this.composer).toString();
    }

    private static ImmutableRound checkPreconditions(ImmutableRound instance) {
        return instance;
    }

    public static ImmutableRound copyOf(Round instance) {
        if (instance instanceof ImmutableRound) {
            return (ImmutableRound)instance;
        }
        Preconditions.checkNotNull(instance);
        return ImmutableRound.builder().processing(instance.processing()).round(instance.round()).addAllAnnotations(instance.annotations()).build();
    }

    @Deprecated
    public static ImmutableRound copyOf(ImmutableRound instance) {
        return Preconditions.checkNotNull(instance);
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL_ = 3L;
        private static final long INITIALIZED_BIT_PROCESSING = 1L;
        private static final long INITIALIZED_BIT_ROUND = 2L;
        private long initializedBitset;
        @Nullable
        private ProcessingEnvironment processing;
        @Nullable
        private RoundEnvironment round;
        private ImmutableSet.Builder<TypeElement> annotationsBuilder = ImmutableSet.builder();

        private Builder() {
        }

        public final Builder processing(ProcessingEnvironment processing) {
            this.processing = Preconditions.checkNotNull(processing);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder round(RoundEnvironment round) {
            this.round = Preconditions.checkNotNull(round);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder addAnnotations(TypeElement element) {
            this.annotationsBuilder.add((Object)element);
            return this;
        }

        public final Builder addAnnotations(TypeElement ... elements) {
            this.annotationsBuilder.addAll(ImmutableSet.copyOf(Arrays.asList(elements)));
            return this;
        }

        public final Builder addAllAnnotations(Iterable<? extends TypeElement> elements) {
            this.annotationsBuilder.addAll(elements);
            return this;
        }

        public ImmutableRound build() {
            this.checkRequiredAttributes();
            return ImmutableRound.checkPreconditions(new ImmutableRound(this));
        }

        private boolean processingIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean roundIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            return MoreObjects.toStringHelper("Cannot build Round, some of required attributes are not set ").omitNullValues().addValue(!this.processingIsSet() ? "processing" : null).addValue(!this.roundIsSet() ? "round" : null).toString();
        }

        public String toString() {
            return MoreObjects.toStringHelper("ImmutableRound.Builder").omitNullValues().add("processing", this.processing).add("round", this.round).add("annotations", this.annotationsBuilder.build()).toString();
        }
    }
}

