/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.lang.annotation.Annotation;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.immutables.value.internal.google.common.base.Optional;
import org.immutables.value.internal.processor.meta.ImmutableReporter;

abstract class Reporter {
    Reporter() {
    }

    abstract Messager messager();

    abstract Optional<Element> element();

    abstract Optional<AnnotationMirror> annotation();

    abstract Reporter withAnnotation(AnnotationMirror var1);

    abstract Reporter withElement(Element var1);

    static Reporter from(ProcessingEnvironment processing) {
        return ImmutableReporter.of(processing.getMessager());
    }

    Reporter forAnnotation(Class<? extends Annotation> annotationType) {
        return this.annotationNamed(annotationType.getSimpleName());
    }

    Reporter annotationNamed(String simpleName) {
        if (this.element().isPresent()) {
            for (AnnotationMirror annotationMirror : this.element().get().getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().asElement().getSimpleName().contentEquals(simpleName)) continue;
                return this.withAnnotation(annotationMirror);
            }
        }
        return this;
    }

    void error(String message, Object ... parameters) {
        this.reportMessage(Diagnostic.Kind.ERROR, message, parameters);
    }

    void warning(String message, Object ... parameters) {
        this.reportMessage(Diagnostic.Kind.WARNING, message, parameters);
    }

    private void reportMessage(Diagnostic.Kind messageKind, String message, Object ... parameters) {
        String formattedMessage = String.format(message, parameters);
        if (this.element().isPresent() && this.annotation().isPresent()) {
            this.messager().printMessage(messageKind, formattedMessage, this.element().get(), this.annotation().get());
        } else if (this.element().isPresent()) {
            this.messager().printMessage(messageKind, formattedMessage, this.element().get());
        } else {
            this.messager().printMessage(messageKind, formattedMessage);
        }
    }
}

