/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.immutables.value.internal.google.common.base.Optional;
import org.immutables.value.internal.google.common.collect.ImmutableList;
import org.immutables.value.internal.google.common.collect.ImmutableMultimap;
import org.immutables.value.internal.google.common.collect.Maps;
import org.immutables.value.internal.google.common.collect.Multimap;
import org.immutables.value.internal.google.common.collect.Sets;
import org.immutables.value.internal.processor.meta.ImmutableProto;
import org.immutables.value.internal.processor.meta.Proto;
import org.immutables.value.internal.processor.meta.Reporter;
import org.immutables.value.internal.processor.meta.ValueType;
import org.immutables.value.internal.processor.meta.ValueTypeComposer;

public abstract class Round {
    public abstract ProcessingEnvironment processing();

    public abstract RoundEnvironment round();

    public abstract Set<TypeElement> annotations();

    ValueTypeComposer composer() {
        return new ValueTypeComposer(this);
    }

    public Multimap<Proto.DeclaringPackage, ValueType> collectValues() {
        final ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        class ValueCombiner {
            final ImmutableList<Proto.Protoclass> protoclasses;
            final Map<Proto.DeclaringType, ValueType> enclosingTypes;

            ValueCombiner() {
                this.protoclasses = Round.this.collectProtoclasses();
                this.enclosingTypes = Maps.newHashMap();
            }

            void combine() {
                this.collectEnclosing();
                this.attachNested();
            }

            void collectEnclosing() {
                for (Proto.Protoclass protoclass : this.protoclasses) {
                    if (!protoclass.kind().isEnclosing()) continue;
                    ValueType type = protoclass.type();
                    this.enclosingTypes.put(protoclass.declaringType().get(), type);
                }
            }

            void attachNested() {
                for (Proto.Protoclass protoclass : this.protoclasses) {
                    ValueType enclosing;
                    if (protoclass.kind().isNested() && (enclosing = this.enclosingTypes.get(protoclass.enclosingOf().get())) != null) {
                        enclosing.addNested(protoclass.type());
                    }
                    builder.put(protoclass.packageOf(), protoclass.type());
                }
            }
        }
        new ValueCombiner().combine();
        return builder.build();
    }

    Optional<Proto.Protoclass> definedValueProtoclassFor(TypeElement element) {
        ProtoclassCollecter collecter = new ProtoclassCollecter();
        collecter.collect(element);
        for (Proto.Protoclass protoclass : collecter.builder.build()) {
            if (!protoclass.kind().isDefinedValue()) continue;
            return Optional.of(protoclass);
        }
        return Optional.absent();
    }

    public ImmutableList<Proto.Protoclass> collectProtoclasses() {
        ProtoclassCollecter collecter = new ProtoclassCollecter();
        for (Element element : this.allAnnotatedElements()) {
            collecter.collect(element);
        }
        return collecter.builder.build();
    }

    private Set<Element> allAnnotatedElements() {
        HashSet<Element> elements = Sets.newHashSetWithExpectedSize(100);
        for (TypeElement annotation : this.annotations()) {
            elements.addAll(this.round().getElementsAnnotatedWith(annotation));
        }
        return elements;
    }

    private class ProtoclassCollecter {
        final ImmutableList.Builder<Proto.Protoclass> builder = ImmutableList.builder();

        private ProtoclassCollecter() {
        }

        void collect(Element element) {
            switch (element.getKind()) {
                case ANNOTATION_TYPE: 
                case INTERFACE: 
                case CLASS: {
                    this.collectIncludedAndDefinedBy((TypeElement)element);
                    break;
                }
                case METHOD: {
                    this.collectDefinedBy((ExecutableElement)element);
                    break;
                }
                case PACKAGE: {
                    this.collectIncludedBy((PackageElement)element);
                    break;
                }
                default: {
                    Reporter.from(Round.this.processing()).withElement(element).warning("Unmatched annotation will be skipped for annotation processing", new Object[0]);
                }
            }
        }

        void collectDefinedBy(ExecutableElement element) {
            ImmutableProto.DeclaringType declaringType = ImmutableProto.DeclaringType.builder().processing(Round.this.processing()).element((TypeElement)element.getEnclosingElement()).build();
            if (declaringType.verifiedFactory(element)) {
                this.builder.add((Object)ImmutableProto.Protoclass.builder().processing(Round.this.processing()).composer(Round.this.composer()).packageOf(((Proto.DeclaringType)declaringType).packageOf()).sourceElement(element).declaringType(declaringType).kind(Proto.Protoclass.Kind.DEFINED_FACTORY).build());
            }
        }

        void collectIncludedBy(PackageElement element) {
            ImmutableProto.DeclaringPackage declaringPackage = ImmutableProto.DeclaringPackage.builder().processing(Round.this.processing()).element(element).build();
            if (((Proto.AbstractDeclaring)declaringPackage).hasInclude()) {
                for (TypeElement sourceElement : ((Proto.AbstractDeclaring)declaringPackage).includedTypes()) {
                    this.builder.add((Object)ImmutableProto.Protoclass.builder().processing(Round.this.processing()).composer(Round.this.composer()).packageOf(declaringPackage).sourceElement(sourceElement).kind(Proto.Protoclass.Kind.INCLUDED_IN_PACKAGE).build());
                }
            }
        }

        void collectIncludedAndDefinedBy(TypeElement element) {
            Proto.Protoclass.Kind kind;
            ImmutableProto.DeclaringType declaringType = ImmutableProto.DeclaringType.builder().processing(Round.this.processing()).element(element).build();
            if (((Proto.AbstractDeclaring)declaringType).hasInclude()) {
                kind = ((Proto.AbstractDeclaring)declaringType).isEnclosing() ? Proto.Protoclass.Kind.INCLUDED_IN_TYPE : Proto.Protoclass.Kind.INCLUDED_ON_TYPE;
                for (TypeElement sourceElement : ((Proto.AbstractDeclaring)declaringType).includedTypes()) {
                    this.builder.add((Object)ImmutableProto.Protoclass.builder().processing(Round.this.processing()).composer(Round.this.composer()).packageOf(((Proto.DeclaringType)declaringType).packageOf()).sourceElement(sourceElement).declaringType(declaringType).kind(kind).build());
                }
            }
            if (declaringType.isImmutable() || ((Proto.AbstractDeclaring)declaringType).isEnclosing()) {
                kind = this.kindOfDefinedBy(declaringType);
                this.builder.add((Object)ImmutableProto.Protoclass.builder().processing(Round.this.processing()).composer(Round.this.composer()).packageOf(((Proto.DeclaringType)declaringType).packageOf()).sourceElement(element).declaringType(declaringType).kind(kind).build());
            }
        }

        private Proto.Protoclass.Kind kindOfDefinedBy(Proto.DeclaringType declaringType) {
            if (declaringType.isImmutable()) {
                if (declaringType.isEnclosing()) {
                    return Proto.Protoclass.Kind.DEFINED_AND_ENCLOSING_TYPE;
                }
                if (declaringType.enclosingOf().isPresent()) {
                    return Proto.Protoclass.Kind.DEFINED_NESTED_TYPE;
                }
                return Proto.Protoclass.Kind.DEFINED_TYPE;
            }
            assert (declaringType.isEnclosing());
            return Proto.Protoclass.Kind.DEFINED_ENCLOSING_TYPE;
        }
    }
}

