/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.Json;
import org.immutables.value.Mongo;
import org.immutables.value.Value;
import org.immutables.value.internal.google.common.base.Ascii;
import org.immutables.value.internal.google.common.base.Functions;
import org.immutables.value.internal.google.common.base.Optional;
import org.immutables.value.internal.google.common.collect.FluentIterable;
import org.immutables.value.internal.google.common.collect.ImmutableList;
import org.immutables.value.internal.google.common.collect.Iterables;
import org.immutables.value.internal.google.common.collect.Lists;
import org.immutables.value.internal.processor.meta.AnnotationPrinting;
import org.immutables.value.internal.processor.meta.AttributeTypeKind;
import org.immutables.value.internal.processor.meta.Proto;
import org.immutables.value.internal.processor.meta.Reporter;
import org.immutables.value.internal.processor.meta.Styles;
import org.immutables.value.internal.processor.meta.TypeIntrospectionBase;
import org.immutables.value.internal.processor.meta.ValueType;

public final class ValueAttribute
extends TypeIntrospectionBase {
    private static final String NULLABLE_SIMPLE_NAME = "Nullable";
    private static final String ID_ATTRIBUTE_NAME = "_id";
    public Styles.UsingName.AttributeNames names;
    public boolean isGenerateDefault;
    public boolean isGenerateDerived;
    public boolean isGenerateAbstract;
    public boolean isGenerateLazy;
    public ImmutableList<String> typeParameters = ImmutableList.of();
    public Reporter reporter;
    TypeMirror returnType;
    Element element;
    ValueType containingType;
    String returnTypeName;
    @Nullable
    private TypeElement marshaledElement;
    @Nullable
    private TypeElement marshaledSecondaryElement;
    @Nullable
    private TypeElement specialMarshaledElement;
    @Nullable
    private TypeElement specialMarshaledSecondaryElement;
    private boolean hasEnumFirstTypeParameter;
    private TypeElement containedTypeElement;
    private boolean generateOrdinalValueSet;
    private TypeMirror arrayComponent;
    private boolean nullable;
    private String nullabilityPrefix;
    @Nullable
    private String rawTypeName;
    @Nullable
    private String marshaledName;
    private OrderKind orderKind = OrderKind.NONE;
    @Nullable
    private CharSequence defaultInterface;
    @Nullable
    private List<SimpleTypeDerivationBase> expectedSubclasses;
    private int constructorOrder = Integer.MIN_VALUE;
    private AttributeTypeKind typeKind;

    public String name() {
        return this.names.raw;
    }

    public boolean isBoolean() {
        return this.returnType.getKind() == TypeKind.BOOLEAN;
    }

    public boolean isInt() {
        return this.returnType.getKind() == TypeKind.INT;
    }

    public boolean isLong() {
        return this.returnType.getKind() == TypeKind.LONG;
    }

    public boolean isStringType() {
        return this.returnTypeName.equals(String.class.getName());
    }

    public boolean charType() {
        return this.returnType.getKind() == TypeKind.CHAR;
    }

    public String atNullability() {
        return this.isNullable() ? this.nullabilityPrefix : "";
    }

    public boolean isSimpleLiteralType() {
        return this.isPrimitive() || this.isStringType() || this.isEnumType();
    }

    public boolean isMandatory() {
        return this.isGenerateAbstract && !this.isContainerType() && !this.isNullable();
    }

    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isComparable() {
        return this.isNumberType() || super.isComparable();
    }

    public String getMarshaledName() {
        if (this.marshaledName == null) {
            this.marshaledName = this.inferMarshaledName();
        }
        return this.marshaledName;
    }

    private String inferMarshaledName() {
        String name;
        Json.Named namedAnnotaion = this.element.getAnnotation(Json.Named.class);
        if (namedAnnotaion != null && !(name = namedAnnotaion.value()).isEmpty()) {
            return name;
        }
        Mongo.Id idAnnotation = this.element.getAnnotation(Mongo.Id.class);
        if (idAnnotation != null) {
            return ID_ATTRIBUTE_NAME;
        }
        return this.names.raw;
    }

    public boolean isForceEmpty() {
        return this.element.getAnnotation(Json.ForceEmpty.class) != null;
    }

    @Override
    protected TypeMirror internalTypeMirror() {
        return this.returnType;
    }

    public String getType() {
        return this.returnTypeName;
    }

    public List<CharSequence> getAnnotations() {
        return AnnotationPrinting.getAnnotationLines(this.element);
    }

    public boolean isJsonIgnore() {
        return this.element.getAnnotation(Json.Ignore.class) != null;
    }

    public List<String> typeParameters() {
        this.ensureTypeIntrospected();
        return this.arrayComponent != null ? ImmutableList.of(this.arrayComponent.toString()) : this.typeParameters;
    }

    public boolean isMapType() {
        return this.typeKind.isMappingKind();
    }

    public boolean isMultimapType() {
        return this.typeKind.isMultimapKind();
    }

    public boolean isListType() {
        return this.typeKind.isList();
    }

    public boolean isSetType() {
        return this.typeKind.isSet();
    }

    public boolean hasNaturalOrder() {
        return this.orderKind == OrderKind.NATURAL;
    }

    public boolean hasReverseOrder() {
        return this.orderKind == OrderKind.REVERSE;
    }

    public boolean isSortedSetType() {
        return this.typeKind.isSortedSet();
    }

    public boolean isSortedMapType() {
        return this.typeKind.isSortedMap();
    }

    public boolean isGenerateSortedSet() {
        return this.typeKind.isSortedSet();
    }

    public boolean isGenerateSortedMap() {
        return this.typeKind.isSortedMap();
    }

    private void checkOrderAnnotations() {
        Value.NaturalOrder naturalOrderAnnotation = this.element.getAnnotation(Value.NaturalOrder.class);
        Value.ReverseOrder reverseOrderAnnotation = this.element.getAnnotation(Value.ReverseOrder.class);
        if (naturalOrderAnnotation != null && reverseOrderAnnotation != null) {
            this.reporter.withElement(this.element).error("@Value.Natural and @Value.Reverse annotations could not be used on the same attribute", new Object[0]);
        } else if (naturalOrderAnnotation != null) {
            if (this.typeKind.isSortedKind()) {
                if (this.isComparable()) {
                    this.orderKind = OrderKind.NATURAL;
                } else {
                    this.reporter.withElement(this.element).forAnnotation(Value.NaturalOrder.class).error("@Value.Natural should used on a set of Comparable elements (map keys)", new Object[0]);
                }
            } else {
                this.reporter.withElement(this.element).forAnnotation(Value.NaturalOrder.class).error("@Value.Natural should specify order for SortedSet, SortedMap, NavigableSet or NavigableMap attributes", new Object[0]);
            }
        } else if (reverseOrderAnnotation != null) {
            if (this.typeKind.isSortedKind()) {
                if (this.isComparable()) {
                    this.orderKind = OrderKind.REVERSE;
                } else {
                    this.reporter.withElement(this.element).forAnnotation(Value.ReverseOrder.class).error("@Value.Reverse should used with a set of Comparable elements", new Object[0]);
                }
            } else {
                this.reporter.withElement(this.element).forAnnotation(Value.ReverseOrder.class).error("@Value.Reverse should specify order for SortedSet, SortedMap, NavigableSet or NavigableMap attributes", new Object[0]);
            }
        }
    }

    public boolean isJdkOptional() {
        return this.typeKind.isOptionalJdk();
    }

    public boolean isOptionalType() {
        return this.typeKind.isOptionalKind();
    }

    public boolean isCollectionType() {
        return this.typeKind.isCollectionKind();
    }

    public boolean isGenerateEnumSet() {
        return this.typeKind.isEnumSet();
    }

    public CharSequence defaultInterface() {
        if (this.defaultInterface == null) {
            this.defaultInterface = this.inferDefaultInterface();
        }
        return this.defaultInterface;
    }

    private CharSequence inferDefaultInterface() {
        if (this.element.getEnclosingElement().getKind() == ElementKind.INTERFACE && !this.element.getModifiers().contains((Object)Modifier.ABSTRACT) && this.containingType.element.getKind() == ElementKind.INTERFACE) {
            return this.containingType.typeAbstract().relative();
        }
        return "";
    }

    public boolean isMapLike() {
        return this.typeKind.isMappingKind();
    }

    public boolean isGenerateEnumMap() {
        return this.typeKind.isEnumMap();
    }

    public String getUnwrappedElementType() {
        return ValueAttribute.unwrapType(this.containmentTypeName());
    }

    public String getWrappedElementType() {
        return ValueAttribute.wrapType(this.containmentTypeName());
    }

    private String containmentTypeName() {
        return this.isArrayType() || this.isContainerType() ? this.firstTypeParameter() : this.returnTypeName;
    }

    public String getRawType() {
        return this.rawTypeName != null ? this.rawTypeName : this.extractRawType(this.returnTypeName);
    }

    public String getConsumedElementType() {
        return this.isUnwrappedElementPrimitiveType() || String.class.getName().equals(this.containmentTypeName()) || this.hasEnumFirstTypeParameter ? this.getWrappedElementType() : "? extends " + this.getWrappedElementType();
    }

    private String extractRawType(String className) {
        int endOfTypeAnnotations;
        String rawType = className;
        int indexOfGenerics = rawType.indexOf(60);
        if (indexOfGenerics > 0) {
            rawType = rawType.substring(0, indexOfGenerics);
        }
        if ((endOfTypeAnnotations = rawType.lastIndexOf(32)) > 0) {
            rawType = rawType.substring(endOfTypeAnnotations + 1);
        }
        return rawType;
    }

    public boolean isUnwrappedElementPrimitiveType() {
        return ValueAttribute.isPrimitiveType(this.getUnwrappedElementType());
    }

    public boolean isUnwrappedSecondaryElementPrimitiveType() {
        return ValueAttribute.isPrimitiveType(this.getUnwrappedSecondaryElementType());
    }

    public String firstTypeParameter() {
        return Iterables.getFirst(this.typeParameters(), "");
    }

    public String secondTypeParameter() {
        return Iterables.get(this.typeParameters(), 1);
    }

    public String getElementType() {
        return this.containmentTypeName();
    }

    public List<SimpleTypeDerivationBase> getExpectedSubclasses() {
        if (this.expectedSubclasses == null) {
            Iterable<TypeElement> expectedSubclassesType;
            this.expectedSubclasses = this.isPrimitiveElement() ? ImmutableList.of() : ((expectedSubclassesType = this.findDeclaredSubclasses()) != null ? this.toMarshaledTypeDerivations(expectedSubclassesType) : ImmutableList.of());
        }
        return this.expectedSubclasses;
    }

    @Nullable
    private Iterable<TypeElement> findDeclaredSubclasses() {
        if (this.element.getAnnotation(Json.Subclasses.class) != null) {
            return ValueAttribute.listExpectedSubclassesFromElement(this.element);
        }
        this.ensureTypeIntrospected();
        if (this.containedTypeElement != null) {
            return ValueAttribute.listExpectedSubclassesFromElement(this.containedTypeElement);
        }
        return null;
    }

    private List<SimpleTypeDerivationBase> toMarshaledTypeDerivations(Iterable<TypeElement> elements) {
        ArrayList<SimpleTypeDerivationBase> derivations = Lists.newArrayList();
        for (TypeElement element : elements) {
            Optional<Proto.Protoclass> protoclass = this.containingType.round.definedValueProtoclassFor(element);
            if (!protoclass.isPresent() || !protoclass.get().declaringType().get().hasAnnotation(Json.Marshaled.class)) continue;
            derivations.add(new SimpleTypeDerivationBase(protoclass.get()));
        }
        return ImmutableList.copyOf(derivations);
    }

    private static FluentIterable<TypeElement> listExpectedSubclassesFromElement(Element element) {
        return FluentIterable.from(ValueType.extractedTypesFromAnnotationMirrors(Json.Subclasses.class.getCanonicalName(), "value", element.getAnnotationMirrors())).transform(Proto.DeclatedTypeToElement.FUNCTION);
    }

    public boolean isGenerateJdkOnly() {
        return this.containingType.isGenerateJdkOnly();
    }

    public boolean isGenerateOrdinalValueSet() {
        if (!this.isSetType()) {
            return false;
        }
        this.ensureTypeIntrospected();
        return this.generateOrdinalValueSet;
    }

    public boolean isDocumentElement() {
        this.ensureTypeIntrospected();
        return this.containedTypeElement != null && this.containedTypeElement.getAnnotation(Mongo.Repository.class) != null;
    }

    public boolean isArrayType() {
        return this.typeKind.isArray();
    }

    @Override
    protected void introspectType() {
        TypeMirror typeMirror = this.returnType;
        if (this.isContainerType()) {
            if (typeMirror instanceof DeclaredType) {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                ArrayList<String> typeParameters = Lists.newArrayList();
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                if (!typeArguments.isEmpty()) {
                    TypeMirror typeArgument;
                    if (typeArguments.size() == 1) {
                        typeArgument = typeArguments.get(0);
                        if (typeArgument instanceof DeclaredType) {
                            typeMirror = typeArgument;
                        }
                        if (this.isSetType()) {
                            this.generateOrdinalValueSet = new TypeIntrospectionBase(){

                                @Override
                                protected TypeMirror internalTypeMirror() {
                                    return typeArgument;
                                }
                            }.isOrdinalValue();
                        }
                    }
                    if (typeArguments.size() >= 1) {
                        TypeMirror typeSecondArgument;
                        typeArgument = typeArguments.get(0);
                        if (typeArgument instanceof DeclaredType) {
                            TypeElement typeElement = (TypeElement)((DeclaredType)typeArgument).asElement();
                            this.hasEnumFirstTypeParameter = typeElement.getSuperclass().toString().startsWith(Enum.class.getName());
                        }
                        if (typeArguments.size() >= 2 && (typeSecondArgument = typeArguments.get(1)) instanceof DeclaredType) {
                            TypeElement typeElement = (TypeElement)((DeclaredType)typeSecondArgument).asElement();
                            Json.Marshaled generateMarshaler = typeElement.getAnnotation(Json.Marshaled.class);
                            this.marshaledSecondaryElement = generateMarshaler != null ? typeElement : null;
                            this.specialMarshaledSecondaryElement = this.asSpecialMarshaledElement(this.marshaledSecondaryElement, typeElement);
                        }
                        typeMirror = typeArgument;
                    }
                    typeParameters.addAll(Lists.transform(typeArguments, Functions.toStringFunction()));
                }
                this.typeParameters = ImmutableList.copyOf(typeParameters);
            }
        } else if (this.isArrayType()) {
            typeMirror = this.arrayComponent = ((ArrayType)typeMirror).getComponentType();
        }
        if (typeMirror instanceof DeclaredType) {
            TypeElement typeElement;
            this.containedTypeElement = typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            Json.Marshaled generateMarshaler = typeElement.getAnnotation(Json.Marshaled.class);
            this.marshaledElement = generateMarshaler != null ? typeElement : null;
            this.specialMarshaledElement = this.asSpecialMarshaledElement(this.marshaledElement, typeElement);
        }
        this.intospectTypeMirror(typeMirror);
    }

    public AttributeTypeKind typeKind() {
        return this.typeKind;
    }

    static boolean isRegularMarshalableType(String name) {
        return String.class.getName().equals(name) || ValueAttribute.isPrimitiveOrWrapped(name);
    }

    public String getRawCollectionType() {
        return this.typeKind.rawSimpleName();
    }

    public boolean isMultisetType() {
        return this.typeKind.isMultiset();
    }

    public String getRawMapType() {
        return this.typeKind.rawSimpleName();
    }

    public String simpleContainerName() {
        return this.typeKind.rawSimpleName();
    }

    public String getSecondaryElementType() {
        return this.secondTypeParameter();
    }

    public String getUnwrappedSecondaryElementType() {
        return ValueAttribute.unwrapType(this.secondTypeParameter());
    }

    public String getWrappedSecondaryElementType() {
        return ValueAttribute.wrapType(this.secondTypeParameter());
    }

    public String getUnwrapperOrRawSecondaryElementType() {
        return this.extractRawType(this.getWrappedSecondaryElementType());
    }

    public String getUnwrapperOrRawElementType() {
        return this.extractRawType(this.getWrappedElementType());
    }

    public boolean isNumberType() {
        TypeKind kind = this.returnType.getKind();
        return kind.isPrimitive() && kind != TypeKind.CHAR && kind != TypeKind.BOOLEAN;
    }

    public boolean isFloatType() {
        return this.isFloat() || this.isDouble();
    }

    public boolean isFloat() {
        return this.returnType.getKind() == TypeKind.FLOAT;
    }

    public boolean isDouble() {
        return this.returnType.getKind() == TypeKind.DOUBLE;
    }

    public boolean isNonRawElemementType() {
        return this.getElementType().indexOf(60) > 0;
    }

    public boolean isContainerType() {
        return this.isCollectionType() || this.isOptionalType() || this.isMapType();
    }

    public String getWrapperType() {
        return this.isPrimitive() ? ValueAttribute.wrapType(this.rawTypeName) : this.returnTypeName;
    }

    public boolean isPrimitive() {
        return this.returnType.getKind().isPrimitive();
    }

    int getConstructorParameterOrder() {
        if (this.constructorOrder < -1) {
            Value.Parameter annotation = this.element.getAnnotation(Value.Parameter.class);
            this.constructorOrder = annotation != null ? annotation.order() : -1;
        }
        return this.constructorOrder;
    }

    public boolean isConstructorParameter() {
        return this.getConstructorParameterOrder() >= 0;
    }

    public boolean isSpecialMarshaledElement() {
        this.ensureTypeIntrospected();
        return this.specialMarshaledElement != null;
    }

    public boolean isSpecialMarshaledSecondaryElement() {
        this.ensureTypeIntrospected();
        return this.specialMarshaledSecondaryElement != null;
    }

    public boolean isMarshaledElement() {
        if (this.isPrimitive()) {
            return false;
        }
        this.ensureTypeIntrospected();
        return this.marshaledElement != null;
    }

    public boolean isMarshaledSecondaryElement() {
        this.ensureTypeIntrospected();
        return this.marshaledSecondaryElement != null;
    }

    public boolean isPrimitiveElement() {
        return ValueAttribute.isPrimitiveType(this.getUnwrappedElementType());
    }

    private TypeElement asSpecialMarshaledElement(@Nullable TypeElement marshaled, TypeElement element) {
        if (marshaled != null) {
            return marshaled;
        }
        if (!ValueAttribute.isRegularMarshalableType(element.getQualifiedName().toString())) {
            return element;
        }
        return null;
    }

    Collection<SimpleTypeDerivationBase> getMarshaledImportRoutines() {
        ArrayList<TypeElement> imports = Lists.newArrayListWithExpectedSize(2);
        if (this.isMarshaledElement()) {
            imports.add(this.marshaledElement);
        }
        if (this.isMapType() && this.isMarshaledSecondaryElement()) {
            imports.add(this.marshaledSecondaryElement);
        }
        return this.toMarshaledTypeDerivations(imports);
    }

    Collection<String> getSpecialMarshaledTypes() {
        ArrayList<String> marshaledTypeSet = Lists.newArrayListWithExpectedSize(2);
        if (this.isSpecialMarshaledElement()) {
            String typeName = this.isContainerType() ? this.getUnwrappedElementType() : this.getType();
            marshaledTypeSet.add(typeName);
        }
        if (this.isMapType() && this.isSpecialMarshaledSecondaryElement()) {
            marshaledTypeSet.add(this.specialMarshaledSecondaryElement.getQualifiedName().toString());
        }
        return marshaledTypeSet;
    }

    public boolean isAuxiliary() {
        return this.element.getAnnotation(Value.Auxiliary.class) != null;
    }

    public boolean isMarshaledIgnore() {
        this.ensureTypeIntrospected();
        return this.isMarshaledElement();
    }

    boolean isIdAttribute() {
        return this.getMarshaledName().equals(ID_ATTRIBUTE_NAME);
    }

    void initAndValidate() {
        this.initRawTypeName();
        this.initTypeKind();
        this.initOrderKind();
        this.makeRegularAndNullableWithValidation();
        this.makeRegularIfContainsWildcards();
        this.makeRegularIfDefaultWithValidation();
        this.prohibitAuxiliaryOnAnnotationTypes();
    }

    private void initOrderKind() {
        if (this.typeKind.isSortedKind()) {
            this.checkOrderAnnotations();
            if (this.orderKind == OrderKind.NONE) {
                this.typeKind = AttributeTypeKind.REGULAR;
            }
        }
    }

    private void prohibitAuxiliaryOnAnnotationTypes() {
        if (this.containingType.isAnnotationType() && this.isAuxiliary()) {
            this.reporter.withElement(this.element).forAnnotation(Value.Auxiliary.class).error("@Value.Auxiliary cannot be used on annotation attribute to not violate annotation spec", new Object[0]);
        }
    }

    private void initRawTypeName() {
        if (this.returnType.getKind() == TypeKind.DECLARED) {
            this.rawTypeName = ((TypeElement)((DeclaredType)this.returnType).asElement()).getQualifiedName().toString();
        } else if (this.returnType.getKind().isPrimitive()) {
            this.rawTypeName = Ascii.toLowerCase(this.returnType.getKind().name());
        }
    }

    private void initTypeKind() {
        if (this.returnType.getKind() == TypeKind.ARRAY) {
            this.typeKind = AttributeTypeKind.ARRAY;
            this.ensureTypeIntrospected();
        } else {
            this.typeKind = AttributeTypeKind.forRawType(this.rawTypeName);
            this.ensureTypeIntrospected();
            this.typeKind = this.typeKind.withHasEnumFirstTypeParameter(this.hasEnumFirstTypeParameter);
        }
    }

    private void makeRegularIfDefaultWithValidation() {
        if (this.isGenerateDefault && this.isContainerType()) {
            this.typeKind = AttributeTypeKind.REGULAR;
            this.reporter.withElement(this.element).forAnnotation(Value.Default.class).warning("@Value.Default on a container attribute make it lose it's special treatment", new Object[0]);
        }
    }

    private void makeRegularIfContainsWildcards() {
        if (this.returnTypeName.indexOf(63) >= 0) {
            this.typeKind = AttributeTypeKind.REGULAR;
        }
    }

    private void makeRegularAndNullableWithValidation() {
        for (AnnotationMirror annotationMirror : this.element.getAnnotationMirrors()) {
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!annotationElement.getSimpleName().contentEquals(NULLABLE_SIMPLE_NAME)) continue;
            if (this.isPrimitive()) {
                this.reporter.withElement(this.element).annotationNamed(NULLABLE_SIMPLE_NAME).error("@Nullable could not be used with primitive type attibutes", new Object[0]);
                continue;
            }
            this.nullable = true;
            this.nullabilityPrefix = "@" + annotationElement.getQualifiedName() + " ";
            if (!this.nullable) continue;
            this.typeKind = AttributeTypeKind.REGULAR;
        }
        if (this.containingType.isAnnotationType() && this.nullable) {
            this.reporter.withElement(this.element).annotationNamed(NULLABLE_SIMPLE_NAME).error("@Nullable could not be used with annotation attribute, use default value", new Object[0]);
        }
    }

    public String toString() {
        return "Attribute[" + this.name() + "]";
    }

    public static final class SimpleTypeDerivationBase {
        public final String packaged;
        public final String name;

        SimpleTypeDerivationBase(Proto.Protoclass protoclass) {
            this.packaged = protoclass.packageOf().asPrefix();
            this.name = protoclass.createTypeNames().raw;
        }
    }

    private static enum OrderKind {
        NONE,
        NATURAL,
        REVERSE;

    }
}

