/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.Jackson;
import org.immutables.value.Json;
import org.immutables.value.Mongo;
import org.immutables.value.Value;
import org.immutables.value.ext.ExtValue;
import org.immutables.value.ext.Gson;
import org.immutables.value.ext.Parboil;
import org.immutables.value.internal.google.common.base.CaseFormat;
import org.immutables.value.internal.google.common.base.Function;
import org.immutables.value.internal.google.common.base.Functions;
import org.immutables.value.internal.google.common.base.Optional;
import org.immutables.value.internal.google.common.base.Predicate;
import org.immutables.value.internal.google.common.base.Predicates;
import org.immutables.value.internal.google.common.collect.FluentIterable;
import org.immutables.value.internal.google.common.collect.ImmutableList;
import org.immutables.value.internal.google.common.collect.ImmutableSet;
import org.immutables.value.internal.google.common.collect.Iterables;
import org.immutables.value.internal.google.common.collect.Lists;
import org.immutables.value.internal.google.common.collect.Ordering;
import org.immutables.value.internal.google.common.collect.Sets;
import org.immutables.value.internal.processor.meta.AttributeTypeKind;
import org.immutables.value.internal.processor.meta.CaseStructure;
import org.immutables.value.internal.processor.meta.Constitution;
import org.immutables.value.internal.processor.meta.Proto;
import org.immutables.value.internal.processor.meta.Round;
import org.immutables.value.internal.processor.meta.Styles;
import org.immutables.value.internal.processor.meta.TypeIntrospectionBase;
import org.immutables.value.internal.processor.meta.ValueAttribute;
import org.immutables.value.internal.processor.meta.ValueAttributeFunctions;

public final class ValueType
extends TypeIntrospectionBase {
    private static final String SUPER_BUILDER_TYPE_NAME = "Builder";
    private static final ImmutableSet<String> JACKSON_MAPPING_ANNOTATION_CLASSES = ImmutableSet.of(Jackson.Mapped.class.getCanonicalName(), "com.fasterxml.jackson.databind.annotation.JsonSerialize", "com.fasterxml.jackson.databind.annotation.JsonDeserialize");
    @Nullable
    public String typeMoreObjects;
    public Element element;
    public List<ValueAttribute> attributes = Lists.newArrayList();
    public boolean isHashCodeDefined;
    public boolean isEqualToDefined;
    public boolean isToStringDefined;
    public Constitution constitution;
    Round round;
    private CaseStructure caseStructure;
    public List<ValueType> nested = Collections.emptyList();
    @Nullable
    private ValueType enclosingValue;
    @Nullable
    public String validationMethodName;
    public Value.Immutable immutableFeatures;
    private Boolean generateMarshaled;
    private Boolean hasAbstractBuilder;
    private Set<String> importedMarshalRoutines;
    private List<ValueAttribute.SimpleTypeDerivationBase> importedMarshalers;
    private Set<String> generateMarshaledTypes;
    private List<ValueAttribute> implementedAttributes;
    @Nullable
    private Boolean generateJacksonMapped;

    public Styles.UsingName.TypeNames names() {
        return this.constitution.names();
    }

    public Constitution.NameForms factoryOf() {
        return this.constitution.factoryOf();
    }

    public Constitution.NameForms factoryCopyOf() {
        return this.constitution.factoryCopyOf();
    }

    public Constitution.NameForms factoryInstance() {
        return this.constitution.factoryInstance();
    }

    public Constitution.NameForms factoryBuilder() {
        return this.constitution.factoryBuilder();
    }

    public Proto.Protoclass.Kind kind() {
        return this.constitution.protoclass().kind();
    }

    public Constitution.NameForms typeBuilder() {
        return this.constitution.typeBuilder();
    }

    public Constitution.NameForms typeAbstract() {
        return this.constitution.typeAbstract();
    }

    public Constitution.NameForms typeValue() {
        return this.constitution.typeValue();
    }

    public Constitution.NameForms typeImmutable() {
        return this.constitution.typeImmutable();
    }

    public Constitution.NameForms typeEnclosing() {
        return this.constitution.typeEnclosing();
    }

    public boolean isUseBuilder() {
        return this.immutableFeatures.builder();
    }

    public boolean isImplementationHidden() {
        return this.constitution.isImplementationHidden();
    }

    public boolean isGenerateJdkOnly() {
        return this.typeMoreObjects == null || this.immutableFeatures.jdkOnly();
    }

    public boolean isGenerateJacksonMapped() {
        if (this.generateJacksonMapped == null) {
            this.generateJacksonMapped = this.inferJacksonMapped();
        }
        return this.generateJacksonMapped;
    }

    private boolean inferJacksonMapped() {
        List<? extends AnnotationMirror> annotationMirrors = this.element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!JACKSON_MAPPING_ANNOTATION_CLASSES.contains(annotationElement.getQualifiedName().toString())) continue;
            return true;
        }
        return false;
    }

    public boolean isTopLevel() {
        return !this.kind().isNested();
    }

    public boolean isAnnotationType() {
        return this.element.getKind() == ElementKind.ANNOTATION_TYPE;
    }

    public boolean isGenerateParboiled() {
        return this.kind().isEnclosing() && this.element.getAnnotation(Parboil.Ast.class) != null;
    }

    public boolean isGenerateTransformer() {
        return this.kind().isValue() && this.element.getAnnotation(ExtValue.Transformer.class) != null;
    }

    public CaseStructure getCases() {
        if (this.caseStructure == null) {
            this.caseStructure = new CaseStructure(this);
        }
        return this.caseStructure;
    }

    public void addNested(ValueType nested) {
        if (this.nested.isEmpty()) {
            this.nested = Lists.newArrayList();
        }
        this.nested.add(nested);
        nested.enclosingValue = this;
    }

    public boolean isIface() {
        return this.element.getKind() == ElementKind.INTERFACE || this.element.getKind() == ElementKind.ANNOTATION_TYPE;
    }

    public String getInheritsKeyword() {
        return this.isIface() ? "implements" : "extends";
    }

    public <T extends Annotation> boolean hasAnnotation(Class<T> annotationType) {
        Optional<Proto.DeclaringType> declaringType = this.constitution.protoclass().declaringType();
        return declaringType.isPresent() && declaringType.get().hasAnnotation(annotationType);
    }

    public boolean isGenerateGetters() {
        return this.element.getAnnotation(Value.Getters.class) != null;
    }

    public String $$package() {
        return this.constitution.protoclass().packageOf().name();
    }

    public String name() {
        return this.names().raw;
    }

    public boolean isGenerateOrdinalValue() {
        return !this.isGenerateJdkOnly() && this.isOrdinalValue();
    }

    public boolean isUseConstructorOnly() {
        return this.isUseConstructor() && !this.isUseBuilder();
    }

    public boolean isUseCopyMethods() {
        return this.immutableFeatures.copy() && this.immutableFeatures.withers() && !this.constitution.implementationVisibility().isPrivate() && !this.getImplementedAttributes().isEmpty();
    }

    public boolean isUseCopyConstructor() {
        return this.immutableFeatures.copy() && (this.isUseConstructor() || this.isUseBuilder());
    }

    public boolean isUseSingleton() {
        return this.immutableFeatures.singleton() || this.getImplementedAttributes().isEmpty();
    }

    public boolean isUseInterned() {
        return this.immutableFeatures.intern();
    }

    public boolean isUsePrehashed() {
        return this.isUseInterned() || this.isGenerateOrdinalValue() || this.immutableFeatures.prehash();
    }

    public boolean isGenerateMarshaled() {
        if (this.generateMarshaled == null) {
            this.generateMarshaled = this.hasAnnotation(Json.Marshaled.class) || this.isGenerateJacksonMapped() || this.isGenerateRepository();
        }
        return this.generateMarshaled;
    }

    public boolean isGenerateStreamed() {
        return this.hasAnnotation(Gson.Streamed.class);
    }

    public boolean isGenerateRepository() {
        return this.element.getAnnotation(Mongo.Repository.class) != null;
    }

    public boolean isHasAbstractBuilder() {
        if (this.hasAbstractBuilder == null) {
            boolean abstractBuilderDeclared = false;
            for (Element element : this.element.getEnclosedElements()) {
                if (element.getKind() != ElementKind.CLASS || !element.getSimpleName().contentEquals(SUPER_BUILDER_TYPE_NAME)) continue;
                abstractBuilderDeclared = true;
                break;
            }
            this.hasAbstractBuilder = abstractBuilderDeclared;
        }
        return this.hasAbstractBuilder;
    }

    public String getDocumentName() {
        Mongo.Repository annotation = this.element.getAnnotation(Mongo.Repository.class);
        if (annotation != null && !annotation.value().isEmpty()) {
            return annotation.value();
        }
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, this.name());
    }

    public Set<String> getGenerateImportedMarshalRoutines() {
        if (this.importedMarshalRoutines == null) {
            LinkedHashSet<String> imports = Sets.newLinkedHashSet();
            this.collectImportRoutines(imports);
            this.importedMarshalRoutines = ImmutableSet.copyOf(imports);
        }
        return this.importedMarshalRoutines;
    }

    public List<ValueAttribute.SimpleTypeDerivationBase> getGenerateImportedMarshalers() {
        if (this.importedMarshalers == null) {
            ArrayList<ValueAttribute.SimpleTypeDerivationBase> imports = Lists.newArrayList();
            for (ValueAttribute a : this.attributes()) {
                imports.addAll(a.getMarshaledImportRoutines());
            }
            this.importedMarshalers = ImmutableList.copyOf(imports);
        }
        return this.importedMarshalers;
    }

    private void collectImportRoutines(Set<String> imports) {
        Element element = this.element;
        while (true) {
            imports.addAll(this.extractClassNamesFromMirrors(Json.Import.class, "value", element.getAnnotationMirrors()));
            Element enclosingElement = element.getEnclosingElement();
            if (enclosingElement == null || element instanceof PackageElement) break;
            element = enclosingElement;
        }
    }

    @Nullable
    public ValueAttribute getIdAttribute() {
        for (ValueAttribute attribute : this.getImplementedAttributes()) {
            if (!attribute.isIdAttribute()) continue;
            return attribute;
        }
        return null;
    }

    public Set<String> getGenerateMarshaledTypes() {
        if (this.generateMarshaledTypes == null) {
            LinkedHashSet<String> marshaledTypes = Sets.newLinkedHashSet();
            for (ValueAttribute a : this.attributes()) {
                marshaledTypes.addAll(a.getSpecialMarshaledTypes());
            }
            this.generateMarshaledTypes = marshaledTypes;
        }
        return this.generateMarshaledTypes;
    }

    public boolean isUseReferenceEquality() {
        if (this.isAnnotationType()) {
            return false;
        }
        return this.isUseInterned() || this.isGenerateOrdinalValue() || this.isUseSingletonOnly();
    }

    public boolean isUseSingletonOnly() {
        return this.isUseSingleton() && !this.isUseConstructor() && !this.isUseBuilder();
    }

    private List<String> extractClassNamesFromMirrors(Class<?> annotationType, String annotationValueName, List<? extends AnnotationMirror> annotationMirrors) {
        return FluentIterable.from(ValueType.extractedTypesFromAnnotationMirrors(annotationType.getCanonicalName(), annotationValueName, annotationMirrors)).transform(Functions.toStringFunction()).toList();
    }

    public static Iterable<DeclaredType> extractedTypesFromAnnotationMirrors(String annotationTypeName, String annotationValueName, List<? extends AnnotationMirror> annotationMirrors) {
        final ArrayList<DeclaredType> collectTypes = Lists.newArrayList();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotationTypeName)) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
                if (!e.getKey().getSimpleName().contentEquals(annotationValueName)) continue;
                e.getValue().accept(new SimpleAnnotationValueVisitor7<Void, Void>(){

                    @Override
                    public Void visitArray(List<? extends AnnotationValue> vals, Void p) {
                        for (AnnotationValue annotationValue : vals) {
                            annotationValue.accept(this, p);
                        }
                        return null;
                    }

                    @Override
                    public Void visitType(TypeMirror t, Void p) {
                        if (t instanceof DeclaredType) {
                            collectTypes.add((DeclaredType)t);
                        }
                        return null;
                    }
                }, null);
            }
        }
        return collectTypes;
    }

    public List<ValueAttribute> getSettableAttributes() {
        return this.attributes().filter(Predicates.or(ValueAttributeFunctions.isGenerateAbstract(), ValueAttributeFunctions.isGenerateDefault())).toList();
    }

    public boolean isUseConstructor() {
        return !this.getConstructorArguments().isEmpty() || !this.isUseBuilder() && !this.isUseSingleton() && this.getImplementedAttributes().isEmpty();
    }

    public List<ValueAttribute> getConstructorArguments() {
        return this.attributes().filter(Predicates.compose(Predicates.not(Predicates.equalTo(-1)), ToConstructorArgumentOrder.FUNCTION)).toSortedList(Ordering.natural().onResultOf(ToConstructorArgumentOrder.FUNCTION));
    }

    public List<ValueAttribute> getConstructorOmited() {
        return FluentIterable.from(this.getImplementedAttributes()).filter(Predicates.compose(Predicates.equalTo(-1), ToConstructorArgumentOrder.FUNCTION)).toList();
    }

    public List<ValueAttribute> getExcludableAttributes() {
        ArrayList<ValueAttribute> excludables = Lists.newArrayList();
        for (ValueAttribute attribute : this.attributes()) {
            if (!attribute.isGenerateAbstract || !attribute.isContainerType() || attribute.isArrayType()) continue;
            excludables.add(attribute);
        }
        return excludables;
    }

    public List<ValueAttribute> mandatoryAttributes() {
        ArrayList<ValueAttribute> mandatory = Lists.newArrayList();
        for (ValueAttribute attribute : this.getSettableAttributes()) {
            if (!attribute.isMandatory()) continue;
            mandatory.add(attribute);
        }
        return mandatory;
    }

    public List<ValueAttribute> getLazyAttributes() {
        ArrayList<ValueAttribute> lazyAttributes = Lists.newArrayList();
        for (ValueAttribute attribute : this.attributes()) {
            if (!attribute.isGenerateLazy) continue;
            lazyAttributes.add(attribute);
        }
        return lazyAttributes;
    }

    public List<ValueAttribute> getAllAccessibleAttributes() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.getImplementedAttributes())).addAll(this.getLazyAttributes())).build();
    }

    private FluentIterable<ValueAttribute> attributes() {
        return FluentIterable.from(this.attributes);
    }

    public List<ValueAttribute> getMarshaledAttributes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ValueAttribute attribute : this.getImplementedAttributes()) {
            if (attribute.isJsonIgnore()) continue;
            builder.add(attribute);
        }
        return builder.build();
    }

    public List<ValueAttribute> getUnmarshaledAttributes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ValueAttribute attribute : this.getSettableAttributes()) {
            if (attribute.isJsonIgnore()) continue;
            builder.add(attribute);
        }
        return builder.build();
    }

    public List<ValueAttribute> getPrimitiveDefaultAttributes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ValueAttribute attribute : this.getSettableAttributes()) {
            if (!attribute.isPrimitive() || !attribute.isGenerateDefault) continue;
            builder.add(attribute);
        }
        return builder.build();
    }

    public List<ValueAttribute> getDefaultAttributes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ValueAttribute attribute : this.getImplementedAttributes()) {
            if (!attribute.isGenerateDefault) continue;
            builder.add(attribute);
        }
        return builder.build();
    }

    public List<ValueAttribute> getImplementedAttributes() {
        if (this.implementedAttributes == null) {
            this.implementedAttributes = this.attributes().filter(Predicates.or(Arrays.asList(ValueAttributeFunctions.isGenerateAbstract(), ValueAttributeFunctions.isGenerateDefault(), ValueAttributeFunctions.isGenerateDerived()))).toList();
        }
        return this.implementedAttributes;
    }

    public List<ValueAttribute> getEquivalenceAttributes() {
        return FluentIterable.from(this.getImplementedAttributes()).filter(NonAuxiliary.PREDICATE).toList();
    }

    public boolean hasSingleParameterConstructor() {
        return this.isUseConstructor() && this.getConstructorArguments().size() == 1;
    }

    @Override
    protected TypeMirror internalTypeMirror() {
        return this.element.asType();
    }

    public boolean isUseListUtility() {
        return this.useCollectionUtility(new KindPredicate(AttributeTypeKind.LIST));
    }

    public boolean isUseSetUtility() {
        return this.useCollectionUtility(new KindPredicate(AttributeTypeKind.SET));
    }

    public boolean isUseEnumSetUtility() {
        return this.useCollectionUtility(new KindPredicate(AttributeTypeKind.ENUM_SET));
    }

    public boolean isUseSortedSetUtility() {
        return this.useCollectionUtility(new KindPredicate(AttributeTypeKind.SORTED_SET));
    }

    public boolean isUseMapUtility() {
        return this.useCollectionUtility(new KindPredicate(AttributeTypeKind.MAP));
    }

    public boolean isUseEnumMapUtility() {
        return this.useCollectionUtility(new KindPredicate(AttributeTypeKind.ENUM_MAP));
    }

    public boolean isUseSortedMapUtility() {
        return this.useCollectionUtility(new KindPredicate(AttributeTypeKind.SORTED_MAP));
    }

    private boolean useCollectionUtility(Predicate<ValueAttribute> predicate) {
        for (ValueType n : this.nested) {
            if (!Iterables.any(n.getSettableAttributes(), predicate)) continue;
            return true;
        }
        return Iterables.any(this.getSettableAttributes(), predicate);
    }

    public boolean hasCollectionAttribute() {
        for (ValueAttribute attribute : this.getSettableAttributes()) {
            if (!attribute.isCollectionType() && !attribute.isMapLike()) continue;
            return true;
        }
        return false;
    }

    public boolean isUseCollectionUtility() {
        for (ValueType n : this.nested) {
            if (!n.hasCollectionAttribute()) continue;
            return true;
        }
        return this.hasCollectionAttribute();
    }

    public int hashCode() {
        return 31 * this.constitution.protoclass().sourceQualifedName().hashCode();
    }

    public String toString() {
        return "Value[" + this.name() + "]";
    }

    private static class KindPredicate
    implements Predicate<ValueAttribute> {
        private final AttributeTypeKind kind;

        KindPredicate(AttributeTypeKind kind) {
            this.kind = kind;
        }

        @Override
        public boolean apply(ValueAttribute attribute) {
            return attribute.typeKind() == this.kind;
        }
    }

    private static enum ToConstructorArgumentOrder implements Function<ValueAttribute, Integer>
    {
        FUNCTION;


        @Override
        public Integer apply(ValueAttribute input) {
            return input.getConstructorParameterOrder();
        }
    }

    private static enum NonAuxiliary implements Predicate<ValueAttribute>
    {
        PREDICATE;


        @Override
        public boolean apply(ValueAttribute input) {
            return !input.isAuxiliary();
        }
    }
}

