/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.generator;

import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import org.immutables.value.internal.google.common.base.Preconditions;
import org.immutables.value.internal.google.common.base.Supplier;
import org.immutables.value.internal.google.common.collect.ClassToInstanceMap;
import org.immutables.value.internal.google.common.collect.ImmutableSet;
import org.immutables.value.internal.google.common.collect.MutableClassToInstanceMap;

final class StaticEnvironment {
    private static ClassToInstanceMap<Completable> components;
    private static ProcessingEnvironment processing;
    private static RoundEnvironment round;
    private static Set<TypeElement> annotations;
    private static boolean initialized;

    private StaticEnvironment() {
    }

    static <T extends Completable> T getInstance(Class<T> type, Supplier<T> supplier) {
        StaticEnvironment.checkInitialized();
        Completable instance = (Completable)components.getInstance(type);
        if (instance == null) {
            instance = (Completable)supplier.get();
            components.putInstance(type, instance);
        }
        return (T)instance;
    }

    static ProcessingEnvironment processing() {
        StaticEnvironment.checkInitialized();
        return processing;
    }

    static RoundEnvironment round() {
        StaticEnvironment.checkInitialized();
        return round;
    }

    static Set<TypeElement> annotations() {
        StaticEnvironment.checkInitialized();
        return annotations;
    }

    private static void checkInitialized() {
        Preconditions.checkState(initialized, "Static environment should be initialized");
    }

    static void shutdown() throws Exception {
        for (Completable component : components.values()) {
            component.complete();
        }
        components = null;
        processing = null;
        round = null;
        annotations = null;
        initialized = false;
    }

    static void init(Set<? extends TypeElement> annotations, RoundEnvironment round, ProcessingEnvironment processing) {
        components = MutableClassToInstanceMap.create();
        StaticEnvironment.processing = processing;
        StaticEnvironment.round = round;
        StaticEnvironment.annotations = ImmutableSet.copyOf(annotations);
        initialized = true;
    }

    static interface Completable {
        public void complete();
    }
}

