/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.google.common.collect;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.immutables.value.internal.google.common.annotations.GwtCompatible;
import org.immutables.value.internal.google.common.base.Preconditions;
import org.immutables.value.internal.google.common.collect.ForwardingCollection;
import org.immutables.value.internal.google.common.collect.Sets;

@GwtCompatible
public abstract class ForwardingSet<E>
extends ForwardingCollection<E>
implements Set<E> {
    protected ForwardingSet() {
    }

    @Override
    protected abstract Set<E> delegate();

    @Override
    public boolean equals(@Nullable Object object) {
        return object == this || this.delegate().equals(object);
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    @Override
    protected boolean standardRemoveAll(Collection<?> collection) {
        return Sets.removeAllImpl(this, Preconditions.checkNotNull(collection));
    }

    protected boolean standardEquals(@Nullable Object object) {
        return Sets.equalsImpl(this, object);
    }

    protected int standardHashCode() {
        return Sets.hashCodeImpl(this);
    }
}

