/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.google.common.util.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.immutables.value.internal.google.common.annotations.Beta;

@Beta
public interface Service {
    public Service startAsync();

    public boolean isRunning();

    public State state();

    public Service stopAsync();

    public void awaitRunning();

    public void awaitRunning(long var1, TimeUnit var3) throws TimeoutException;

    public void awaitTerminated();

    public void awaitTerminated(long var1, TimeUnit var3) throws TimeoutException;

    public Throwable failureCause();

    public void addListener(Listener var1, Executor var2);

    @Beta
    public static abstract class Listener {
        public void starting() {
        }

        public void running() {
        }

        public void stopping(State from) {
        }

        public void terminated(State from) {
        }

        public void failed(State from, Throwable failure) {
        }
    }

    @Beta
    public static enum State {
        NEW{

            @Override
            boolean isTerminal() {
                return false;
            }
        }
        ,
        STARTING{

            @Override
            boolean isTerminal() {
                return false;
            }
        }
        ,
        RUNNING{

            @Override
            boolean isTerminal() {
                return false;
            }
        }
        ,
        STOPPING{

            @Override
            boolean isTerminal() {
                return false;
            }
        }
        ,
        TERMINATED{

            @Override
            boolean isTerminal() {
                return true;
            }
        }
        ,
        FAILED{

            @Override
            boolean isTerminal() {
                return true;
            }
        };


        abstract boolean isTerminal();
    }
}

