/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.immutables.value.Value;
import org.immutables.value.internal.generator.SourceOrdering;
import org.immutables.value.internal.google.common.collect.Lists;
import org.immutables.value.internal.processor.meta.Proto;
import org.immutables.value.internal.processor.meta.Reporter;
import org.immutables.value.internal.processor.meta.Round;
import org.immutables.value.internal.processor.meta.Styles;
import org.immutables.value.internal.processor.meta.ValueAttribute;
import org.immutables.value.internal.processor.meta.ValueType;

final class AccessorAttributesCollector {
    private static final int USEFUL_PARAMETER_COUNT_LIMIT = 120;
    private static final String ORDINAL_VALUE_TYPE = "org.immutables.common.collect.OrdinalValue";
    private static final String EQUALS_METHOD = "equals";
    private static final String TO_STRING_METHOD = "toString";
    private static final String HASH_CODE_METHOD = "hashCode";
    private final Proto.Protoclass protoclass;
    private final ValueType type;
    private final ProcessingEnvironment processing;
    private final List<ValueAttribute> attributes = Lists.newArrayList();
    private final Styles styles;
    private final Reporter reporter;
    private final Round round;

    AccessorAttributesCollector(Round round, Proto.Protoclass protoclass, ValueType type) {
        this.round = round;
        this.protoclass = protoclass;
        this.processing = protoclass.processing();
        this.styles = protoclass.styles();
        this.type = type;
        this.reporter = protoclass.report();
    }

    void collect() {
        this.collectGeneratedCandidateMethods((TypeElement)this.type.element);
        if (this.attributes.size() > 120) {
            ArrayList<ValueAttribute> list = Lists.newArrayListWithCapacity(120);
            list.addAll(this.attributes);
            this.attributes.clear();
            this.attributes.addAll(list);
            this.protoclass.report().error("Value objects with more than %d attributes (including inherited) are not supported. Please decompose '%s' class into a smaller ones", 120, this.protoclass.sourceQualifedName());
        }
        for (ValueAttribute attribute : this.attributes) {
            attribute.initAndValidate();
        }
        this.type.attributes.addAll(this.attributes);
    }

    private void collectGeneratedCandidateMethods(TypeElement type) {
        for (Element element : this.getAccessorsInSourceOrder(type)) {
            if (!this.isElegibleAccessorMethod(element)) continue;
            this.processGenerationCandidateMethod((ExecutableElement)element);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(type.getEnclosedElements())) {
            switch (executableElement.getSimpleName().toString()) {
                case "equals": 
                case "hashCode": 
                case "toString": {
                    this.processGenerationCandidateMethod(executableElement);
                    break;
                }
            }
        }
    }

    private List<? extends Element> getAccessorsInSourceOrder(TypeElement type) {
        return type.getKind() == ElementKind.ANNOTATION_TYPE ? SourceOrdering.getEnclosedElements(type) : SourceOrdering.getAllAccessors(this.processing.getElementUtils(), type);
    }

    private boolean isElegibleAccessorMethod(Element element) {
        if (element.getKind() != ElementKind.METHOD) {
            return false;
        }
        if (element.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        switch (element.getSimpleName().toString()) {
            case "hashCode": 
            case "toString": {
                return false;
            }
        }
        String definitionType = element.getEnclosingElement().toString();
        if (definitionType.equals(Object.class.getName())) {
            return false;
        }
        return !definitionType.startsWith(ORDINAL_VALUE_TYPE);
    }

    private void processGenerationCandidateMethod(ExecutableElement attributeMethodCandidate) {
        Name name = attributeMethodCandidate.getSimpleName();
        List<? extends VariableElement> parameters = attributeMethodCandidate.getParameters();
        if (name.contentEquals(EQUALS_METHOD) && parameters.size() == 1 && parameters.get(0).asType().toString().equals(Object.class.getName()) && !attributeMethodCandidate.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.type.isEqualToDefined = true;
            return;
        }
        if (name.contentEquals(HASH_CODE_METHOD) && parameters.isEmpty() && !attributeMethodCandidate.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.type.isHashCodeDefined = true;
            return;
        }
        if (name.contentEquals(TO_STRING_METHOD) && parameters.isEmpty() && !attributeMethodCandidate.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.type.isToStringDefined = true;
            return;
        }
        Value.Check validateAnnotation = attributeMethodCandidate.getAnnotation(Value.Check.class);
        if (validateAnnotation != null) {
            if (!(attributeMethodCandidate.getReturnType().getKind() != TypeKind.VOID || !attributeMethodCandidate.getParameters().isEmpty() || attributeMethodCandidate.getModifiers().contains((Object)Modifier.PRIVATE) || attributeMethodCandidate.getModifiers().contains((Object)Modifier.ABSTRACT) || attributeMethodCandidate.getModifiers().contains((Object)Modifier.STATIC) || attributeMethodCandidate.getModifiers().contains((Object)Modifier.NATIVE))) {
                this.type.validationMethodName = attributeMethodCandidate.getSimpleName().toString();
            } else {
                this.report(attributeMethodCandidate).error("Method '%s' annotated with @%s must be non-private parameter-less method and have void return type.", attributeMethodCandidate.getSimpleName(), Value.Check.class.getSimpleName());
            }
        }
        if (AccessorAttributesCollector.isDiscoveredAttribute(attributeMethodCandidate)) {
            TypeMirror returnType = attributeMethodCandidate.getReturnType();
            ValueAttribute attribute = new ValueAttribute();
            boolean isFinal = AccessorAttributesCollector.isFinal(attributeMethodCandidate);
            boolean isAbstract = AccessorAttributesCollector.isAbstract(attributeMethodCandidate);
            boolean defaultAnnotationPresent = AccessorAttributesCollector.hasAnnotation(attributeMethodCandidate, Value.Default.class);
            boolean derivedAnnotationPresent = AccessorAttributesCollector.hasAnnotation(attributeMethodCandidate, Value.Derived.class);
            if (isAbstract) {
                attribute.isGenerateAbstract = true;
                if (attributeMethodCandidate.getDefaultValue() != null) {
                    attribute.isGenerateDefault = true;
                } else if (defaultAnnotationPresent) {
                    this.report(attributeMethodCandidate).forAnnotation(Value.Default.class).error("@Value.Default should have initializer body", name);
                } else if (derivedAnnotationPresent) {
                    this.report(attributeMethodCandidate).forAnnotation(Value.Derived.class).error("@Value.Derived should have initializer body", name);
                }
            } else if (defaultAnnotationPresent && derivedAnnotationPresent) {
                this.report(attributeMethodCandidate).forAnnotation(Value.Derived.class).error("Attribute '%s' cannot be both @Value.Default and @Value.Derived", name);
                attribute.isGenerateDefault = true;
                attribute.isGenerateDerived = false;
            } else if ((defaultAnnotationPresent || derivedAnnotationPresent) && isFinal) {
                this.report(attributeMethodCandidate).error("Annotated attribute '%s' will be overriden and cannot be final", name);
            } else if (defaultAnnotationPresent) {
                attribute.isGenerateDefault = true;
            } else if (derivedAnnotationPresent) {
                attribute.isGenerateDerived = true;
            }
            if (AccessorAttributesCollector.hasAnnotation(attributeMethodCandidate, Value.Lazy.class)) {
                if (isAbstract || isFinal) {
                    this.report(attributeMethodCandidate).error("@Value.Lazy attribute '%s' must be non abstract and non-final", name);
                } else if (defaultAnnotationPresent || derivedAnnotationPresent) {
                    this.report(attributeMethodCandidate).error("@Value.Lazy attribute '%s' cannot be @Value.Derived or @Value.Default", name);
                } else {
                    attribute.isGenerateLazy = true;
                }
            }
            attribute.reporter = this.reporter;
            attribute.round = this.round;
            attribute.returnTypeName = returnType.toString();
            attribute.returnType = returnType;
            attribute.names = this.styles.forAccessor(name.toString());
            attribute.element = attributeMethodCandidate;
            this.attributes.add(attribute);
        }
    }

    private static boolean isAbstract(Element element) {
        return element.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    private static boolean isFinal(Element element) {
        return element.getModifiers().contains((Object)Modifier.FINAL);
    }

    private static boolean isDiscoveredAttribute(ExecutableElement attributeMethodCandidate) {
        return attributeMethodCandidate.getParameters().isEmpty() && attributeMethodCandidate.getReturnType().getKind() != TypeKind.VOID && (AccessorAttributesCollector.isAbstract(attributeMethodCandidate) || AccessorAttributesCollector.hasGenerateAnnotation(attributeMethodCandidate));
    }

    private static boolean hasGenerateAnnotation(ExecutableElement attributeMethodCandidate) {
        return AccessorAttributesCollector.hasAnnotation(attributeMethodCandidate, Value.Default.class) || AccessorAttributesCollector.hasAnnotation(attributeMethodCandidate, Value.Derived.class) || AccessorAttributesCollector.hasAnnotation(attributeMethodCandidate, Value.Lazy.class);
    }

    private static boolean hasAnnotation(Element element, Class<? extends Annotation> annotationType) {
        return element.getAnnotation(annotationType) != null;
    }

    private Reporter report(Element type) {
        return Reporter.from(this.protoclass.processing()).withElement(type);
    }
}

