/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.immutables.value.internal.generator.AnnotationMirrors;
import org.immutables.value.internal.google.common.collect.Lists;

final class AnnotationPrinting {
    private static final String PREFIX_JAVA_LANG = "@java.lang.";
    private static final String PREFIX_ORG_IMMUTABLES = "@org.immutables.";

    private AnnotationPrinting() {
    }

    static List<CharSequence> getAnnotationLines(Element element) {
        ArrayList<CharSequence> lines = Lists.newArrayList();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String string = annotationMirror.toString();
            if (string.startsWith(PREFIX_ORG_IMMUTABLES) || string.startsWith(PREFIX_JAVA_LANG)) continue;
            lines.add(AnnotationMirrors.toCharSequence(annotationMirror));
        }
        return lines;
    }
}

