/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.internal.google.common.base.MoreObjects;
import org.immutables.value.internal.google.common.base.Preconditions;
import org.immutables.value.internal.google.common.primitives.Booleans;
import org.immutables.value.internal.processor.meta.Constitution;
import org.immutables.value.internal.processor.meta.Proto;
import org.immutables.value.internal.processor.meta.Styles;
import org.immutables.value.internal.processor.meta.Visibility;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableConstitution
extends Constitution {
    private final Proto.Protoclass protoclass;
    private final Visibility implementationVisibility;
    private final Styles.UsingName.TypeNames names;
    private final boolean hasImmutableInBuilder;
    @GuardedBy(value="this")
    private volatile long lazyInitBitmap0;
    private static final long TYPE_VALUE_LAZY_INIT_BIT = 1L;
    @GuardedBy(value="this")
    private Constitution.NameForms typeValue;
    private static final long TYPE_ABSTRACT_LAZY_INIT_BIT = 2L;
    @GuardedBy(value="this")
    private Constitution.NameForms typeAbstract;
    private static final long TYPE_IMMUTABLE_LAZY_INIT_BIT = 4L;
    @GuardedBy(value="this")
    private Constitution.NameForms typeImmutable;
    private static final long TYPE_IMMUTABLE_ENCLOSING_SIMPLE_NAME_LAZY_INIT_BIT = 8L;
    @GuardedBy(value="this")
    private String typeImmutableEnclosingSimpleName;
    private static final long FACTORY_BUILDER_LAZY_INIT_BIT = 16L;
    @GuardedBy(value="this")
    private Constitution.NameForms factoryBuilder;
    private static final long FACTORY_OF_LAZY_INIT_BIT = 32L;
    @GuardedBy(value="this")
    private Constitution.NameForms factoryOf;
    private static final long FACTORY_INSTANCE_LAZY_INIT_BIT = 64L;
    @GuardedBy(value="this")
    private Constitution.NameForms factoryInstance;
    private static final long FACTORY_COPY_OF_LAZY_INIT_BIT = 128L;
    @GuardedBy(value="this")
    private Constitution.NameForms factoryCopyOf;
    private static final long TYPE_ENCLOSING_LAZY_INIT_BIT = 256L;
    @GuardedBy(value="this")
    private Constitution.NameForms typeEnclosing;
    private static final long TYPE_BUILDER_LAZY_INIT_BIT = 512L;
    @GuardedBy(value="this")
    private Constitution.NameForms typeBuilder;

    private static ImmutableConstitution checkPreconditions(ImmutableConstitution instance) {
        return instance;
    }

    public static ImmutableConstitution copyOf(Constitution instance) {
        if (instance instanceof ImmutableConstitution) {
            return (ImmutableConstitution)instance;
        }
        Preconditions.checkNotNull(instance);
        return ImmutableConstitution.builder().protoclass(instance.protoclass()).build();
    }

    @Deprecated
    public static ImmutableConstitution copyOf(ImmutableConstitution instance) {
        return Preconditions.checkNotNull(instance);
    }

    public static Builder builder() {
        return new Builder();
    }

    private ImmutableConstitution(Builder builder) {
        this.protoclass = builder.protoclass;
        this.implementationVisibility = Preconditions.checkNotNull(super.implementationVisibility());
        this.names = Preconditions.checkNotNull(super.names());
        this.hasImmutableInBuilder = super.hasImmutableInBuilder();
    }

    private ImmutableConstitution(ImmutableConstitution original, Proto.Protoclass protoclass, Visibility implementationVisibility, Styles.UsingName.TypeNames names, boolean hasImmutableInBuilder) {
        this.protoclass = protoclass;
        this.implementationVisibility = implementationVisibility;
        this.names = names;
        this.hasImmutableInBuilder = hasImmutableInBuilder;
    }

    public final ImmutableConstitution withProtoclass(Proto.Protoclass value) {
        if (this.protoclass == value) {
            return this;
        }
        Proto.Protoclass newValue = Preconditions.checkNotNull(value);
        return ImmutableConstitution.checkPreconditions(new ImmutableConstitution(this, newValue, this.implementationVisibility, this.names, this.hasImmutableInBuilder));
    }

    @Override
    public Proto.Protoclass protoclass() {
        return this.protoclass;
    }

    @Override
    public Visibility implementationVisibility() {
        return this.implementationVisibility;
    }

    @Override
    public Styles.UsingName.TypeNames names() {
        return this.names;
    }

    @Override
    public boolean hasImmutableInBuilder() {
        return this.hasImmutableInBuilder;
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ImmutableConstitution && this.equalTo((ImmutableConstitution)another);
    }

    private boolean equalTo(ImmutableConstitution another) {
        return this.protoclass.equals(another.protoclass) && this.implementationVisibility.equals((Object)another.implementationVisibility) && this.names.equals(another.names) && this.hasImmutableInBuilder == another.hasImmutableInBuilder;
    }

    private int computeHashCode() {
        int h = 31;
        h = h * 17 + this.protoclass.hashCode();
        h = h * 17 + this.implementationVisibility.hashCode();
        h = h * 17 + this.names.hashCode();
        h = h * 17 + Booleans.hashCode(this.hasImmutableInBuilder);
        return h;
    }

    public int hashCode() {
        return this.computeHashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper("Constitution").omitNullValues().add("protoclass", this.protoclass).add("implementationVisibility", (Object)this.implementationVisibility).add("names", this.names).add("hasImmutableInBuilder", this.hasImmutableInBuilder).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.NameForms typeValue() {
        if ((this.lazyInitBitmap0 & 1L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap0 & 1L) == 0L) {
                    this.typeValue = Preconditions.checkNotNull(super.typeValue());
                    this.lazyInitBitmap0 |= 1L;
                }
            }
        }
        return this.typeValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.NameForms typeAbstract() {
        if ((this.lazyInitBitmap0 & 2L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap0 & 2L) == 0L) {
                    this.typeAbstract = Preconditions.checkNotNull(super.typeAbstract());
                    this.lazyInitBitmap0 |= 2L;
                }
            }
        }
        return this.typeAbstract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.NameForms typeImmutable() {
        if ((this.lazyInitBitmap0 & 4L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap0 & 4L) == 0L) {
                    this.typeImmutable = Preconditions.checkNotNull(super.typeImmutable());
                    this.lazyInitBitmap0 |= 4L;
                }
            }
        }
        return this.typeImmutable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String typeImmutableEnclosingSimpleName() {
        if ((this.lazyInitBitmap0 & 8L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap0 & 8L) == 0L) {
                    this.typeImmutableEnclosingSimpleName = Preconditions.checkNotNull(super.typeImmutableEnclosingSimpleName());
                    this.lazyInitBitmap0 |= 8L;
                }
            }
        }
        return this.typeImmutableEnclosingSimpleName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.NameForms factoryBuilder() {
        if ((this.lazyInitBitmap0 & 0x10L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap0 & 0x10L) == 0L) {
                    this.factoryBuilder = Preconditions.checkNotNull(super.factoryBuilder());
                    this.lazyInitBitmap0 |= 0x10L;
                }
            }
        }
        return this.factoryBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.NameForms factoryOf() {
        if ((this.lazyInitBitmap0 & 0x20L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap0 & 0x20L) == 0L) {
                    this.factoryOf = Preconditions.checkNotNull(super.factoryOf());
                    this.lazyInitBitmap0 |= 0x20L;
                }
            }
        }
        return this.factoryOf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.NameForms factoryInstance() {
        if ((this.lazyInitBitmap0 & 0x40L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap0 & 0x40L) == 0L) {
                    this.factoryInstance = Preconditions.checkNotNull(super.factoryInstance());
                    this.lazyInitBitmap0 |= 0x40L;
                }
            }
        }
        return this.factoryInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.NameForms factoryCopyOf() {
        if ((this.lazyInitBitmap0 & 0x80L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap0 & 0x80L) == 0L) {
                    this.factoryCopyOf = Preconditions.checkNotNull(super.factoryCopyOf());
                    this.lazyInitBitmap0 |= 0x80L;
                }
            }
        }
        return this.factoryCopyOf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.NameForms typeEnclosing() {
        if ((this.lazyInitBitmap0 & 0x100L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap0 & 0x100L) == 0L) {
                    this.typeEnclosing = Preconditions.checkNotNull(super.typeEnclosing());
                    this.lazyInitBitmap0 |= 0x100L;
                }
            }
        }
        return this.typeEnclosing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.NameForms typeBuilder() {
        if ((this.lazyInitBitmap0 & 0x200L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap0 & 0x200L) == 0L) {
                    this.typeBuilder = Preconditions.checkNotNull(super.typeBuilder());
                    this.lazyInitBitmap0 |= 0x200L;
                }
            }
        }
        return this.typeBuilder;
    }

    @Immutable
    public static final class NameForms
    extends Constitution.NameForms {
        private final String simple;
        private final String relative;
        private final String packageOf;
        private final Visibility visibility;
        private final boolean relativeAlreadyQualified;

        private static NameForms checkPreconditions(NameForms instance) {
            return instance;
        }

        public static NameForms copyOf(Constitution.NameForms instance) {
            if (instance instanceof NameForms) {
                return (NameForms)instance;
            }
            Preconditions.checkNotNull(instance);
            return NameForms.builder().simple(instance.simple()).relative(instance.relative()).packageOf(instance.packageOf()).visibility(instance.visibility()).relativeAlreadyQualified(instance.relativeAlreadyQualified()).build();
        }

        @Deprecated
        public static NameForms copyOf(NameForms instance) {
            return Preconditions.checkNotNull(instance);
        }

        public static Builder builder() {
            return new Builder();
        }

        private NameForms(Builder builder) {
            this.simple = builder.simple;
            this.relative = builder.relative;
            this.packageOf = builder.packageOf;
            this.visibility = builder.visibility;
            this.relativeAlreadyQualified = builder.relativeAlreadyQualifiedIsSet() ? builder.relativeAlreadyQualified : super.relativeAlreadyQualified();
        }

        private NameForms(NameForms original, String simple, String relative, String packageOf, Visibility visibility, boolean relativeAlreadyQualified) {
            this.simple = simple;
            this.relative = relative;
            this.packageOf = packageOf;
            this.visibility = visibility;
            this.relativeAlreadyQualified = relativeAlreadyQualified;
        }

        public final NameForms withSimple(String value) {
            if (this.simple == value) {
                return this;
            }
            String newValue = Preconditions.checkNotNull(value);
            return NameForms.checkPreconditions(new NameForms(this, newValue, this.relative, this.packageOf, this.visibility, this.relativeAlreadyQualified));
        }

        public final NameForms withRelative(String value) {
            if (this.relative == value) {
                return this;
            }
            String newValue = Preconditions.checkNotNull(value);
            return NameForms.checkPreconditions(new NameForms(this, this.simple, newValue, this.packageOf, this.visibility, this.relativeAlreadyQualified));
        }

        public final NameForms withPackageOf(String value) {
            if (this.packageOf == value) {
                return this;
            }
            String newValue = Preconditions.checkNotNull(value);
            return NameForms.checkPreconditions(new NameForms(this, this.simple, this.relative, newValue, this.visibility, this.relativeAlreadyQualified));
        }

        public final NameForms withVisibility(Visibility value) {
            if (this.visibility == value) {
                return this;
            }
            Visibility newValue = Preconditions.checkNotNull(value);
            return NameForms.checkPreconditions(new NameForms(this, this.simple, this.relative, this.packageOf, newValue, this.relativeAlreadyQualified));
        }

        public final NameForms withRelativeAlreadyQualified(boolean value) {
            if (this.relativeAlreadyQualified == value) {
                return this;
            }
            boolean newValue = value;
            return NameForms.checkPreconditions(new NameForms(this, this.simple, this.relative, this.packageOf, this.visibility, newValue));
        }

        @Override
        public String simple() {
            return this.simple;
        }

        @Override
        public String relative() {
            return this.relative;
        }

        @Override
        public String packageOf() {
            return this.packageOf;
        }

        @Override
        public Visibility visibility() {
            return this.visibility;
        }

        @Override
        public boolean relativeAlreadyQualified() {
            return this.relativeAlreadyQualified;
        }

        public boolean equals(@Nullable Object another) {
            return this == another || another instanceof NameForms && this.equalTo((NameForms)another);
        }

        private boolean equalTo(NameForms another) {
            return this.simple.equals(another.simple) && this.relative.equals(another.relative) && this.packageOf.equals(another.packageOf) && this.visibility.equals((Object)another.visibility) && this.relativeAlreadyQualified == another.relativeAlreadyQualified;
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.simple.hashCode();
            h = h * 17 + this.relative.hashCode();
            h = h * 17 + this.packageOf.hashCode();
            h = h * 17 + this.visibility.hashCode();
            h = h * 17 + Booleans.hashCode(this.relativeAlreadyQualified);
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long NONDEFAULT_BIT_RELATIVE_ALREADY_QUALIFIED = 1L;
            private static final long INITIALIZED_BITSET_ALL_0 = 15L;
            private static final long INITIALIZED_BIT_SIMPLE = 1L;
            private static final long INITIALIZED_BIT_RELATIVE = 2L;
            private static final long INITIALIZED_BIT_PACKAGE_OF = 4L;
            private static final long INITIALIZED_BIT_VISIBILITY = 8L;
            private long nondefaultBitset0;
            private long initializedBitset0;
            @Nullable
            private String simple;
            @Nullable
            private String relative;
            @Nullable
            private String packageOf;
            @Nullable
            private Visibility visibility;
            private boolean relativeAlreadyQualified;

            private Builder() {
            }

            public final Builder simple(String simple) {
                this.simple = Preconditions.checkNotNull(simple);
                this.initializedBitset0 |= 1L;
                return this;
            }

            public final Builder relative(String relative) {
                this.relative = Preconditions.checkNotNull(relative);
                this.initializedBitset0 |= 2L;
                return this;
            }

            public final Builder packageOf(String packageOf) {
                this.packageOf = Preconditions.checkNotNull(packageOf);
                this.initializedBitset0 |= 4L;
                return this;
            }

            public final Builder visibility(Visibility visibility) {
                this.visibility = Preconditions.checkNotNull(visibility);
                this.initializedBitset0 |= 8L;
                return this;
            }

            public final Builder relativeAlreadyQualified(boolean relativeAlreadyQualified) {
                this.relativeAlreadyQualified = relativeAlreadyQualified;
                this.nondefaultBitset0 |= 1L;
                return this;
            }

            public NameForms build() {
                this.checkRequiredAttributes();
                return NameForms.checkPreconditions(new NameForms(this));
            }

            private boolean relativeAlreadyQualifiedIsSet() {
                return (this.nondefaultBitset0 & 1L) != 0L;
            }

            private boolean simpleIsSet() {
                return (this.initializedBitset0 & 1L) != 0L;
            }

            private boolean relativeIsSet() {
                return (this.initializedBitset0 & 2L) != 0L;
            }

            private boolean packageOfIsSet() {
                return (this.initializedBitset0 & 4L) != 0L;
            }

            private boolean visibilityIsSet() {
                return (this.initializedBitset0 & 8L) != 0L;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset0 != 15L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
            }

            private String formatRequiredAttributesMessage() {
                return MoreObjects.toStringHelper("Cannot build NameForms, some of required attributes are not set ").omitNullValues().addValue(!this.simpleIsSet() ? "simple" : null).addValue(!this.relativeIsSet() ? "relative" : null).addValue(!this.packageOfIsSet() ? "packageOf" : null).addValue(!this.visibilityIsSet() ? "visibility" : null).toString();
            }

            public String toString() {
                return MoreObjects.toStringHelper("ImmutableConstitution.NameForms.Builder").omitNullValues().add("simple", this.simple).add("relative", this.relative).add("packageOf", this.packageOf).add("visibility", (Object)this.visibility).add("relativeAlreadyQualified", this.relativeAlreadyQualifiedIsSet() ? Boolean.valueOf(this.relativeAlreadyQualified) : null).toString();
            }
        }
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL_0 = 1L;
        private static final long INITIALIZED_BIT_PROTOCLASS = 1L;
        private long initializedBitset0;
        @Nullable
        private Proto.Protoclass protoclass;

        private Builder() {
        }

        public final Builder protoclass(Proto.Protoclass protoclass) {
            this.protoclass = Preconditions.checkNotNull(protoclass);
            this.initializedBitset0 |= 1L;
            return this;
        }

        public ImmutableConstitution build() {
            this.checkRequiredAttributes();
            return ImmutableConstitution.checkPreconditions(new ImmutableConstitution(this));
        }

        private boolean protoclassIsSet() {
            return (this.initializedBitset0 & 1L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset0 != 1L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            return MoreObjects.toStringHelper("Cannot build Constitution, some of required attributes are not set ").omitNullValues().addValue(!this.protoclassIsSet() ? "protoclass" : null).toString();
        }

        public String toString() {
            return MoreObjects.toStringHelper("ImmutableConstitution.Builder").omitNullValues().add("protoclass", this.protoclass).toString();
        }
    }
}

