/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.Value;
import org.immutables.value.internal.generator.AnnotationMirrors;
import org.immutables.value.internal.google.common.base.Function;
import org.immutables.value.internal.google.common.base.Joiner;
import org.immutables.value.internal.google.common.base.Optional;
import org.immutables.value.internal.google.common.base.Predicate;
import org.immutables.value.internal.google.common.collect.FluentIterable;
import org.immutables.value.internal.google.common.collect.ImmutableList;
import org.immutables.value.internal.google.common.collect.ImmutableSet;
import org.immutables.value.internal.processor.meta.ImmutableProto;
import org.immutables.value.internal.processor.meta.Reporter;
import org.immutables.value.internal.processor.meta.Styles;
import org.immutables.value.internal.processor.meta.ValueType;
import org.immutables.value.internal.processor.meta.ValueTypeComposer;
import org.immutables.value.internal.processor.meta.Visibility;

public class Proto {
    private Proto() {
    }

    static enum IsPublic implements Predicate<Element>
    {
        PREDICATE;


        @Override
        public boolean apply(Element input) {
            return input.getModifiers().contains((Object)Modifier.PUBLIC);
        }
    }

    static enum DeclatedTypeToElement implements Function<DeclaredType, TypeElement>
    {
        FUNCTION;


        @Override
        public TypeElement apply(DeclaredType input) {
            return (TypeElement)input.asElement();
        }
    }

    static enum ElementToName implements Function<TypeElement, String>
    {
        FUNCTION;


        @Override
        public String apply(TypeElement input) {
            return input.getQualifiedName().toString();
        }
    }

    public static abstract class Protoclass
    extends Diagnosable {
        public abstract Element sourceElement();

        public abstract DeclaringPackage packageOf();

        public abstract Optional<DeclaringType> declaringType();

        public abstract Kind kind();

        public abstract ValueTypeComposer composer();

        public Visibility visibility() {
            return Visibility.of(this.sourceElement());
        }

        public Visibility declaringVisibility() {
            if (this.declaringType().isPresent()) {
                return Visibility.of(this.declaringType().get().element());
            }
            return Visibility.PUBLIC;
        }

        @Override
        public Element element() {
            if (this.kind().isFactory()) {
                return this.sourceElement();
            }
            if (this.declaringType().isPresent()) {
                return this.declaringType().get().element();
            }
            return this.packageOf().element();
        }

        @Nullable
        public Value.Immutable features() {
            if (this.declaringType().isPresent() && !this.declaringType().get().useImmutableDefaults()) {
                return this.declaringType().get().features();
            }
            return this.styles().defaults();
        }

        public Styles styles() {
            Value.Style packageStyle;
            if (this.declaringType().isPresent()) {
                Optional<DeclaringType> enclosing = this.enclosingOf();
                if (enclosing.isPresent()) {
                    Value.Style enclosingStyle = enclosing.get().style();
                    if (enclosingStyle != null) {
                        return Styles.using(enclosingStyle);
                    }
                } else {
                    Value.Style style = this.declaringType().get().style();
                    if (style != null) {
                        return Styles.using(style);
                    }
                }
            }
            if ((packageStyle = this.packageOf().style()) != null) {
                return Styles.using(packageStyle);
            }
            return Styles.using(Styles.defaultStyle());
        }

        public Optional<DeclaringType> enclosingOf() {
            if (this.declaringType().isPresent()) {
                if (this.kind().isFactory()) {
                    return this.declaringType();
                }
                if (this.kind().isNested()) {
                    if (this.kind().isIncluded()) {
                        return this.declaringType();
                    }
                    return this.declaringType().get().enclosingOf();
                }
            }
            return Optional.absent();
        }

        public ValueType type() {
            return this.composer().compose(this);
        }

        public String sourceQualifedName() {
            Element element = this.sourceElement();
            if (element instanceof TypeElement) {
                return ((TypeElement)element).getQualifiedName().toString();
            }
            Element enclosingElement = element.getEnclosingElement();
            if (enclosingElement instanceof TypeElement) {
                return Joiner.on('.').join(((TypeElement)element).getQualifiedName(), element.getSimpleName(), new Object[0]);
            }
            return element.getSimpleName().toString();
        }

        Styles.UsingName.TypeNames createTypeNames() {
            return this.styles().forType(this.sourceElement().getSimpleName().toString());
        }

        public static enum Kind {
            INCLUDED_IN_PACKAGE,
            INCLUDED_ON_TYPE,
            INCLUDED_IN_TYPE,
            DEFINED_FACTORY,
            DEFINED_TYPE,
            DEFINED_AND_ENCLOSING_TYPE,
            DEFINED_ENCLOSING_TYPE,
            DEFINED_NESTED_TYPE;


            public boolean isNested() {
                switch (this) {
                    case INCLUDED_IN_TYPE: 
                    case DEFINED_NESTED_TYPE: {
                        return true;
                    }
                }
                return false;
            }

            public boolean isIncluded() {
                switch (this) {
                    case INCLUDED_IN_TYPE: 
                    case INCLUDED_IN_PACKAGE: 
                    case INCLUDED_ON_TYPE: {
                        return true;
                    }
                }
                return false;
            }

            public boolean isEnclosing() {
                switch (this) {
                    case DEFINED_AND_ENCLOSING_TYPE: 
                    case DEFINED_ENCLOSING_TYPE: {
                        return true;
                    }
                }
                return false;
            }

            public boolean isValue() {
                switch (this) {
                    case INCLUDED_IN_TYPE: 
                    case DEFINED_NESTED_TYPE: 
                    case INCLUDED_IN_PACKAGE: 
                    case INCLUDED_ON_TYPE: 
                    case DEFINED_AND_ENCLOSING_TYPE: 
                    case DEFINED_TYPE: {
                        return true;
                    }
                }
                return false;
            }

            public boolean isDefinedValue() {
                switch (this) {
                    case DEFINED_NESTED_TYPE: 
                    case DEFINED_AND_ENCLOSING_TYPE: 
                    case DEFINED_TYPE: {
                        return true;
                    }
                }
                return false;
            }

            public boolean isFactory() {
                return this == DEFINED_FACTORY;
            }

            public boolean isEnclosingOnly() {
                return this == DEFINED_ENCLOSING_TYPE;
            }
        }
    }

    public static abstract class DeclaringType
    extends AbstractDeclaring {
        @Override
        public abstract TypeElement element();

        @Override
        public String name() {
            return this.element().getQualifiedName().toString();
        }

        @Override
        public boolean isTopLevel() {
            return this.element().getEnclosingElement().getKind() == ElementKind.PACKAGE;
        }

        public Optional<DeclaringType> enclosingOf() {
            ImmutableProto.DeclaringType enclosingType;
            TypeElement top = this.element();
            Element e = this.element();
            while (e.getKind() != ElementKind.PACKAGE) {
                top = e;
                e = e.getEnclosingElement();
            }
            if (top != this.element() && (enclosingType = ImmutableProto.DeclaringType.builder().processing(this.processing()).element(top).build()).isEnclosing()) {
                return Optional.of(enclosingType);
            }
            return Optional.absent();
        }

        public DeclaringPackage packageOf() {
            return ImmutableProto.DeclaringPackage.builder().processing(this.processing()).element(this.processing().getElementUtils().getPackageOf(this.element())).build();
        }

        public boolean verifiedFactory(ExecutableElement element) {
            if (element.getAnnotation(Value.Builder.class) == null) {
                return false;
            }
            if (!(this.isTopLevel() && !element.getModifiers().contains((Object)Modifier.PRIVATE) && element.getModifiers().contains((Object)Modifier.STATIC) && element.getThrownTypes().isEmpty() && element.getTypeParameters().isEmpty())) {
                this.report().withElement(element).forAnnotation(Value.Builder.class).error("@Value.Builder method '%s' should be static, non-private, with no type parameters or throws declaration, and enclosed in top level type", element.getSimpleName());
                return false;
            }
            return true;
        }
    }

    public static abstract class DeclaringPackage
    extends AbstractDeclaring {
        @Override
        public abstract PackageElement element();

        @Override
        public String name() {
            return this.element().isUnnamed() ? "" : this.element().getQualifiedName().toString();
        }

        public String asPrefix() {
            return this.element().isUnnamed() ? "" : this.name() + ".";
        }
    }

    public static abstract class AbstractDeclaring
    extends Diagnosable {
        public abstract String name();

        public List<TypeElement> includedTypes() {
            ImmutableList<TypeMirror> typeMirrors = AnnotationMirrors.getTypesFromMirrors(Value.Immutable.Include.class.getCanonicalName(), "value", this.element().getAnnotationMirrors());
            ImmutableSet<String> typeNames = FluentIterable.from(typeMirrors).filter(DeclaredType.class).transform(DeclatedTypeToElement.FUNCTION).filter(IsPublic.PREDICATE).transform(ElementToName.FUNCTION).toSet();
            if (typeNames.size() != typeMirrors.size()) {
                this.report().forAnnotation(Value.Immutable.Include.class).warning("Some types were ignored, non-supported for inclusion: duplicates, non reference types, non-public", new Object[0]);
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String typeName : typeNames) {
                builder.add(this.processing().getElementUtils().getTypeElement(typeName));
            }
            return builder.build();
        }

        public boolean useImmutableDefaults() {
            AnnotationMirror annotation = AnnotationMirrors.findAnnotation(this.element().getAnnotationMirrors(), Value.Immutable.class);
            if (annotation != null) {
                return annotation.getElementValues().isEmpty();
            }
            return true;
        }

        public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
            return AnnotationMirrors.isAnnotationPresent(this.element().getAnnotationMirrors(), annotationType);
        }

        public boolean hasInclude() {
            return AnnotationMirrors.isAnnotationPresent(this.element().getAnnotationMirrors(), Value.Immutable.Include.class);
        }

        public boolean isEnclosing() {
            return AnnotationMirrors.isAnnotationPresent(this.element().getAnnotationMirrors(), Value.Nested.class);
        }

        public boolean isTopLevel() {
            return this.element().getEnclosingElement() == null || this.element().getEnclosingElement().getKind() == ElementKind.PACKAGE;
        }

        @Nullable
        public Value.Immutable features() {
            return this.element().getAnnotation(Value.Immutable.class);
        }

        public boolean isImmutable() {
            return this.features() != null;
        }

        @Nullable
        public Value.Style style() {
            Value.Style style = this.element().getAnnotation(Value.Style.class);
            if (style != null) {
                return style;
            }
            for (AnnotationMirror annotationMirror : this.element().getAnnotationMirrors()) {
                MetaAnnotated metaAnnotated = MetaAnnotated.from(annotationMirror);
                Value.Style metaStyle = metaAnnotated.style();
                if (metaStyle == null) continue;
                return metaStyle;
            }
            return null;
        }

        protected void validate() {
            if (this.hasInclude() && !this.isTopLevel()) {
                this.report().forAnnotation(Value.Immutable.Include.class).error("@Include could not be used on nested types.", new Object[0]);
            }
            if (this.isEnclosing() && !this.isTopLevel()) {
                this.report().forAnnotation(Value.Nested.class).error("@Nested should only be used on a top-level types.", new Object[0]);
            }
            if (this.element().getKind() == ElementKind.ENUM) {
                this.report().error("@Value.* annotations are not supported on enums", new Object[0]);
            }
        }
    }

    static abstract class Diagnosable {
        Diagnosable() {
        }

        abstract Element element();

        abstract ProcessingEnvironment processing();

        protected Reporter report() {
            return Reporter.from(this.processing()).withElement(this.element());
        }
    }

    public static abstract class MetaAnnotated {
        public abstract String name();

        public abstract Element element();

        @Nullable
        public Value.Style style() {
            return this.element().getAnnotation(Value.Style.class);
        }

        public static MetaAnnotated from(AnnotationMirror mirror) {
            TypeElement element = (TypeElement)mirror.getAnnotationType().asElement();
            return ImmutableProto.MetaAnnotated.of(element.getQualifiedName().toString(), element);
        }
    }
}

