/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.util.Map;
import org.immutables.value.Value;
import org.immutables.value.internal.generator.Naming;
import org.immutables.value.internal.google.common.base.CaseFormat;
import org.immutables.value.internal.google.common.collect.Maps;

public final class Styles {
    private static final Map<Value.Style, Styles> cache = Maps.newHashMap();
    private final Value.Style style;
    private final Scheme scheme;

    public static Value.Style defaultStyle() {
        return DefaultStyle.style;
    }

    public static Styles using(Value.Style style) {
        Styles namings = cache.get(style);
        if (namings == null) {
            namings = new Styles(style);
            cache.put(style, namings);
        }
        return namings;
    }

    private Styles(Value.Style style) {
        this.style = style;
        this.scheme = new Scheme();
    }

    public Value.Immutable defaults() {
        return this.style.defaults();
    }

    public UsingName.TypeNames forType(String name) {
        return new UsingName(name, this.scheme, "").new UsingName.TypeNames();
    }

    public UsingName.AttributeNames forAccessorWithRaw(String name, String raw) {
        return new UsingName(name, this.scheme, raw).new UsingName.AttributeNames();
    }

    public UsingName.AttributeNames forAccessor(String name) {
        return this.forAccessorWithRaw(name, "");
    }

    public static class UsingName {
        private final String name;
        private final Scheme scheme;
        private final String forcedRaw;

        private UsingName(String name, Scheme scheme, String forcedRaw) {
            this.name = name;
            this.scheme = scheme;
            this.forcedRaw = forcedRaw;
        }

        private String detectRawFromGet() {
            if (!this.forcedRaw.isEmpty()) {
                return this.forcedRaw;
            }
            for (Naming naming : this.scheme.get) {
                String raw = naming.detect(this.name);
                if (raw.isEmpty()) continue;
                return raw;
            }
            return this.name;
        }

        private String detectRawFromAbstract() {
            if (!this.forcedRaw.isEmpty()) {
                return this.forcedRaw;
            }
            return this.detectRawFromAbstract(this.name);
        }

        String detectRawFromAbstract(String abstractName) {
            for (Naming naming : this.scheme.typeAbstract) {
                String raw = naming.detect(abstractName);
                if (raw.isEmpty()) continue;
                return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, raw);
            }
            return abstractName;
        }

        public class AttributeNames {
            public final String raw;
            public final String get;
            public final String init;
            public final String with;
            public final String add;
            public final String addAll;
            public final String put;
            public final String putAll;

            public AttributeNames() {
                this.raw = UsingName.this.detectRawFromGet();
                this.get = UsingName.this.name;
                this.init = ((UsingName)UsingName.this).scheme.init.apply(this.raw);
                this.with = ((UsingName)UsingName.this).scheme.with.apply(this.raw);
                this.add = ((UsingName)UsingName.this).scheme.add.apply(this.raw);
                this.addAll = ((UsingName)UsingName.this).scheme.addAll.apply(this.raw);
                this.put = ((UsingName)UsingName.this).scheme.put.apply(this.raw);
                this.putAll = ((UsingName)UsingName.this).scheme.putAll.apply(this.raw);
            }
        }

        public class TypeNames {
            public final Scheme namings;
            public final String raw;
            public final String typeAbstract;
            public final String typeImmutable;
            public final String typeImmutableEnclosing;
            public final String typeImmutableNested;
            public final String of;
            public final String instance;
            public final String copyOf;
            public final String builder;
            public final String build;

            public TypeNames() {
                this.namings = UsingName.this.scheme;
                this.raw = UsingName.this.detectRawFromAbstract();
                this.typeAbstract = UsingName.this.name;
                this.typeImmutable = ((UsingName)UsingName.this).scheme.typeImmutable.apply(this.raw);
                this.typeImmutableEnclosing = ((UsingName)UsingName.this).scheme.typeImmutableEnclosing.apply(this.raw);
                this.typeImmutableNested = ((UsingName)UsingName.this).scheme.typeImmutableNested.apply(this.raw);
                this.of = ((UsingName)UsingName.this).scheme.of.apply(this.raw);
                this.instance = ((UsingName)UsingName.this).scheme.instance.apply(this.raw);
                this.copyOf = ((UsingName)UsingName.this).scheme.copyOf.apply(this.raw);
                this.builder = ((UsingName)UsingName.this).scheme.builder.apply(this.raw);
                this.build = ((UsingName)UsingName.this).scheme.build.apply(this.raw);
            }

            String rawFromAbstract(String abstractName) {
                return UsingName.this.detectRawFromAbstract(abstractName);
            }
        }
    }

    class Scheme {
        Naming[] typeAbstract;
        Naming typeImmutable;
        Naming typeImmutableNested;
        Naming typeImmutableEnclosing;
        Naming of;
        Naming copyOf;
        Naming instance;
        Naming typeBuilder;
        Naming builder;
        Naming build;
        Naming[] get;
        Naming init;
        Naming with;
        Naming add;
        Naming addAll;
        Naming put;
        Naming putAll;

        Scheme() {
            this.typeAbstract = Naming.fromAll(Styles.this.style.typeAbstract());
            this.typeImmutable = Naming.from(Styles.this.style.typeImmutable());
            this.typeImmutableNested = Naming.from(Styles.this.style.typeImmutableNested());
            this.typeImmutableEnclosing = Naming.from(Styles.this.style.typeImmutableEnclosing());
            this.of = Naming.from(Styles.this.style.of());
            this.copyOf = Naming.from(Styles.this.style.copyOf());
            this.instance = Naming.from(Styles.this.style.instance());
            this.typeBuilder = Naming.from(Styles.this.style.typeBuilder());
            this.builder = Naming.from(Styles.this.style.builder());
            this.build = Naming.from(Styles.this.style.build());
            this.get = Naming.fromAll(Styles.this.style.get());
            this.init = Naming.from(Styles.this.style.init());
            this.with = Naming.from(Styles.this.style.with());
            this.add = Naming.from(Styles.this.style.add());
            this.addAll = Naming.from(Styles.this.style.addAll());
            this.put = Naming.from(Styles.this.style.put());
            this.putAll = Naming.from(Styles.this.style.putAll());
        }
    }

    @Value.Style
    private static class DefaultStyle {
        static Value.Style style = DefaultStyle.class.getAnnotation(Value.Style.class);

        private DefaultStyle() {
        }
    }
}

