/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.Json;
import org.immutables.value.Mongo;
import org.immutables.value.Value;
import org.immutables.value.internal.generator.AnnotationMirrors;
import org.immutables.value.internal.google.common.base.Functions;
import org.immutables.value.internal.google.common.base.Joiner;
import org.immutables.value.internal.google.common.base.Optional;
import org.immutables.value.internal.google.common.collect.FluentIterable;
import org.immutables.value.internal.google.common.collect.ImmutableList;
import org.immutables.value.internal.google.common.collect.Iterables;
import org.immutables.value.internal.google.common.collect.Lists;
import org.immutables.value.internal.processor.meta.AnnotationPrinting;
import org.immutables.value.internal.processor.meta.Proto;
import org.immutables.value.internal.processor.meta.Reporter;
import org.immutables.value.internal.processor.meta.Round;
import org.immutables.value.internal.processor.meta.Styles;
import org.immutables.value.internal.processor.meta.TypeIntrospectionBase;
import org.immutables.value.internal.processor.meta.UnshadeGuava;
import org.immutables.value.internal.processor.meta.ValueType;

public class ValueAttribute
extends TypeIntrospectionBase {
    private static final Joiner COMMA_JOINER = Joiner.on(", ");
    private static final String NULLABLE_PREFIX = "@javax.annotation.Nullable ";
    private static final String NULLABLE_SIMPLE_NAME = "Nullable";
    private static final String ID_ATTRIBUTE_NAME = "_id";
    public Styles.UsingName.AttributeNames names;
    public boolean isGenerateFunction;
    public boolean isGeneratePredicate;
    public boolean isGenerateDefault;
    public boolean isGenerateDerived;
    public boolean isGenerateAbstract;
    public boolean isGenerateLazy;
    public ImmutableList<String> typeParameters = ImmutableList.of();
    public Reporter reporter;
    TypeMirror returnType;
    Element element;
    String returnTypeName;
    @Nullable
    private String marshaledName;
    private String implementationType;
    private Boolean isMapType;
    private Boolean isListType;
    @Nullable
    private Boolean isSetType;
    @Nullable
    private Boolean isSortedSetType;
    @Nullable
    private Boolean isSortedMapType;
    @Nullable
    private Boolean shouldGenerateSortedSet;
    @Nullable
    private Boolean shouldGenerateSortedMap;
    private OrderKind orderKind = OrderKind.NONE;
    private Boolean isOptionalType;
    @Nullable
    private List<SimpleTypeDerivationBase> expectedSubclasses;
    @Nullable
    private TypeElement marshaledElement;
    @Nullable
    private TypeElement marshaledSecondaryElement;
    @Nullable
    private TypeElement specialMarshaledElement;
    @Nullable
    private TypeElement specialMarshaledSecondaryElement;
    private boolean hasEnumFirstTypeParameter;
    private TypeElement containedTypeElement;
    private boolean generateOrdinalValueSet;
    private TypeMirror arrayComponent;
    private boolean regularAttribute;
    private boolean nullable;
    Round round;

    public String name() {
        return this.names.raw;
    }

    public boolean isBoolean() {
        return this.internalTypeMirror().getKind() == TypeKind.BOOLEAN;
    }

    public boolean isStringType() {
        return this.returnTypeName.equals(String.class.getName());
    }

    public boolean charType() {
        return this.internalTypeMirror().getKind() == TypeKind.CHAR;
    }

    public String atNullability() {
        return this.isNullable() ? NULLABLE_PREFIX : "";
    }

    public boolean isSimpleLiteralType() {
        return this.isPrimitive() || this.isStringType() || this.isEnumType();
    }

    public boolean isMandatory() {
        return this.isGenerateAbstract && !this.isContainerType() && !this.isNullable();
    }

    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isComparable() {
        return this.isNumberType() || super.isComparable();
    }

    public String getMarshaledName() {
        if (this.marshaledName == null) {
            this.marshaledName = this.inferMarshaledName();
        }
        return this.marshaledName;
    }

    private String inferMarshaledName() {
        String name;
        Json.Named namedAnnotaion = this.element.getAnnotation(Json.Named.class);
        if (namedAnnotaion != null && !(name = namedAnnotaion.value()).isEmpty()) {
            return name;
        }
        Mongo.Id idAnnotation = this.element.getAnnotation(Mongo.Id.class);
        if (idAnnotation != null) {
            return ID_ATTRIBUTE_NAME;
        }
        return this.names.raw;
    }

    public boolean isForceEmpty() {
        return this.element.getAnnotation(Json.ForceEmpty.class) != null;
    }

    @Deprecated
    @Nullable
    public CharSequence getAnnotationDefaultValue() {
        AnnotationValue defaultValue;
        if (this.element instanceof ExecutableElement && (defaultValue = ((ExecutableElement)this.element).getDefaultValue()) != null) {
            return AnnotationMirrors.toCharSequence(defaultValue);
        }
        return null;
    }

    @Override
    protected TypeMirror internalTypeMirror() {
        return this.returnType;
    }

    public String getType() {
        return this.returnTypeName;
    }

    public List<CharSequence> getAnnotations() {
        return AnnotationPrinting.getAnnotationLines(this.element);
    }

    public boolean isJsonIgnore() {
        return this.element.getAnnotation(Json.Ignore.class) != null;
    }

    public String getImplementationType() {
        if (this.implementationType == null) {
            String implementationRawType = "";
            if (this.isMapType()) {
                implementationRawType = this.isGenerateSortedMap() ? UnshadeGuava.typeString("collect.ImmutableSortedMap") : UnshadeGuava.typeString("collect.ImmutableMap");
            } else if (this.isListType()) {
                implementationRawType = UnshadeGuava.typeString("collect.ImmutableList");
            } else if (this.isGenerateSortedSet()) {
                implementationRawType = UnshadeGuava.typeString("collect.ImmutableSortedSet");
            } else if (this.isSetType()) {
                String string = implementationRawType = this.isGenerateOrdinalValueSet() ? "org.immutables.common.".concat("collect.ImmutableOrdinalSet") : UnshadeGuava.typeString("collect.ImmutableSet");
            }
            if (implementationRawType.isEmpty()) {
                this.implementationType = this.getType();
            } else {
                this.implementationType = implementationRawType;
                List<String> parameters = this.typeParameters();
                if (!parameters.isEmpty()) {
                    this.implementationType = this.implementationType + "<" + COMMA_JOINER.join(parameters) + ">";
                }
            }
        }
        return this.implementationType;
    }

    public List<String> typeParameters() {
        this.ensureTypeIntrospected();
        return this.arrayComponent != null ? ImmutableList.of(this.arrayComponent.toString()) : this.typeParameters;
    }

    public boolean isMapType() {
        if (this.isRegularAttribute()) {
            return false;
        }
        if (this.isMapType == null) {
            this.isMapType = this.returnTypeName.startsWith(Map.class.getName()) || this.isSortedMapType();
        }
        return this.isMapType;
    }

    public boolean isListType() {
        if (this.isRegularAttribute()) {
            return false;
        }
        if (this.isListType == null) {
            this.isListType = this.returnTypeName.startsWith(List.class.getName());
        }
        return this.isListType;
    }

    public boolean isSetType() {
        if (this.isRegularAttribute()) {
            return false;
        }
        if (this.isSetType == null) {
            this.isSetType = this.returnTypeName.startsWith(Set.class.getName());
        }
        return this.isSetType;
    }

    public boolean hasNaturalOrder() {
        return this.orderKind == OrderKind.NATURAL;
    }

    public boolean hasReverseOrder() {
        return this.orderKind == OrderKind.REVERSE;
    }

    public boolean isSortedSetType() {
        if (this.isRegularAttribute()) {
            return false;
        }
        if (this.isSortedSetType == null) {
            this.isSortedSetType = this.returnTypeName.startsWith(SortedSet.class.getName()) || this.returnTypeName.startsWith(NavigableSet.class.getName());
        }
        return this.isSortedSetType;
    }

    public boolean isSortedMapType() {
        if (this.isRegularAttribute()) {
            return false;
        }
        if (this.isSortedMapType == null) {
            this.isSortedMapType = this.returnTypeName.startsWith(SortedMap.class.getName()) || this.returnTypeName.startsWith(NavigableMap.class.getName());
        }
        return this.isSortedMapType;
    }

    public boolean isGenerateSortedSet() {
        if (this.isRegularAttribute()) {
            return false;
        }
        if (this.shouldGenerateSortedSet == null) {
            boolean isEligibleSetType = this.isSortedSetType();
            this.checkOrderAnnotations();
            this.shouldGenerateSortedSet = isEligibleSetType && this.orderKind != OrderKind.NONE;
        }
        return this.shouldGenerateSortedSet;
    }

    public boolean isGenerateSortedMap() {
        if (this.isRegularAttribute()) {
            return false;
        }
        if (this.shouldGenerateSortedMap == null) {
            boolean isEligibleType = this.isSortedMapType();
            this.checkOrderAnnotations();
            this.shouldGenerateSortedMap = isEligibleType && this.orderKind != OrderKind.NONE;
        }
        return this.shouldGenerateSortedMap;
    }

    private void checkOrderAnnotations() {
        boolean isEligibleType = this.isSortedMapType() || this.isSortedSetType();
        Value.NaturalOrder naturalOrderAnnotation = this.element.getAnnotation(Value.NaturalOrder.class);
        Value.ReverseOrder reverseOrderAnnotation = this.element.getAnnotation(Value.ReverseOrder.class);
        if (naturalOrderAnnotation != null && reverseOrderAnnotation != null) {
            this.reporter.withElement(this.element).error("@Value.Natural and @Value.Reverse annotations could not be used on the same attribute", new Object[0]);
        } else if (naturalOrderAnnotation != null) {
            if (isEligibleType) {
                if (this.isComparable()) {
                    this.orderKind = OrderKind.NATURAL;
                } else {
                    this.reporter.withElement(this.element).forAnnotation(Value.NaturalOrder.class).error("@Value.Natural should used on a set of Comparable elements (map keys)", new Object[0]);
                }
            } else {
                this.reporter.withElement(this.element).forAnnotation(Value.NaturalOrder.class).error("@Value.Natural should specify order for SortedSet, SortedMap, NavigableSet or NavigableMap attributes", new Object[0]);
            }
        } else if (reverseOrderAnnotation != null) {
            if (isEligibleType) {
                if (this.isComparable()) {
                    this.orderKind = OrderKind.REVERSE;
                } else {
                    this.reporter.withElement(this.element).forAnnotation(Value.ReverseOrder.class).error("@Value.Reverse should used with a set of Comparable elements", new Object[0]);
                }
            } else {
                this.reporter.withElement(this.element).forAnnotation(Value.ReverseOrder.class).error("@Value.Reverse should specify order for SortedSet, SortedMap, NavigableSet or NavigableMap attributes", new Object[0]);
            }
        }
    }

    public boolean isOptionalType() {
        if (this.isRegularAttribute()) {
            return false;
        }
        if (this.isOptionalType == null) {
            this.isOptionalType = this.returnTypeName.startsWith(UnshadeGuava.typeString("base.Optional"));
        }
        return this.isOptionalType;
    }

    public boolean isCollectionType() {
        return this.isSortedSetType() || this.isSetType() || this.isListType();
    }

    public boolean isGenerateEnumSet() {
        this.ensureTypeIntrospected();
        return this.isSetType() && this.hasEnumFirstTypeParameter;
    }

    public CharSequence defaultInterface() {
        Element enclosing = this.element.getEnclosingElement();
        if (enclosing.getKind() == ElementKind.INTERFACE && this.isGenerateDefault) {
            return ((TypeElement)enclosing).getQualifiedName();
        }
        return "";
    }

    public boolean isGenerateEnumMap() {
        this.ensureTypeIntrospected();
        return this.isMapType() && this.hasEnumFirstTypeParameter;
    }

    public String getUnwrappedElementType() {
        return ValueAttribute.unwrapType(this.containmentTypeName());
    }

    public String getWrappedElementType() {
        return ValueAttribute.wrapType(this.containmentTypeName());
    }

    private String containmentTypeName() {
        return this.isArrayType() || this.isContainerType() ? this.firstTypeParameter() : this.returnTypeName;
    }

    public String getRawType() {
        String type = this.getType();
        int endIndex = type.length();
        int firstIndexOfGenerics = type.indexOf(60);
        if (firstIndexOfGenerics > 0) {
            endIndex = firstIndexOfGenerics;
        }
        return type.substring(0, endIndex);
    }

    public String getConsumedElementType() {
        return this.isUnwrappedElementPrimitiveType() || String.class.getName().equals(this.containmentTypeName()) || this.hasEnumFirstTypeParameter ? this.getWrappedElementType() : "? extends " + this.getWrappedElementType();
    }

    private String extractRawType(String className) {
        int indexOfGenerics = className.indexOf(60);
        if (indexOfGenerics > 0) {
            return className.substring(0, indexOfGenerics);
        }
        return className;
    }

    public boolean isUnwrappedElementPrimitiveType() {
        return ValueAttribute.isPrimitiveType(this.getUnwrappedElementType());
    }

    public boolean isUnwrappedSecondaryElementPrimitiveType() {
        return ValueAttribute.isPrimitiveType(this.getUnwrappedSecondaryElementType());
    }

    public String firstTypeParameter() {
        return Iterables.getFirst(this.typeParameters(), "");
    }

    public String secondTypeParameter() {
        return Iterables.get(this.typeParameters(), 1);
    }

    public String getElementType() {
        return this.containmentTypeName();
    }

    public List<SimpleTypeDerivationBase> getExpectedSubclasses() {
        if (this.expectedSubclasses == null) {
            Iterable<TypeElement> expectedSubclassesType;
            this.expectedSubclasses = this.isPrimitiveElement() ? ImmutableList.of() : ((expectedSubclassesType = this.findDeclaredSubclasses()) != null ? this.toMarshaledTypeDerivations(expectedSubclassesType) : ImmutableList.of());
        }
        return this.expectedSubclasses;
    }

    @Nullable
    private Iterable<TypeElement> findDeclaredSubclasses() {
        if (this.element.getAnnotation(Json.Subclasses.class) != null) {
            return ValueAttribute.listExpectedSubclassesFromElement(this.element);
        }
        this.ensureTypeIntrospected();
        if (this.containedTypeElement != null) {
            return ValueAttribute.listExpectedSubclassesFromElement(this.containedTypeElement);
        }
        return null;
    }

    private List<SimpleTypeDerivationBase> toMarshaledTypeDerivations(Iterable<TypeElement> elements) {
        ArrayList<SimpleTypeDerivationBase> derivations = Lists.newArrayList();
        for (TypeElement element : elements) {
            Optional<Proto.Protoclass> protoclass = this.round.definedValueProtoclassFor(element);
            if (!protoclass.isPresent() || !protoclass.get().declaringType().get().hasAnnotation(Json.Marshaled.class)) continue;
            derivations.add(new SimpleTypeDerivationBase(protoclass.get()));
        }
        return ImmutableList.copyOf(derivations);
    }

    private static FluentIterable<TypeElement> listExpectedSubclassesFromElement(Element element) {
        return FluentIterable.from(ValueType.extractedTypesFromAnnotationMirrors(Json.Subclasses.class.getCanonicalName(), "value", element.getAnnotationMirrors())).transform(Proto.DeclatedTypeToElement.FUNCTION);
    }

    public boolean isGenerateOrdinalValueSet() {
        if (!this.isSetType()) {
            return false;
        }
        this.ensureTypeIntrospected();
        return this.generateOrdinalValueSet;
    }

    public boolean isDocumentElement() {
        this.ensureTypeIntrospected();
        return this.containedTypeElement != null && this.containedTypeElement.getAnnotation(Mongo.Repository.class) != null;
    }

    public boolean isArrayType() {
        return !this.isRegularAttribute() && this.internalTypeMirror().getKind() == TypeKind.ARRAY;
    }

    @Override
    protected void introspectType() {
        TypeMirror typeMirror = this.internalTypeMirror();
        if (this.isContainerType()) {
            if (typeMirror instanceof DeclaredType) {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                ArrayList<String> typeParameters = Lists.newArrayList();
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                if (!typeArguments.isEmpty()) {
                    TypeMirror typeArgument;
                    if (typeArguments.size() == 1) {
                        typeArgument = typeArguments.get(0);
                        if (typeArgument instanceof DeclaredType) {
                            typeMirror = typeArgument;
                        }
                        if (this.isSetType()) {
                            this.generateOrdinalValueSet = new TypeIntrospectionBase(){

                                @Override
                                protected TypeMirror internalTypeMirror() {
                                    return typeArgument;
                                }
                            }.isOrdinalValue();
                        }
                    }
                    if (typeArguments.size() >= 1) {
                        TypeMirror typeSecondArgument;
                        typeArgument = typeArguments.get(0);
                        if (typeArgument instanceof DeclaredType) {
                            TypeElement typeElement = (TypeElement)((DeclaredType)typeArgument).asElement();
                            this.hasEnumFirstTypeParameter = typeElement.getSuperclass().toString().startsWith(Enum.class.getName());
                        }
                        if (typeArguments.size() >= 2 && (typeSecondArgument = typeArguments.get(1)) instanceof DeclaredType) {
                            TypeElement typeElement = (TypeElement)((DeclaredType)typeSecondArgument).asElement();
                            Json.Marshaled generateMarshaler = typeElement.getAnnotation(Json.Marshaled.class);
                            this.marshaledSecondaryElement = generateMarshaler != null ? typeElement : null;
                            this.specialMarshaledSecondaryElement = this.asSpecialMarshaledElement(this.marshaledSecondaryElement, typeElement);
                        }
                        typeMirror = typeArgument;
                    }
                    typeParameters.addAll(Lists.transform(typeArguments, Functions.toStringFunction()));
                }
                this.typeParameters = ImmutableList.copyOf(typeParameters);
            }
        } else if (this.isArrayType()) {
            typeMirror = this.arrayComponent = ((ArrayType)typeMirror).getComponentType();
        }
        if (typeMirror instanceof DeclaredType) {
            TypeElement typeElement;
            this.containedTypeElement = typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            Json.Marshaled generateMarshaler = typeElement.getAnnotation(Json.Marshaled.class);
            this.marshaledElement = generateMarshaler != null ? typeElement : null;
            this.specialMarshaledElement = this.asSpecialMarshaledElement(this.marshaledElement, typeElement);
        }
        this.intospectTypeMirror(typeMirror);
    }

    private boolean isRegularAttribute() {
        return this.regularAttribute;
    }

    static boolean isRegularMarshalableType(String name) {
        return String.class.getName().equals(name) || ValueAttribute.isPrimitiveOrWrapped(name);
    }

    public String getRawCollectionType() {
        return this.isListType() ? List.class.getSimpleName() : (this.isSetType() ? Set.class.getSimpleName() : (this.isSortedSetType() ? SortedSet.class.getSimpleName() : ""));
    }

    public String getSecondaryElementType() {
        return this.secondTypeParameter();
    }

    public String getUnwrappedSecondaryElementType() {
        return ValueAttribute.unwrapType(this.secondTypeParameter());
    }

    public String getWrappedSecondaryElementType() {
        return ValueAttribute.wrapType(this.secondTypeParameter());
    }

    public String getUnwrapperOrRawSecondaryElementType() {
        return this.extractRawType(this.getWrappedSecondaryElementType());
    }

    public String getUnwrapperOrRawElementType() {
        return this.extractRawType(this.getWrappedElementType());
    }

    public boolean isNumberType() {
        TypeKind kind = this.internalTypeMirror().getKind();
        return kind.isPrimitive() && kind != TypeKind.CHAR && kind != TypeKind.BOOLEAN;
    }

    public boolean isFloatType() {
        return this.isFloat() || this.isDouble();
    }

    public boolean isFloat() {
        return this.internalTypeMirror().getKind() == TypeKind.FLOAT;
    }

    public boolean isDouble() {
        return this.internalTypeMirror().getKind() == TypeKind.DOUBLE;
    }

    public boolean isNonRawElemementType() {
        return this.getElementType().indexOf(60) > 0;
    }

    public boolean isContainerType() {
        return this.isCollectionType() || this.isOptionalType() || this.isMapType();
    }

    public String getWrapperType() {
        return this.isPrimitive() ? ValueAttribute.wrapType(this.returnTypeName) : this.returnTypeName;
    }

    public boolean isPrimitive() {
        return this.internalTypeMirror().getKind().isPrimitive();
    }

    public int getConstructorArgumentOrder() {
        Value.Parameter annotation = this.element.getAnnotation(Value.Parameter.class);
        return annotation != null ? annotation.order() : -1;
    }

    public boolean isSpecialMarshaledElement() {
        this.ensureTypeIntrospected();
        return this.specialMarshaledElement != null;
    }

    public boolean isSpecialMarshaledSecondaryElement() {
        this.ensureTypeIntrospected();
        return this.specialMarshaledSecondaryElement != null;
    }

    public boolean isMarshaledElement() {
        if (this.isPrimitive()) {
            return false;
        }
        this.ensureTypeIntrospected();
        return this.marshaledElement != null;
    }

    public boolean isMarshaledSecondaryElement() {
        this.ensureTypeIntrospected();
        return this.marshaledSecondaryElement != null;
    }

    public boolean isPrimitiveElement() {
        return ValueAttribute.isPrimitiveType(this.getUnwrappedElementType());
    }

    private TypeElement asSpecialMarshaledElement(@Nullable TypeElement marshaled, TypeElement element) {
        if (marshaled != null) {
            return marshaled;
        }
        if (!ValueAttribute.isRegularMarshalableType(element.getQualifiedName().toString())) {
            return element;
        }
        return null;
    }

    Collection<SimpleTypeDerivationBase> getMarshaledImportRoutines() {
        ArrayList<TypeElement> imports = Lists.newArrayListWithExpectedSize(2);
        if (this.isMarshaledElement()) {
            imports.add(this.marshaledElement);
        }
        if (this.isMapType() && this.isMarshaledSecondaryElement()) {
            imports.add(this.marshaledSecondaryElement);
        }
        return this.toMarshaledTypeDerivations(imports);
    }

    Collection<String> getSpecialMarshaledTypes() {
        ArrayList<String> marshaledTypeSet = Lists.newArrayListWithExpectedSize(2);
        if (this.isSpecialMarshaledElement()) {
            String typeName = this.isContainerType() ? this.getUnwrappedElementType() : this.getType();
            marshaledTypeSet.add(typeName);
        }
        if (this.isMapType() && this.isSpecialMarshaledSecondaryElement()) {
            marshaledTypeSet.add(this.specialMarshaledSecondaryElement.getQualifiedName().toString());
        }
        return marshaledTypeSet;
    }

    public boolean isAuxiliary() {
        return this.element.getAnnotation(Value.Auxiliary.class) != null;
    }

    public boolean isMarshaledIgnore() {
        this.ensureTypeIntrospected();
        return this.isMarshaledElement();
    }

    boolean isIdAttribute() {
        return this.getMarshaledName().equals(ID_ATTRIBUTE_NAME);
    }

    void initAndValidate() {
        for (AnnotationMirror annotationMirror : this.element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().asElement().getSimpleName().contentEquals(NULLABLE_SIMPLE_NAME)) continue;
            if (this.isPrimitive()) {
                this.reporter.withElement(this.element).annotationNamed(NULLABLE_SIMPLE_NAME).error("@Nullable could not be used with primitive type attibutes", new Object[0]);
                continue;
            }
            this.nullable = true;
            if (!this.isContainerType()) continue;
            this.regularAttribute = true;
        }
        if (this.isGenerateDefault && this.isContainerType()) {
            this.regularAttribute = true;
            this.reporter.withElement(this.element).forAnnotation(Value.Default.class).warning("@Value.Default on a container attribute make it lose it's special treatment", new Object[0]);
        }
    }

    public String toString() {
        return "Attribute[" + this.name() + "]";
    }

    public static final class SimpleTypeDerivationBase {
        public final String packaged;
        public final String name;

        SimpleTypeDerivationBase(Proto.Protoclass protoclass) {
            this.packaged = protoclass.packageOf().asPrefix();
            this.name = protoclass.createTypeNames().raw;
        }
    }

    private static enum OrderKind {
        NONE,
        NATURAL,
        REVERSE;

    }
}

