/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.processor.meta;

import java.util.ArrayList;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.immutables.value.internal.google.common.collect.HashMultiset;
import org.immutables.value.internal.google.common.collect.Lists;
import org.immutables.value.internal.google.common.collect.Multiset;
import org.immutables.value.internal.processor.meta.AccessorAttributesCollector;
import org.immutables.value.internal.processor.meta.FactoryMethodAttributesCollector;
import org.immutables.value.internal.processor.meta.ImmutableConstitution;
import org.immutables.value.internal.processor.meta.Proto;
import org.immutables.value.internal.processor.meta.Round;
import org.immutables.value.internal.processor.meta.UnshadeGuava;
import org.immutables.value.internal.processor.meta.ValueAttribute;
import org.immutables.value.internal.processor.meta.ValueType;

public final class ValueTypeComposer {
    private final ProcessingEnvironment processing;
    private final Round round;
    private final String typeMoreObjects;

    ValueTypeComposer(Round round) {
        this.round = round;
        this.processing = round.processing();
        this.typeMoreObjects = this.inferTypeMoreObjects();
    }

    String inferTypeMoreObjects() {
        String typeMoreObjects = UnshadeGuava.typeString("base.MoreObjects");
        String typeObjects = UnshadeGuava.typeString("base.Objects");
        TypeElement typeElement = this.processing.getElementUtils().getTypeElement(typeMoreObjects);
        return typeElement != null ? typeMoreObjects : typeObjects;
    }

    ValueType compose(Proto.Protoclass protoclass) {
        ValueType type = new ValueType();
        type.typeMoreObjects = this.typeMoreObjects;
        type.element = protoclass.sourceElement();
        type.immutableFeatures = protoclass.features();
        type.constitution = ImmutableConstitution.builder().protoclass(protoclass).build();
        if (protoclass.kind().isFactory()) {
            new FactoryMethodAttributesCollector(this.round, protoclass, type).collect();
        } else if (protoclass.kind().isValue()) {
            if (ValueTypeComposer.isAbstractValueType(type.element)) {
                new AccessorAttributesCollector(this.round, protoclass, type).collect();
            } else {
                protoclass.report().error("Type '%s' annotated or included as value must be non-final class, interface or annotation type", protoclass.sourceElement().getSimpleName());
            }
        }
        this.checkAttributeNamesForDuplicates(type, protoclass);
        return type;
    }

    private void checkAttributeNamesForDuplicates(ValueType type, Proto.Protoclass protoclass) {
        if (!type.attributes.isEmpty()) {
            HashMultiset<String> attributeNames = HashMultiset.create(type.attributes.size());
            for (ValueAttribute attribute : type.attributes) {
                attributeNames.add(attribute.name());
            }
            ArrayList duplicates = Lists.newArrayList();
            for (Multiset.Entry entry : attributeNames.entrySet()) {
                if (entry.getCount() <= 1) continue;
                duplicates.add(entry.getElement());
            }
            if (!duplicates.isEmpty()) {
                protoclass.report().error("Duplicate attribute names %s. You should check if correct @Value.Style applied", duplicates);
            }
        }
    }

    static boolean isAbstractValueType(Element element) {
        boolean ofSupportedKind = element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.ANNOTATION_TYPE || element.getKind() == ElementKind.CLASS;
        boolean staticOrTopLevel = element.getEnclosingElement().getKind() == ElementKind.PACKAGE || element.getModifiers().contains((Object)Modifier.STATIC);
        boolean nonFinal = !element.getModifiers().contains((Object)Modifier.FINAL);
        return ofSupportedKind && staticOrTopLevel && nonFinal;
    }
}

